/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.relation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algo.util.bitset.LongBitSet;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.fi.frm.common.model.FrmLogger;
import kd.fi.frm.common.relation.AbstractRelationService;
import kd.fi.frm.common.relation.InFilterLongBitSetFunction;
import kd.fi.frm.common.relation.RelationParam;
import kd.fi.frm.common.util.FrmQueryServiceHelper;

public class DaptrackerService
extends AbstractRelationService {
    private static final Log log = LogFactory.getLog(DaptrackerService.class);
    private static final String DAP = "ai_daptracker";
    private static final String SELECT_FIELDS = "billtype entity, sourcebillid, voucherid";

    public DaptrackerService(FrmLogger frmLogger) {
        this.frmLogger = frmLogger;
    }

    @Override
    public DataSet getRelation(RelationParam param, LongBitSet billBitSet, Set<Long> vchIdSet) {
        QFilter dapFilter = new QFilter("org", "in", param.getBizOrgIds()).and(new QFilter("period", "=", (Object)param.getPeriodId())).and(new QFilter("billtype", "=", (Object)param.getSourceEntity()));
        if (CollectionUtils.isNotEmpty(vchIdSet)) {
            dapFilter = dapFilter.and(new QFilter("voucherid", "in", vchIdSet));
        }
        DataSet dataSet = FrmQueryServiceHelper.queryDataSet(this.frmLogger, this.getClass().getName(), DAP, SELECT_FIELDS, dapFilter.toArray(), null);
        if (billBitSet != null && billBitSet.iterator().hasNext()) {
            dataSet = dataSet.filter((FilterFunction)new InFilterLongBitSetFunction(billBitSet, "sourcebillid"));
        }
        return dataSet;
    }

    private DataSet queryRelationByAlgox(List<Long> billIdList, int billSize, QFilter dapFilter) {
        OrmInput input;
        log.info("query relation by algox");
        String algoKey = "kd.fi.frm.common.relation.DaptrackerService";
        String entityName = DAP;
        String selectFields = SELECT_FIELDS;
        ArrayList<OrmInput> inputList = new ArrayList<OrmInput>();
        while (billIdList.size() >= billSize) {
            ArrayList<Long> tmpBillIdList = new ArrayList<Long>(billSize);
            tmpBillIdList.addAll(billIdList.subList(0, billSize));
            input = new OrmInput(algoKey, entityName, selectFields, new QFilter[]{new QFilter("sourcebillid", "in", tmpBillIdList), dapFilter});
            inputList.add(input);
            billIdList = this.removeAll(billIdList, tmpBillIdList);
        }
        if (billIdList.size() > 0) {
            input = new OrmInput(algoKey, entityName, selectFields, new QFilter[]{new QFilter("sourcebillid", "in", billIdList), dapFilter});
            inputList.add(input);
        }
        JobSession session = AlgoX.createSession((String)DaptrackerService.class.getName(), (String)"dapTracker");
        DataSetX dataSetx = session.fromInput(inputList.toArray(new Input[0]));
        DataSetOutput resultSet = new DataSetOutput(dataSetx.getRowMeta());
        dataSetx.output((Output)resultSet);
        int timeoutTime = Math.max(180, Integer.parseInt(System.getProperty("prop.fi.ai.thread.timeoutsecs", Integer.toString(180))));
        session.commit(timeoutTime, TimeUnit.SECONDS);
        return session.readDataSet(resultSet.getId());
    }

    private DataSet queryRelationBySplit(List<Long> billIdList, int billSize, QFilter dapFilter) {
        log.info("query relation by split");
        DataSet result = null;
        while (billIdList.size() >= billSize) {
            ArrayList<Long> tmpBillIdList = new ArrayList<Long>(billSize);
            tmpBillIdList.addAll(billIdList.subList(0, billSize));
            QFilter qFilter = new QFilter("sourcebillid", "in", tmpBillIdList);
            DataSet dataSet = FrmQueryServiceHelper.queryDataSet(this.frmLogger, this.getClass().getName(), DAP, SELECT_FIELDS, new QFilter[]{dapFilter, qFilter}, null);
            result = result == null ? dataSet : result.union(dataSet);
            billIdList = this.removeAll(billIdList, tmpBillIdList);
        }
        if (billIdList.size() > 0) {
            QFilter qFilter = new QFilter("sourcebillid", "in", billIdList);
            DataSet dataSet = FrmQueryServiceHelper.queryDataSet(this.frmLogger, this.getClass().getName(), DAP, SELECT_FIELDS, new QFilter[]{dapFilter, qFilter}, null);
            result = result == null ? dataSet : result.union(dataSet);
        }
        return result;
    }

    public List<Long> removeAll(List<Long> data, List<Long> beDelete) {
        LinkedList<Long> linkedList = new LinkedList<Long>(data);
        HashSet<Long> hashSet = new HashSet<Long>(beDelete);
        linkedList.removeIf(hashSet::contains);
        return linkedList;
    }
}

