/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.relation;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.bitset.LongBitSet;
import kd.bos.orm.query.QFilter;
import kd.fi.frm.common.model.FrmLogger;
import kd.fi.frm.common.relation.AbstractRelationService;
import kd.fi.frm.common.relation.ArapService;
import kd.fi.frm.common.relation.CASService;
import kd.fi.frm.common.relation.DaptrackerService;
import kd.fi.frm.common.relation.FaService;
import kd.fi.frm.common.relation.IRelationService;
import kd.fi.frm.common.relation.RelationParam;
import kd.fi.frm.common.util.FrmQueryServiceHelper;

public class RelationServiceAdaptor {
    public static DataSet getRelation(RelationParam param, FrmLogger frmLogger, LongBitSet billBitSet, Set<Long> vchIdSet) {
        IRelationService service = RelationServiceAdaptor.getRelationService(frmLogger, param);
        return service.getRelation(param, billBitSet, vchIdSet);
    }

    public static boolean isArap(String entity) {
        return "ar_journal".equalsIgnoreCase(entity) || "ap_journal".equalsIgnoreCase(entity);
    }

    public static boolean isCAS(String entity) {
        return "cas_bankjournal".equalsIgnoreCase(entity) || "cas_cashjournal".equalsIgnoreCase(entity);
    }

    public static boolean isFa(String entity) {
        return "fa_card_fin".equalsIgnoreCase(entity);
    }

    public static Set<Long> getReverRelation(FrmLogger frmLogger, List<QFilter> vchFilters) {
        QFilter enable = new QFilter("iseffective", "=", (Object)true);
        DataSet reserveDataSet = FrmQueryServiceHelper.queryDataSet(frmLogger, "gl_reverserelation", "gl_reverserelation", "srcentity,targentity", new QFilter[]{enable}, null);
        HashSet<Long> relationVchIds = new HashSet<Long>(1000);
        for (Row row : reserveDataSet) {
            Long srcVchId = row.getLong("srcentity");
            Long targetVchId = row.getLong("targentity");
            relationVchIds.add(srcVchId);
            relationVchIds.add(targetVchId);
        }
        return relationVchIds;
    }

    public static IRelationService getRelationService(FrmLogger frmLogger, RelationParam param) {
        AbstractRelationService service = null;
        String entity = param.getSourceEntity();
        service = RelationServiceAdaptor.isCAS(entity) ? new CASService(frmLogger, param) : (RelationServiceAdaptor.isArap(entity) ? new ArapService(frmLogger) : (RelationServiceAdaptor.isFa(entity) ? new FaService(frmLogger) : new DaptrackerService(frmLogger)));
        return service;
    }
}

