/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.task;

import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.enums.AssistTypeEnum;
import kd.fi.frm.common.enums.DataTypeEnum;
import kd.fi.frm.common.enums.ReconcilationResultEnum;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.bizdata.BizDataParam;
import kd.fi.frm.common.model.bizdata.BizDataSourceConfig;
import kd.fi.frm.common.model.bizdata.BizReconPlanDetailModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanModel;
import kd.fi.frm.common.mq.ReconciliationPublish;
import kd.fi.frm.common.task.TaskInfo;
import kd.fi.frm.common.task.TaskStatusEnum;
import kd.fi.frm.common.util.ReconciliationParmUtil;
import kd.fi.frm.common.util.ReconciliationUtil;
import kd.fi.frm.common.util.ShowConfirmUtil;

public class TaskDao {
    private static final String algoKey = TaskDao.class.getName();
    private static final Log logger = LogFactory.getLog(TaskDao.class);

    public static DynamicObject buildTask(long orgId, String appId, ReconciliationParamModel paramModel) {
        MainEntityType taskMetaType = EntityMetadataCache.getDataEntityType((String)"frm_task");
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        String instanceNumber = Instance.getInstanceId();
        return TaskDao.buildTask(orgId, appId, paramModel, taskMetaType, currUserId, now, instanceNumber);
    }

    public static DynamicObject buildTask(long orgId, String appId, ReconciliationParamModel paramModel, MainEntityType taskMetaType, long currUserId, Date now, String instanceNumber) {
        Long bookTypeId = paramModel.getBookTypeId();
        Long periodId = paramModel.getPeriodId();
        boolean init = paramModel.isInit();
        String dataTypeEnumValue = paramModel.getDataType().getValue() + "";
        if (paramModel.isApi()) {
            dataTypeEnumValue = DataTypeEnum.API.getValue() + "";
        }
        if (!init && periodId.compareTo(0L) == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u521d\u59cb\u5316\u5bf9\u8d26\uff0c\u5bf9\u8d26\u671f\u95f4\u5374\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"TaskDao_1", (String)"fi-frm-common", (Object[])new Object[0]));
        }
        DynamicObject task = (DynamicObject)taskMetaType.createInstance();
        task.set("org_id", (Object)orgId);
        task.set("createorg_id", (Object)orgId);
        task.set("bizapp_id", (Object)appId);
        task.set("creator_id", (Object)currUserId);
        task.set("createtime", (Object)now);
        task.set("init", (Object)init);
        task.set("booktype_id", (Object)bookTypeId);
        task.set("period_id", (Object)periodId);
        task.set("taskstatus", (Object)TaskStatusEnum.NOT_START.getValue());
        task.set("reconresulttype", (Object)dataTypeEnumValue);
        task.set("suppinst", (Object)instanceNumber);
        return task;
    }

    public static void addNew(DynamicObject task, Supplier<ReconciliationPublish> mqPublisher) {
        ArrayList<DynamicObject> tasks = new ArrayList<DynamicObject>();
        tasks.add(task);
        TaskDao.addNew(tasks, mqPublisher);
    }

    public static void addNewButNotPublish(DynamicObject task) {
        ArrayList<DynamicObject> tasks = new ArrayList<DynamicObject>();
        tasks.add(task);
        TaskDao.addNew(tasks, null);
    }

    public static void addNew(List<DynamicObject> tasks, Supplier<ReconciliationPublish> mqPublisher) {
        if (tasks.isEmpty()) {
            return;
        }
        HashSet<Long> orgIds = new HashSet<Long>(tasks.size());
        HashSet<String> appIds = new HashSet<String>(tasks.size());
        HashSet<Long> periodIds = new HashSet<Long>(tasks.size());
        HashSet<Long> bookTypeIds = new HashSet<Long>(tasks.size());
        HashSet<Boolean> inits = new HashSet<Boolean>(tasks.size());
        for (DynamicObject task : tasks) {
            if ((DataTypeEnum.API.getValue() + "").equals(task.getString("reconresulttype"))) continue;
            orgIds.add(task.getLong("org_id"));
            appIds.add(task.getString("bizapp_id"));
            periodIds.add(task.getLong("period_id"));
            bookTypeIds.add(task.getLong("booktype_id"));
            inits.add(task.getBoolean("init"));
        }
        DataTypeEnum dataType = mqPublisher.get().getParamModel().getDataType();
        Set<String> dataTypeSet = TaskDao.getExistTaskDataType(dataType);
        TaskDao.checkExists(orgIds, appIds, periodIds, bookTypeIds, inits, dataTypeSet);
        String batchNo = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        for (DynamicObject task : tasks) {
            task.set("batchno", (Object)batchNo);
        }
        TaskDao.doWithTX(() -> {
            SaveServiceHelper.save((DynamicObject[])tasks.toArray(new DynamicObject[0]));
            if (mqPublisher != null) {
                HashMap<String, String> taskCacheMap = new HashMap<String, String>(tasks.size());
                for (DynamicObject task : tasks) {
                    TaskInfo taskInfo = new TaskInfo();
                    taskInfo.setAppId(task.getString("bizapp_id"));
                    taskInfo.setOrgId(task.getLong("org_id"));
                    taskInfo.setBatchNo(batchNo);
                    taskInfo.setId(task.getLong("id"));
                    ReconciliationPublish publish = (ReconciliationPublish)mqPublisher.get();
                    taskInfo.setDataType(publish.getParamModel().getDataType());
                    taskInfo.setTaskStatus(TaskStatusEnum.NOT_START);
                    taskInfo.setPercent(0);
                    taskCacheMap.put(task.getString("id"), SerializationUtils.serializeToBase64((Object)taskInfo));
                }
                AppCacheHelper.putBatchCache(batchNo, taskCacheMap);
                for (DynamicObject task : tasks) {
                    ReconciliationPublish publish = (ReconciliationPublish)mqPublisher.get();
                    publish.setId(task.getString("id"));
                    publish.setBatchNo(batchNo);
                    publish.setTask(task);
                    publish.start();
                }
            }
        });
    }

    private static void doWithTX(Runnable fn) {
        try (TXHandle tx = TX.required((String)"kd.fi.frm.frm_task");){
            try {
                fn.run();
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private static void checkExists(Set<Long> orgIds, Set<String> appIds, Set<Long> periodIds, Set<Long> bookTypeIds, Set<Boolean> inits, Set<String> dataTypeSet) {
        boolean exists;
        if (ShowConfirmUtil.isUnitTest()) {
            exists = Boolean.FALSE;
        } else {
            QFilter[] filters = new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("bizapp", "in", appIds), new QFilter("period", "in", periodIds), new QFilter("booktype", "in", bookTypeIds), new QFilter("init", "in", inits), new QFilter("reconresulttype", "not in", dataTypeSet), new QFilter("taskstatus", "in", (Object)new String[]{TaskStatusEnum.NOT_START.getValue(), TaskStatusEnum.DOING.getValue()})};
            exists = QueryServiceHelper.exists((String)"frm_task", (QFilter[])filters);
        }
        if (exists) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u672a\u5f00\u59cb\u3001\u8fdb\u884c\u4e2d\u7684\u5bf9\u8d26\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u64cd\u4f5c\u3002", (String)"TaskDao_0", (String)"fi-frm-common", (Object[])new Object[0]));
        }
    }

    public static DynamicObjectCollection getExistTasks(ReconciliationParamModel paramModel) {
        Set<String> dataTypeSet = TaskDao.getExistTaskDataType(paramModel.getDataType());
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(8);
        filterList.add(new QFilter("org", "in", paramModel.getOrgIds()));
        filterList.add(new QFilter("bizapp", "in", paramModel.getAppIds()));
        filterList.add(new QFilter("period", "=", (Object)paramModel.getPeriodId()));
        filterList.add(new QFilter("booktype", "=", (Object)paramModel.getBookTypeId()));
        filterList.add(new QFilter("init", "=", (Object)paramModel.isInit()));
        filterList.add(new QFilter("reconresulttype", "not in", dataTypeSet));
        filterList.add(new QFilter("taskstatus", "in", (Object)new String[]{TaskStatusEnum.NOT_START.getValue(), TaskStatusEnum.DOING.getValue()}));
        if (ShowConfirmUtil.isUnitTest()) {
            filterList.add(new QFilter("id", "in", null));
        }
        DynamicObjectCollection taskList = QueryServiceHelper.query((String)"frm_task", (String)"id,createtime,begintime,taskstatus,percent", (QFilter[])filterList.toArray(new QFilter[0]));
        HashSet<Long> stopIds = new HashSet<Long>(taskList.size());
        Iterator its = taskList.iterator();
        while (its.hasNext()) {
            DynamicObject taskInfo = (DynamicObject)its.next();
            if (DLock.getLockInfo((String)taskInfo.getString("id")) != null) continue;
            stopIds.add(taskInfo.getLong("id"));
            its.remove();
        }
        if (stopIds.size() > 0) {
            String error = ResManager.loadKDString((String)"\u7cfb\u7edf\u505c\u6b62\u670d\u52a1", (String)"TaskDao_2", (String)"fi-frm-common", (Object[])new Object[0]);
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("update t_frm_task set ", new Object[0]);
            sqlBuilder.append("ftaskstatus = ?", new Object[]{TaskStatusEnum.STOPPED.getValue()});
            sqlBuilder.append(",fendtime = ?", new Object[]{new Date()});
            sqlBuilder.append(",ferror = ?", new Object[]{error});
            sqlBuilder.append(",ferror_tag = ?", new Object[]{error});
            sqlBuilder.append(" where ", new Object[0]);
            sqlBuilder.appendIn("fid", (Object[])stopIds.toArray(new Long[0]));
            DB.execute((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
        }
        return taskList;
    }

    public static Set<String> getExistTaskDataType(DataTypeEnum dataType) {
        HashSet<String> dataTypeSet = new HashSet<String>(3);
        dataTypeSet.add(DataTypeEnum.API.getValue() + "");
        if (DataTypeEnum.Detail == dataType) {
            dataTypeSet.add(DataTypeEnum.OnlyStatus.getValue() + "");
            dataTypeSet.add(DataTypeEnum.NotDetail.getValue() + "");
        } else if (DataTypeEnum.OnlyStatus == dataType || DataTypeEnum.NotDetail == dataType) {
            dataTypeSet.add(DataTypeEnum.Detail.getValue() + "");
        }
        return dataTypeSet;
    }

    public static TaskInfo getTaskInfo(Long taskId) {
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"frm_task", (String)"org,bizapp,taskstatus,batchno,reconresult", (QFilter[])new QFilter("id", "=", (Object)taskId).toArray(), null);){
            if (dataSet.iterator().hasNext()) {
                Row row = (Row)dataSet.iterator().next();
                TaskInfo taskInfo = new TaskInfo();
                taskInfo.setId(taskId);
                taskInfo.setOrgId(row.getLong("org"));
                taskInfo.setAppId(row.getString("bizapp"));
                taskInfo.setTaskStatusByValue(row.getString("taskStatus"));
                taskInfo.setBatchNo(row.getString("batchno"));
                if (StringUtils.isNotEmpty((CharSequence)row.getString("reconresult"))) {
                    taskInfo.setCode(ReconcilationResultEnum.getOrgTypeEnumByIndex(Integer.parseInt(row.getString("reconresult"))));
                }
                TaskInfo taskInfo2 = taskInfo;
                return taskInfo2;
            }
        }
        return null;
    }

    public static void startTask(TaskInfo taskInfo, String instanceId, Date beginTime, String reconParamTag) {
        String reconParam = reconParamTag.length() > 100 ? reconParamTag.substring(0, 100) : reconParamTag;
        String sql = "update t_frm_task set ftaskstatus=?, fconsinst=?, fbegintime=?, fapiparam=?, fapiparam_tag=? where fid=?";
        DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{TaskStatusEnum.DOING.getValue(), instanceId, beginTime, reconParam, reconParamTag, taskInfo.getId()});
        taskInfo.setConsumed(true);
        taskInfo.setTaskStatus(TaskStatusEnum.DOING);
    }

    public static void failTask(TaskInfo taskInfo) {
        String[] errorArr = taskInfo.getError();
        String error = "";
        String errorTag = "";
        if (errorArr != null) {
            error = errorArr[0] == null ? "" : errorArr[0];
            error = error.length() > 200 ? error.substring(0, 200) : error;
            errorTag = errorArr[1] == null ? "" : errorArr[1];
        }
        int index = ReconcilationResultEnum.error.getIndex();
        String sql = "update t_frm_task set fpercent=?, ftaskstatus=?, ferror=?,ferror_tag=?,freconresult=?,fendtime=? where fid=?";
        DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{100, TaskStatusEnum.ERROR.getValue(), error, errorTag, index, new Date(), taskInfo.getId()});
        taskInfo.setTaskStatus(TaskStatusEnum.ERROR);
    }

    public static void failTask(String batchNo, Long taskId) {
        String taskStr = AppCacheHelper.getTaskCache(batchNo, taskId.toString());
        TaskInfo taskInfo = (TaskInfo)SerializationUtils.deSerializeFromBase64((String)taskStr);
        String[] errorArr = taskInfo.getError();
        String error = "";
        String errorTag = "";
        if (errorArr != null) {
            error = errorArr[0] == null ? "" : errorArr[0];
            error = error.length() > 200 ? error.substring(0, 200) : error;
            errorTag = errorArr[1] == null ? "" : errorArr[1];
        }
        int index = ReconcilationResultEnum.error.getIndex();
        String sql = "update t_frm_task set fpercent=?, ftaskstatus=?, ferror=?,ferror_tag=?,freconresult=?,fendtime=? where fid=?";
        DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{100, TaskStatusEnum.ERROR.getValue(), error, errorTag, index, new Date(), taskInfo.getId()});
        taskInfo.setTaskStatus(TaskStatusEnum.ERROR);
    }

    public static void finishTask(long taskId, ReconcilationResultEnum code) {
        String reconResult = " ";
        if (code != null) {
            reconResult = code.getIndex() + "";
        }
        String sql = "update t_frm_task set fpercent=?, ftaskstatus=?, freconresult=?, fendtime=? where fid=? and ftaskstatus not in (?,?,?)";
        DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{100, TaskStatusEnum.FINISHED.getValue(), reconResult, new Date(), taskId, TaskStatusEnum.STOPPED.getValue(), TaskStatusEnum.FINISHED.getValue(), TaskStatusEnum.ERROR.getValue()});
    }

    @Deprecated
    public static void finishTask(TaskInfo taskInfo) {
        String reconResult = taskInfo.getCode().getIndex() + "";
        String[] errorArr = taskInfo.getError();
        String error = " ";
        String errorTag = "";
        if (errorArr != null) {
            error = errorArr[0] == null ? "" : errorArr[0];
            errorTag = errorArr[1] == null ? "" : errorArr[1];
        }
        String sql = "update t_frm_task set fpercent=?, ftaskstatus=?, freconresult=?, ferror=?,ferror_tag=?, fendtime=? where fid=?";
        DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{100, TaskStatusEnum.FINISHED.getValue(), reconResult, error, errorTag, new Date(), taskInfo.getId()});
        taskInfo.setTaskStatus(TaskStatusEnum.FINISHED);
    }

    public static boolean isTaskOver(TaskInfo taskInfo) {
        if (taskInfo == null) {
            return false;
        }
        String infoStr = AppCacheHelper.getTaskCache(taskInfo.getBatchNo(), String.valueOf(taskInfo.getId()));
        if (StringUtils.isNotEmpty((CharSequence)infoStr)) {
            TaskInfo task = (TaskInfo)SerializationUtils.deSerializeFromBase64((String)infoStr);
            if (TaskStatusEnum.STOPPED == task.getTaskStatus() || TaskStatusEnum.FINISHED == task.getTaskStatus() || TaskStatusEnum.ERROR == task.getTaskStatus()) {
                return true;
            }
            return DataTypeEnum.OnlyStatus == task.getDataType() && ReconcilationResultEnum.fail == task.getCode();
        }
        String sql = "select ftaskstatus from t_frm_task where fid = ?";
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{taskInfo.getId()});){
            for (Row row : ds) {
                String taskStatus = row.getString("ftaskstatus");
                if (TaskStatusEnum.STOPPED.getValue().equals(taskStatus)) {
                    taskInfo.setTaskStatus(TaskStatusEnum.STOPPED);
                    boolean bl = true;
                    return bl;
                }
                if (!TaskStatusEnum.FINISHED.getValue().equals(taskStatus) && !TaskStatusEnum.ERROR.getValue().equals(taskStatus)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static void stopTask(TaskInfo taskInfo) {
        String[] errorArr = taskInfo.getError();
        if (errorArr != null) {
            String error = errorArr[0] == null ? "" : errorArr[0];
            String errorTag = errorArr[1] == null ? "" : errorArr[1];
            String sql = "update t_frm_task set ftaskstatus=?,fendtime=?,ferror=?,ferror_tag=? where fid=?";
            DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{TaskStatusEnum.STOPPED.getValue(), new Date(), error, errorTag, taskInfo.getId()});
            taskInfo.setTaskStatus(TaskStatusEnum.STOPPED);
        }
    }

    public static TaskInfo getTaskInfoFromCache(String taskId, String batchNo) {
        return (TaskInfo)SerializationUtils.deSerializeFromBase64((String)AppCacheHelper.getTaskCache(batchNo, taskId));
    }

    public static void updateTaskHeader(TaskInfo taskInfo) {
        String sql = "update t_frm_task set fbizappid=?,fbooktypeid=? where fid=?";
        DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{taskInfo.getAppId(), taskInfo.getBookTypeId(), taskInfo.getId()});
    }

    public static int updateTask(long taskId, long orgId, BizReconPlanModel planModel, ReconciliationParamModel paramModel, DynamicObject dataRule) {
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew();){
            DynamicObject taskInfoObj = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"frm_task");
            DynamicObjectCollection planEntrys = taskInfoObj.getDynamicObjectCollection("planentry");
            int acctRow = TaskDao.buildTaskEntry(taskId, orgId, planModel, planEntrys, paramModel, dataRule, AssistTypeEnum.Acct);
            int asstcatRow = TaskDao.buildTaskEntry(taskId, orgId, planModel, planEntrys, paramModel, dataRule, AssistTypeEnum.Asstact);
            int assistRow = TaskDao.buildTaskEntry(taskId, orgId, planModel, planEntrys, paramModel, dataRule, AssistTypeEnum.Assist);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskInfoObj});
            int n = acctRow + asstcatRow + assistRow;
            return n;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int buildTaskEntry(long taskId, long orgId, BizReconPlanModel planModel, DynamicObjectCollection planEntrys, ReconciliationParamModel paramModel, DynamicObject dataRule, AssistTypeEnum type) {
        List<BizReconPlanDetailModel> details = ReconciliationUtil.getDetailModel(planModel, type);
        if (details.size() == 0) {
            logger.info("TaskDao : build task entry detail size = 0 !");
            return 0;
        }
        int planIdIndex = 0;
        int totalRows = 0;
        int index = 0;
        long[] taskEntryIds = DB.genLongIds((String)"t_frm_task_entry", (int)details.size());
        ArrayList mqPublishParam = new ArrayList(10);
        for (BizReconPlanDetailModel planDetail : details) {
            void var24_23;
            ReconciliationUtil.planDetailAssist(planDetail, orgId);
            List<BizDataParam> list = ReconciliationParmUtil.getDataRuleParam(planDetail, dataRule, planDetail.getAmountTypeList(), paramModel, orgId, planModel.getReconAmountType());
            logger.info("TaskDao : planDetailid = {}, params size = {}", (Object)planDetail.getId(), (Object)list.size());
            DynamicObject entry = planEntrys.addNew();
            planDetail.setTaskEntryId(taskEntryIds[index++]);
            long entryId = planDetail.getTaskEntryId();
            entry.set("id", (Object)entryId);
            entry.set("seq", (Object)(++planIdIndex));
            entry.set("plandetailid", (Object)planDetail.getId());
            entry.set("assisttype", (Object)type.getValue());
            DynamicObjectCollection acctColls = entry.getDynamicObjectCollection("account");
            for (Long l : planDetail.getAccountIds()) {
                DynamicObject acct = acctColls.addNew();
                acct.set("fbasedataid", (Object)l);
                acct.set("fbasedataid_id", (Object)l);
            }
            DynamicObjectCollection amtTypeColls = entry.getDynamicObjectCollection("amttypes");
            for (Long amtType : planDetail.getAmountTypeList()) {
                DynamicObject amt = amtTypeColls.addNew();
                amt.set("fbasedataid", (Object)amtType);
                amt.set("fbasedataid_id", (Object)amtType);
            }
            entry.set("entryexeced", (Object)0);
            entry.set("entrystatus", (Object)"0");
            boolean bl = false;
            DynamicObjectCollection ruleEntrys = entry.getDynamicObjectCollection("ruleentry");
            if (list.size() == 0) {
                HashMap<String, Object> pubParam = new HashMap<String, Object>(3, 1.0f);
                pubParam.put("taskId", paramModel.getTaskInfo().getId());
                pubParam.put("reconParam", SerializationUtils.toJsonString((Object)paramModel));
                pubParam.put("onlyGlData", true);
                pubParam.put("bizParam", null);
                pubParam.put("bizConfig", null);
                pubParam.put("reconTab", type.getValue());
                pubParam.put("bizOrgIds", paramModel.getTaskInfo().getBizOrgIds());
                pubParam.put("planDetailModel", SerializationUtils.toJsonString((Object)planDetail));
                pubParam.put("dataRuleId", planModel.getRuleId());
                pubParam.put("reconAmountType", (Object)planModel.getReconAmountType());
                mqPublishParam.add(pubParam);
            } else {
                for (BizDataParam bizDataParam : list) {
                    int ruleIdIndex = 0;
                    BizDataSourceConfig sourceConfig = bizDataParam.getSourceConfig();
                    sourceConfig.setTaskEntryId(entryId);
                    DynamicObject detail = ruleEntrys.addNew();
                    detail.set("entryid", (Object)entryId);
                    detail.set("taskid", (Object)taskId);
                    detail.set("seq", (Object)(++ruleIdIndex));
                    detail.set("detailstatus", (Object)"0");
                    detail.set("ruleentryid", (Object)sourceConfig.getRuleEntryId());
                    detail.set("amttype", (Object)sourceConfig.getAmountTypeID());
                    detail.set("datatype", (Object)sourceConfig.getType().getValue());
                    detail.set("bizobj", (Object)bizDataParam.getEntityKey());
                    String dataFilterDesc = sourceConfig.getBillFilter().getExprDesc();
                    if (dataFilterDesc != null && dataFilterDesc.length() > 1000) {
                        dataFilterDesc = dataFilterDesc.substring(0, 999);
                    }
                    detail.set("datafilterdesc", (Object)dataFilterDesc);
                    if (paramModel.isEnableMq()) {
                        HashMap<String, Object> pubParam = new HashMap<String, Object>(3, 1.0f);
                        pubParam.put("taskId", paramModel.getTaskInfo().getId());
                        pubParam.put("reconParam", SerializationUtils.toJsonString((Object)paramModel));
                        pubParam.put("onlyGlData", false);
                        pubParam.put("bizParam", SerializationUtils.toJsonString((Object)bizDataParam));
                        pubParam.put("bizConfig", SerializationUtils.toJsonString((Object)sourceConfig));
                        pubParam.put("reconTab", type.getValue());
                        pubParam.put("bizOrgIds", paramModel.getTaskInfo().getBizOrgIds());
                        pubParam.put("planDetailModel", SerializationUtils.toJsonString((Object)planDetail));
                        pubParam.put("dataRuleId", planModel.getRuleId());
                        pubParam.put("reconAmountType", (Object)planModel.getReconAmountType());
                        mqPublishParam.add(pubParam);
                    }
                    ++var24_23;
                    ++totalRows;
                }
            }
            entry.set("entrytotalcount", (Object)((int)var24_23));
        }
        if (paramModel.isEnableMq()) {
            MessagePublisher pub = MQFactory.get().createSimplePublisher("fi", "fi.frm.checkaccount_queue_detail");
            for (Map map : mqPublishParam) {
                pub.publishInDbTranscation("fi", (Object)map);
            }
            pub.close();
        }
        return totalRows;
    }

    public static void startExecutePlanEntry(Long taskId, Long planEntryId) {
        String sql = "update t_frm_task_entry set fentrybegin=? , ftraceid=? , fstatus = '1' where fid=? and fplandetailid = ? and fstatus = '0'";
        DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{new Date(), RequestContext.get().getTraceId(), taskId, planEntryId});
    }

    public static boolean finishExecutePlanEntry(Long taskId, Long planEntryId, ReconcilationResultEnum reconCode) {
        String status = "2";
        if (ReconcilationResultEnum.fail == reconCode) {
            status = "4";
        }
        String sql = "update t_frm_task_entry set fentryend=? , fstatus = ? where fid=? and fplandetailid = ? and fstatus = '1'";
        return DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{new Date(), status, taskId, planEntryId});
    }

    public static void failExecutePlanEntry(Long taskId, Long planEntryId, String errorTag) {
        String sql = "update t_frm_task_entry set fentryend=? , fstatus = ? where fid=? and fplandetailid = ?";
        DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{new Date(), "3", taskId, planEntryId});
    }

    public static boolean isExecutePlanEntryFinish(Long taskEntryId) {
        String sql = "select ftotalcount,fexeced,fstatus from t_frm_task_entry where fentryid=?";
        boolean finish = (Boolean)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{taskEntryId}, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    String entryRowStatus = resultSet.getString("fstatus");
                    if ("2".equals(entryRowStatus) || "3".equals(entryRowStatus) || "4".equals(entryRowStatus)) {
                        return false;
                    }
                    int totalCount = resultSet.getInt("ftotalcount");
                    int execdCount = resultSet.getInt("fexeced");
                    return execdCount >= totalCount;
                }
                return false;
            }
        });
        return finish;
    }

    public static void startExecuteRuleEntry(Long taskId, Long ruleEntryId, Long taskEntryId) {
        String sql = "update t_frm_task_detail set fdetailbegin=?, fstatus = '1' , ftraceid=? where ftaskid=? and fruleentryid = ? and fentryid = ? ";
        DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{new Date(), RequestContext.get().getTraceId(), taskId, ruleEntryId, taskEntryId});
    }

    public static void failExecuteRuleEntry(Long taskId, Long ruleEntryId, Long taskEntryId) {
        String sql = "update t_frm_task_detail set fdetailend=?, fstatus = '3' , ftraceid=? where ftaskid=? and fruleentryid = ? and fentryid = ? ";
        DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{new Date(), RequestContext.get().getTraceId(), taskId, ruleEntryId, taskEntryId});
    }

    public static void finishExecuteRuleEntry(Long taskId, Long ruleEntryId, Long taskEntryId, int dataCount, String cacheId) {
        try (TXHandle h = TX.requiresNew();){
            try {
                String detail = "update t_frm_task_detail set fdetailend=?, fcount = ?, fstatus = '2', fdscacheid=? where ftaskid=? and fruleentryid = ? and fentryid = ? ";
                DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)detail, (Object[])new Object[]{new Date(), dataCount, cacheId, taskId, ruleEntryId, taskEntryId});
                String entry = "update t_frm_task_entry set fexeced=fexeced+1 where fid=? and fentryid = ? ";
                DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)entry, (Object[])new Object[]{taskId, taskEntryId});
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static Set<String> getTaskEntryDetailCachedId(Long taskEntryId) {
        String sql = "select fdetailid, fdscacheid from t_frm_task_detail where fentryid=?";
        Set cacheDsId = (Set)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{taskEntryId}, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet resultSet) throws Exception {
                HashSet<String> cacheSet = new HashSet<String>(resultSet.getRow());
                while (resultSet.next()) {
                    String fdscacheid = resultSet.getString("fdscacheid");
                    if (StringUtils.isEmpty((CharSequence)fdscacheid)) continue;
                    cacheSet.add(fdscacheid);
                }
                return cacheSet;
            }
        });
        return cacheDsId;
    }

    public static boolean isTaskAllFinish(Long id) {
        String sql = "select fstatus from t_frm_task_entry where fid = ?";
        boolean finish = (Boolean)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{id}, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet resultSet) throws Exception {
                int finishedRow = 0;
                int totalRow = 0;
                while (resultSet.next()) {
                    ++totalRow;
                    String status = resultSet.getString("fstatus");
                    if (!"2".equals(status) && !"3".equals(status) && !"4".equals(status)) continue;
                    ++finishedRow;
                }
                return finishedRow >= totalRow;
            }
        });
        return finish;
    }

    public static void updateTaskReconPlan(Long taskId, long planId, long ruleId, Long glAppCfgId) {
        long _glAppCfgId = 0L;
        if (glAppCfgId != null) {
            _glAppCfgId = glAppCfgId;
        }
        String sql = "update t_frm_task set freconplanid = ?, fdataruleid = ?, fglappid = ? where fid = ?";
        DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{planId, ruleId, _glAppCfgId, taskId});
    }
}

