/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.frm.common.cache.gl.CacheHelper;
import kd.fi.frm.common.cache.gl.CacheModule;
import kd.fi.frm.common.cache.gl.DistributeCache;
import kd.fi.frm.common.enums.PermissonType;
import kd.fi.frm.common.util.ContextUtil;

public class AccSysUtil {
    private AccSysUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static List<Long> getAcctOrgPkList(String entityId, boolean isIncludeUnit, PermissonType permType) {
        String appId = AppMetadataCache.getAppInfo((String)"iep").getId();
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)entityId, (String)permType.getPermId());
        LinkedHashSet<Long> orgSet = new LinkedHashSet<Long>();
        Map<Long, Set<Long>> viewOrgMap = isIncludeUnit ? AccSysUtil.getViewOrgMap() : AccSysUtil.getMainViewOrgMap();
        for (Set<Long> orgs : viewOrgMap.values()) {
            orgSet.addAll(orgs);
        }
        List permOrgs = new ArrayList();
        if (!permOrgRs.hasAllOrgPerm()) {
            permOrgs = permOrgRs.getHasPermOrgs();
            orgSet.retainAll(permOrgs);
        }
        HashSet permChildOrg = new HashSet(orgSet);
        if (isIncludeUnit) {
            Map<Long, Set> filteredViewOrgMap = viewOrgMap.entrySet().stream().filter(x -> {
                Set value = (Set)x.getValue();
                value.retainAll(permChildOrg);
                return !value.isEmpty();
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            DataSet orgStructureByViews = AccSysUtil.getOrgStructureByViews(filteredViewOrgMap.keySet());
            LinkedHashSet parentOrgs = new LinkedHashSet();
            for (Map.Entry<Long, Set> entry : filteredViewOrgMap.entrySet()) {
                List<Object> rs = new LinkedList();
                Set orgs = entry.getValue();
                orgs.retainAll(orgSet);
                if (!orgs.isEmpty()) {
                    rs = AccSysUtil.getParentOrgId(orgStructureByViews.copy().filter("view = " + entry.getKey()), orgs, false);
                }
                parentOrgs.addAll(rs);
            }
            if (!permOrgRs.hasAllOrgPerm()) {
                parentOrgs.retainAll(permOrgs);
            }
            parentOrgs.addAll(orgSet);
            orgSet = parentOrgs;
        }
        return new ArrayList<Long>(orgSet);
    }

    private static DataSet getOrgStructureByViews(Collection<Long> views) {
        QFilter mainViewFilter = new QFilter("view", "in", views);
        return QueryServiceHelper.queryDataSet((String)"GLUtil.getParentOrgId", (String)"bos_org_structure", (String)"org,parent,view", (QFilter[])new QFilter[]{mainViewFilter}, null);
    }

    private static Map<Long, Set<Long>> getViewOrgMap() {
        Map<Long, Map<Long, List<Long>>> viewOrgBTMap = AccSysUtil.getViewOrgBTMap();
        HashMap<Long, Set<Long>> viewOrgMap = new HashMap<Long, Set<Long>>(viewOrgBTMap.size());
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : viewOrgBTMap.entrySet()) {
            HashSet<Long> orgSet = new HashSet<Long>(entry.getValue().keySet());
            viewOrgMap.put(entry.getKey(), orgSet);
        }
        return viewOrgMap;
    }

    public static Map<Long, Map<Long, List<Long>>> getViewOrgBTMap() {
        Map<Long, Map<Long, List<Long>>> mainViewOrgBTMap = AccSysUtil.getMainViewOrgBTMap();
        Map<Long, Map<Long, List<Long>>> statViewOrgBTMap = AccSysUtil.getStatViewOrgBTMap();
        mainViewOrgBTMap.putAll(statViewOrgBTMap);
        return mainViewOrgBTMap;
    }

    private static Map<Long, Set<Long>> getMainViewOrgMap() {
        Map<Long, Map<Long, List<Long>>> viewOrgBTMap = AccSysUtil.getMainViewOrgBTMap();
        HashMap<Long, Set<Long>> viewOrgMap = new HashMap<Long, Set<Long>>(viewOrgBTMap.size());
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : viewOrgBTMap.entrySet()) {
            HashSet<Long> orgSet = new HashSet<Long>(entry.getValue().keySet());
            viewOrgMap.put(entry.getKey(), orgSet);
        }
        return viewOrgMap;
    }

    private static Map<Long, Map<Long, List<Long>>> getMainViewOrgBTMap() {
        return AccSysUtil.getViewOrgBTMapHelper(true);
    }

    private static Map<Long, Map<Long, List<Long>>> getStatViewOrgBTMap() {
        return AccSysUtil.getViewOrgBTMapHelper(false);
    }

    private static Map<Long, Map<Long, List<Long>>> getViewOrgBTMapHelper(boolean isMainView) {
        DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.accSys);
        String str = cache.get(isMainView ? "accsys-mainvieworgbooktype-cache" : "accsys-statvieworgbooktype-cache");
        if (str != null) {
            Map map = (Map)SerializationUtils.deSerializeFromBase64((String)str);
            return map;
        }
        HashMap<Long, Map<Long, List<Long>>> result = new HashMap<Long, Map<Long, List<Long>>>();
        QFilter[] bookQF = new QFilter[]{new QFilter("isbizunit", "=", (Object)"1")};
        QFilter[] viewQF = new QFilter[]{new QFilter("ismainview", "=", (Object)isMainView)};
        try (DataSet bookDataSet = QueryServiceHelper.queryDataSet((String)(AccSysUtil.class.getName() + ".getMainViewOrgBTMap#getBook"), (String)"gl_accountbook", (String)"bookstype,org,accountingsys", (QFilter[])bookQF, null);
             DataSet viewDataSet = QueryServiceHelper.queryDataSet((String)(AccSysUtil.class.getName() + ".getMainViewOrgBTMap#getView"), (String)"bd_accountingsysviewsch", (String)"id,accountingsys", (QFilter[])viewQF, null);
             DataSet finish = bookDataSet.join(viewDataSet, JoinType.INNER).on("accountingsys", "accountingsys").select(new String[]{"bookstype", "org"}, new String[]{"id"}).finish();){
            for (Row row : finish) {
                Map orgBookTypeMap;
                long mainView = row.getLong("id");
                long org = row.getLong("org");
                long bookType = row.getLong("bookstype");
                if (result.containsKey(mainView)) {
                    List<Long> bookTypeList;
                    orgBookTypeMap = (Map)result.get(mainView);
                    if (orgBookTypeMap.containsKey(org)) {
                        bookTypeList = (List)orgBookTypeMap.get(org);
                        bookTypeList.add(bookType);
                        orgBookTypeMap.put(org, bookTypeList);
                        result.put(mainView, orgBookTypeMap);
                        continue;
                    }
                    bookTypeList = new ArrayList<Long>();
                    bookTypeList.add(bookType);
                    orgBookTypeMap.put(org, bookTypeList);
                    result.put(mainView, orgBookTypeMap);
                    continue;
                }
                orgBookTypeMap = new HashMap();
                ArrayList<Long> bookTypes = new ArrayList<Long>();
                bookTypes.add(bookType);
                orgBookTypeMap.put(org, bookTypes);
                result.put(mainView, orgBookTypeMap);
            }
        }
        CacheHelper.getDistributeCache(CacheModule.accSys).put(isMainView ? "accsys-mainvieworgbooktype-cache" : "accsys-statvieworgbooktype-cache", SerializationUtils.serializeToBase64(result));
        return result;
    }

    public static List<Long> getParentOrgId(DataSet orgDataSet, Set<Long> childList, boolean includeChildSelf) {
        LinkedList<Long> result = new LinkedList<Long>();
        if (childList == null || childList.isEmpty()) {
            return result;
        }
        AccSysUtil.getParentOrgIdHelper(childList, result, orgDataSet);
        if (includeChildSelf) {
            result.addAll(childList);
        }
        return result;
    }

    private static void getParentOrgIdHelper(Set<Long> childList, LinkedList<Long> result, DataSet orgDataSet) {
        LinkedHashSet<Long> parentOrgId = new LinkedHashSet<Long>();
        String childStr = "(0)";
        if (!childList.isEmpty()) {
            childStr = childList.toString().replace('[', '(').replaceFirst("]", ")");
        }
        try (DataSet parentOrgSet = orgDataSet.copy().filter("org in " + childStr);){
            for (Row row : parentOrgSet) {
                Long parent = row.getLong("parent");
                if (parent == null || parent == 0L) continue;
                parentOrgId.add(parent);
            }
            if (parentOrgId.size() > 0) {
                for (Long pid : parentOrgId) {
                    if (result.contains(pid)) continue;
                    result.addFirst(pid);
                }
                AccSysUtil.getParentOrgIdHelper(parentOrgId, result, orgDataSet);
            }
        }
    }
}

