/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.formula.FormulaEngine;
import kd.fi.frm.common.util.EntityFieldTreeOption;
import kd.fi.frm.common.util.EntityFieldTreeResult;
import kd.fi.frm.common.util.EntityTreeUtil;
import kd.fi.frm.common.util.ExpressionType;
import kd.fi.frm.common.util.Token;
import org.apache.commons.collections4.CollectionUtils;

public class BuildTree {
    public static TreeNode buildTree(MainEntityType srcMainET, String key, ExpressionType type, boolean readChildEntity, Class<?> cls, boolean IncludeID) {
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        option.setEntityType((IDataEntityType)srcMainET);
        option.setReadEntryEntity(readChildEntity);
        option.setExprType(type);
        option.setFieldType(cls);
        option.setIncludeID(IncludeID);
        EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes(option);
        TreeNode tree = EntityTreeUtil.buildBillTree(result.getNodes());
        return tree;
    }

    public static TreeNode searchTree(String searchText, TreeNode rootNode) {
        if (StringUtils.isNotBlank((CharSequence)searchText) && CollectionUtils.isNotEmpty((Collection)rootNode.getChildren())) {
            rootNode.setChildren(BuildTree.getContains(rootNode.getChildren(), searchText));
        }
        return rootNode;
    }

    private static List<TreeNode> getContains(List<TreeNode> childrens, String searchText) {
        Iterator<TreeNode> iterator = childrens.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = iterator.next();
            treeNode.setIsOpened(true);
            if (CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) {
                treeNode.setChildren(BuildTree.getContains(treeNode.getChildren(), searchText));
            }
            if (!CollectionUtils.isEmpty((Collection)treeNode.getChildren()) || treeNode.getText().contains(searchText)) continue;
            iterator.remove();
        }
        return childrens;
    }

    public static String getLongName(String nodeID, String json) {
        TreeNode parent;
        TreeNode rootNode = new TreeNode();
        rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        TreeNode parentNode = rootNode.getTreeNode(nodeID, 6);
        if (null == parentNode) {
            return null;
        }
        Stack<String> stack = new Stack<String>();
        stack.push(parentNode.getText());
        while (StringUtils.isNotEmpty((CharSequence)parentNode.getParentid()) && !StringUtils.isEmpty((CharSequence)(parent = rootNode.getTreeNode(parentNode.getParentid(), 5)).getParentid())) {
            parentNode = parent;
            stack.push(parentNode.getText());
        }
        int size = stack.size();
        StringBuilder builder = new StringBuilder();
        for (int j = 0; j < size; ++j) {
            builder.append((String)stack.pop()).append(".");
        }
        String varCaption = builder.substring(0, builder.length() - 1);
        return varCaption;
    }

    public static String tranExpression(String expression, String json) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        String expressionDesc = expression;
        String[] vars = new String[]{};
        try {
            int endIndex = expression.indexOf(123);
            vars = endIndex != -1 ? BuildTree.extractVariables(expression) : FormulaEngine.extractVariables((String)expression);
        }
        catch (Throwable e) {
            return expression;
        }
        if (vars.length == 0 || StringUtils.isBlank((CharSequence)vars[0])) {
            return expressionDesc;
        }
        ArrayList<String> orderVars = new ArrayList<String>(vars.length);
        for (String string : vars) {
            orderVars.add(string);
        }
        orderVars.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() > o2.length()) {
                    return -1;
                }
                if (o1.length() < o2.length()) {
                    return 1;
                }
                return o2.compareTo(o1);
            }
        });
        HashMap<String, String> tmpVariables = new HashMap<String, String>(orderVars.size());
        int i = 1;
        Iterator<Object> iterator = orderVars.iterator();
        while (iterator.hasNext()) {
            String string;
            String paramVar = string = (String)iterator.next();
            int endIndex = expression.indexOf(123);
            if (endIndex != -1) {
                paramVar = "{" + string + "}";
            }
            String tempVariable = String.format("###%s###", String.valueOf(i));
            String varCaption = BuildTree.getLongName(paramVar, json);
            if (null == varCaption) {
                varCaption = string;
            }
            tmpVariables.put(tempVariable, varCaption);
            expressionDesc = expressionDesc.replace(string, tempVariable);
            ++i;
        }
        for (Map.Entry entry : tmpVariables.entrySet()) {
            expressionDesc = expressionDesc.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return expressionDesc;
    }

    public static String[] extractVariables(String expression) {
        ArrayList<String> variables = new ArrayList<String>();
        int len = expression.length();
        Token token = Token.Text;
        for (int pos = 0; pos < len; ++pos) {
            char c = expression.charAt(pos);
            switch (c) {
                case '{': {
                    boolean condition = pos + 1 < len && expression.charAt(pos + 1) == '{';
                    Token token2 = token = condition ? Token.Escape : Token.Variable;
                }
            }
            if (token != Token.Variable) continue;
            int endIndex = expression.indexOf(125, pos + 1);
            if (endIndex == -1) break;
            String variableName = expression.substring(pos + 1, endIndex);
            variables.add(variableName);
            pos = endIndex;
            token = Token.Text;
        }
        return variables.toArray(new String[variables.size()]);
    }
}

