/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.fs.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.frm.common.util.AppBookConfig;

public class DapCache {
    private static final String DapConfigCacheKey = "fi-ai-dapconfigs";
    private static Log log = LogFactory.getLog(DapCache.class);
    private static Map<String, AppBookConfig> appConfig = new HashMap<String, AppBookConfig>();
    private static volatile Map<String, String> billBookTypeFieldCache = new HashMap<String, String>();
    private static volatile Map<String, String> billBookFieldCache = new HashMap<String, String>();
    private static volatile Map<String, String> billEntityAppNumCache = new HashMap<String, String>();
    private static Map<String, AppBookConfig> orgConfig;

    public static Map<String, AppBookConfig> getOrgConfig() {
        return orgConfig;
    }

    public static Map<String, AppBookConfig> getAppConfig() {
        return appConfig;
    }

    public static String getBillBookTypeField(String billType) {
        return DapCache.getBillBookTypeField(billType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBillBookTypeField(String billType, EntityType firstEntity) {
        String cacheKey = billType;
        if (firstEntity != null) {
            cacheKey = cacheKey + firstEntity.getName();
        }
        if (billBookTypeFieldCache.containsKey(cacheKey)) {
            return billBookTypeFieldCache.get(cacheKey);
        }
        Class<DapCache> clazz = DapCache.class;
        synchronized (DapCache.class) {
            MainEntityType meta = EntityMetadataCache.getDataEntityType((String)billType);
            String appNum = meta.getAppId();
            if (!billEntityAppNumCache.containsKey(billType)) {
                billEntityAppNumCache.put(billType, appNum);
            }
            if (appConfig.get(appNum) == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            String bookTypeEntity = DapCache.appConfig.get((Object)appNum).bookTypeEntity;
            if (bookTypeEntity == null) {
                billBookTypeFieldCache.put(cacheKey, null);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            HashSet<String> selectEntitys = null;
            if (firstEntity != null) {
                selectEntitys = new HashSet<String>();
                selectEntitys.add(firstEntity.getName());
                if (firstEntity instanceof SubEntryType) {
                    selectEntitys.add(firstEntity.getParent().getName());
                }
            }
            String bookTypeField = DapCache.searchField((IDataEntityType)meta, bookTypeEntity, null, selectEntitys);
            billBookTypeFieldCache.put(cacheKey, bookTypeField);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return bookTypeField;
        }
    }

    public static String getBillBookField(String billType) {
        return DapCache.getBillBookField(billType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBillBookField(String billType, EntityType firstEntity) {
        if (billBookFieldCache.containsKey(billType)) {
            return billBookFieldCache.get(billType);
        }
        Class<DapCache> clazz = DapCache.class;
        synchronized (DapCache.class) {
            MainEntityType meta = EntityMetadataCache.getDataEntityType((String)billType);
            String appNum = meta.getAppId();
            if (!billEntityAppNumCache.containsKey(billType)) {
                billEntityAppNumCache.put(billType, appNum);
            }
            if (appConfig.get(appNum) == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            String bookEntity = DapCache.appConfig.get((Object)appNum).bookEntity;
            if (bookEntity == null) {
                billBookFieldCache.put(billType, null);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            HashSet<String> selectEntitys = null;
            if (firstEntity != null) {
                selectEntitys = new HashSet<String>();
                selectEntitys.add(firstEntity.getName());
                if (firstEntity instanceof SubEntryType) {
                    selectEntitys.add(firstEntity.getParent().getName());
                }
            }
            String bookField = DapCache.searchField((IDataEntityType)meta, bookEntity, null, selectEntitys);
            billBookFieldCache.put(billType, bookField);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return bookField;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBillEntityAppNumber(String billType) {
        if (billEntityAppNumCache.containsKey(billType)) {
            return billEntityAppNumCache.get(billType);
        }
        Class<DapCache> clazz = DapCache.class;
        synchronized (DapCache.class) {
            MainEntityType meta = EntityMetadataCache.getDataEntityType((String)billType);
            String appNum = meta.getAppId();
            if (!billEntityAppNumCache.containsKey(billType)) {
                billEntityAppNumCache.put(billType, appNum);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return appNum;
        }
    }

    private static String searchField(IDataEntityType meta, String entityNumber, String prefix, Set<String> selectEntitys) {
        String fieldName = null;
        for (IDataEntityProperty property : meta.getProperties()) {
            BasedataProp bdProp;
            if (property instanceof EntryProp) {
                EntityType childEntity;
                if (selectEntitys != null && !selectEntitys.contains(property.getName()) || StringUtils.isBlank((String)(childEntity = (EntityType)((EntryProp)property).getItemType()).getAlias())) continue;
                String epx = null;
                epx = prefix == null ? property.getName() : prefix + "." + property.getName();
                fieldName = DapCache.searchField((IDataEntityType)childEntity, entityNumber, epx, selectEntitys);
                if (fieldName == null) continue;
                return fieldName;
            }
            if (!(property instanceof BasedataProp) || !entityNumber.equalsIgnoreCase((bdProp = (BasedataProp)property).getBaseEntityId())) continue;
            if (prefix != null) {
                return prefix + "." + property.getName();
            }
            return property.getName();
        }
        return fieldName;
    }

    static {
        appConfig.put("fa", new AppBookConfig("fa", "fa_assetbook", "fa_depreuse", "t_bd_assetbookentry", "org", "depreuse"));
        appConfig.put("cal", new AppBookConfig("cal", "cal_bd_costaccount", "cal_bd_costaccounttype", "t_bd_costaccountentry", "calorg", null));
        appConfig.put("ar", new AppBookConfig("ar", "ar_policy", "ar_policytype", "t_bd_policybookentry", "org", "policytype"));
        orgConfig = new HashMap<String, AppBookConfig>(2);
        orgConfig.put("ap", new AppBookConfig("ap", null, null, "t_bd_glrefaporgs", "aporg", null));
        orgConfig.put("cas", new AppBookConfig("cas", null, null, "t_bd_glrefcasorgs", "casorg", null));
    }
}

