/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.util;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class DapUtil {
    public static final String BD_ACCOUNTINGSYS = "bd_accountingsys";

    public static Set<Long> getAcctOrgIncludeSelf(long bizOrgID) {
        Set<Long> accOrgs;
        Set<Long> set = DapUtil.getAcctOrgsFromAccountingSys(bizOrgID);
        set.add(bizOrgID);
        Set<Long> newSet = DapUtil.filterByAcctBook(set);
        if (newSet.size() == 0 && !DapUtil.stopBizRelation() && (accOrgs = DapUtil.getAcctOrgIds(bizOrgID)).size() > 0) {
            newSet = DapUtil.filterByAcctBook(accOrgs);
        }
        return newSet;
    }

    private static boolean stopBizRelation() {
        QFilter filter = new QFilter("number", "=", (Object)"2012@2013");
        return QueryServiceHelper.exists((String)"ai_basedatamapping", (QFilter[])new QFilter[]{filter});
    }

    private static Set<Long> filterByAcctBook(Set<Long> set) {
        QFilter h = new QFilter("org", "in", set);
        QFilter g = new QFilter("isbizunit", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"gl_accountbook", (String)"org.id", (QFilter[])new QFilter[]{h, g});
        HashSet<Long> newSet = new HashSet<Long>();
        for (DynamicObject book : coll) {
            newSet.add(book.getLong("org.id"));
        }
        return newSet;
    }

    private static Set<Long> getAcctOrgsFromAccountingSys(long bizOrgID) {
        String selectFields = "id,bizorgentry.bizorg bizorg,bizorgentry.bizacctorg bizacctorg";
        QFilter orgqf = new QFilter("bizorgentry.bizorg", "=", (Object)bizOrgID);
        DynamicObjectCollection bizColl = QueryServiceHelper.query((String)BD_ACCOUNTINGSYS, (String)selectFields, (QFilter[])new QFilter[]{orgqf});
        return bizColl.stream().map(e -> e.getLong("bizacctorg")).collect(Collectors.toSet());
    }

    private static Set<Long> getAcctOrgIds(long bizOrgID) {
        HashSet<Long> set = new HashSet<Long>();
        QFilter k = new QFilter("typerelation.totype", "=", (Object)"10");
        QFilter j = new QFilter("fromorg", "=", (Object)bizOrgID);
        DynamicObjectCollection bizOrgColl = QueryServiceHelper.query((String)"bos_org_orgrelation", (String)"fromorg,toorg,id", (QFilter[])new QFilter[]{j, k});
        if (null == bizOrgColl || bizOrgColl.size() == 0) {
            return set;
        }
        for (DynamicObject accsys : bizOrgColl) {
            set.add(accsys.getLong("toorg"));
        }
        return set;
    }

    public static Set<String> getVchFields(IDataEntityType entityType) {
        HashSet<String> fields = new HashSet<String>();
        for (IDataEntityProperty property : entityType.getProperties()) {
            if (property instanceof EntryProp || property instanceof SubEntryProp) {
                IDataEntityType childEntity = ((EntryProp)property).getItemType();
                fields.addAll(DapUtil.getVchFields(childEntity));
                continue;
            }
            if (!(property instanceof IFieldHandle)) continue;
            fields.add(property.getName());
        }
        return fields;
    }

    public static MainEntityType getEntityTypeByNumber(Object number) {
        MainEntityType srcMainET = null;
        if (number != null) {
            String entityNumber = number.toString();
            srcMainET = EntityMetadataCache.getDataEntityType((String)entityNumber);
        }
        return srcMainET;
    }

    public static boolean getBooleanMcParam(String key, Boolean defaultValue) {
        return Boolean.parseBoolean(System.getProperty(key, String.valueOf(defaultValue)));
    }
}

