/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;

public class DateUtil {
    private static final Map<String, ThreadLocal<SimpleDateFormat>> map = new HashMap<String, ThreadLocal<SimpleDateFormat>>();
    public static final String SHORT = "yyyy-MM-dd";
    public static final String LONG = "yyyy-MM-dd HH:mm:ss";

    public static SimpleDateFormat getShortFormat() {
        return map.get(SHORT).get();
    }

    public static Date addMonth(Date date, int imonth) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(2, imonth);
        return cd.getTime();
    }

    public static Date addDay(Date date, int iday) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(5, iday);
        return cd.getTime();
    }

    public static String getPeriodStr(Date startTime, Date endTime) {
        StringBuilder result = new StringBuilder();
        long diff = endTime.getTime() - startTime.getTime();
        long diffMillSeconds = diff % 1000L;
        long diffSeconds = diff / 1000L % 60L;
        long diffMinutes = diff / 60000L % 60L;
        long diffHours = diff / 3600000L % 24L;
        long diffDays = diff / 86400000L;
        if (diffDays > 0L) {
            result.append(diffDays).append(ResManager.loadKDString((String)"\u5929", (String)"DateUtil_0", (String)"fi-frm-common", (Object[])new Object[0]));
        }
        if (diffHours > 0L) {
            result.append(diffHours).append(ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"DateUtil_1", (String)"fi-frm-common", (Object[])new Object[0]));
        }
        if (diffMinutes > 0L) {
            result.append(diffMinutes).append(ResManager.loadKDString((String)"\u5206\u949f", (String)"DateUtil_2", (String)"fi-frm-common", (Object[])new Object[0]));
        }
        if (diffSeconds > 0L) {
            result.append(diffSeconds).append(ResManager.loadKDString((String)"\u79d2", (String)"DateUtil_3", (String)"fi-frm-common", (Object[])new Object[0]));
        }
        if (diffMillSeconds > 0L) {
            result.append(diffMillSeconds).append(ResManager.loadKDString((String)"\u6beb\u79d2", (String)"DateUtil_4", (String)"fi-frm-common", (Object[])new Object[0]));
        }
        if (result.length() == 0) {
            result.append(0).append(ResManager.loadKDString((String)"\u79d2", (String)"DateUtil_3", (String)"fi-frm-common", (Object[])new Object[0]));
        }
        return result.toString();
    }

    public static Date parseStrToDate(Object dateObj, String format) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        if (dateObj instanceof Date) {
            String dateStr = simpleDateFormat.format(dateObj);
            return simpleDateFormat.parse(dateStr);
        }
        return simpleDateFormat.parse(String.valueOf(dateObj));
    }

    static {
        map.put(SHORT, new ThreadLocal<SimpleDateFormat>(){

            @Override
            public SimpleDateFormat initialValue() {
                return new SimpleDateFormat(DateUtil.SHORT);
            }
        });
    }
}

