/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.util;

import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.frm.common.util.DapUtil;
import kd.fi.frm.common.util.EntityFieldTreeOption;
import kd.fi.frm.common.util.EntityFieldTreeResult;
import kd.fi.frm.common.util.ExpressionType;

class EntityFieldNodeHandle {
    private static Log log = LogFactory.getLog(EntityFieldNodeHandle.class);
    private EntityFieldTreeOption option;
    private Set<String> vchAbleFields;
    private EntityFieldTreeResult result = new EntityFieldTreeResult();

    public EntityFieldNodeHandle(EntityFieldTreeOption option) {
        this.option = option;
    }

    public EntityFieldTreeResult getNodes() {
        this.vchAbleFields = DapUtil.getVchFields(this.option.getEntityType());
        try {
            this.buildFldTreeNodes(this.option.getEntityType(), this.option.getParentNode(), this.option.isReadEntryEntity(), true, null, "");
        }
        catch (CloneNotSupportedException e) {
            log.error((Throwable)e);
        }
        if (this.option.getExprType() == ExpressionType.DynamicText) {
            TreeNode sscApproveMsg = new TreeNode(this.option.getEntityType().getName(), "{sscApproveMsg}", ResManager.loadKDString((String)"\u5171\u4eab\u5ba1\u6279\u4fe1\u606f", (String)"EntityTreeUtil_1", (String)"fi-ai-common", (Object[])new Object[0]));
            TreeNode sscInnerMsg = new TreeNode(this.option.getEntityType().getName(), "{sscInnerMsg}", ResManager.loadKDString((String)"\u5171\u4eab\u5185\u90e8\u8bf4\u660e", (String)"EntityTreeUtil_2", (String)"fi-ai-common", (Object[])new Object[0]));
            this.result.getNodes().add(sscApproveMsg);
            this.result.getNodes().add(sscInnerMsg);
        } else if (this.option.getFieldType() == DateTimeProp.class || this.option.getFieldType() == null) {
            // empty if block
        }
        return this.result;
    }

    private void buildFldTreeNodes(IDataEntityType entityType, TreeNode parentNode, boolean readEntryEntity, boolean searchSubBaseData, TreeNode currentEntityNode, String prefix) throws CloneNotSupportedException {
        if (currentEntityNode == null) {
            String parentId = "";
            if (parentNode != null) {
                parentId = parentNode.getId();
            }
            String entityNodeId = entityType.getName();
            String entityNodeName = "";
            if (((EntityType)entityType).getDisplayName() != null) {
                entityNodeName = ((EntityType)entityType).getDisplayName().toString();
            }
            this.result.getNonFields().add(entityNodeId);
            currentEntityNode = new TreeNode(parentId, entityNodeId, entityNodeName);
        }
        int oriNodeCount = this.result.getNodes().size();
        for (IDataEntityProperty property : entityType.getProperties()) {
            String pfx;
            boolean personNodeFlag = this.createPersonNode(prefix, property, currentEntityNode);
            if (personNodeFlag) continue;
            if (property instanceof EntryProp) {
                EntityType childEntity;
                this.result.getNonFields().add(property.getName());
                if (!readEntryEntity || StringUtils.isBlank((CharSequence)(childEntity = (EntityType)((EntryProp)property).getItemType()).getAlias())) continue;
                TreeNode entityNode = new TreeNode(currentEntityNode.getId(), property.getName(), ((EntryProp)property).getDisplayName().toString());
                String pfx2 = property.getName();
                if (!StringUtils.isBlank((CharSequence)prefix)) {
                    pfx2 = prefix + "." + property.getName();
                }
                this.buildFldTreeNodes((IDataEntityType)childEntity, currentEntityNode, readEntryEntity, searchSubBaseData, entityNode, pfx2);
                continue;
            }
            if (searchSubBaseData && this.vchAbleFields.size() > 0 && !this.vchAbleFields.contains(property.getName())) continue;
            if (property instanceof BasedataProp && searchSubBaseData) {
                BasedataProp bdProp = (BasedataProp)property;
                IDataEntityType bdType = bdProp.getComplexType();
                TreeNode entityNode = new TreeNode(currentEntityNode.getId(), property.getName(), ((BasedataProp)property).getDisplayName().toString());
                pfx = property.getName();
                if (!StringUtils.isBlank((CharSequence)prefix)) {
                    pfx = prefix + "." + property.getName();
                }
                this.buildFldTreeNodes(bdType, currentEntityNode, false, false, entityNode, pfx);
                continue;
            }
            TreeNode fldNode = this.buildFldTreeNode(property, currentEntityNode, prefix);
            if (fldNode == null) continue;
            this.result.getNodes().add(fldNode);
            if (!(property instanceof BasedataProp)) continue;
            BasedataProp bdProp = (BasedataProp)property;
            IDataEntityType bdType = bdProp.getComplexType();
            if (!(property instanceof FlexProp)) {
                try {
                    bdType = MetadataServiceHelper.getDataEntityType((String)bdType.getName());
                }
                catch (KDException ex) {
                    ex.printStackTrace();
                }
            }
            pfx = property.getName();
            if (!StringUtils.isBlank((CharSequence)prefix)) {
                pfx = prefix + "." + property.getName();
            }
            this.buildBDFldRefPropNodes(bdType, fldNode, pfx, true);
        }
        if (oriNodeCount != this.result.getNodes().size()) {
            this.result.getNodes().add(currentEntityNode);
        }
    }

    private void buildBDFldRefPropNodes(IDataEntityType bdType, TreeNode bdFldNode, String prefix, boolean loadSubBaseMeta) {
        for (IDataEntityProperty property : bdType.getProperties()) {
            TreeNode fldNode;
            boolean personNodeFlag = this.createPersonNode(prefix, property, bdFldNode);
            if (personNodeFlag || property instanceof EntryProp || (fldNode = this.buildFldTreeNode(property, bdFldNode, prefix)) == null) continue;
            this.result.getNodes().add(fldNode);
            if (!(property instanceof BasedataProp)) continue;
            BasedataProp bdProp2 = (BasedataProp)property;
            IDataEntityType bdType2 = bdProp2.getComplexType();
            if (loadSubBaseMeta && !(property instanceof FlexProp)) {
                try {
                    bdType2 = MetadataServiceHelper.getDataEntityType((String)bdType2.getName());
                }
                catch (KDException ex) {
                    ex.printStackTrace();
                }
            }
            String prefix2 = prefix + "." + bdProp2.getName();
            this.buildBDFldRefPropNodes(bdType2, fldNode, prefix2, false);
        }
    }

    private TreeNode buildFldTreeNode(IDataEntityProperty fldProperty, TreeNode parentNode, String prefix) {
        TreeNode fldNode = null;
        boolean isMatch = true;
        if (this.option.getFieldType() != null) {
            if (!this.option.getFieldType().isInstance(fldProperty)) {
                isMatch = false;
            }
            if (DecimalProp.class.equals(this.option.getFieldType()) && BigIntProp.class.isInstance(fldProperty)) {
                isMatch = false;
            }
        }
        DynamicProperty prop = (DynamicProperty)fldProperty;
        if (isMatch && prop != null && (this.option.isIncludeID() && "id".equalsIgnoreCase(prop.getName()) || prop.getDisplayName() != null) && StringUtils.isNotEmpty((CharSequence)fldProperty.getAlias())) {
            String fullPropName;
            String fldNodeId = fullPropName = StringUtils.isBlank((CharSequence)prefix) ? prop.getName() : prefix + "." + prop.getName();
            if (this.option.getExprType() == ExpressionType.DynamicText) {
                fldNodeId = "{" + fullPropName + "}";
            }
            String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
            fldNode = new TreeNode(parentNode.getId(), fldNodeId, fldNodeName);
        }
        return fldNode;
    }

    private boolean createPersonNode(String prefix, IDataEntityProperty property, TreeNode node) {
        boolean personPropertyFlag;
        boolean personFlag = prefix.endsWith("creator") || prefix.endsWith("modifier") || prefix.endsWith("disabler");
        boolean bl = personPropertyFlag = "number".equals(property.getName()) || "name".equals(property.getName()) || "masterid".equals(property.getName());
        if (personFlag) {
            TreeNode fldNode;
            if (personPropertyFlag && (fldNode = this.buildFldTreeNode(property, node, prefix)) != null) {
                this.result.getNodes().add(fldNode);
            }
            return true;
        }
        return false;
    }
}

