/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.frm.common.model.Expression;
import kd.fi.frm.common.model.ReturnData;
import kd.fi.frm.common.util.ExpressionType;

public class EntityFieldUtil {
    public static final String KEY_BUTTON_CLICK = "ai_button_key";
    public static final String KEY_VCHTEMPEDIT_ROWINDEX = "ai_row_index";
    protected static final Map<String, Map<String, List<String>>> localCahce = new HashMap<String, Map<String, List<String>>>(16);
    protected static final Map<String, String> numberlocalCahce = new HashMap<String, String>(16);
    private static final Set<String> escapeValidateGroupSet = new HashSet<String>(6){
        {
            this.add("ai_condition-condition");
            this.add("ai_expiredate-fvoucherdatedesc");
            this.add("ai_expression-fvchtypedesc");
            this.add("ai_expiredate-fbizDatedesc");
            this.add("ai_expression-freferencedesc");
            this.add("ai_expression-fmatchfieldname");
        }
    };
    public static final String formulaPattern = "(?<=\\{)(.+?)(?=\\})";

    public static String getEntryNameByPropName(IDataEntityType entityType, String propName) {
        Map<String, List<String>> entryFieldMap = EntityFieldUtil.getEntryFields(entityType);
        if (null == entryFieldMap || entryFieldMap.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, List<String>> entryField : entryFieldMap.entrySet()) {
            if (!entryField.getValue().contains(propName)) continue;
            return entryField.getKey();
        }
        return null;
    }

    public static String getEntryDisplayName(IDataEntityType entityType, String name) {
        if (null == entityType) {
            return null;
        }
        String key = entityType.getAlias() + "." + name;
        if (!numberlocalCahce.containsKey(key)) {
            for (IDataEntityProperty property : entityType.getProperties()) {
                if (!(property instanceof EntryProp)) continue;
                EntryProp entryProp = (EntryProp)property;
                name = entryProp.getName();
                String displayName = entryProp.getDisplayName().getLocaleValue();
                numberlocalCahce.put(key, displayName);
            }
        }
        return numberlocalCahce.get(key);
    }

    public static Set<String> resolveProperties(ExpressionType type, String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return null;
        }
        if (ExpressionType.Formula.getValue() == type.getValue()) {
            return EntityFieldUtil.formulaResolveProperties(content);
        }
        if (ExpressionType.AiFormula.getValue() == type.getValue()) {
            return EntityFieldUtil.aiFormulaResolveProperties(content);
        }
        return null;
    }

    private static Set<String> aiFormulaResolveProperties(String content) {
        HashSet<String> ret = new HashSet<String>();
        String[] props = StringUtils.split((String)content, (String)" ");
        for (int i = 0; i < props.length; ++i) {
            if (!StringUtils.isNotEmpty((CharSequence)props[i])) continue;
            ret.add(props[i]);
        }
        return ret;
    }

    private static Set<String> formulaResolveProperties(String content) {
        HashSet<String> ret = new HashSet<String>();
        Pattern compile = Pattern.compile(formulaPattern);
        Matcher matcher = compile.matcher(content);
        while (matcher.find()) {
            ret.add(matcher.group());
        }
        return ret;
    }

    private static Map<String, List<String>> getEntryFields(IDataEntityType entityType) {
        HashMap<String, List<String>> ret;
        if (null == entityType) {
            return null;
        }
        String cacheKey = entityType.getName();
        if (localCahce.containsKey(cacheKey)) {
            ret = localCahce.get(cacheKey);
        } else {
            ret = new HashMap();
            for (IDataEntityProperty property : entityType.getProperties()) {
                if (!(property instanceof EntryProp)) continue;
                EntryProp entryProp = (EntryProp)property;
                String entryName = entryProp.getName();
                DynamicObjectType entryType = entryProp.getDynamicCollectionItemPropertyType();
                DataEntityPropertyCollection properites = entryType.getProperties();
                if (properites == null || properites.isEmpty()) continue;
                for (IDataEntityProperty subProperty : properites) {
                    if (subProperty instanceof SubEntryProp) {
                        SubEntryProp subEntryProp = (SubEntryProp)subProperty;
                        DynamicObjectType subEntryType = subEntryProp.getDynamicCollectionItemPropertyType();
                        DataEntityPropertyCollection subProperites = subEntryType.getProperties();
                        if (subProperites == null || subProperites.isEmpty()) continue;
                        for (IDataEntityProperty subProperty2 : subProperites) {
                            if ("id".equalsIgnoreCase(subProperty2.getName()) || "seq".equalsIgnoreCase(subProperty2.getName())) continue;
                            ret.computeIfAbsent(entryName, p -> new ArrayList()).add(subProperty2.getName());
                        }
                        continue;
                    }
                    if ("id".equalsIgnoreCase(subProperty.getName()) || "seq".equalsIgnoreCase(subProperty.getName())) continue;
                    ret.computeIfAbsent(entryName, p -> new ArrayList()).add(subProperty.getName());
                }
            }
            localCahce.put(cacheKey, ret);
        }
        return ret;
    }

    public static ReturnData validateDiffEntry(Object exprObj, String currentFormId, String entitynumber, String cacheValue) {
        ReturnData returnData = new ReturnData();
        if (exprObj == null) {
            returnData.setStatus(true);
            return returnData;
        }
        MainEntityType entityType = EntityFieldUtil.getEntityType(entitynumber);
        String expression = "";
        ExpressionType type = null;
        if (exprObj instanceof Expression) {
            Expression vchExprObj = (Expression)exprObj;
            String exprObjStr = SerializationUtils.toJsonString((Object)vchExprObj);
            returnData.setDataStr(exprObjStr);
            expression = vchExprObj.getExpression();
            type = ExpressionType.Formula;
        } else if (exprObj instanceof CRFormula) {
            String exprObjStr;
            CRFormula crExprObj;
            String typeName = exprObj.getClass().getName();
            if ("kd.bos.entity.botp.CRFormula".equals(typeName)) {
                crExprObj = (CRFormula)exprObj;
                exprObjStr = SerializationUtils.toJsonString((Object)crExprObj);
                returnData.setDataStr(exprObjStr);
                expression = crExprObj.getExpression();
                type = ExpressionType.AiFormula;
            } else if ("kd.bos.entity.botp.CRCondition".equals(typeName)) {
                crExprObj = (CRCondition)exprObj;
                exprObjStr = SerializationUtils.toJsonString((Object)crExprObj);
                returnData.setDataStr(exprObjStr);
                expression = EntityFieldUtil.getCRConditionExpression((CRCondition)crExprObj);
                type = ExpressionType.Formula;
            }
        } else if (exprObj instanceof String) {
            String inputStr = (String)exprObj;
            returnData.setDataStr(inputStr);
            String[] fieldArr = StringUtils.split((String)inputStr, (String)".");
            StringBuilder sbExpression = new StringBuilder();
            for (int i = 0; i < fieldArr.length; ++i) {
                sbExpression.append('{');
                sbExpression.append(fieldArr[i]);
                sbExpression.append('}');
            }
            expression = sbExpression.toString();
            type = ExpressionType.Formula;
        }
        returnData.setFormId(currentFormId);
        Set<Object> properties = new HashSet(12);
        if (type != null) {
            properties = EntityFieldUtil.resolveProperties(type, expression);
        }
        if (properties == null || properties.isEmpty()) {
            returnData.setStatus(true);
            return returnData;
        }
        HashMap entryMap = new HashMap();
        properties.forEach(prop -> {
            String entryName = EntityFieldUtil.getEntryNameByPropName((IDataEntityType)entityType, prop);
            if (StringUtils.isNotEmpty((CharSequence)entryName)) {
                entryMap.computeIfAbsent(entryName, p -> new ArrayList()).add(prop);
            }
        });
        if (!escapeValidateGroupSet.contains(currentFormId)) {
            if (entryMap.size() > 1) {
                returnData.setMessage(ResManager.loadKDString((String)"\u6458\u8981\u53d6\u503c\u8868\u8fbe\u5f0f\u4e2d\u5df2\u914d\u7f6e\u7684\u5b57\u6bb5\u5b58\u5728\u8de8\u5206\u5f55\u7684\u60c5\u51b5\uff0c\u8bf7\u68c0\u67e5", (String)"EntityFieldUtil_0", (String)"fi-frm-common", (Object[])new Object[0]));
                returnData.setStatus(true);
                return returnData;
            }
            if (entryMap.size() == 1) {
                String currentEntryName = (String)entryMap.keySet().iterator().next();
                if (StringUtils.isNotEmpty((CharSequence)cacheValue)) {
                    Set<String> values = EntityFieldUtil.formulaResolveProperties(cacheValue);
                    for (String curValue : values) {
                        String[] cacheValueArr = StringUtils.split((String)curValue, (String)":");
                        String formId = cacheValueArr[0];
                        String entryName = cacheValueArr[1];
                        if (formId.equals(currentFormId) || StringUtils.equals((CharSequence)currentEntryName, (CharSequence)entryName)) continue;
                        String displayName = EntityFieldUtil.getEntryDisplayName((IDataEntityType)entityType, entryName);
                        String currentDisplayName = EntityFieldUtil.getEntryDisplayName((IDataEntityType)entityType, currentEntryName);
                        returnData.setStatus(true);
                        returnData.setMessage(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e2d\u914d\u7f6e\u7684\u5206\u5f55\uff1a%1$s\u548c\u5df2\u914d\u7f6e\u7684\u5206\u5f55\uff1a%2$s\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (String)"EntityFieldUtil_1", (String)"fi-frm-common", (Object[])new Object[0]), currentDisplayName, displayName));
                        return returnData;
                    }
                }
                returnData.setEntryName(currentEntryName);
            }
        }
        returnData.setStatus(true);
        return returnData;
    }

    private static String getCRConditionExpression(CRCondition crExprObj) {
        if (crExprObj == null) {
            return null;
        }
        StringBuilder sbExpression = new StringBuilder();
        FilterCondition filterCondition = crExprObj.getFilterCondition();
        if (filterCondition != null) {
            List rows = filterCondition.getFilterRow();
            for (SimpleFilterRow row : rows) {
                if (!StringUtils.isNotEmpty((CharSequence)row.getFieldName())) continue;
                String[] fieldArr = StringUtils.split((String)row.getFieldName(), (String)".");
                sbExpression.append('{');
                sbExpression.append(fieldArr[0]);
                sbExpression.append('}');
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)crExprObj.getExpression())) {
            String[] props = StringUtils.split((String)crExprObj.getExpression(), (String)" ");
            for (int i = 0; i < props.length; ++i) {
                if (!StringUtils.isNotEmpty((CharSequence)props[i])) continue;
                sbExpression.append('{');
                sbExpression.append(props[i]);
                sbExpression.append('}');
            }
        }
        return sbExpression.toString();
    }

    public static String getCacheValueFromFormParameter(IFormView view) {
        Object objEntryName = view.getFormShowParameter().getCustomParam("ai_vchtemplatecachekey");
        return objEntryName == null ? null : objEntryName.toString();
    }

    private static MainEntityType getEntityType(String entitynumber) {
        return MetadataServiceHelper.getDataEntityType((String)entitynumber);
    }
}

