/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.frm.common.model.SysParam;
import kd.fi.frm.common.model.bizdata.BizDataTypeEnum;
import kd.fi.frm.common.util.DateUtil;

public class FrmFilterUtil {
    private static final String CON_START_DATE = "con_startdate";

    public static List<QFilter[]> getSplitFiltersByDate(List<QFilter[]> allFilters, boolean needSplit, Date maxDate, Date minDate, int splitStep) {
        ArrayList<QFilter[]> splitFilters = new ArrayList<QFilter[]>(allFilters.size());
        if (!needSplit) {
            splitFilters.addAll(allFilters);
            return splitFilters;
        }
        ArrayList<Date[]> dateStepList = new ArrayList<Date[]>(12);
        while (maxDate.after(minDate)) {
            Date[] dateArr = new Date[]{maxDate, maxDate = DateUtil.addMonth(maxDate, -splitStep)};
            dateStepList.add(dateArr);
        }
        Date[] lastStep = new Date[2];
        lastStep[0] = maxDate;
        dateStepList.add(lastStep);
        QFilter[] filters = allFilters.get(0);
        ArrayList<QFilter> tmpList = new ArrayList<QFilter>(allFilters.size());
        String dateField = "";
        QFilter oriDateFilter = null;
        QFilter dateStepFilter = null;
        for (int i = 0; i < dateStepList.size(); ++i) {
            Date[] dates = (Date[])dateStepList.get(i);
            for (QFilter filter : filters) {
                QFilter copy = filter.copy();
                if (CON_START_DATE.equals(copy.getValue())) {
                    dateField = copy.getProperty();
                    QFilter tmpFilter = new QFilter(dateField, "<", (Object)dates[0]);
                    List nests = copy.getNests(Boolean.FALSE.booleanValue());
                    if (nests != null && nests.size() > 0) {
                        Iterator iterator = nests.iterator();
                        while (iterator.hasNext()) {
                            QFilter.QFilterNest nest = (QFilter.QFilterNest)iterator.next();
                            tmpFilter = tmpFilter.and(nest.getFilter());
                        }
                    }
                    tmpList.add(tmpFilter);
                    if (i == dateStepList.size() - 1) continue;
                    tmpList.add(new QFilter(dateField, ">=", (Object)dates[1]));
                    continue;
                }
                if (copy.toString().contains(CON_START_DATE)) {
                    List nests = copy.getNests(Boolean.FALSE.booleanValue());
                    for (QFilter.QFilterNest nest : nests) {
                        oriDateFilter = nest.getFilter();
                        if (!CON_START_DATE.equals(oriDateFilter.getValue())) continue;
                        dateField = oriDateFilter.getProperty();
                        break;
                    }
                    String expression = copy.toString();
                    if (i != dateStepList.size() - 1) {
                        String[] expressionArr = expression.split(CON_START_DATE);
                        expression = expressionArr[0] + "? AND " + dateField + ">=" + "? ";
                        if (expressionArr.length > 1) {
                            expression = expression + expressionArr[1];
                        }
                        dateStepFilter = QFilter.of((String)expression, (Object[])new Object[]{dates[0], dates[1]});
                    } else {
                        dateStepFilter = QFilter.of((String)expression.replace(CON_START_DATE, "?"), (Object[])new Object[]{dates[0]});
                    }
                    tmpList.add(dateStepFilter);
                    continue;
                }
                tmpList.add(copy);
            }
            splitFilters.add(tmpList.toArray(new QFilter[0]));
            tmpList.clear();
        }
        return splitFilters;
    }

    public static Set<QFilter> getSplitPeriodFilter(Boolean needSplitPeriod, QFilter billFilter, SysParam sysParam, int periodYear, int periodNumber) {
        HashSet<QFilter> billFilters = new HashSet<QFilter>(16);
        if (needSplitPeriod == null || !needSplitPeriod.booleanValue()) {
            billFilters.add(billFilter);
            return billFilters;
        }
        long balancePeriod = 100L * (long)periodYear + (long)periodNumber;
        if (sysParam == null || sysParam.getBeginPeriod() == null || sysParam.getBeginPeriod() <= 0L || sysParam.getBeginPeriod() > balancePeriod) {
            billFilters.add(billFilter);
            return billFilters;
        }
        long beginPeriod = sysParam.getBeginPeriod();
        String expression = billFilter.toString();
        expression = expression.replace(" < " + balancePeriod, " = " + balancePeriod);
        while (balancePeriod > beginPeriod) {
            long tmp = balancePeriod;
            if (periodNumber > 0 && --periodNumber == 0) {
                periodNumber = 12;
                --periodYear;
            }
            if ((balancePeriod = 100L * (long)periodYear + (long)periodNumber) > beginPeriod) {
                expression = expression.replace(" = " + tmp, " = " + balancePeriod);
            } else if (balancePeriod == beginPeriod) {
                expression = expression.replace("" + tmp, "" + balancePeriod);
                billFilters.add(QFilter.of((String)expression, (Object[])new Object[0]));
                expression = expression.replace(" = " + balancePeriod, " < " + balancePeriod);
            }
            billFilters.add(QFilter.of((String)expression, (Object[])new Object[0]));
        }
        if (billFilters.size() == 0) {
            billFilters.add(billFilter);
        }
        return billFilters;
    }

    public static QFilter getPkTableFilter(Tuple<QFilter, QFilter> specialFilter, List<QFilter> assFilterList, MainEntityType mainEntityType) {
        QFilter pkTableFilter = null;
        if (specialFilter != null) {
            QFilter item2 = (QFilter)specialFilter.item2;
            String property = item2.getProperty();
            Tuple<String, String> joinParts = FrmFilterUtil.getJoinParts(property, mainEntityType);
            Object value = item2.getValue();
            long functionId = Long.parseLong(((String)((List)value).get(0)).split("_")[1]);
            StringBuilder sql = new StringBuilder("INNER JOIN t_frm_pktable tfpk ON tfpk.fdataid = ");
            sql.append((String)joinParts.item1).append(".").append((String)joinParts.item2);
            sql.append(" AND tfpk.ffunctionid = ").append(functionId);
            ArrayList<QFilter> toRemoveFilters = new ArrayList<QFilter>(assFilterList.size());
            for (QFilter qFilter : assFilterList) {
                String tmpProperty = qFilter.getProperty();
                Tuple<String, String> tmpJoinParts = FrmFilterUtil.getJoinParts(tmpProperty, mainEntityType);
                if (!((String)tmpJoinParts.item1).equals(joinParts.item1)) continue;
                sql.append(" and ").append((String)tmpJoinParts.item1).append(".").append((String)tmpJoinParts.item2).append(" ");
                String cp = qFilter.getCP();
                sql.append(cp);
                sql.append(" ");
                if (cp.equals("in") || cp.equals("not in")) {
                    Collection collection = (Collection)qFilter.getValue();
                    String tmpValueStr = collection.isEmpty() ? "(0)" : collection.toString().replace("[", "(").replace("]", ")");
                    sql.append(tmpValueStr);
                } else {
                    sql.append(qFilter.getValue());
                }
                toRemoveFilters.add(qFilter);
            }
            if (toRemoveFilters.size() > 0) {
                assFilterList.removeAll(toRemoveFilters);
            }
            pkTableFilter = QFilter.joinSQL((String)((String)joinParts.item1), (String)sql.toString(), (Object[])new Object[0]);
        }
        return pkTableFilter;
    }

    private static Tuple<String, String> getJoinParts(String property, MainEntityType mainEntityType) {
        String joinEntity;
        String dbField = null;
        if (property.contains(".")) {
            String[] names = property.split("\\.");
            String name = names[names.length - 1];
            DynamicProperty dynamicProperty = mainEntityType.getProperty(names[0]);
            for (int index = 1; index < names.length - 1; ++index) {
                dynamicProperty = dynamicProperty instanceof EntryProp ? ((EntryProp)dynamicProperty).getDynamicCollectionItemPropertyType().getProperty(names[index]) : mainEntityType.getProperty(names[index]);
            }
            if (dynamicProperty instanceof EntryProp) {
                DynamicObjectType dynamicObjectType = ((EntryProp)dynamicProperty).getDynamicCollectionItemPropertyType();
                dbField = dynamicObjectType.getProperty(name).getAlias();
            } else if (dynamicProperty instanceof BasedataProp) {
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)((BasedataProp)dynamicProperty).getBaseEntityId());
                dbField = dataEntityType.getProperty(name).getAlias();
            }
            joinEntity = mainEntityType.getName() + "." + property.substring(0, property.lastIndexOf("."));
        } else {
            dbField = mainEntityType.getProperty(property).getAlias();
            joinEntity = mainEntityType.getName();
        }
        return new Tuple((Object)joinEntity, (Object)dbField);
    }

    public static Boolean needSplit(BizDataTypeEnum bizDataTypeEnum, Long ruleEntryId, String expr, SysParam sysParam, Date maxDate) {
        String ruleEntryIdStr = sysParam.getRuleEntryIdStr();
        if (ruleEntryIdStr == null || !ruleEntryIdStr.contains(String.valueOf(ruleEntryId))) {
            return Boolean.FALSE;
        }
        if (bizDataTypeEnum == BizDataTypeEnum.Debit || bizDataTypeEnum == BizDataTypeEnum.Credit) {
            return Boolean.FALSE;
        }
        Date minDate = sysParam.getMinDate();
        if (minDate == null || minDate.after(maxDate)) {
            return Boolean.FALSE;
        }
        int splitStep = sysParam.getSplitStep();
        if (splitStep <= 0) {
            return Boolean.FALSE;
        }
        String maxCp = "";
        QFilter oriDateFilter = QFilter.of((String)expr, (Object[])new Object[0]);
        QFilter tmpFilter = null;
        if (CON_START_DATE.equals(oriDateFilter.getValue())) {
            maxCp = oriDateFilter.getCP().trim();
        } else if (oriDateFilter.toString().contains(CON_START_DATE)) {
            List nests = oriDateFilter.getNests(Boolean.FALSE.booleanValue());
            for (QFilter.QFilterNest nest : nests) {
                tmpFilter = nest.getFilter();
                if (!CON_START_DATE.equals(tmpFilter.getValue())) continue;
                maxCp = tmpFilter.getCP();
                break;
            }
        } else {
            return Boolean.FALSE;
        }
        if (!"<".equals(maxCp)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static void createAndSetShardingHintContext(String entityKey, Set<Long> bizOrgIds, Date beginDate, Date endDate) {
        String table = null;
        String orgField = null;
        String dateField = null;
        switch (entityKey) {
            case "cal_costrecord_subentity": {
                table = "t_cal_calcostrecord";
                orgField = "fcostaccountid";
                dateField = "fbookdate";
                break;
            }
            case "t_cal_costadjustbill": {
                table = "t_cal_calcostrecord";
                orgField = "fcostaccount";
                dateField = "fbookdate";
                break;
            }
            case "cal_bal": {
                table = "t_cal_bal";
                orgField = "fcostaccountid";
                break;
            }
        }
        if (table == null) {
            return;
        }
        if (dateField != null) {
            ShardingHintContext.createAndSet((String)table, (HintCondition[])new HintCondition[]{new HintCondition(orgField, FilterType.in_range, bizOrgIds), new HintCondition(dateField, FilterType.ge, (Object)beginDate), new HintCondition(dateField, FilterType.le, (Object)endDate)});
        } else {
            ShardingHintContext.createAndSet((String)table, (HintCondition[])new HintCondition[]{new HintCondition(orgField, FilterType.in_range, bizOrgIds)});
        }
    }
}

