/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.util;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;

public class FrmPkTableUtil {
    private static final Log logger = LogFactory.getLog(FrmPkTableUtil.class);
    private static final String CREATE_TABLE_SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_FRM_PKTABLE') CREATE TABLE T_FRM_PKTABLE( fid bigint DEFAULT 0 not null primary key,ffunctionid bigint DEFAULT 0 not null,fdataid bigint default 0 not null)";
    private static final String CREATE_INDEX_SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_FRM_PKTABLE_FUNC') CREATE INDEX IDX_FRM_PKTABLE_FUNC ON T_FRM_PKTABLE ( FFUNCTIONID )";

    public static String createPkTable(Set<String> appNumberSet) {
        if (CollectionUtils.isEmpty(appNumberSet)) {
            return ResManager.loadKDString((String)"\u521b\u5efa\u5bf9\u8d26\u4e34\u65f6\u8868\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReconciliationServiceImpl_3", (String)"fi-frm-mservice", (Object[])new Object[0]);
        }
        HashSet<String> successApp = new HashSet<String>(appNumberSet.size());
        HashSet<String> existApp = new HashSet<String>(appNumberSet.size());
        try (DLock dLock = null;){
            dLock = DLock.create((String)"frm_api_createPkTable").fastMode();
            boolean getLock = dLock.tryLock(10000L);
            if (!getLock) {
                logger.error("\u521b\u5efa\u5bf9\u8d26\u4e34\u65f6\u8868\u83b7\u53d6\u9501\u5931\u8d25,appNumberSet={} !", appNumberSet);
            }
            for (String appNumber : appNumberSet) {
                DBRoute dbRoute = DBRoute.of((String)appNumber);
                boolean success = FrmPkTableUtil.checkAndCreatePkTable(dbRoute);
                if (success) {
                    successApp.add(appNumber);
                    continue;
                }
                existApp.add(appNumber);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (successApp.size() > 0) {
            stringBuilder.append(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7cfb\u7edf\uff1a%s\u521b\u5efa\u5bf9\u8d26\u4e34\u65f6\u8868\u6210\u529f\u3002", (String)"ReconciliationServiceImpl_4", (String)"fi-frm-mservice", (Object[])new Object[0]), ((Object)successApp).toString()));
        }
        if (existApp.size() > 0) {
            stringBuilder.append(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7cfb\u7edf\uff1a%s\u5df2\u5b58\u5728\u5bf9\u8d26\u4e34\u65f6\u8868\uff0c\u65e0\u9700\u521b\u5efa\u3002", (String)"ReconciliationServiceImpl_5", (String)"fi-frm-mservice", (Object[])new Object[0]), ((Object)existApp).toString()));
        }
        return stringBuilder.toString();
    }

    private static boolean checkAndCreatePkTable(DBRoute dbRoute) {
        boolean exitsTable = DB.exitsTable((DBRoute)dbRoute, (String)"T_FRM_PKTABLE");
        if (exitsTable) {
            return false;
        }
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            DB.execute((DBRoute)dbRoute, (String)CREATE_TABLE_SQL);
            DB.execute((DBRoute)dbRoute, (String)CREATE_INDEX_SQL);
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            try {
                logger.error("Create t_frm_pktable error : " + e.getMessage());
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

