/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.util;

import java.util.Arrays;
import java.util.LinkedHashMap;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.frm.common.model.FrmLogger;

public class FrmQueryServiceHelper {
    private static final Log logger = LogFactory.getLog(FrmQueryServiceHelper.class);

    public static DataSet queryDataSet(FrmLogger frmLogger, String algoKey, String entityName, String selectFields, QFilter[] filters, String orderBys, int top, boolean preview) {
        DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys, (int)top);
        String logMsg = "";
        if (preview) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("entityName", entityName);
            map.put("selectFields", selectFields);
            map.put("filters", Arrays.toString(filters));
            map.put("orderBys", orderBys);
            map.put("top", top + "");
            logMsg = SerializationUtils.toJsonString(map);
            logger.info(logMsg);
        }
        frmLogger.logDataSet(logMsg, ds);
        return ds;
    }

    public static DataSet queryDataSet(FrmLogger frmLogger, String algoKey, String entityName, String selectFields, QFilter[] filters, String orderBys, int top) {
        return FrmQueryServiceHelper.queryDataSet(frmLogger, algoKey, entityName, selectFields, filters, orderBys, top, true);
    }

    public static DataSet queryDataSet(FrmLogger frmLogger, String algoKey, String entityName, String selectFields, QFilter[] filters, String orderBys) {
        return FrmQueryServiceHelper.queryDataSet(frmLogger, algoKey, entityName, selectFields, filters, orderBys, -1, false);
    }
}

