/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.util;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.utils.StringUtils;

public class FrmStringUtil {
    public static final String COMMA = ",";
    public static final String DOT = ".";
    public static final String LF = "\n";

    public static String comma(String ... strings) {
        return FrmStringUtil.join(strings, COMMA);
    }

    public static String dot(String ... strings) {
        return FrmStringUtil.join(strings, DOT);
    }

    public static String join(Object[] objs, String delimiter) {
        return Stream.of(objs).map(v -> v == null ? "null" : v.toString()).collect(Collectors.joining(delimiter));
    }

    public static String joinCollection(Collection col, String delimiter) {
        return col.stream().map(v -> v == null ? "null" : v.toString()).collect(Collectors.joining(delimiter));
    }

    public static String id(String str) {
        if (str != null) {
            str = str + ".id";
        }
        return str;
    }

    public static String substring(String originStr, int length) {
        if (StringUtils.isEmpty((CharSequence)originStr)) {
            return originStr;
        }
        if (originStr.length() <= length) {
            return originStr;
        }
        return originStr.substring(0, length);
    }
}

