/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.util.bitset.LongBitSet;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.util.StringUtils;

public class MapUtil {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static boolean isEmpty(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return null != map && false == map.isEmpty();
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return MapUtil.newHashMap(16);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size, boolean isLinked) {
        int initialCapacity = (int)((float)size / 0.75f) + 1;
        return isLinked ? new LinkedHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return MapUtil.newHashMap(size, false);
    }

    public static <K, V> HashMap<K, V> newHashMap(boolean isLinked) {
        return MapUtil.newHashMap(16, isLinked);
    }

    public static void addAll(Map<String, Set<Long>> dest, Map<String, Set<Long>> src) {
        Set<Long> list = null;
        for (Map.Entry<String, Set<Long>> srcEntry : src.entrySet()) {
            list = dest.get(srcEntry.getKey());
            if (list == null) {
                list = new HashSet<Long>();
                dest.put(srcEntry.getKey(), list);
            }
            list.addAll((Collection<Long>)srcEntry.getValue());
        }
    }

    public static Map<String, Set<Object>> list2SetMap(Map<String, List<Object>> listMap) {
        HashMap<String, Set<Object>> setMap = new HashMap<String, Set<Object>>(listMap.size());
        for (Map.Entry<String, List<Object>> list : listMap.entrySet()) {
            List<Object> value = list.getValue();
            HashSet<Object> set = new HashSet<Object>(value.size());
            set.addAll(value);
            setMap.put(list.getKey(), set);
        }
        return setMap;
    }

    public static Map<String, Set<Object>> str2SetMap(String str) {
        Map<String, List<Object>> listMap = new HashMap<String, List<Object>>(2);
        if (StringUtils.isNotEmpty((String)str)) {
            listMap = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        }
        return MapUtil.list2SetMap(listMap);
    }

    public static Set<Long> bitSetMap2Set(LongBitSet bitSet) {
        if (bitSet == null) {
            return new HashSet<Long>(0);
        }
        HashSet<Long> idSet = new HashSet<Long>();
        Iterator it = bitSet.iterator();
        while (it.hasNext()) {
            idSet.add((Long)it.next());
        }
        return idSet;
    }
}

