/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;

public class MetadataUtil {
    private static final Log log = LogFactory.getLog(MetadataUtil.class);

    public static List<ComboItem> buildPropComboItems(Set<String> entityIds, MainEntityType srcMainEntityType, boolean searchSubEntity, boolean searchSubEntry, boolean searchSubEntrySubEntitySub) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        items.add(blankItem);
        MetadataUtil.searchBDField(entityIds, (EntityType)srcMainEntityType, items, null, null, searchSubEntity, searchSubEntry, searchSubEntrySubEntitySub);
        return MetadataUtil.resortComboItems(items);
    }

    public static void buildPropComboItemsV2(List<ComboItem> resultItems, Set<String> baseDataEntityIds, IDataEntityType rootEntityType, IDataEntityType srcMainEntityType, int maxLayer, int currentLayer, String parentKey, String parentName) {
        if (currentLayer > maxLayer) {
            return;
        }
        DataEntityPropertyCollection properties = srcMainEntityType.getProperties();
        for (IDataEntityProperty prop : properties) {
            String currentDisplayName;
            String currentKey;
            IDataEntityType itemType;
            String alias = prop.getAlias();
            if (prop instanceof FlexProp) continue;
            if (prop instanceof ItemClassProp) {
                String _currentDisplayName;
                String _currentKey;
                MainEntityType subEntityType;
                String currentDisplayName2;
                if (StringUtils.isEmpty((CharSequence)alias)) continue;
                ItemClassProp itemClassProp = (ItemClassProp)prop;
                String typePropName = itemClassProp.getTypePropName();
                ItemClassTypeProp mulItemType = (ItemClassTypeProp)properties.get((Object)typePropName);
                if (mulItemType == null) {
                    MainEntityType curLayerRootEntity = MetadataUtil.getRootEntityType(srcMainEntityType);
                    if (curLayerRootEntity == null) continue;
                    mulItemType = (ItemClassTypeProp)curLayerRootEntity.getProperties().get((Object)typePropName);
                }
                if (mulItemType == null) continue;
                ArrayList<String> itemTypePropPath = new ArrayList<String>(2);
                MetadataUtil.getParentPropPath(itemTypePropPath, mulItemType.getParent());
                StringBuilder typePropPath = new StringBuilder();
                for (int i = itemTypePropPath.size(); i > 0; --i) {
                    typePropPath.append((String)itemTypePropPath.get(i - 1)).append(".");
                }
                typePropPath.append(typePropName);
                List mulTypeEntityIds = mulItemType.getBaseEntityIds();
                String currentKey2 = StringUtils.isEmpty((CharSequence)parentKey) ? prop.getName() : parentKey + "." + prop.getName();
                String string = currentDisplayName2 = StringUtils.isEmpty((CharSequence)parentName) ? prop.getDisplayName().getLocaleValue() : parentName + "." + prop.getDisplayName().getLocaleValue();
                if (CollectionUtils.containsAny((Collection)mulTypeEntityIds, baseDataEntityIds)) {
                    for (String entityId : mulTypeEntityIds) {
                        if (!baseDataEntityIds.contains(entityId)) continue;
                        subEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
                        _currentKey = currentKey2 + "(" + entityId + ":" + typePropPath + ")";
                        _currentDisplayName = currentDisplayName2 + "(" + subEntityType.getDisplayName().getLocaleValue() + ")";
                        ComboItem item = new ComboItem();
                        item.setValue(_currentKey);
                        item.setCaption(new LocaleString(_currentDisplayName));
                        resultItems.add(item);
                    }
                    continue;
                }
                for (String entityId : mulTypeEntityIds) {
                    subEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
                    _currentKey = currentKey2 + "(" + entityId + ":" + typePropPath + ")";
                    _currentDisplayName = currentDisplayName2 + "(" + subEntityType.getDisplayName().getLocaleValue() + ")";
                    MetadataUtil.buildPropComboItemsV2(resultItems, baseDataEntityIds, rootEntityType, (IDataEntityType)subEntityType, maxLayer, 1 + currentLayer, _currentKey, _currentDisplayName);
                }
                continue;
            }
            if (prop instanceof BasedataProp) {
                String currentDisplayName3;
                if (StringUtils.isEmpty((CharSequence)alias)) continue;
                BasedataProp bdProp = (BasedataProp)prop;
                String currentKey3 = StringUtils.isEmpty((CharSequence)parentKey) ? prop.getName() : parentKey + "." + prop.getName();
                String string = currentDisplayName3 = StringUtils.isEmpty((CharSequence)parentName) ? prop.getDisplayName().getLocaleValue() : parentName + "." + prop.getDisplayName().getLocaleValue();
                if (baseDataEntityIds.contains(bdProp.getBaseEntityId())) {
                    ComboItem item = new ComboItem();
                    item.setValue(currentKey3);
                    item.setCaption(new LocaleString(currentDisplayName3));
                    resultItems.add(item);
                    continue;
                }
                MainEntityType subEntityType = MetadataServiceHelper.getDataEntityType((String)bdProp.getComplexType().getName());
                MetadataUtil.buildPropComboItemsV2(resultItems, baseDataEntityIds, rootEntityType, (IDataEntityType)subEntityType, maxLayer, 1 + currentLayer, currentKey3, currentDisplayName3);
                continue;
            }
            if (prop instanceof SubEntryProp) {
                SubEntryProp subEntryProp = (SubEntryProp)prop;
                itemType = subEntryProp.getItemType();
                currentKey = StringUtils.isEmpty((CharSequence)parentKey) ? prop.getName() : parentKey + "." + prop.getName();
                currentDisplayName = StringUtils.isEmpty((CharSequence)parentName) ? prop.getDisplayName().getLocaleValue() : parentName + "." + prop.getDisplayName().getLocaleValue();
                MetadataUtil.buildPropComboItemsV2(resultItems, baseDataEntityIds, rootEntityType, itemType, maxLayer, currentLayer, currentKey, currentDisplayName);
                continue;
            }
            if (!(prop instanceof EntryProp)) continue;
            EntryProp entryProp = (EntryProp)prop;
            itemType = entryProp.getItemType();
            currentKey = StringUtils.isEmpty((CharSequence)parentKey) ? prop.getName() : parentKey + "." + prop.getName();
            currentDisplayName = StringUtils.isEmpty((CharSequence)parentName) ? prop.getDisplayName().getLocaleValue() : parentName + "." + prop.getDisplayName().getLocaleValue();
            MetadataUtil.buildPropComboItemsV2(resultItems, baseDataEntityIds, rootEntityType, itemType, maxLayer, 1 + currentLayer, currentKey, currentDisplayName);
        }
    }

    private static void getParentPropPath(List<String> parentPath, IDataEntityType parentEntity) {
        if (parentEntity == null) {
            return;
        }
        IDataEntityType parent = parentEntity.getParent();
        if (parent != null) {
            String currentPropName = parentEntity.getName();
            parentPath.add(currentPropName);
            MetadataUtil.getParentPropPath(parentPath, parent);
        }
    }

    public static Map<String, ComboItem> buildPropComboItemsByItemClass(Set<String> entityIds, MainEntityType entityType, String parentName, String parentKey, boolean searchSubEntity, boolean searchSubEntry, boolean searchSubEntrySubEntitySub) {
        HashMap<String, ComboItem> result = new HashMap<String, ComboItem>();
        HashMap<String, ComboItem> itemProps = new HashMap<String, ComboItem>();
        HashMap<String, String> itemTypes = new HashMap<String, String>();
        MetadataUtil.searchBDFieldByItemClass(entityIds, (EntityType)entityType, itemProps, itemTypes, parentName, parentKey, searchSubEntity, searchSubEntry, searchSubEntrySubEntitySub);
        String filter = null;
        for (Map.Entry entry : itemProps.entrySet()) {
            String itemType = (String)entry.getKey();
            if (!itemTypes.containsKey(itemType)) continue;
            filter = itemType + "==" + (String)itemTypes.get(itemType);
            result.put(filter, (ComboItem)entry.getValue());
        }
        return result;
    }

    public static void buildAssistPropComboItems(List<ComboItem> resultItems, Set<String> baseDataEntityIds, IDataEntityType srcMainEntityType, int maxLayer, int currentLayer, String parentKey, String parentName) {
        if (currentLayer > maxLayer) {
            return;
        }
        DataEntityPropertyCollection properties = srcMainEntityType.getProperties();
        for (IDataEntityProperty prop : properties) {
            String currentDisplayName;
            String currentKey;
            IDataEntityType itemType;
            String currentDisplayName2;
            String currentKey2;
            String alias = prop.getAlias();
            if (prop instanceof FlexProp || prop instanceof ItemClassProp) continue;
            if (prop instanceof AssistantProp) {
                AssistantProp adProp;
                if (StringUtils.isEmpty((CharSequence)alias) || !baseDataEntityIds.contains((adProp = (AssistantProp)prop).getAsstTypeId())) continue;
                currentKey2 = StringUtils.isEmpty((CharSequence)parentKey) ? prop.getName() : parentKey + "." + prop.getName();
                currentDisplayName2 = StringUtils.isEmpty((CharSequence)parentName) ? prop.getDisplayName().getLocaleValue() : parentName + "." + prop.getDisplayName().getLocaleValue();
                ComboItem item = new ComboItem();
                item.setValue(currentKey2);
                item.setCaption(new LocaleString(currentDisplayName2));
                resultItems.add(item);
                continue;
            }
            if (prop instanceof BasedataProp) {
                if (StringUtils.isEmpty((CharSequence)alias)) continue;
                BasedataProp bdProp = (BasedataProp)prop;
                currentKey2 = StringUtils.isEmpty((CharSequence)parentKey) ? prop.getName() : parentKey + "." + prop.getName();
                currentDisplayName2 = StringUtils.isEmpty((CharSequence)parentName) ? prop.getDisplayName().getLocaleValue() : parentName + "." + prop.getDisplayName().getLocaleValue();
                MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)bdProp.getBaseEntityId());
                MetadataUtil.buildAssistPropComboItems(resultItems, baseDataEntityIds, (IDataEntityType)mainEntityType, maxLayer, 1 + currentLayer, currentKey2, currentDisplayName2);
                continue;
            }
            if (prop instanceof SubEntryProp) {
                SubEntryProp subEntryProp = (SubEntryProp)prop;
                itemType = subEntryProp.getItemType();
                currentKey = StringUtils.isEmpty((CharSequence)parentKey) ? prop.getName() : parentKey + "." + prop.getName();
                currentDisplayName = StringUtils.isEmpty((CharSequence)parentName) ? prop.getDisplayName().getLocaleValue() : parentName + "." + prop.getDisplayName().getLocaleValue();
                MetadataUtil.buildAssistPropComboItems(resultItems, baseDataEntityIds, itemType, maxLayer, currentLayer, currentKey, currentDisplayName);
                continue;
            }
            if (!(prop instanceof EntryProp)) continue;
            EntryProp entryProp = (EntryProp)prop;
            itemType = entryProp.getItemType();
            currentKey = StringUtils.isEmpty((CharSequence)parentKey) ? prop.getName() : parentKey + "." + prop.getName();
            currentDisplayName = StringUtils.isEmpty((CharSequence)parentName) ? prop.getDisplayName().getLocaleValue() : parentName + "." + prop.getDisplayName().getLocaleValue();
            MetadataUtil.buildAssistPropComboItems(resultItems, baseDataEntityIds, itemType, maxLayer, 1 + currentLayer, currentKey, currentDisplayName);
        }
    }

    private static List<ComboItem> resortComboItems(List<ComboItem> items) {
        items.sort(new Comparator<ComboItem>(){

            @Override
            public int compare(ComboItem arg0, ComboItem arg1) {
                String arg0Str = arg0.getValue();
                String arg1Str = arg1.getValue();
                if ("".equals(arg0Str)) {
                    return -1;
                }
                if ("".equals(arg1Str)) {
                    return 1;
                }
                if (arg0Str.indexOf(46) >= 0 && arg1Str.indexOf(46) < 0) {
                    return 1;
                }
                if (arg0Str.indexOf(46) < 0 && arg1Str.indexOf(46) >= 0) {
                    return -1;
                }
                return arg1.getValue().compareTo(arg0.getValue());
            }
        });
        return items;
    }

    private static void searchBDFieldByItemClass(Set<String> entityIds, EntityType entityType, Map<String, ComboItem> itemProps, Map<String, String> itemTypes, String parentName, String parentKey, boolean searchSubEntity, boolean searchSubEntry, boolean searchSubEntrySubEntitySub) {
        for (IDataEntityProperty prop : entityType.getProperties()) {
            String typeId2;
            if (prop instanceof EntryProp) {
                if (prop instanceof SubEntryProp && !searchSubEntry || !(prop instanceof SubEntryProp) && parentKey != null) continue;
                EntityType subEntityType = (EntityType)((EntryProp)prop).getItemType();
                Object parentKeySub = null;
                String parentNameSub = subEntityType.getDisplayName().toString();
                if (prop instanceof SubEntryProp) {
                    parentKeySub = prop.getParent().getName() + "." + prop.getName();
                    parentNameSub = parentName + "." + parentNameSub;
                } else if (parentKey != null) {
                    parentKeySub = parentKey + "." + prop.getName();
                    parentNameSub = parentName + "." + parentNameSub;
                } else {
                    parentKeySub = prop.getName();
                }
                MetadataUtil.searchBDFieldByItemClass(entityIds, subEntityType, itemProps, itemTypes, parentNameSub, (String)parentKeySub, searchSubEntrySubEntitySub, searchSubEntry, searchSubEntrySubEntitySub);
                continue;
            }
            if (prop instanceof ItemClassTypeProp) {
                ItemClassTypeProp typeProp = (ItemClassTypeProp)prop;
                for (String typeId2 : typeProp.getBaseEntityIds()) {
                    if (!entityIds.contains(typeId2)) continue;
                    if (parentKey == null) {
                        itemTypes.put(typeProp.getName(), typeId2);
                        continue;
                    }
                    itemTypes.put(parentKey + "." + typeProp.getName(), typeId2);
                }
                continue;
            }
            if (!(prop instanceof ItemClassProp)) continue;
            ItemClassProp itemProp = (ItemClassProp)prop;
            String parentNameNext = parentName + "." + itemProp.getDisplayName().toString();
            if (parentName == null) {
                parentNameNext = itemProp.getDisplayName().toString();
            }
            typeId2 = itemProp.getTypePropName();
            ComboItem item = new ComboItem();
            if (parentKey != null) {
                item.setValue(parentKey + "." + itemProp.getName());
            } else {
                item.setValue(itemProp.getName());
            }
            if (parentName != null) {
                item.setCaption(new LocaleString(parentNameNext));
            } else {
                parentNameNext = entityType.getDisplayName().toString() + "." + itemProp.getDisplayName().toString();
                item.setCaption(new LocaleString(parentNameNext));
            }
            if (parentKey != null) {
                itemProps.put(parentKey + "." + typeId2, item);
                continue;
            }
            itemProps.put(typeId2, item);
        }
    }

    private static MainEntityType getRootEntityType(IDataEntityType entityType) {
        if (entityType.getParent() instanceof MainEntityType) {
            return (MainEntityType)entityType.getParent();
        }
        if (entityType.getParent() instanceof SubEntryType) {
            return (MainEntityType)entityType.getParent().getParent().getParent();
        }
        return entityType.getParent() instanceof EntryType ? (MainEntityType)entityType.getParent().getParent() : null;
    }

    private static void searchBDField(Set<String> entityIds, EntityType entityType, List<ComboItem> items, String parentName, String parentKey, boolean searchSubEntity, boolean searchSubEntry, boolean searchSubEntrySubEntitySub) {
        for (IDataEntityProperty prop : entityType.getProperties()) {
            if (prop instanceof EntryProp) {
                if (prop instanceof SubEntryProp && !searchSubEntry || !(prop instanceof SubEntryProp) && parentKey != null) continue;
                EntityType subEntityType = (EntityType)((EntryProp)prop).getItemType();
                String parentKeySub = null;
                String parentNameSub = subEntityType.getDisplayName().toString();
                if (prop instanceof SubEntryProp) {
                    parentKeySub = prop.getParent().getName() + "." + prop.getName();
                    parentNameSub = parentName + "." + parentNameSub;
                } else if (parentKey != null) {
                    parentKeySub = parentKey + "." + prop.getName();
                    parentNameSub = parentName + "." + parentNameSub;
                } else {
                    parentKeySub = prop.getName();
                }
                MetadataUtil.searchBDField(entityIds, subEntityType, items, parentNameSub, parentKeySub, searchSubEntrySubEntitySub, searchSubEntry, searchSubEntrySubEntitySub);
                continue;
            }
            if (!(prop instanceof BasedataProp)) continue;
            BasedataProp bdProp = (BasedataProp)prop;
            String parentNameNext = parentName + "." + bdProp.getDisplayName().toString();
            if (parentName == null) {
                parentNameNext = bdProp.getDisplayName().toString();
            }
            if (entityIds.contains(bdProp.getBaseEntityId()) && StringUtils.isNotEmpty((CharSequence)prop.getAlias())) {
                ComboItem item = new ComboItem();
                if (parentKey != null) {
                    item.setValue(parentKey + "." + bdProp.getName());
                } else {
                    item.setValue(bdProp.getName());
                }
                if (parentName != null) {
                    item.setCaption(new LocaleString(parentNameNext));
                } else {
                    parentNameNext = entityType.getDisplayName().toString() + "." + bdProp.getDisplayName().toString();
                    item.setCaption(new LocaleString(parentNameNext));
                }
                items.add(item);
                continue;
            }
            if (!searchSubEntity || !StringUtils.isNotEmpty((CharSequence)prop.getAlias()) || bdProp instanceof FlexProp) continue;
            String propName = bdProp.getName();
            if (entityType instanceof EntryType) {
                propName = parentKey + "." + propName;
            }
            MetadataUtil.searchBDField(entityIds, (EntityType)EntityMetadataCache.getDataEntityType((String)bdProp.getComplexType().getName()), items, parentNameNext, propName, false, false, false);
        }
    }

    public static String getFormPropVisible(String formName, String propName) {
        FormMetadata formMeta = (FormMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)formName, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        String visible = null;
        for (ControlAp item : formMeta.getItems()) {
            if (!propName.equals(item.getKey())) continue;
            visible = item.getVisible();
            break;
        }
        return visible;
    }
}

