/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterInfo;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterService;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.business.service.GLAccountBookService;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.enums.ReconcilationResultEnum;
import kd.fi.frm.common.model.ReconciliationParam;
import kd.fi.frm.common.util.AppBookConfig;
import kd.fi.frm.common.util.DapCache;
import kd.fi.frm.common.util.RecAccountBookResult;
import kd.fi.frm.common.util.ReconciliationUtil;

public class RecAccountBookUtil {
    private static final Log logger = LogFactory.getLog(RecAccountBookUtil.class);
    private static final Map<String, String> appConfig = new HashMap<String, String>();
    private static final Map<String, String> orgConfig = new HashMap<String, String>();

    public static Map<String, String> getAppConfig() {
        return appConfig;
    }

    public static final Map<String, String> getOrgConfig() {
        return orgConfig;
    }

    public static RecAccountBookResult getAcctBookFromBiz(String tableName, long bizId) {
        RecAccountBookResult result = new RecAccountBookResult();
        ArrayList<Long> acctBookIds = new ArrayList<Long>();
        String sql = "SELECT t1.fid AS fid from " + tableName + " t1 INNER JOIN t_bd_accountbooks t2 ON t1.fid = t2.fid WHERE t1.fbasedataid = " + bizId + " AND t2.fenable = '1'";
        try (DataSet ds = DB.queryDataSet((String)"ALGO_KEY", (DBRoute)DBRoute.of((String)"gl"), (String)sql);){
            for (Row row : ds) {
                if (acctBookIds.contains(row.getLong("fid"))) continue;
                acctBookIds.add(row.getLong("fid"));
            }
        }
        if (acctBookIds.size() == 0) {
            result.setCode(ReconcilationResultEnum.noBook);
            return result;
        }
        if (acctBookIds.size() > 1) {
            result.setCode(ReconcilationResultEnum.moreBook);
            return result;
        }
        HashSet<Long> relateBizIds = new HashSet<Long>(6);
        String relateSql = "select fbasedataid from " + tableName + " where fid = " + acctBookIds.get(0);
        try (DataSet ds = DB.queryDataSet((String)"ALGO_KEY", (DBRoute)DBRoute.of((String)"gl"), (String)relateSql);){
            for (Row row : ds) {
                relateBizIds.add(row.getLong("fbasedataid"));
            }
        }
        if (relateBizIds.size() > 1) {
            result.setCode(ReconcilationResultEnum.notonly);
        } else {
            DynamicObject acctBook = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (String)"org,bookstype", (QFilter[])new QFilter("id", "=", acctBookIds.get(0)).toArray());
            result.setCode(ReconcilationResultEnum.Pass);
            result.setBizIds(relateBizIds);
            result.setAcctOrgId(acctBook.getLong("org_id"));
            result.setAcctBookTypeId(acctBook.getLong("bookstype_id"));
        }
        return result;
    }

    public static RecAccountBookResult checkNewAcctBooksTypeId(ReconciliationParam param, String appId) {
        String appNumber = param.getAppNumber();
        Long bizBookId = param.getBizBookId();
        Long bizOrgId = param.getOrgId();
        Set accountBookIdsFromBizOrg = GLAccountBookService.queryGlAccountBook((String)appId, null, (Long)bizOrgId);
        Set accountBookIdsFromBizBook = GLAccountBookService.queryGlAccountBook((String)appId, (Long)bizBookId, null);
        HashSet accountBookIds = new HashSet(16);
        if (!CollectionUtils.isEmpty((Collection)accountBookIdsFromBizOrg)) {
            accountBookIds.addAll(accountBookIdsFromBizOrg);
        }
        if (!CollectionUtils.isEmpty((Collection)accountBookIdsFromBizBook)) {
            accountBookIds.addAll(accountBookIdsFromBizBook);
        }
        RecAccountBookResult result = new RecAccountBookResult();
        if (CollectionUtils.isEmpty(accountBookIds)) {
            result.setCode(ReconcilationResultEnum.noBook);
            return result;
        }
        if (accountBookIds.size() > 1) {
            result.setCode(ReconcilationResultEnum.moreBook);
            return result;
        }
        Map accountBookMap = GLAccountBookService.queryAllBizAccountBook((long)accountBookIds.toArray(new Long[0])[0]);
        List bizIds = (List)accountBookMap.get(appNumber);
        if (bizIds.size() > 1) {
            result.setCode(ReconcilationResultEnum.notonly);
        } else {
            DynamicObject acctBook = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (String)"org,bookstype", (QFilter[])new QFilter("id", "=", (Object)accountBookIds.toArray(new Long[0])[0]).toArray());
            result.setCode(ReconcilationResultEnum.Pass);
            result.setBizIds(new HashSet<Long>(bizIds));
            result.setAcctOrgId(acctBook.getLong("org_id"));
            result.setAcctBookTypeId(acctBook.getLong("bookstype_id"));
        }
        return result;
    }

    public static Set<Long> getAcctBookFromFRM(String appNumber, String tableName, long acctBookId) {
        Set<Long> bizBookIDs = RecAccountBookUtil.getAcctBookIds(tableName, acctBookId);
        return RecAccountBookUtil.getBizBookOrgIds(appNumber, bizBookIDs);
    }

    public static Set<Long> getAcctBookIds(String tableName, long acctBookId) {
        HashSet<Long> bizBookIds = new HashSet<Long>();
        String relateSql = "select fbasedataid from " + tableName + " where fid = " + acctBookId;
        try (DataSet ds = DB.queryDataSet((String)"ALGO_KEY", (DBRoute)DBRoute.of((String)"gl"), (String)relateSql);){
            for (Row row : ds) {
                bizBookIds.add(row.getLong("fbasedataid"));
            }
        }
        return bizBookIds;
    }

    public static Set<Long> getBizBookOrgIds(String appNumber, Set<Long> bizOrgIds) {
        AppBookConfig appBookConfig = DapCache.getAppConfig().get(appNumber);
        if (appBookConfig != null) {
            DynamicObjectCollection bizOrgCollection = QueryServiceHelper.query((String)appBookConfig.bookEntity, (String)appBookConfig.bookEntityOrgField, (QFilter[])new QFilter[]{new QFilter("id", "in", bizOrgIds)});
            for (DynamicObject bizOrg : bizOrgCollection) {
                bizOrgIds.add(bizOrg.getLong(appBookConfig.bookEntityOrgField));
            }
        }
        return bizOrgIds;
    }

    public static RecAccountBookResult getAcctBookByBizBook(String appNumber, Long bizBookId, QFilter orgFilter, QFilter enableFilter, Set<Long> acctBookTypeIds) {
        RecAccountBookResult result = new RecAccountBookResult();
        String acctorgSelectFields = "bookstype.id,startperiod.id," + appConfig.get(appNumber) + ".id";
        DynamicObject[] acctBooks = BusinessDataServiceHelper.load((String)"gl_accountbook", (String)acctorgSelectFields, (QFilter[])new QFilter[]{orgFilter, enableFilter});
        int acctBookCount = 0;
        for (DynamicObject acctBook : acctBooks) {
            DynamicObjectCollection bizBooks = (DynamicObjectCollection)acctBook.get(appConfig.get(appNumber));
            if (bizBooks == null || bizBooks.size() == 0) continue;
            for (DynamicObject eachBook : bizBooks) {
                if (bizBookId.longValue() != eachBook.getLong("fbasedataid_id")) continue;
                if (bizBooks.size() > 1) {
                    result.setCode(ReconcilationResultEnum.notonly);
                    return result;
                }
                ++acctBookCount;
                acctBookTypeIds.add(acctBook.getLong("bookstype_id"));
            }
        }
        if (acctBookCount > 1) {
            result.setCode(ReconcilationResultEnum.moreBook);
        } else if (acctBookCount == 0) {
            result.setCode(ReconcilationResultEnum.noBook);
        }
        return result;
    }

    public static RecAccountBookResult getAcctBook4Org(String tableName, Long bizOrgId, QFilter orgFilter, QFilter enableFilter, Set<Long> acctBookTypeIds) {
        RecAccountBookResult result = new RecAccountBookResult();
        QFilter booksTypeFilter = new QFilter("bookstype.accounttype", "=", (Object)"1");
        String acctorgSelectFields = "id,bookstype.id,startperiod.id";
        DynamicObject[] acctBooks = BusinessDataServiceHelper.load((String)"gl_accountbook", (String)acctorgSelectFields, (QFilter[])new QFilter[]{orgFilter, enableFilter, booksTypeFilter});
        long acctBookId = 0L;
        for (DynamicObject acctBook : acctBooks) {
            acctBookTypeIds.add(acctBook.getLong("bookstype_id"));
            acctBookId = acctBook.getLong("id");
        }
        if (acctBookTypeIds.size() > 1) {
            result.setCode(ReconcilationResultEnum.moreBook);
        } else if (acctBookTypeIds.size() == 0) {
            result.setCode(ReconcilationResultEnum.noBook);
        } else if (tableName != null) {
            result.setCode(RecAccountBookUtil.isCorrect4Org(tableName, acctBookId, bizOrgId));
        } else {
            result.setCode(ReconcilationResultEnum.Pass);
        }
        return result;
    }

    private static ReconcilationResultEnum isCorrect4Org(String tableName, long acctBookId, Long bizOrgId) {
        if (tableName == null) {
            return null;
        }
        HashSet<Long> bizOrgIds = new HashSet<Long>();
        String sql = "select fid from " + tableName + " where fid = " + acctBookId;
        try (DataSet ds = DB.queryDataSet((String)"ALGO_KEY", (DBRoute)DBRoute.of((String)"gl"), (String)sql);){
            for (Row row : ds) {
                bizOrgIds.add(row.getLong("fid"));
            }
        }
        if (bizOrgIds.size() == 0 || bizOrgIds.size() == 1 && bizOrgIds.contains(bizOrgId)) {
            return null;
        }
        if (bizOrgIds.size() == 1 && !bizOrgIds.contains(bizOrgId)) {
            return ReconcilationResultEnum.noBook;
        }
        if (!bizOrgIds.contains(bizOrgId)) {
            return ReconcilationResultEnum.noBook;
        }
        return ReconcilationResultEnum.moreBook;
    }

    public static RecAccountBookResult getAccountBookResultFromFRM(String appNumber, Long orgId, Long booksTypeId, boolean isAPI) {
        boolean glAccountBookConfig = false;
        boolean appFlag = false;
        boolean newAccountBook = RecAccountBookUtil.isNewAccountBook();
        if (newAccountBook) {
            BookRegisterInfo bookRegisterInfo = BookRegisterService.queryByBizApp((String)appNumber);
            if (bookRegisterInfo != null) {
                glAccountBookConfig = true;
            }
        } else {
            appFlag = appConfig.containsKey(appNumber);
            boolean orgFlag = orgConfig.containsKey(appNumber);
            glAccountBookConfig = appFlag || orgFlag;
        }
        RecAccountBookResult result = new RecAccountBookResult();
        Set<Long> bizOrgIds = null;
        if (glAccountBookConfig) {
            QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
            QFilter bookTypeFilter = new QFilter("bookstype", "=", (Object)booksTypeId);
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            DynamicObject glAccountBook = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, enableFilter});
            if (glAccountBook == null) {
                result.setCode(ReconcilationResultEnum.noBook);
                return result;
            }
            result.setAcctOrgId(orgId);
            result.setAcctBookTypeId(booksTypeId);
            long glAccountBookId = glAccountBook.getLong("id");
            Set<Object> bizBookIds = new HashSet(4);
            String tableName = null;
            if (newAccountBook) {
                Map bizAccountBookMap = GLAccountBookService.queryAllBizAccountBook((long)glAccountBookId);
                if (bizAccountBookMap.isEmpty() && !isAPI) {
                    result.setCode(ReconcilationResultEnum.noBook);
                    return result;
                }
                List bizIds = (List)bizAccountBookMap.get(appNumber);
                if (!CollectionUtils.isEmpty((Collection)bizIds)) {
                    bizBookIds = new HashSet(bizIds);
                }
            } else {
                tableName = appFlag ? DapCache.getAppConfig().get((Object)appNumber).acctBookEnryTableName : DapCache.getOrgConfig().get((Object)appNumber).acctBookEnryTableName;
                bizBookIds = RecAccountBookUtil.getAcctBookIds(tableName, glAccountBookId);
            }
            bizOrgIds = RecAccountBookUtil.getBizBookOrgIds(appNumber, bizBookIds);
            if (bizOrgIds.size() > 0) {
                bizOrgIds.add(orgId);
                result.setBizIds(bizOrgIds);
            } else if (!isAPI) {
                result.setCode(ReconcilationResultEnum.noBook);
            }
        }
        if (result.getBizIds() == null || result.getBizIds().size() == 0) {
            HashSet<Long> acctOrgIds = new HashSet<Long>(1);
            acctOrgIds.add(orgId);
            Map<Long, Set<Long>> bizOrgMap = ReconciliationUtil.getBizOrgIds(acctOrgIds, booksTypeId);
            if (bizOrgMap == null) {
                result.setCode(ReconcilationResultEnum.noBook);
            } else {
                result.setAcctOrgId(orgId);
                result.setAcctBookTypeId(booksTypeId);
                bizOrgIds = bizOrgMap.get(orgId);
                if (bizOrgIds != null && bizOrgIds.size() > 0) {
                    result.setBizIds(bizOrgIds);
                } else {
                    result.setCode(ReconcilationResultEnum.noBook);
                }
            }
        }
        return result;
    }

    public static boolean isNewAccountBook() {
        String newGlAccountBook = AppCacheHelper.getResultCache("newGlAccountBook");
        if (!StringUtils.isEmpty((String)newGlAccountBook)) {
            return Boolean.parseBoolean(newGlAccountBook);
        }
        boolean newAccountBookFlag = true;
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"gl_accountbook");
        try {
            mainEntityType.getProperty("b_entry");
        }
        catch (Exception e) {
            logger.error("Get new gl_accountbook property failed !{}", (Object)e.getMessage());
            newAccountBookFlag = false;
        }
        AppCacheHelper.putResultCache("newGlAccountBook", newAccountBookFlag);
        return newAccountBookFlag;
    }

    static {
        appConfig.put("fa", "assetbook");
        appConfig.put("cal", "costaccount");
        appConfig.put("ar", "policybook");
        orgConfig.put("ap", "aporg");
        orgConfig.put("cas", "casorg");
    }
}

