/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.fi.frm.common.enums.AssistDataType;
import org.apache.commons.io.FilenameUtils;

public class ReconciliationFileUtil {
    private static final Log log = LogFactory.getLog(ReconciliationFileUtil.class);
    private static final String planFolder = "reconciliationPlan";
    private static final String commonFilterFolder = "commonFilterFolder";
    private static final String amountType = "amountType";
    private static final String planBill = "ai_reconciliation_scheme";
    private static final String amountTypeBill = "frm_amount_type";
    private static final String commonFilterBill = "frm_rec_common_filter";
    private static final String ruleBill = "frm_recdatarule";

    public static Map<String, String> exportPlan(String path, Set<Long> ids) {
        DynamicObject[] amountTypes;
        DynamicObject[] commonFilters;
        HashMap<String, String> result = new HashMap<String, String>();
        DynamicObject[] recPlan = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)planBill));
        HashSet<String> appIds = new HashSet<String>(recPlan.length);
        HashSet<Long> commonfilterIds = new HashSet<Long>();
        for (DynamicObject plan : recPlan) {
            DynamicObjectCollection entryCollon = plan.getDynamicObjectCollection("modularentryentity");
            DynamicObjectCollection fieldEnt = plan.getDynamicObjectCollection("fieldmapentry");
            for (DynamicObject dyns : entryCollon) {
                HashMap baseNumberMap = new HashMap();
                for (DynamicObject fieldEn : fieldEnt) {
                    String fieldKey = fieldEn.getString("fieldkey");
                    String bdtype = fieldEn.getString("datatype");
                    String entityName = "";
                    HashSet<Object> baseids = new HashSet<Object>();
                    if (AssistDataType.isBaseDataType(bdtype)) {
                        DynamicObjectCollection baseColl = dyns.getDynamicObjectCollection(fieldKey);
                        for (DynamicObject base : baseColl) {
                            baseids.add(base.get("fbasedataid_id"));
                        }
                        entityName = fieldEn.getString("entityid");
                    } else {
                        DynamicObjectCollection assistantEntry = dyns.getDynamicObjectCollection("acctassistentry");
                        for (DynamicObject base : assistantEntry) {
                            baseids.add(base.get("assistvalue"));
                        }
                        entityName = "bos_assistantdata_detail";
                    }
                    if (baseids.size() <= 0) continue;
                    ArrayList<String> numbers = new ArrayList<String>();
                    DynamicObjectCollection numberCol = QueryServiceHelper.query((String)entityName, (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", baseids)});
                    for (DynamicObject numberDyn : numberCol) {
                        numbers.add(numberDyn.getString("number"));
                    }
                    if (numbers.size() <= 0) continue;
                    baseNumberMap.put(fieldKey, numbers);
                }
                String baseNumberMapString = "";
                if (baseNumberMap.size() > 0) {
                    baseNumberMapString = SerializationUtils.toJsonString(baseNumberMap);
                }
                dyns.set("bdinfoimport", (Object)baseNumberMapString);
            }
            String planStr = ReconciliationFileUtil.getJson(plan);
            ReconciliationFileUtil.saveTplFile(path, plan.getString("number") + ".json", planStr, result, "reconciliationPlan/plan" + plan.getDynamicObject("createorg").getString("number") + plan.getString("number"));
            String appid = plan.getString("bizapp_id");
            DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)plan.getLong("reconciliactionconfig.id"), (String)ruleBill);
            String ruleString = ReconciliationFileUtil.getJson(rule);
            ReconciliationFileUtil.saveTplFile(path, "rule.json", ruleString, result, "reconciliationPlan/plan" + plan.getDynamicObject("createorg").getString("number") + plan.getString("number"));
            appIds.add(appid);
            DynamicObjectCollection rulEntity = rule.getDynamicObjectCollection("entryentity");
            for (DynamicObject dyn : rulEntity) {
                commonfilterIds.add(dyn.getLong("commonfilter_id"));
            }
        }
        for (DynamicObject commonFilter : commonFilters = BusinessDataServiceHelper.load((Object[])commonfilterIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)commonFilterBill))) {
            String comFilStr = ReconciliationFileUtil.getJson(commonFilter);
            ReconciliationFileUtil.saveTplFile(path, commonFilter.getDynamicObject("bizobj").getString("number") + commonFilter.getString("number") + ".json", comFilStr, result, commonFilterFolder);
        }
        HashSet<Long> idset = new HashSet<Long>();
        DynamicObjectCollection amountTypeIds = QueryServiceHelper.query((String)amountTypeBill, (String)"id", (QFilter[])new QFilter[]{new QFilter("bizapp", "in", appIds)});
        for (DynamicObject[] dyn : amountTypeIds) {
            idset.add(dyn.getLong("id"));
        }
        for (DynamicObject type : amountTypes = BusinessDataServiceHelper.load((Object[])idset.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)amountTypeBill))) {
            String amountTypeStr = ReconciliationFileUtil.getJson(type);
            ReconciliationFileUtil.saveTplFile(path, type.getDynamicObject("bizapp").getString("number") + ".json", amountTypeStr, result, amountType);
        }
        if (result.get("error") != null) {
            return result;
        }
        String zipPath = path + File.separator + planFolder;
        File zipFilePath = new File(FilenameUtils.getFullPath((String)zipPath), FilenameUtils.getName((String)zipPath));
        String zipPath2 = path + File.separator + commonFilterFolder;
        String zipPath3 = path + File.separator + amountType;
        String[] files = new String[3];
        if (zipFilePath.exists()) {
            files[0] = zipPath;
            files[1] = zipPath2;
            files[2] = zipPath3;
        }
        String fileName = path + File.separator + ids.iterator().next() + ".zip";
        File zipFile = new File(FilenameUtils.getFullPath((String)fileName), FilenameUtils.getName((String)fileName));
        try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
            ReconciliationFileUtil.zipFile(files, out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (zipFile.exists()) {
            result.put("fileName", zipFile.getPath());
        }
        ReconciliationFileUtil.deleteFile(zipPath);
        result.put("success", ResManager.loadKDString((String)"\u5907\u4efd\u6210\u529f", (String)"ReconciliationFileUtil_0", (String)"fi-ai-common", (Object[])new Object[0]));
        return result;
    }

    public static String getJson(DynamicObject dyn) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(dyn.getDynamicObjectType());
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setIsLocaleValueFull(true);
        binder.setOnlyDbProperty(false);
        String ruleString = jser.serializeToString((Object)dyn, null);
        return ruleString;
    }

    public static void deleteFile(String deletePath) {
        File file = new File(FilenameUtils.getFullPath((String)deletePath), FilenameUtils.getName((String)deletePath));
        ReconciliationFileUtil.deleteKd(file);
    }

    public static void deleteKd(File file) {
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            if (!file.delete()) {
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u6587\u4ef6\u51fa\u9519\uff0c\u539f\u6587\u4ef6%s\u65e0\u6cd5\u5220\u9664", (String)"ReconciliationFileUtil_14", (String)"fi-ai-common", (Object[])new Object[0]), file.getAbsolutePath()));
            }
        } else if (file.isDirectory()) {
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                File delfile = fileList[i];
                if (!delfile.isDirectory()) {
                    if (delfile.delete()) continue;
                    throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u6587\u4ef6\u51fa\u9519\uff0c\u539f\u6587\u4ef6%s\u65e0\u6cd5\u5220\u9664", (String)"ReconciliationFileUtil_14", (String)"fi-ai-common", (Object[])new Object[0]), delfile.getAbsolutePath()));
                }
                if (!delfile.isDirectory()) continue;
                ReconciliationFileUtil.deleteKd(fileList[i]);
            }
            if (!file.delete()) {
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u6587\u4ef6\u51fa\u9519\uff0c\u539f\u6587\u4ef6%s\u65e0\u6cd5\u5220\u9664", (String)"ReconciliationFileUtil_14", (String)"fi-ai-common", (Object[])new Object[0]), file.getAbsolutePath()));
            }
        }
    }

    private static String saveTplFile(String exportPath, String fileName, String fileContext, Map<String, String> checkInMsg, String folder) {
        try {
            File file;
            String fullPath = ReconciliationFileUtil.getFullPath(exportPath, fileName, folder);
            String[] abovePath = fullPath.split(fileName);
            File fileAbovePath = new File(FilenameUtils.getFullPath((String)abovePath[0]), FilenameUtils.getName((String)abovePath[0]));
            if (!fileAbovePath.exists()) {
                fileAbovePath.mkdirs();
            }
            if ((file = new File(FilenameUtils.getFullPath((String)fullPath), FilenameUtils.getName((String)fullPath))).exists() && !file.delete()) {
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u6587\u4ef6\u51fa\u9519\uff0c\u539f\u6587\u4ef6%s\u65e0\u6cd5\u5220\u9664", (String)"ReconciliationFileUtil_15", (String)"fi-ai-common", (Object[])new Object[0]), fullPath));
            }
            if (!file.createNewFile()) {
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u6587\u4ef6\u51fa\u9519\uff0c\u6587\u4ef6%s\u4e0d\u5408\u6cd5", (String)"ReconciliationFileUtil_16", (String)"fi-ai-common", (Object[])new Object[0]), fullPath));
            }
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                writer.write(fileContext);
            }
            return fullPath;
        }
        catch (IOException e) {
            log.error((Throwable)e);
            checkInMsg.put("error", String.format(ResManager.loadKDString((String)"\u751f\u6210\u6587\u4ef6\uff1a%1$s\u51fa\u9519:%2$s", (String)"ReconciliationFileUtil_6", (String)"fi-frm-common", (Object[])new Object[0]), fileName, e.getMessage()));
            return "";
        }
    }

    private static String getFullPath(String exportPath, String filename, String folder) {
        String fullPath = String.format("%s" + System.getProperty("file.separator") + folder + System.getProperty("file.separator") + "%s", exportPath, filename);
        return fullPath;
    }

    private static void zipFile(String[] files, ZipOutputStream out) {
        try {
            for (String fileName : files) {
                File file = new File(FilenameUtils.getFullPath((String)fileName), FilenameUtils.getName((String)fileName));
                String path = file.getAbsolutePath();
                if (file.isDirectory()) {
                    File[] listFiles = file.listFiles();
                    String[] tempFiles = new String[listFiles.length];
                    int i = 0;
                    for (File tempFile : listFiles) {
                        tempFiles[i++] = tempFile.getAbsolutePath();
                    }
                    ReconciliationFileUtil.zipFile(tempFiles, out);
                    continue;
                }
                int t = -1;
                if (path.contains(planFolder)) {
                    t = path.indexOf(planFolder);
                } else if (path.contains(commonFilterFolder)) {
                    t = path.indexOf(commonFilterFolder);
                } else if (path.contains(amountType)) {
                    t = path.indexOf(amountType);
                }
                if (t == -1) {
                    return;
                }
                path = path.substring(t);
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                    ZipEntry entry = new ZipEntry(path);
                    entry.setMethod(8);
                    out.putNextEntry(entry);
                    int n = 0;
                    byte[] buf = new byte[1024];
                    while ((n = in.read(buf)) != -1) {
                        out.write(buf, 0, n);
                    }
                    out.closeEntry();
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public static Map<String, List<String>> uploadRule(String fileUrl, Long orgId, boolean isCover) {
        Map<String, List<String>> result = new HashMap<String, List<String>>(12);
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        TempFileCacheDownloadable.Content zipContent = null;
        try {
            String[] queryParams = new URL(fileUrl).getQuery().split("&");
            HashMap<String, String> downloadFileParams = new HashMap<String, String>(queryParams.length);
            for (String queryParam : queryParams) {
                String[] p = queryParam.split("=");
                downloadFileParams.put(p[0], p[1]);
            }
            zipContent = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
        }
        catch (MalformedURLException exp) {
            log.error((Throwable)exp);
            ReconciliationFileUtil.puterroe(result, exp.getMessage());
            return result;
        }
        InputStream inStream = zipContent.getInputStream();
        result = ReconciliationFileUtil.saveZip(inStream, orgId, isCover);
        return result;
    }

    public static void uploadRuleForTest(InputStream inStream, Long orgId, boolean isCover) {
        ReconciliationFileUtil.saveZip(inStream, orgId, isCover);
    }

    private static Map<String, List<String>> saveZip(InputStream inStream, Long orgId, boolean isCover) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(16);
        String jsonFileSuffix = ".json";
        int limitsiz = 0x500000;
        try (ZipInputStream zipIn = new ZipInputStream(inStream);
             TXHandle tx = TX.requiresNew();){
            ArrayList<String> planList = new ArrayList<String>();
            ArrayList<String> ruleList = new ArrayList<String>();
            ArrayList<String> amountTypeList = new ArrayList<String>();
            ArrayList<String> commonFilterList = new ArrayList<String>();
            ZipEntry zipEntry = null;
            while ((zipEntry = zipIn.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                String entityName = planBill;
                Iterator metaName = zipEntry.getName();
                String[] splitWindows = ((String)((Object)metaName)).split("\\\\");
                String[] splitLinuex = ((String)((Object)metaName)).split("/");
                if (((String)((Object)metaName)).startsWith(amountType)) {
                    entityName = amountTypeBill;
                } else if (((String)((Object)metaName)).startsWith(commonFilterFolder)) {
                    entityName = commonFilterBill;
                } else if (splitWindows[splitWindows.length - 1].startsWith("rule") || splitLinuex[splitLinuex.length - 1].startsWith("rule")) {
                    entityName = ruleBill;
                }
                int readLength = 0;
                int len = 0;
                byte[] buf = new byte[limitsiz];
                StringBuilder contentBuilder = new StringBuilder();
                if (!((String)((Object)metaName)).endsWith(jsonFileSuffix)) continue;
                while ((readLength = zipIn.read()) != -1) {
                    buf[len] = (byte)readLength;
                    if (++len != limitsiz) continue;
                    contentBuilder.append(new String(buf, 0, len));
                    len = 0;
                }
                if (len > 0) {
                    contentBuilder.append(new String(buf, 0, len));
                }
                String content = contentBuilder.toString();
                if (entityName.equals(planBill)) {
                    planList.add(content);
                    continue;
                }
                if (entityName.equals(ruleBill)) {
                    ruleList.add(content);
                    continue;
                }
                if (entityName.equals(amountTypeBill)) {
                    amountTypeList.add(content);
                    continue;
                }
                commonFilterList.add(content);
            }
            HashMap<Long, Object> oldIdToNewId = new HashMap<Long, Object>();
            try {
                for (String content : commonFilterList) {
                    ReconciliationFileUtil.importSave(content, commonFilterBill, false, orgId, isCover, oldIdToNewId);
                }
                for (String content : amountTypeList) {
                    ReconciliationFileUtil.importSave(content, amountTypeBill, false, orgId, isCover, oldIdToNewId);
                }
                for (String content : ruleList) {
                    ReconciliationFileUtil.importSave(content, ruleBill, true, orgId, isCover, oldIdToNewId);
                }
                for (String content : planList) {
                    ReconciliationFileUtil.importSave(content, planBill, true, orgId, isCover, oldIdToNewId);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            if (e instanceof KDBizException) {
                ReconciliationFileUtil.puterroe(result, e.getMessage());
            } else {
                ReconciliationFileUtil.puterroe(result, ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            return result;
        }
        return result;
    }

    private static Map<String, List<String>> puterroe(Map<String, List<String>> result, String errorMsg) {
        List<String> errors = result.get("ERROR");
        if (errors == null) {
            errors = new ArrayList<String>();
        }
        errors.add(errorMsg);
        result.put("ERROR", errors);
        return result;
    }

    private static Map<Long, Object> importSave(String content, String entityName, boolean isBaseOrgTpl, Long orgId, boolean isCover, Map<Long, Object> oldIdToNewId) {
        List idObjs;
        OperationResult executeOperate;
        String appNumer;
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)ORM.create().getDataEntityType(entityName));
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        DynamicObject dyn = (DynamicObject)jser.deserializeFromString(content, null);
        String accTypeNumber = "";
        if (entityName.equals(planBill)) {
            accTypeNumber = dyn.getDynamicObject("accounttable").getString("number");
        }
        HashMap<String, DynamicObject> fieldMap = new HashMap<String, DynamicObject>();
        if (entityName.equals(planBill) || entityName.equals(commonFilterBill)) {
            DynamicObjectCollection fieldmapentry = dyn.getDynamicObjectCollection("fieldmapentry");
            for (DynamicObject field : fieldmapentry) {
                fieldMap.put(field.getString("fieldkey"), field);
            }
        }
        DataEntityPropertyCollection properties = dyn.getDynamicObjectType().getProperties();
        DynamicObject newDyn = null;
        if (entityName.equals(planBill)) {
            appNumer = dyn.getDynamicObject("bizapp").getString("number");
            Object accountTableId = dyn.getDynamicObject("accounttable").getPkValue();
            QFilter createOrgF = new QFilter("createorg", "=", (Object)orgId);
            QFilter bizappF = new QFilter("bizapp.number", "=", (Object)appNumer);
            QFilter accountTableF = new QFilter("accounttable", "=", accountTableId);
            if (isCover) {
                DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{createOrgF, bizappF, accountTableF});
            } else {
                DynamicObject newId = QueryServiceHelper.queryOne((String)entityName, (String)"id", (QFilter[])new QFilter[]{createOrgF, bizappF});
                if (newId != null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5b58\u5728\u4e1a\u52a1\u7cfb\u7edf\u4e3a%s\u7684\u65b9\u6848\uff0c\u65e0\u6cd5\u5bfc\u5165", (String)"ReconciliationFileUtil_17", (String)"fi-frm-common", (Object[])new Object[0]), appNumer));
                }
            }
            long useOrgId = ((DynamicObject)dyn.get("useorg")).getLong("id");
            if (useOrgId != orgId) {
                dyn.set("id", null);
            }
            newDyn = ORM.create().newDynamicObject(dyn.getDynamicObjectType());
            ReconciliationFileUtil.setCreatePro(dyn, newDyn, properties, isBaseOrgTpl, fieldMap, orgId, oldIdToNewId, accTypeNumber, appNumer, isCover);
        } else if (entityName.equals(ruleBill)) {
            appNumer = dyn.getDynamicObject("bizapp").getString("number");
            QFilter useOrgF = new QFilter("useorg", "=", (Object)orgId);
            QFilter bizappF = new QFilter("bizapp.number", "=", (Object)appNumer);
            if (isCover) {
                long id = dyn.getLong("id");
                QFilter idFilter = new QFilter("id", "=", (Object)id);
                DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{idFilter});
            } else {
                DynamicObject newId = QueryServiceHelper.queryOne((String)entityName, (String)"id", (QFilter[])new QFilter[]{useOrgF, bizappF});
                if (newId != null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5b58\u5728\u4e1a\u52a1\u7cfb\u7edf\u4e3a:%s\u7684\u53d6\u6570\u89c4\u5219\uff0c\u65e0\u6cd5\u5bfc\u5165", (String)"ReconciliationFileUtil_18", (String)"fi-frm-common", (Object[])new Object[0]), appNumer));
                }
            }
            newDyn = ORM.create().newDynamicObject(dyn.getDynamicObjectType());
            ReconciliationFileUtil.setCreatePro(dyn, newDyn, properties, isBaseOrgTpl, fieldMap, orgId, oldIdToNewId, accTypeNumber, appNumer, isCover);
            newDyn.set("reconassist", (Object)"reconassist");
        } else if (entityName.equals(amountTypeBill)) {
            appNumer = dyn.getDynamicObject("bizapp").getString("number");
            QFilter bizappF = new QFilter("bizapp.number", "=", (Object)appNumer);
            DynamicObject newId = QueryServiceHelper.queryOne((String)entityName, (String)"id", (QFilter[])new QFilter[]{bizappF});
            if (newId != null && isCover) {
                newDyn = BusinessDataServiceHelper.loadSingle((Object)newId.get("id"), (DynamicObjectType)dyn.getDynamicObjectType());
                ReconciliationFileUtil.setCoverPro(dyn, newDyn, properties, isBaseOrgTpl, fieldMap, true, orgId, oldIdToNewId, appNumer);
            } else {
                if (newId != null && !isCover) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7cfb\u7edf:%s\u5df2\u5b58\u5728\u91d1\u989d\u7c7b\u522b\uff0c\u65e0\u6cd5\u5bfc\u5165", (String)"ReconciliationFileUtil_19", (String)"fi-frm-common", (Object[])new Object[0]), appNumer));
                }
                newDyn = ORM.create().newDynamicObject(dyn.getDynamicObjectType());
                ReconciliationFileUtil.setCreatePro(dyn, newDyn, properties, isBaseOrgTpl, fieldMap, orgId, oldIdToNewId, accTypeNumber, appNumer, isCover);
            }
        } else if (entityName.equals(commonFilterBill)) {
            String name;
            QFilter nameF;
            String objNumber = dyn.getDynamicObject("bizobj").getString("number");
            QFilter objNumberF = new QFilter("bizobj.number", "=", (Object)objNumber);
            DynamicObject newId = QueryServiceHelper.queryOne((String)entityName, (String)"id", (QFilter[])new QFilter[]{objNumberF, nameF = new QFilter("name", "=", (Object)(name = dyn.getString("name")))});
            if (newId != null && isCover) {
                newDyn = BusinessDataServiceHelper.loadSingle((Object)newId.get("id"), (DynamicObjectType)dyn.getDynamicObjectType());
                ReconciliationFileUtil.setCoverPro(dyn, newDyn, properties, isBaseOrgTpl, fieldMap, false, orgId, oldIdToNewId, "");
            } else {
                if (newId != null && !isCover) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s+%2$s:\u5b58\u5728\u76f8\u540c\u4e1a\u52a1\u5bf9\u8c61\u548c\u540d\u79f0\u7684\u901a\u7528\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u5bfc\u5165", (String)"ReconciliationFileUtil_20", (String)"fi-frm-common", (Object[])new Object[0]), objNumber, name));
                }
                newDyn = ORM.create().newDynamicObject(dyn.getDynamicObjectType());
                ReconciliationFileUtil.setCreatePro(dyn, newDyn, properties, isBaseOrgTpl, fieldMap, orgId, oldIdToNewId, accTypeNumber, "", isCover);
            }
            newDyn.set("reconassist", (Object)"reconassist");
        } else {
            newDyn = ORM.create().newDynamicObject(dyn.getDynamicObjectType());
        }
        DynamicObject org = ORM.create().newDynamicObject("bos_org");
        org.set("id", (Object)orgId);
        if (isBaseOrgTpl) {
            newDyn.set("createorg", (Object)org);
            newDyn.set("useorg", (Object)org);
        }
        if (entityName.equals(planBill)) {
            newDyn.set("dataruledesc", (Object)"1");
            String planBalanceBasis = newDyn.getString("balancebasis");
            DynamicObjectCollection entry1 = newDyn.getDynamicObjectCollection("modularentryentity");
            for (Object row : entry1) {
                String balancebasis1 = row.getString("balancebasis1");
                if (!StringUtils.isEmpty((String)balancebasis1)) continue;
                row.set("balancebasis1", (Object)planBalanceBasis);
            }
            DynamicObjectCollection entry2 = newDyn.getDynamicObjectCollection("assistentry");
            for (DynamicObject row : entry2) {
                String balancebasis1 = row.getString("balancebasis2");
                if (!StringUtils.isEmpty((String)balancebasis1)) continue;
                row.set("balancebasis2", (Object)planBalanceBasis);
            }
            DynamicObjectCollection entry3 = newDyn.getDynamicObjectCollection("basedataentry");
            for (DynamicObject row : entry3) {
                String balancebasis1 = row.getString("balancebasis3");
                if (!StringUtils.isEmpty((String)balancebasis1)) continue;
                row.set("balancebasis3", (Object)planBalanceBasis);
            }
        } else if (entityName.equals(ruleBill)) {
            newDyn.set("amounttypedesc", (Object)"1");
        }
        newDyn.set("org", (Object)org);
        Boolean existFlag = ReconciliationFileUtil.createNewBillNo(newDyn, entityName);
        if (existFlag.booleanValue() && ruleBill.equals(entityName)) {
            newDyn.set("preset", (Object)Boolean.FALSE);
        }
        if (!(executeOperate = OperationServiceHelper.executeOperate((String)"save", (String)entityName, (DynamicObject[])new DynamicObject[]{newDyn}, (OperateOption)OperateOption.create())).isSuccess()) {
            DynamicObjectType entityType = newDyn.getDynamicObjectType();
            ReconciliationFileUtil.handleOperationResult(entityType.getDisplayName().getLocaleValue(), executeOperate);
        }
        if (entityName.equals(commonFilterBill) && (idObjs = executeOperate.getSuccessPkIds()) != null && idObjs.size() > 0) {
            oldIdToNewId.put(dyn.getLong("id"), idObjs.get(0));
        }
        return oldIdToNewId;
    }

    private static Boolean createNewBillNo(DynamicObject newDyn, String entryNumber) {
        String billno = newDyn.getString("number");
        boolean existFlag = false;
        if (QueryServiceHelper.exists((String)entryNumber, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)billno)})) {
            existFlag = true;
            newDyn.set("number", (Object)(billno + "#"));
            ReconciliationFileUtil.createNewBillNo(newDyn, entryNumber);
        }
        return existFlag;
    }

    private static void handleOperationResult(String entityName, OperationResult result) {
        if (!result.isSuccess()) {
            List msg = result.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
            if (msg == null) {
                msg = new ArrayList(1);
            }
            if (msg.size() == 0) {
                msg.add(result.getMessage());
            }
            String errInfo = String.join((CharSequence)" ", msg);
            throw new KDBizException(entityName + ":" + errInfo);
        }
    }

    private static void setCreatePro(DynamicObject dyn, DynamicObject newDyn, DataEntityPropertyCollection properties, boolean isBaseOrgTpl, Map<String, DynamicObject> fieldMap, Long orgId, Map<Long, Object> oldIdToNewId, String accTypeNumber, String appNumber, boolean isCover) {
        for (IDataEntityProperty prop : properties) {
            if (!isCover && (dyn.getDynamicObjectType().getPrimaryKey().equals(prop) || prop.getName().equals("masterid")) || prop instanceof DynamicLocaleProperty) continue;
            if (prop instanceof EntryProp) {
                DynamicObjectCollection entries = dyn.getDynamicObjectCollection(prop);
                DynamicObjectCollection newEntries = newDyn.getDynamicObjectCollection(prop);
                for (DynamicObject entry : entries) {
                    DataEntityPropertyCollection entryProperties = entry.getDynamicObjectType().getProperties();
                    DynamicObject newEntry = newEntries.addNew();
                    for (IDataEntityProperty entryProp : entryProperties) {
                        if (entry.getDynamicObjectType().getPrimaryKey().equals(entryProp)) continue;
                        if (entryProp instanceof SubEntryProp) {
                            SubEntryProp subEntryProp = (SubEntryProp)entryProp;
                            DataEntityPropertyCollection subProps = subEntryProp.getDynamicCollectionItemPropertyType().getProperties();
                            DynamicObjectCollection oldSubColls = entry.getDynamicObjectCollection(entryProp.getName());
                            DynamicObjectCollection newSubColls = newEntry.getDynamicObjectCollection(entryProp.getName());
                            for (DynamicObject oldRow : oldSubColls) {
                                DynamicObject newRow = newSubColls.addNew();
                                for (IDataEntityProperty subProp : subProps) {
                                    newRow.set(subProp.getName(), oldRow.get(subProp.getName()));
                                }
                            }
                            continue;
                        }
                        if (entryProp.getName().equals("commonfilter") || entryProp.getName().equals("amttype")) {
                            DynamicObject proDyn = entry.getDynamicObject(entryProp);
                            Object id = oldIdToNewId.get(proDyn.getLong("id"));
                            if (id != null) {
                                newEntry.set(entryProp, id);
                                newEntry.set(((BasedataProp)entryProp).getRefIdProp(), id);
                                continue;
                            }
                            ReconciliationFileUtil.setProp(newEntry, entry, entryProp, orgId, accTypeNumber, appNumber);
                            continue;
                        }
                        if (entryProp instanceof DynamicLocaleProperty || isBaseOrgTpl && (entryProp.getName().startsWith("basedata") || entryProp.getName().startsWith("assistantfield"))) continue;
                        if (entryProp.getName().equals("bdinfoimport")) {
                            ReconciliationFileUtil.setDynamicEntryProp(newEntry, entry, entryProp, fieldMap, orgId);
                            continue;
                        }
                        ReconciliationFileUtil.setProp(newEntry, entry, entryProp, orgId, accTypeNumber, appNumber);
                    }
                }
                continue;
            }
            ReconciliationFileUtil.setProp(newDyn, dyn, prop, orgId, accTypeNumber, appNumber);
        }
    }

    private static Map<Long, Object> setCoverPro(DynamicObject dyn, DynamicObject newDyn, DataEntityPropertyCollection properties, boolean isBaseOrgTpl, Map<String, DynamicObject> fieldMap, boolean isAmountType, Long orgId, Map<Long, Object> oldIdToNewId, String appNumber) {
        for (IDataEntityProperty prop : properties) {
            if (dyn.getDynamicObjectType().getPrimaryKey().equals(prop) || prop.getName().equals("masterid") || prop instanceof DynamicLocaleProperty) continue;
            if (prop instanceof EntryProp) {
                DynamicObjectCollection entries = dyn.getDynamicObjectCollection(prop);
                DynamicObjectCollection newEntries = newDyn.getDynamicObjectCollection(prop);
                ArrayList<String> entryNumber = new ArrayList<String>();
                if (isAmountType) {
                    for (DynamicObject ent : newEntries) {
                        entryNumber.add(ent.getString("typenumber"));
                    }
                } else {
                    newEntries.clear();
                }
                int seq = newEntries.size();
                DataEntityPropertyCollection entryProperties = null;
                for (DynamicObject entry : entries) {
                    if (entryProperties == null) {
                        entryProperties = entry.getDynamicObjectType().getProperties();
                    }
                    if (isAmountType) {
                        if (entryNumber.contains(entry.get("typenumber"))) {
                            for (DynamicObject newEntry : newEntries) {
                                if (!newEntry.getString("typenumber").equals(entry.getString("typenumber"))) continue;
                                ILocaleString localeString = entry.getLocaleString("typename");
                                LocaleString newLoc = (LocaleString)TypesContainer.createInstance(LocaleString.class);
                                newLoc.setLocaleValue_en(localeString.getLocaleValue_en());
                                newLoc.setLocaleValue_zh_CN(localeString.getLocaleValue_zh_CN());
                                newLoc.setLocaleValue_zh_TW(localeString.getLocaleValue_zh_TW());
                                newEntry.set("typename", (Object)newLoc);
                                oldIdToNewId.put(entry.getLong("id"), newEntry.get("id"));
                            }
                            continue;
                        }
                        DynamicObject createEnt = newEntries.addNew();
                        createEnt.set("seq", (Object)(++seq));
                        createEnt.set("typenumber", (Object)entry.getString("typenumber"));
                        ILocaleString localeString = entry.getLocaleString("typename");
                        LocaleString newLoc = (LocaleString)TypesContainer.createInstance(LocaleString.class);
                        newLoc.setLocaleValue_en(localeString.getLocaleValue_en());
                        newLoc.setLocaleValue_zh_CN(localeString.getLocaleValue_zh_CN());
                        newLoc.setLocaleValue_zh_TW(localeString.getLocaleValue_zh_TW());
                        createEnt.set("typename", (Object)entry.getLocaleString("typename"));
                        continue;
                    }
                    DynamicObject newEntry = newEntries.addNew();
                    for (IDataEntityProperty entryProp : entryProperties) {
                        if (entry.getDynamicObjectType().getPrimaryKey().equals(entryProp) || entryProp instanceof DynamicLocaleProperty || isBaseOrgTpl && (entryProp.getName().startsWith("basedata") || entryProp.getName().startsWith("assistantfield"))) continue;
                        if (entryProp.getName().equals("bdinfoimport")) {
                            ReconciliationFileUtil.setDynamicEntryProp(newEntry, entry, entryProp, fieldMap, orgId);
                            continue;
                        }
                        ReconciliationFileUtil.setProp(newEntry, entry, entryProp, orgId, null, appNumber);
                    }
                }
                continue;
            }
            ReconciliationFileUtil.setProp(newDyn, dyn, prop, orgId, null, appNumber);
        }
        return oldIdToNewId;
    }

    private static void setDynamicEntryProp(DynamicObject newDyn, DynamicObject dyn, IDataEntityProperty prop, Map<String, DynamicObject> fieldMap, Long orgId) {
        String numberString = dyn.getString(prop);
        if (numberString == null || numberString.length() == 0) {
            return;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)numberString, Map.class);
        for (Map.Entry entry : map.entrySet()) {
            DynamicObject field = fieldMap.get(entry.getKey());
            List numberList = (List)entry.getValue();
            String entityName = field.getString("entityid");
            String fieldKey = field.getString("fieldkey");
            String bdtype = field.getString("datatype");
            if (!AssistDataType.isBaseDataType(bdtype)) continue;
            DynamicObjectCollection idColl = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)numberList), BaseDataServiceHelper.getBaseDataFilter((String)entityName, (Long)orgId)});
            DynamicObjectCollection mulBase = newDyn.getDynamicObjectCollection(fieldKey);
            for (DynamicObject idDyn : idColl) {
                DynamicObject base = mulBase.addNew();
                base.set("fbasedataid_id", idDyn.get("id"));
            }
        }
    }

    private static void setProp(DynamicObject newDyn, DynamicObject dyn, IDataEntityProperty prop, Long orgId, String aaaTypeNumber, String appNumber) {
        if (prop instanceof MuliLangTextProp) {
            ILocaleString value = (ILocaleString)dyn.get(prop);
            LocaleString newLoc = (LocaleString)TypesContainer.createInstance(LocaleString.class);
            newLoc.setLocaleValue_en(value.getLocaleValue_en());
            newLoc.setLocaleValue_zh_CN(value.getLocaleValue_zh_CN());
            newLoc.setLocaleValue_zh_TW(value.getLocaleValue_zh_TW());
            newDyn.set(prop, (Object)newLoc);
        } else if (prop instanceof MulBasedataProp) {
            DynamicObjectCollection m = (DynamicObjectCollection)dyn.get(prop);
            for (DynamicObject d : m) {
                DynamicObject base = d.getDynamicObject("fbasedataid");
                String baseEntityName = base.getDataEntityType().getName();
                String number = base.getString("number");
                QFilter filter = null;
                if (baseEntityName.equals("bd_accountview")) {
                    filter = new QFilter("accounttable.number", "=", (Object)aaaTypeNumber);
                } else if (baseEntityName.equals("frm_amouttype_layout")) {
                    filter = new QFilter("amounttype.bizapp.number", "=", (Object)appNumber);
                }
                DynamicObjectCollection dyns = QueryServiceHelper.query((String)baseEntityName, (String)"id", (QFilter[])new QFilter[]{filter, new QFilter("number", "=", (Object)number), BaseDataServiceHelper.getBaseDataFilter((String)baseEntityName, (Long)orgId)});
                d.set("pkid", null);
                d.set("fbasedataid_id", null);
                if (dyns == null || dyns.size() <= 0) continue;
                d.set("fbasedataid_id", ((DynamicObject)dyns.get(0)).get("id"));
            }
            newDyn.set(prop, (Object)m);
        } else if (prop instanceof BasedataProp) {
            DynamicObject dd = dyn.getDynamicObject(prop);
            if (dd == null) {
                return;
            }
            QFilter filter = null;
            if (dd.getDataEntityType().getName().equals("bd_accountview")) {
                filter = new QFilter("accounttable.number", "=", (Object)aaaTypeNumber);
            } else if (dd.getDataEntityType().getName().equals("frm_amouttype_layout")) {
                filter = new QFilter("amounttype.bizapp.number", "=", (Object)appNumber);
            }
            String number = dd.getString("number");
            DynamicObjectCollection basedata = QueryServiceHelper.query((String)dd.getDataEntityType().getName(), (String)"id", (QFilter[])new QFilter[]{filter, new QFilter("number", "=", (Object)number), BaseDataServiceHelper.getBaseDataFilter((String)dd.getDataEntityType().getName(), (Long)orgId)});
            if (basedata != null && basedata.size() > 0) {
                newDyn.set(prop, ((DynamicObject)basedata.get(0)).get("id"));
                newDyn.set(((BasedataProp)prop).getRefIdProp(), ((DynamicObject)basedata.get(0)).get("id"));
            }
        } else {
            if (prop.getName().endsWith("_id")) {
                return;
            }
            newDyn.set(prop, dyn.get(prop));
        }
    }
}

