/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.frm.common.cache.frm.ReconModelCacheHelper;
import kd.fi.frm.common.constant.ReconciliationFormConstant;
import kd.fi.frm.common.enums.AssistDataType;
import kd.fi.frm.common.enums.AssistTypeEnum;
import kd.fi.frm.common.enums.DataTypeEnum;
import kd.fi.frm.common.enums.ReconAmountTypeEnum;
import kd.fi.frm.common.model.FieldMapEntryModel;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.bizdata.BizDataParam;
import kd.fi.frm.common.model.bizdata.BizDataSourceConfig;
import kd.fi.frm.common.model.bizdata.BizDataTypeEnum;
import kd.fi.frm.common.model.bizdata.BizReconPlanDetailModel;
import kd.fi.frm.common.util.FaBillParamUtils;
import kd.fi.frm.common.util.ReconciliationUtil;

public class ReconciliationParmUtil
implements ReconciliationFormConstant {
    private static final Log logger = LogFactory.getLog(ReconciliationParmUtil.class);
    private static final Pattern COMMONFILTER_ITEMCLASS_PATTERN = Pattern.compile("(\\w+\\.)*(\\w+\\(\\w+:.+\\))((\\.\\w+)*)");

    public static List<BizDataParam> getDataRuleParam(BizReconPlanDetailModel detailModel, DynamicObject dataRule, List<Long> amountTypes, ReconciliationParamModel paramModel, Long orgId, ReconAmountTypeEnum reconAmountType) {
        boolean ruleCacheEnable = FaBillParamUtils.getBooleanValue(0L, "frm_rule_cache_enable");
        List<BizDataParam> params = ruleCacheEnable ? ReconciliationParmUtil.getCacheDataRuleParam(detailModel, dataRule, amountTypes, paramModel, orgId, reconAmountType) : ReconciliationParmUtil.getRealDataRuleParam(detailModel, dataRule, amountTypes, paramModel, orgId, reconAmountType);
        return params;
    }

    public static List<BizDataParam> getCacheDataRuleParam(BizReconPlanDetailModel detailModel, DynamicObject dataRule, List<Long> amountTypes, ReconciliationParamModel paramModel, Long orgId, ReconAmountTypeEnum reconAmountType) {
        List<BizDataParam> params = ReconModelCacheHelper.getRuleParam(orgId, dataRule, paramModel);
        Set<Integer> dataTypes = paramModel.isInit() ? BizDataTypeEnum.getInitTypes() : (DataTypeEnum.Detail == paramModel.getDataType() ? BizDataTypeEnum.getDetailTypesByReconAmountType(reconAmountType) : BizDataTypeEnum.getClosePeriodTypesByReconAmountType(reconAmountType));
        if (paramModel.getDetailTypeEnum() != null) {
            BizDataTypeEnum.filterDataTypeByClickItem(paramModel.getDetailTypeEnum(), dataTypes);
        }
        String appId = dataRule.getString("bizapp.id");
        boolean needSpFilter = "83bfebc800001aac".equals(appId);
        boolean faDepreBySum = true;
        if (needSpFilter) {
            AppParam param = new AppParam(appId, "10", orgId, Long.valueOf(0L));
            Object faParam = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"isuse_depredetail");
            faDepreBySum = faParam != null && Boolean.parseBoolean(faParam.toString());
        }
        HashSet<String> dimEntitys = new HashSet<String>();
        ArrayList<Map<String, Set<Long>>> bizAssistIdSetMapList = new ArrayList(6);
        if (detailModel != null) {
            bizAssistIdSetMapList = ReconciliationParmUtil.getBizAssistSetFromBizFilter(detailModel);
            dimEntitys.addAll(detailModel.getBizAssistIndexMap().keySet());
        }
        boolean hasOrg = dimEntitys.contains("1.bos_org") || dimEntitys.contains("1.bos_adminorg");
        Iterator<BizDataParam> iterator = params.iterator();
        while (iterator.hasNext()) {
            String fieldName;
            BizDataParam next = iterator.next();
            BizDataSourceConfig sourceConfig = next.getSourceConfig();
            BizDataTypeEnum type = sourceConfig.getType();
            long amountTypeId = sourceConfig.getAmountTypeID();
            if (!dataTypes.contains(type.getValue()) || !amountTypes.contains(amountTypeId)) {
                iterator.remove();
                continue;
            }
            String amountTag = next.getAmountTag();
            if (StringUtils.isNotEmpty((String)amountTag)) {
                boolean rule_SplitSum = amountTag.contains("totalsplitamount");
                boolean rule_SplitDetail = amountTag.contains("splitamount");
                if (faDepreBySum && !rule_SplitSum && rule_SplitDetail) {
                    iterator.remove();
                    continue;
                }
                if (!faDepreBySum && rule_SplitSum && rule_SplitDetail) {
                    iterator.remove();
                    continue;
                }
            }
            sourceConfig.setTaskEntryId(detailModel.getTaskEntryId());
            next.setCurrencyIds(detailModel.getCurrencyIds());
            next.setIgnoreEmpty(detailModel.isIgnoreEmpty());
            next.setNeedQueryBiz(detailModel.isNeedQueryBiz());
            next.setAssistType(detailModel.getAssistType());
            next.setInit(paramModel.isInit());
            next.setDataType(paramModel.getDataType());
            next.setAcctBookTypeID(paramModel.getBookTypeId());
            next.setPeriodid(paramModel.getPeriodId());
            List<FieldMapEntryModel> fieldMapEntryModels = next.getFieldMapEntryModels();
            for (FieldMapEntryModel fieldMapEntryModel : fieldMapEntryModels) {
                boolean isOrg;
                String entityId = fieldMapEntryModel.getEntityId();
                boolean bl = isOrg = "bos_org".equals(entityId) || "bos_adminorg".equals(entityId);
                if (isOrg && hasOrg || dimEntitys.contains(entityId)) continue;
                iterator.remove();
            }
            ReconciliationParmUtil.dealItemClassType(fieldMapEntryModels, next, paramModel);
            CRCondition billFilter = sourceConfig.getBillFilter();
            if (!paramModel.isLocalCurrency() || !StringUtils.isNotEmpty((String)(fieldName = next.getCurrencyField())) || paramModel.getCurrency() == 0L) continue;
            ReconciliationParmUtil.appendPropFilter(billFilter, fieldName, paramModel.getCurrency(), false);
        }
        for (BizDataParam bizDataParam : params) {
            bizDataParam.setBizAssistIdSetMapList(bizAssistIdSetMapList);
            BizDataSourceConfig sourceConfig = bizDataParam.getSourceConfig();
            Map<String, String> dimPropMap = sourceConfig.getDimPropMap();
            Map<String, String> dimPropMasterIdMap = sourceConfig.getDimPropMasterIdMap();
            HashSet<String> assistKeySet = new HashSet<String>(dimPropMap.keySet());
            hasOrg = dimEntitys.contains("1.bos_org") || dimEntitys.contains("1.bos_adminorg");
            for (String assistKey : assistKeySet) {
                boolean isOrg;
                boolean bl = isOrg = "1.bos_org".equals(assistKey) || "1.bos_adminorg".equals(assistKey);
                if (isOrg && hasOrg || detailModel == null || dimEntitys.contains(assistKey)) continue;
                dimPropMap.remove(assistKey);
                dimPropMasterIdMap.remove(assistKey);
            }
        }
        return params;
    }

    public static List<BizDataParam> getRealDataRuleParam(BizReconPlanDetailModel detailModel, DynamicObject dataRule, List<Long> amountTypes, ReconciliationParamModel paramModel, Long orgId, ReconAmountTypeEnum reconAmountType) {
        ArrayList<BizDataParam> params = new ArrayList<BizDataParam>();
        Map<Object, DynamicObject> commonFilterMap = ReconciliationParmUtil.getAllCommonFilter();
        ArrayList<Map<String, Set<Long>>> bizAssistIdSetMapList = new ArrayList(6);
        if (detailModel != null) {
            bizAssistIdSetMapList = ReconciliationParmUtil.getBizAssistSetFromBizFilter(detailModel);
        }
        Set<Integer> dataTypes = null;
        dataTypes = paramModel.isInit() ? BizDataTypeEnum.getInitTypes() : (DataTypeEnum.Detail == paramModel.getDataType() ? BizDataTypeEnum.getDetailTypesByReconAmountType(reconAmountType) : BizDataTypeEnum.getClosePeriodTypesByReconAmountType(reconAmountType));
        if (paramModel.getDetailTypeEnum() != null) {
            dataTypes = BizDataTypeEnum.filterDataTypeByClickItem(paramModel.getDetailTypeEnum(), dataTypes);
        }
        String appId = dataRule.getString("bizapp.id");
        String appNumber = dataRule.getString("bizapp.number");
        boolean needSpFilter = "83bfebc800001aac".equals(appId);
        boolean faDepreBySum = true;
        if (needSpFilter) {
            AppParam param = new AppParam(appId, "10", orgId, Long.valueOf(0L));
            Object faParam = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"isuse_depredetail");
            faDepreBySum = faParam != null && Boolean.parseBoolean(faParam.toString());
        }
        DynamicObjectCollection entrys = dataRule.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryInfo : entrys) {
            String fieldName;
            Long commonFilterId;
            DynamicObject commonFilterInfo;
            boolean matchRow = ReconciliationParmUtil.matchDataRuleConfigRow(entryInfo, dataTypes, amountTypes, commonFilterInfo = commonFilterMap.get(commonFilterId = Long.valueOf(entryInfo.getLong("commonfilter.id"))));
            if (!matchRow) continue;
            String entity = entryInfo.getString("bizobj.id");
            if ("fa_depre_sum".equalsIgnoreCase(entity) && needSpFilter) {
                boolean rule_SplitSum = entryInfo.getString("amount_tag").contains("totalsplitamount");
                boolean rule_SplitDetail = entryInfo.getString("amount_tag").contains("splitamount");
                if (faDepreBySum && !rule_SplitSum && rule_SplitDetail || !faDepreBySum && rule_SplitSum && rule_SplitDetail) continue;
            }
            BizDataParam bizDataParam = new BizDataParam();
            params.add(bizDataParam);
            bizDataParam.setBizAssistIdSetMapList(bizAssistIdSetMapList);
            bizDataParam.setInit(paramModel.isInit());
            bizDataParam.setDataType(paramModel.getDataType());
            bizDataParam.setAcctBookTypeID(paramModel.getBookTypeId());
            bizDataParam.setAppNumber(appNumber);
            bizDataParam.setBizOrgField(commonFilterInfo.getString("bizorg"));
            bizDataParam.setEntityKey(entity);
            bizDataParam.setPeriodid(paramModel.getPeriodId());
            BizDataSourceConfig dynConfig = new BizDataSourceConfig();
            bizDataParam.setSourceConfig(dynConfig);
            if (detailModel != null) {
                bizDataParam.setCurrencyIds(detailModel.getCurrencyIds());
                bizDataParam.setIgnoreEmpty(detailModel.isIgnoreEmpty());
                bizDataParam.setNeedQueryBiz(detailModel.isNeedQueryBiz());
                bizDataParam.setAssistType(detailModel.getAssistType());
                dynConfig.setTaskEntryId(detailModel.getTaskEntryId());
            }
            dynConfig.setBizDateField(commonFilterInfo.getString("bizdate"));
            dynConfig.setPeriodField(commonFilterInfo.getString("period"));
            dynConfig.setCommonFilterId(commonFilterId);
            dynConfig.setTaskSize(entryInfo.getInt("tasksize"));
            dynConfig.setAmountExp(entryInfo.getString("amount_tag"));
            dynConfig.setAmountTypeID(entryInfo.getLong("amttype.id"));
            dynConfig.setRuleEntryId(entryInfo.getLong("id"));
            CRCondition cdb = null;
            String exp = entryInfo.getString("datafilter_tag");
            cdb = StringUtils.isNotEmpty((String)exp) ? (CRCondition)SerializationUtils.fromJsonString((String)exp, CRCondition.class) : new CRCondition();
            String commonFilterExt = commonFilterInfo.getString("itemclasstype");
            if (StringUtils.isNotEmpty((String)commonFilterExt)) {
                String[] split = commonFilterExt.split(":");
                ReconciliationParmUtil.appendPropFilter(cdb, split[0], split[1], true);
            }
            dynConfig.setBillFilter(cdb);
            dynConfig.setType(BizDataTypeEnum.getEnum(entryInfo.getInt("datatype")));
            if (detailModel != null) {
                ReconciliationParmUtil.buildDimsAndItemClassPropFilter(detailModel, paramModel, bizDataParam, commonFilterInfo);
            }
            if (!paramModel.isLocalCurrency() || !StringUtils.isNotEmpty((String)(fieldName = bizDataParam.getCurrencyField())) || paramModel.getCurrency() == 0L) continue;
            ReconciliationParmUtil.appendPropFilter(cdb, fieldName, paramModel.getCurrency(), false);
        }
        return params;
    }

    public static void buildDimsAndItemClassPropFilter(BizReconPlanDetailModel detailModel, ReconciliationParamModel paramModel, BizDataParam bizDataParam, DynamicObject commonFilterInfo) {
        DynamicObjectCollection propEntrys = commonFilterInfo.getDynamicObjectCollection("entryentity");
        DynamicObject entryEntity = (DynamicObject)propEntrys.get(0);
        DynamicObjectCollection dimProps = commonFilterInfo.getDynamicObjectCollection("fieldmapentry");
        for (DynamicObject dimObject : dimProps) {
            ReconciliationParmUtil.appendItemClassPropFilter(detailModel, paramModel, bizDataParam, entryEntity, dimObject);
        }
    }

    private static void appendItemClassPropFilter(BizReconPlanDetailModel detailModel, ReconciliationParamModel paramModel, BizDataParam bizDataParam, DynamicObject commonFilterEntry, DynamicObject fieldMapRow) {
        int containsType;
        BizDataSourceConfig dynConfig = bizDataParam.getSourceConfig();
        CRCondition cdb = dynConfig.getBillFilter();
        HashSet<String> dimEntitys = new HashSet<String>(detailModel.getBizAssistIndexMap().keySet());
        String entityId = fieldMapRow.getString("entityid");
        String bdtype = fieldMapRow.getString("datatype");
        String assistKey = AssistDataType.makeAssistKey(bdtype, fieldMapRow.getString("entityid"));
        boolean needAppendDimMap = true;
        String prop = commonFilterEntry.getString(fieldMapRow.getString("fieldkey"));
        if (AssistDataType.isBaseDataType(bdtype) && "bd_currency".equalsIgnoreCase(entityId)) {
            paramModel.setLocalCurrency(false);
            if (!prop.contains("(")) {
                bizDataParam.setCurrencyField(prop);
                needAppendDimMap = false;
            }
        } else if (detailModel != null && !dimEntitys.contains(assistKey)) {
            needAppendDimMap = false;
        }
        if ((containsType = prop.indexOf("(")) > -1) {
            Matcher matcher = COMMONFILTER_ITEMCLASS_PATTERN.matcher(prop);
            if (matcher.matches()) {
                String keyPrefix = matcher.group(1);
                String matchStr = matcher.group(2);
                String tailFieldPath = matcher.group(3);
                int endSplitIndex = prop.indexOf(")");
                String replacedStr = prop.substring(containsType, endSplitIndex + 1);
                int splitIndex = matchStr.indexOf("(");
                String typeString = matchStr.substring(splitIndex).replace("(", "").replace(")", "");
                String typeEntity = typeString.split(":")[0];
                String typePropPath = typeString.split(":")[1];
                ReconciliationParmUtil.appendPropFilter(cdb, typePropPath, typeEntity, true);
                if (StringUtils.isNotEmpty((String)tailFieldPath)) {
                    String multiFilterProp = (keyPrefix == null ? "" : keyPrefix) + matchStr;
                    multiFilterProp = multiFilterProp.replace(replacedStr, "");
                    if (!paramModel.isPreviewMode()) {
                        String expression = cdb.getExpression();
                        if (StringUtils.isEmpty((String)expression)) {
                            cdb.setExpression(multiFilterProp + ".id != " + String.format("'multibasedata[%s,%s,0]'", typeEntity, multiFilterProp));
                        } else {
                            expression = expression + " and " + multiFilterProp + ".id != " + String.format("'multibasedata[%s,%s,0]'", typeEntity, multiFilterProp);
                            cdb.setExpression(expression);
                        }
                    }
                    bizDataParam.appendItemClassFilter(assistKey, multiFilterProp, tailFieldPath.replaceFirst("\\.", ""), typeEntity);
                }
                String replacedProp = prop.replace(replacedStr, "");
                if ("bd_currency".equalsIgnoreCase(entityId)) {
                    bizDataParam.setCurrencyField(replacedProp);
                } else if (needAppendDimMap) {
                    dynConfig.getDimPropMap().put(assistKey, replacedProp);
                    dynConfig.getDimPropMasterIdMap().put(assistKey, replacedProp + ".masterid");
                }
                if (!"bd_currency".equalsIgnoreCase(entityId)) {
                    dynConfig.getFilterPropMap().put(assistKey, replacedProp);
                }
            }
        } else {
            boolean isOrg;
            boolean bl = isOrg = "1.bos_org".equals(assistKey) || "1.bos_adminorg".equals(assistKey);
            if (isOrg) {
                dynConfig.getFilterPropMap().put("1.bos_adminorg", prop);
                dynConfig.getFilterPropMap().put("1.bos_org", prop);
            } else {
                dynConfig.getFilterPropMap().put(assistKey, prop);
            }
            if (needAppendDimMap) {
                dynConfig.getDimPropMap().put(assistKey, prop);
                dynConfig.getDimPropMasterIdMap().put(assistKey, prop + ".masterid");
            }
        }
    }

    public static void dealItemClassType(List<FieldMapEntryModel> fieldMapEntryModels, BizDataParam next, ReconciliationParamModel paramModel) {
        BizDataSourceConfig sourceConfig = next.getSourceConfig();
        CRCondition billFilter = sourceConfig.getBillFilter();
        for (FieldMapEntryModel model : fieldMapEntryModels) {
            String entityId = model.getEntityId();
            String bdtype = model.getDataType();
            String assistKey = AssistDataType.makeAssistKey(bdtype, entityId);
            String prop = model.getFieldKey();
            Matcher matcher = COMMONFILTER_ITEMCLASS_PATTERN.matcher(prop);
            if (!matcher.matches()) continue;
            String keyPrefix = matcher.group(1);
            String matchStr = matcher.group(2);
            String tailFieldPath = matcher.group(3);
            int endSplitIndex = prop.indexOf(")");
            int containsType = prop.indexOf("(");
            String replacedStr = prop.substring(containsType, endSplitIndex + 1);
            int splitIndex = matchStr.indexOf("(");
            String typeString = matchStr.substring(splitIndex).replace("(", "").replace(")", "");
            String typeEntity = typeString.split(":")[0];
            String typePropPath = typeString.split(":")[1];
            ReconciliationParmUtil.appendPropFilter(billFilter, typePropPath, typeEntity, true);
            if (StringUtils.isNotEmpty((String)tailFieldPath)) {
                String multiFilterProp = (keyPrefix == null ? "" : keyPrefix) + matchStr;
                multiFilterProp = multiFilterProp.replace(replacedStr, "");
                if (!paramModel.isPreviewMode()) {
                    String expression = billFilter.getExpression();
                    if (StringUtils.isEmpty((String)expression)) {
                        billFilter.setExpression(multiFilterProp + ".id != " + String.format("'multibasedata[%s,%s,0]'", typeEntity, multiFilterProp));
                    } else {
                        expression = expression + " and " + multiFilterProp + ".id != " + String.format("'multibasedata[%s,%s,0]'", typeEntity, multiFilterProp);
                        billFilter.setExpression(expression);
                    }
                }
                next.appendItemClassFilter(assistKey, multiFilterProp, tailFieldPath.replaceFirst("\\.", ""), typeEntity);
            }
            String replacedProp = prop.replace(replacedStr, "");
            if ("bd_currency".equalsIgnoreCase(entityId)) {
                next.setCurrencyField(replacedProp);
            } else {
                sourceConfig.getDimPropMap().put(assistKey, replacedProp);
                sourceConfig.getDimPropMasterIdMap().put(assistKey, replacedProp + ".masterid");
            }
            if ("bd_currency".equalsIgnoreCase(entityId)) continue;
            sourceConfig.getFilterPropMap().put(assistKey, replacedProp);
        }
    }

    public static List<BizDataParam> loadDataRuleParam(DynamicObject dataRule, ReconciliationParamModel paramModel, Long orgId) {
        ArrayList<BizDataParam> params = new ArrayList<BizDataParam>();
        String appId = dataRule.getString("bizapp.id");
        String appNumber = dataRule.getString("bizapp.number");
        boolean needSpFilter = "83bfebc800001aac".equals(appId);
        Map<Object, DynamicObject> commonFilterMap = ReconciliationParmUtil.getAllCommonFilter();
        DynamicObjectCollection entrys = dataRule.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryInfo : entrys) {
            Long commonFilterId = entryInfo.getLong("commonfilter.id");
            DynamicObject commonFilterInfo = commonFilterMap.get(commonFilterId);
            if (commonFilterInfo == null) continue;
            BizDataParam bizDataParam = new BizDataParam();
            params.add(bizDataParam);
            String entity = entryInfo.getString("bizobj.id");
            if ("fa_depre_sum".equalsIgnoreCase(entity) && needSpFilter) {
                bizDataParam.setAmountTag(entryInfo.getString("amount_tag"));
            }
            bizDataParam.setAppNumber(appNumber);
            bizDataParam.setBizOrgField(commonFilterInfo.getString("bizorg"));
            bizDataParam.setEntityKey(entity);
            BizDataSourceConfig dynConfig = new BizDataSourceConfig();
            bizDataParam.setSourceConfig(dynConfig);
            dynConfig.setBizDateField(commonFilterInfo.getString("bizdate"));
            dynConfig.setPeriodField(commonFilterInfo.getString("period"));
            dynConfig.setTaskSize(entryInfo.getInt("tasksize"));
            dynConfig.setAmountExp(entryInfo.getString("amount_tag"));
            dynConfig.setAmountTypeID(entryInfo.getLong("amttype.id"));
            dynConfig.setRuleEntryId(entryInfo.getLong("id"));
            CRCondition cdb = null;
            String exp = entryInfo.getString("datafilter_tag");
            cdb = StringUtils.isNotEmpty((String)exp) ? (CRCondition)SerializationUtils.fromJsonString((String)exp, CRCondition.class) : new CRCondition();
            String commonFilterExt = commonFilterInfo.getString("itemclasstype");
            if (StringUtils.isNotEmpty((String)commonFilterExt)) {
                String[] split = commonFilterExt.split(":");
                ReconciliationParmUtil.appendPropFilter(cdb, split[0], split[1], true);
            }
            dynConfig.setBillFilter(cdb);
            dynConfig.setType(BizDataTypeEnum.getEnum(entryInfo.getInt("datatype")));
            DynamicObjectCollection propEntrys = commonFilterInfo.getDynamicObjectCollection("entryentity");
            if (propEntrys.size() <= 0) continue;
            DynamicObject entryEntity = (DynamicObject)propEntrys.get(0);
            DynamicObjectCollection dimProps = commonFilterInfo.getDynamicObjectCollection("fieldmapentry");
            ArrayList<FieldMapEntryModel> fieldMapEntryModels = new ArrayList<FieldMapEntryModel>(16);
            for (DynamicObject dimObject : dimProps) {
                boolean isOrg;
                int containsType;
                String entityId = dimObject.getString("entityid");
                String bdtype = dimObject.getString("datatype");
                String assistKey = AssistDataType.makeAssistKey(bdtype, dimObject.getString("entityid"));
                String prop = entryEntity.getString(dimObject.getString("fieldkey"));
                if (AssistDataType.isBaseDataType(bdtype) && "bd_currency".equalsIgnoreCase(entityId)) {
                    paramModel.setLocalCurrency(false);
                    if (!prop.contains("(")) {
                        bizDataParam.setCurrencyField(prop);
                    }
                }
                if ((containsType = prop.indexOf("(")) > -1) {
                    Matcher matcher = COMMONFILTER_ITEMCLASS_PATTERN.matcher(prop);
                    if (!matcher.matches()) continue;
                    FieldMapEntryModel fieldMapEntryModel = new FieldMapEntryModel(entityId, bdtype, prop);
                    fieldMapEntryModels.add(fieldMapEntryModel);
                    continue;
                }
                boolean bl = isOrg = "1.bos_org".equals(assistKey) || "1.bos_adminorg".equals(assistKey);
                if (isOrg) {
                    dynConfig.getFilterPropMap().put("1.bos_adminorg", prop);
                    dynConfig.getFilterPropMap().put("1.bos_org", prop);
                } else {
                    dynConfig.getFilterPropMap().put(assistKey, prop);
                }
                dynConfig.getDimPropMap().put(assistKey, prop);
                dynConfig.getDimPropMasterIdMap().put(assistKey, prop + ".masterid");
            }
            bizDataParam.setFieldMapEntryModels(fieldMapEntryModels);
        }
        return params;
    }

    public static List<Map<String, Set<Long>>> getBizAssistSetFromBizFilter(BizReconPlanDetailModel detailModel) {
        ArrayList<Map<String, Set<Long>>> bizAssistIdSetMapList = new ArrayList<Map<String, Set<Long>>>(6);
        List<Map<String, String>> bizFilterAssistMapList = detailModel.getBizFilterAssistMapList();
        for (Map<String, String> bizAssistFilterMap : bizFilterAssistMapList) {
            if (bizAssistFilterMap == null || bizAssistFilterMap.size() <= 0) continue;
            HashMap<String, Set<Long>> bizAssistIdSetMap = new HashMap<String, Set<Long>>(16);
            for (Map.Entry<String, String> bizAssist : bizAssistFilterMap.entrySet()) {
                String filterCond = bizAssist.getValue();
                if (StringUtils.isEmpty((String)filterCond)) continue;
                String entityKey = bizAssist.getKey();
                String entityId = "";
                if (!entityKey.contains(".")) {
                    entityId = entityKey;
                    entityKey = "1." + entityKey;
                } else {
                    String[] keySplit = entityKey.split("\\.");
                    entityId = AssistDataType.isBaseDataType(keySplit[0]) ? keySplit[1] : "bos_assistantdata_detail";
                }
                if (AssistTypeEnum.Acct == detailModel.getAssistType()) {
                    QFilter idFilter = QFilter.fromSerializedString((String)filterCond);
                    Set basedataIds = (Set)idFilter.getValue();
                    Set<Long> allLeafs = ReconciliationUtil.queryAssistAllSubDatas(entityKey, basedataIds);
                    bizAssistIdSetMap.put(entityKey, allLeafs);
                    continue;
                }
                CRCondition cdb = (CRCondition)SerializationUtils.fromJsonString((String)filterCond, CRCondition.class);
                String expression = cdb.buildFullFormula(EntityMetadataCache.getDataEntityType((String)entityId));
                QFilter filter = QFilter.of((String)expression, (Object[])new Object[0]);
                DynamicObjectCollection objs = QueryServiceHelper.query((String)entityId, (String)"id", (QFilter[])filter.toArray());
                HashSet<Long> ids = new HashSet<Long>(objs.size());
                for (DynamicObject obj : objs) {
                    ids.add(Long.parseLong(String.valueOf(obj.get("id"))));
                }
                Set<Long> allLeafs = ReconciliationUtil.queryAssistAllSubDatas(entityKey, ids);
                if (allLeafs.size() == 0) {
                    detailModel.setNeedQueryBiz(false);
                }
                bizAssistIdSetMap.put(entityKey, allLeafs);
            }
            if (bizAssistIdSetMap.size() <= 0) continue;
            bizAssistIdSetMapList.add(bizAssistIdSetMap);
        }
        return bizAssistIdSetMapList;
    }

    private static void appendPropFilter(CRCondition cdb, String filterField, Object filterValue, boolean appendQuote) {
        String exp = cdb.getExpression();
        if (StringUtils.isNotEmpty((String)exp)) {
            exp = appendQuote ? exp + " and " + filterField + "='" + filterValue + "'" : exp + " and " + filterField + "=" + filterValue;
            cdb.setExpression(exp);
        } else {
            ArrayList<SimpleFilterRow> rows;
            SimpleFilterRow f = new SimpleFilterRow();
            f.setFieldName(filterField);
            f.setCompareType("=");
            FilterValue v = new FilterValue();
            v.setValue(filterValue);
            ArrayList<FilterValue> vs = new ArrayList<FilterValue>(1);
            vs.add(v);
            f.setValue(vs);
            f.setLogic("and");
            FilterCondition cond = cdb.getFilterCondition();
            if (cond == null) {
                cond = new FilterCondition();
                cdb.setFilterCondition(cond);
            }
            if ((rows = cond.getFilterRow()) == null) {
                rows = new ArrayList<SimpleFilterRow>();
                cond.setFilterRow(rows);
            }
            rows.add(0, f);
        }
    }

    private static boolean matchDataRuleConfigRow(DynamicObject entryInfo, Set<Integer> dataTypes, List<Long> amountTypes, DynamicObject commonFilterInfo) {
        Integer dataType = entryInfo.getInt("datatype");
        Long amountType = entryInfo.getLong("amttype.id");
        if (!dataTypes.contains(dataType)) {
            return false;
        }
        if (!amountTypes.contains(amountType)) {
            return false;
        }
        return commonFilterInfo != null;
    }

    public static Map<Object, DynamicObject> getAllCommonFilter() {
        StringBuilder selectors = new StringBuilder();
        selectors.append("bizobj.id,period,bizdate,bizorg,assistentry.bdtype,assistentry.sourcenumber,itemclasstype");
        for (int i = 0; i < 8; ++i) {
            selectors.append(",entryentity.basedata").append(i);
        }
        selectors.append(',').append("fieldmapentry").append('.').append("fieldkey");
        selectors.append(',').append("fieldmapentry").append('.').append("entityid");
        selectors.append(',').append("fieldmapentry").append('.').append("datatype");
        return BusinessDataServiceHelper.loadFromCache((String)"frm_rec_common_filter", (String)selectors.toString(), null);
    }
}

