/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.util;

import com.alibaba.fastjson.JSONArray;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.EntityNotExistsException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.fi.bd.asstdimaptype.AsstDimMapLoader;
import kd.fi.bd.vo.AccountMapTypeFieldMapEntry;
import kd.fi.bd.vo.AsstDimMapType;
import kd.fi.frm.common.cache.frm.ReconModelCacheHelper;
import kd.fi.frm.common.cache.gl.CacheKey;
import kd.fi.frm.common.cache.gl.CacheModule;
import kd.fi.frm.common.cache.gl.LocalCacheHelper;
import kd.fi.frm.common.cache.gl.ThreadCacheKey;
import kd.fi.frm.common.constant.ReconciliationFormConstant;
import kd.fi.frm.common.enums.AssistDataType;
import kd.fi.frm.common.enums.AssistTypeEnum;
import kd.fi.frm.common.enums.BalanceBasisEnum;
import kd.fi.frm.common.enums.BalanceDcEnum;
import kd.fi.frm.common.enums.CheckBoxEnum;
import kd.fi.frm.common.enums.ReconAmountTypeEnum;
import kd.fi.frm.common.model.FrmLogger;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.SysParam;
import kd.fi.frm.common.model.bizdata.AccountAssistInfo;
import kd.fi.frm.common.model.bizdata.BizDataKey;
import kd.fi.frm.common.model.bizdata.BizDataTypeEnum;
import kd.fi.frm.common.model.bizdata.BizReconPlanDetailModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanModel;
import kd.fi.frm.common.model.mulassist.MulassistConfigModel;
import kd.fi.frm.common.util.FaBillParamUtils;
import kd.fi.frm.common.util.FrmStringUtil;
import kd.fi.frm.common.util.MapUtil;
import kd.fi.frm.common.util.SystemParamHelper;

public class ReconciliationUtil
implements ReconciliationFormConstant {
    private static final Log logger = LogFactory.getLog(ReconciliationUtil.class);
    private static final String[] ENTRYS = new String[]{"id", "disable", "datatype", "bizobj", "detailrule", "commonfilter", "datafilter_tag", "amttype.id", "amttype", "amount_tag", "tasksize"};
    private static final ThreadLocal<Map<String, Map<Long, Set<Long>>>> allLeafsMap = new ThreadLocal();
    private static final ThreadLocal<Map<String, String>> flexsMap = new ThreadLocal();
    private static final ThreadLocal<Map<String, String>> flexFieldsMap = new ThreadLocal();
    private static final ThreadLocal<Map<String, Set<Long>>> orgRelationMap = new ThreadLocal();
    private static final String ENTITY_BOS_STRUCTURE = "bos_org_structure";
    private static final String KEY_AI_BOOKTYPEORG = "ai_booktype_toporg";
    private static final String KEY_AI_DIMCONFIG = "frm_rec_dimconfig";
    public static final String REGX_AI_LEAFIDPATTERM = "(?<=leafid\\[)(.+?)(?=\\])";
    public static final String REGX_AI_BASEDATA_ID_PATTERN = "(?<=getbasedataid\\[)(.+?)(?=\\])";
    public static final String REGX_AI_ASSISTANTDATA_ID_PATTERN = "(?<=getassistantdataid\\[)(.+?)(?=\\])";
    public static final String REGX_AI_BASEDATA_ID_BY_ASSISTANT_PATTERN = "(?<=getbasedataidbyassistant\\[)(.+?)(?=\\])";
    public static final String REGX_AI_IS_NULL_PATTERN = "(?<=trim\\(EMPTY_TO_TEXT\\()(.+?)(?=\\)\\))";
    public static final String REGX_AI_LEAFIDPREFIX_QUOTE = "'leafid[";
    public static final String REGX_AI_BASEDATA_ID_PREFIX_QUOTE = "'getbasedataid[";
    public static final String REGX_AI_ASSISTANTDATA_ID_PREFIX_QUOTE = "'getassistantdataid[";
    public static final String REGX_AI_BASEDATA_ID_BY_ASSISTANT_PREFIX_QUOTE = "'getbasedataidbyassistant[";
    public static final String REGX_AI_LEAFPATTERM = "(?<=leaf\\[)(.+?)(?=\\])";
    public static final String REGX_AI_BASEDATA_PATTERN = "(?<=getbasedata\\[)(.+?)(?=\\])";
    public static final String REGX_AI_SPLIT_PERIOD_PATTERN = "(?<=balanceperiod\\()(.+?)(?=\\))";
    public static final String REGX_AI_LEAPREFIX_QUOTE = "'leaf[";
    public static final String REGX_AI_BASEDATA_REFIX_QUOTE = "'getbasedata[";
    public static final String REGX_AI_EMPTY_TO_TEXT_QUOTE = "trim(EMPTY_TO_TEXT(";
    public static final String SIMP_ACCT_SELECTOR = "id,masterid,longnumber,dc";
    public static final String REGX_AI_LEAFID_FUNCTION_TYPE = "leafid";
    public static final String REGX_AI_BASEDATA_ID_FUNCTION_TYPE = "getbasedataid";
    public static final String REGX_AI_BASEDATA_ID_BY_ASSISTANT_FUNCTION_TYPE = "getbasedataidbyassistant";
    public static final String TMP_BASE_DATA_ID_FLAG = "tmpBaseDataId_";

    public static BizReconPlanModel getReconciliationPlanById(Long recPlanId, Long periodId, Long acctTableId, Long orgId, Long planDetailId) {
        BizReconPlanModel recplanModel = ReconModelCacheHelper.getPlanModel(recPlanId.toString());
        recplanModel.setOrgId(orgId);
        HashSet<Long> allAccountIdSet = new HashSet<Long>(20);
        List<BizReconPlanDetailModel> details = recplanModel.getDetail();
        if (planDetailId != null) {
            details = recplanModel.getDetail().stream().filter(detailModel -> planDetailId.equals(detailModel.getId())).collect(Collectors.toList());
            recplanModel.setDetail(details);
        }
        for (BizReconPlanDetailModel detailModel2 : details) {
            allAccountIdSet.addAll(detailModel2.getAccountIds());
        }
        Map<Long, Long> accountRelation = ReconciliationUtil.getAccountRelation(allAccountIdSet, allAccountIdSet.size(), periodId, acctTableId, orgId);
        for (BizReconPlanDetailModel detailModel3 : details) {
            Set<Long> oriAccountIds = detailModel3.getAccountIds();
            HashSet<Long> vmapAccountIds = new HashSet<Long>(oriAccountIds.size());
            for (Long actId : oriAccountIds) {
                if (accountRelation.containsKey(actId)) {
                    vmapAccountIds.add(accountRelation.get(actId));
                    continue;
                }
                vmapAccountIds.add(actId);
            }
            detailModel3.setAccountIds(vmapAccountIds);
            if (AssistTypeEnum.Assist != detailModel3.getAssistType()) continue;
            detailModel3.setHasAccount(vmapAccountIds.size() != 0);
        }
        return recplanModel;
    }

    public static BizReconPlanModel loadPlanModel(Long planId) {
        DynamicObjectCollection tab3Entry;
        List<Long> amountTypeList;
        DynamicObjectCollection amountTypes;
        DynamicObjectCollection tab2Entry;
        String balanceBasis;
        BizReconPlanDetailModel detailModel;
        BizReconPlanModel recplanModel = new BizReconPlanModel();
        QFilter f = new QFilter("id", "=", (Object)planId);
        DynamicObject recPlan = BusinessDataServiceHelper.loadSingleFromCache((String)"frm_reconciliation_scheme", (QFilter[])new QFilter[]{f});
        recplanModel.setId(recPlan.getLong("id"));
        String bizappid = recPlan.getString(FrmStringUtil.id("bizapp"));
        long orgid = recPlan.getLong(FrmStringUtil.id("org"));
        long accoutTableid = recPlan.getLong(FrmStringUtil.id("accounttable"));
        recplanModel.setAppId(bizappid);
        recplanModel.setOrgId(orgid);
        BalanceBasisEnum headBalanceBasis = BalanceBasisEnum.getEnum(recPlan.getInt("balancebasis"));
        recplanModel.setBalanceBasis(headBalanceBasis);
        ReconAmountTypeEnum reconAmountType = ReconAmountTypeEnum.getEnum(recPlan.getInt("reconamounttype"));
        recplanModel.setReconAmountType(reconAmountType);
        DynamicObject dataRule = recPlan.getDynamicObject("reconciliactionconfig");
        if (dataRule != null) {
            recplanModel.setRuleId(dataRule.getLong("id"));
        }
        recplanModel.setAccoutTableId(accoutTableid);
        ArrayList<BizReconPlanDetailModel> recPlanDetailModel = new ArrayList<BizReconPlanDetailModel>();
        recplanModel.setDetail(recPlanDetailModel);
        boolean closeParam = false;
        DynamicObjectCollection tab1Entry = recPlan.getDynamicObjectCollection("modularentryentity");
        if (tab1Entry.size() > 0) {
            DynamicObjectCollection fieldmapEntrys = recPlan.getDynamicObjectCollection("fieldmapentry");
            Object accountId = null;
            for (DynamicObject modular : tab1Entry) {
                detailModel = new BizReconPlanDetailModel();
                detailModel.setAssistType(AssistTypeEnum.Acct);
                detailModel.setId(modular.getLong("id"));
                detailModel.setViewDetail(modular.getBoolean("viewdetail"));
                balanceBasis = modular.getString("balancebasis1");
                if (ReconAmountTypeEnum.DEBIT_CREDIT_CLOSE != reconAmountType || StringUtils.isEmpty((String)balanceBasis)) {
                    detailModel.setBalanceBasis(headBalanceBasis);
                } else {
                    detailModel.setBalanceBasis(BalanceBasisEnum.getEnum(Integer.valueOf(balanceBasis)));
                }
                detailModel.setAssistType(AssistTypeEnum.Acct);
                DynamicObjectCollection accounts = modular.getDynamicObjectCollection("accounts");
                HashSet<Long> accountIdSet = new HashSet<Long>(accounts.size());
                for (DynamicObject acct : accounts) {
                    accountId = ((DynamicObject)acct.get("fbasedataid")).getLong("id");
                    accountIdSet.add((Long)accountId);
                }
                detailModel.setAccountIds(accountIdSet);
                DynamicObjectCollection amountTypes2 = modular.getDynamicObjectCollection("amounttype");
                List<Long> amountTypeList2 = ReconciliationUtil.getBaseDataIdList(amountTypes2);
                detailModel.setAmountTypeList(amountTypeList2);
                int assistIndex = 0;
                String assistFilter = modular.getString("assistfilterinfo_tag");
                if (StringUtils.isNotEmpty((String)assistFilter)) {
                    detailModel.setAssistFilterInfoTag(assistFilter);
                    List entryData = JSONArray.parseArray((String)assistFilter, Map.class);
                    Iterator iterator = entryData.iterator();
                    while (iterator.hasNext()) {
                        Map rowData = (Map)iterator.next();
                        for (Map.Entry entry : rowData.entrySet()) {
                            Set assistIdSet = ((List)entry.getValue()).stream().mapToLong(d -> Long.parseLong(d.toString())).boxed().collect(Collectors.toSet());
                            if (assistIdSet.isEmpty() || detailModel.getGlAssistIndexMap().containsKey(entry.getKey())) continue;
                            detailModel.getGlAssistIndexMap().put((String)entry.getKey(), assistIndex++);
                            detailModel.getBizAssistIndexMap().put((String)entry.getKey(), assistIndex);
                        }
                    }
                } else {
                    for (DynamicObject fieldmapEntry : fieldmapEntrys) {
                        String entityId = fieldmapEntry.getString("entityid");
                        String fieldKey = fieldmapEntry.getString("fieldkey");
                        String bdtype = fieldmapEntry.getString("datatype");
                        Object assits = null;
                        if (AssistDataType.isBaseDataType(bdtype)) {
                            assits = modular.getDynamicObjectCollection(fieldKey);
                        } else {
                            DynamicObjectCollection acctassistentry = modular.getDynamicObjectCollection("acctassistentry");
                            assits = acctassistentry.stream().filter(dyn -> fieldKey.equals(dyn.getString("assistfield"))).collect(Collectors.toList());
                        }
                        if (assits.isEmpty()) continue;
                        Set<Long> assitSet = ReconciliationUtil.getBaseDataIdSet((List<DynamicObject>)assits, bdtype);
                        if (AssistDataType.isBaseDataType(bdtype) && "bd_currency".equals(entityId)) {
                            detailModel.setCurrencyIds(assitSet);
                            continue;
                        }
                        detailModel.getGlAssistIndexMap().put(AssistDataType.makeAssistKey(bdtype, entityId), assistIndex++);
                        detailModel.getBizAssistIndexMap().put(AssistDataType.makeAssistKey(bdtype, entityId), assistIndex);
                        detailModel.getFirstTabAssistInfoList().add(new AccountAssistInfo(bdtype, entityId, assitSet));
                    }
                }
                detailModel.setBalanceDc(BalanceDcEnum.getEnum(modular.getString("balancedc1")));
                boolean closeParam1 = modular.getBoolean("closeparam1");
                detailModel.setCloseParam(closeParam1);
                if (closeParam1) {
                    closeParam = true;
                }
                recPlanDetailModel.add(detailModel);
            }
        }
        if ((tab2Entry = recPlan.getDynamicObjectCollection("assistentry")).size() > 0) {
            for (DynamicObject entryRow : tab2Entry) {
                BizReconPlanDetailModel detailModel2 = new BizReconPlanDetailModel();
                detailModel2.setId(entryRow.getLong("id"));
                detailModel2.setViewDetail(entryRow.getBoolean("viewdetail1"));
                String balanceBasis2 = entryRow.getString("balancebasis2");
                if (ReconAmountTypeEnum.DEBIT_CREDIT_CLOSE != reconAmountType || StringUtils.isEmpty((String)balanceBasis2)) {
                    detailModel2.setBalanceBasis(headBalanceBasis);
                } else {
                    detailModel2.setBalanceBasis(BalanceBasisEnum.getEnum(Integer.valueOf(balanceBasis2)));
                }
                detailModel2.setAssistType(AssistTypeEnum.Asstact);
                DynamicObject acct = entryRow.getDynamicObject("tab1_account");
                detailModel2.setAccountIds(Collections.singleton(acct.getLong("id")));
                amountTypes = entryRow.getDynamicObjectCollection("amounttype1");
                amountTypeList = ReconciliationUtil.getBaseDataIdList(amountTypes);
                detailModel2.setAmountTypeList(amountTypeList);
                detailModel2.setBalanceDc(BalanceDcEnum.getEnum(entryRow.getString("balancedc2")));
                detailModel2.setIgnoreEmpty(entryRow.getBoolean("ignoreempty"));
                String asstTypeCondStr = entryRow.getString("mulassistinfo_tag");
                List asstTypeCondList = null;
                try {
                    asstTypeCondList = (List)JSONUtils.cast((String)asstTypeCondStr, List.class, (Class[])new Class[]{MulassistConfigModel.class});
                }
                catch (IOException e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8d26\u65b9\u6848\u89e3\u6790\u5f02\u5e38\u3002", (String)"ReconciliationUtil_02", (String)"fi-frm-common", (Object[])new Object[0]));
                }
                detailModel2.setAsstTypeCondList(asstTypeCondList);
                ReconciliationUtil.setBizAssistFilter(entryRow, "bizassistinfo_tag", detailModel2);
                boolean closeParam2 = entryRow.getBoolean("closeparam2");
                detailModel2.setCloseParam(closeParam2);
                if (closeParam2) {
                    closeParam = true;
                }
                recPlanDetailModel.add(detailModel2);
            }
        }
        if ((tab3Entry = recPlan.getDynamicObjectCollection("basedataentry")).size() > 0) {
            for (DynamicObject entryRow : tab3Entry) {
                detailModel = new BizReconPlanDetailModel();
                detailModel.setAssistType(AssistTypeEnum.Assist);
                detailModel.setId(entryRow.getLong("id"));
                detailModel.setViewDetail(entryRow.getBoolean("viewdetail2"));
                balanceBasis = entryRow.getString("balancebasis3");
                if (ReconAmountTypeEnum.DEBIT_CREDIT_CLOSE != reconAmountType || StringUtils.isEmpty((String)balanceBasis)) {
                    detailModel.setBalanceBasis(headBalanceBasis);
                } else {
                    detailModel.setBalanceBasis(BalanceBasisEnum.getEnum(Integer.valueOf(balanceBasis)));
                }
                amountTypes = entryRow.getDynamicObjectCollection("amounttype2");
                amountTypeList = ReconciliationUtil.getBaseDataIdList(amountTypes);
                detailModel.setAmountTypeList(amountTypeList);
                DynamicObjectCollection accounts = entryRow.getDynamicObjectCollection("assistacct");
                HashSet<Long> accountIdSet = new HashSet<Long>(accounts.size());
                for (DynamicObject acct : accounts) {
                    long accountId = ((DynamicObject)acct.get("fbasedataid")).getLong("id");
                    accountIdSet.add(accountId);
                }
                String asstTypeCondStr = entryRow.getString("mulassist2info_tag");
                List asstTypeCondList = null;
                try {
                    asstTypeCondList = (List)JSONUtils.cast((String)asstTypeCondStr, List.class, (Class[])new Class[]{MulassistConfigModel.class});
                }
                catch (IOException e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8d26\u65b9\u6848\u89e3\u6790\u5f02\u5e38\u3002", (String)"ReconciliationUtil_02", (String)"fi-frm-common", (Object[])new Object[0]));
                }
                detailModel.setAsstTypeCondList(asstTypeCondList);
                detailModel.setAccountIds(accountIdSet);
                detailModel.setIgnoreEmpty(entryRow.getBoolean("ignoreempty2"));
                ReconciliationUtil.setBizAssistFilter(entryRow, "bizassist2info_tag", detailModel);
                detailModel.setBalanceDc(BalanceDcEnum.getEnum(entryRow.getString("balancedc3")));
                boolean closeParam3 = entryRow.getBoolean("closeparam3");
                detailModel.setCloseParam(closeParam3);
                if (closeParam3) {
                    closeParam = true;
                }
                recPlanDetailModel.add(detailModel);
            }
        }
        recplanModel.setCloseParam(closeParam);
        return recplanModel;
    }

    private static Set<String> getAsstTypeMappingAssists(long orgId, long assistMappingId) {
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"ai_asstdimmaptype", (Long)orgId);
        DynamicObject assistMappingDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"ai_asstdimmaptype", (QFilter[])new QFilter[]{baseDataFilter, new QFilter("masterid", "=", (Object)assistMappingId)});
        if (assistMappingDyn == null) {
            logger.warn("\u6838\u7b97\u7ef4\u5ea6\u6620\u5c04[]\u4e0d\u5b58\u5728\u6216\u5f53\u524d\u7ec4\u7ec7\u4e0d\u53ef\u4f7f\u7528\uff0c\u9700\u68c0\u67e5\u5bf9\u8d26\u65b9\u6848\u548c\u7ef4\u5ea6\u6620\u5c04\u914d\u7f6e", (Object)assistMappingId);
            return Collections.emptySet();
        }
        AsstDimMapType asstDimMapType = AsstDimMapLoader.loadAsstdimmaptype((Long)assistMappingDyn.getLong("id"));
        HashSet<String> assistDimSet = new HashSet<String>(asstDimMapType.fieldMapEntrys.size());
        for (AccountMapTypeFieldMapEntry fieldMapEntry : asstDimMapType.fieldMapEntrys) {
            String bizDimKey = AssistDataType.makeAssistKey(Integer.parseInt(fieldMapEntry.getDataType()) + 1 + "", fieldMapEntry.getEntityid());
            assistDimSet.add(bizDimKey);
        }
        return assistDimSet;
    }

    private static void setBizAssistFilter(DynamicObject modular, String fieldName, BizReconPlanDetailModel recPlanDetil) {
        String bizAssistJson = modular.getString(fieldName);
        if (StringUtils.isNotEmpty((String)bizAssistJson)) {
            List bizAssistList = (List)SerializationUtils.fromJsonString((String)bizAssistJson, List.class);
            HashMap bizAssist = new HashMap(bizAssistList.size());
            for (Map map : bizAssistList) {
                String assistId = (String)map.get("assistId");
                if (!assistId.contains(".")) {
                    assistId = "1." + assistId;
                }
                bizAssist.put(assistId, map.get("conditionTag"));
            }
            ArrayList<Map<String, String>> bizFilterAssistMapList = new ArrayList<Map<String, String>>(1);
            bizFilterAssistMapList.add(bizAssist);
            recPlanDetil.setBizFilterAssistMapList(bizFilterAssistMapList);
        }
    }

    private static Map<Long, Long> getAccountRelation(Set<Long> allAccountIdSet, int accountSize, Long periodId, Long acctTableId, Long orgId) {
        QFilter accountIdFilter = new QFilter("id", "in", allAccountIdSet);
        DataSet accountDataSet = QueryServiceHelper.queryDataSet((String)ReconciliationUtil.class.getName(), (String)"bd_accountview", (String)"id,number", (QFilter[])new QFilter[]{accountIdFilter}, null);
        HashMap<String, Long> accountMap = new HashMap<String, Long>(accountSize);
        HashSet<String> accountNumberSet = new HashSet<String>(accountSize);
        while (accountDataSet.hasNext()) {
            Row row = accountDataSet.next();
            accountMap.put(row.getString("number"), row.getLong("id"));
            accountNumberSet.add(row.getString("number"));
        }
        QFilter tableFilter = new QFilter("accounttable", "=", (Object)acctTableId);
        QFilter periodIdFilter = new QFilter("id", "=", (Object)periodId);
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"enddate", (QFilter[])new QFilter[]{periodIdFilter});
        Date endDate = period.getDate("enddate");
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)endDate).and(new QFilter("enddate", ">", (Object)endDate));
        QFilter acctFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
        QFilter accountNumberFilter = new QFilter("number", "in", accountNumberSet);
        DataSet realAccountDataSet = QueryServiceHelper.queryDataSet((String)ReconciliationUtil.class.getName(), (String)"bd_accountview", (String)"id,number", (QFilter[])new QFilter[]{tableFilter, dateFilter, acctFilter, accountNumberFilter}, null);
        HashMap<Long, Long> accountRelation = new HashMap<Long, Long>(accountSize);
        for (Row row : realAccountDataSet) {
            String accountNumber = row.getString("number");
            if (accountNumber == null || accountMap.get(accountNumber) == null) continue;
            accountRelation.put((Long)accountMap.get(accountNumber), row.getLong("id"));
        }
        return accountRelation;
    }

    private static void setAssistValueRange(Map<String, String> valueSourceMap, Map<String, String> assistTypes_conditionMap, BizReconPlanDetailModel recPlanDetil) {
        Map<String, String> fFieldMap = flexFieldsMap.get();
        HashMap<String, Set<Long>> assistValueRange = new HashMap<String, Set<Long>>();
        HashSet<Long> orgSet = new HashSet<Long>(16);
        HashSet<String> orgFlexFieldSet = new HashSet<String>(8);
        int index = 0;
        for (Map.Entry<String, String> entry : valueSourceMap.entrySet()) {
            String key = entry.getKey();
            recPlanDetil.getGlAssistIndexMap().put(entry.getValue(), index++);
            String condition = assistTypes_conditionMap.get(key);
            if (condition == null || condition.trim().isEmpty()) continue;
            CRCondition cdb = (CRCondition)SerializationUtils.fromJsonString((String)condition, CRCondition.class);
            String entityKey = entry.getValue();
            String[] split = entityKey.split("\\.");
            String expression = "";
            String entityId = "";
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(2);
            if (AssistDataType.isBaseDataType(split[0])) {
                entityId = split[1];
            } else {
                entityId = "bos_assistantdata_detail";
                QFilter groupFilter = new QFilter("group", "=", (Object)Long.valueOf(split[1]));
                filterList.add(groupFilter);
            }
            expression = cdb.buildFullFormula(EntityMetadataCache.getDataEntityType((String)entityId));
            QFilter filter = QFilter.of((String)expression, (Object[])new Object[0]);
            filterList.add(filter);
            String flexField = fFieldMap.get(key);
            DynamicObjectCollection objs = QueryServiceHelper.query((String)entityId, (String)"id", (QFilter[])filterList.toArray(new QFilter[0]));
            Set<Long> ids = objs.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
            Set<Long> allLeafs = ReconciliationUtil.queryAssistAllSubDatas(entityKey, ids);
            HashSet<Long> assistValueSet = (HashSet<Long>)assistValueRange.get(flexField);
            if (assistValueSet == null) {
                assistValueSet = new HashSet<Long>();
                assistValueRange.put(flexField, assistValueSet);
            }
            assistValueSet.addAll(allLeafs);
            if (assistValueSet.size() == 0) {
                recPlanDetil.setNeedQueryGl(false);
            }
            if (!"1.bos_org".equals(entityKey) && !"1.bos_adminorg".equals(entityKey)) continue;
            orgSet.addAll(assistValueSet);
            orgFlexFieldSet.add(flexField);
        }
        for (Map.Entry<String, String> entry : assistValueRange.entrySet()) {
            if (!orgFlexFieldSet.contains(entry.getKey())) continue;
            ((Set)((Object)entry.getValue())).addAll(orgSet);
        }
        recPlanDetil.setAssistValueRange(assistValueRange);
    }

    public static List<BizReconPlanDetailModel> getDetailModel(BizReconPlanModel planModel, AssistTypeEnum type) {
        ArrayList<BizReconPlanDetailModel> list = new ArrayList<BizReconPlanDetailModel>(10);
        for (BizReconPlanDetailModel detail : planModel.getDetail()) {
            if (type != detail.getAssistType()) continue;
            list.add(detail);
        }
        return list;
    }

    public static BizReconPlanDetailModel getDetailModel(BizReconPlanModel planModel, Long planDetailId) {
        BizReconPlanDetailModel detailModel = null;
        for (BizReconPlanDetailModel detail : planModel.getDetail()) {
            if (planDetailId - detail.getId() != 0L) continue;
            detailModel = detail;
            break;
        }
        if (detailModel == null) {
            detailModel = new BizReconPlanDetailModel();
        }
        return detailModel;
    }

    public static List<Long> getBaseDataIdList(DynamicObjectCollection mulBaseData) {
        ArrayList<Long> bastdataidList = new ArrayList<Long>(mulBaseData.size());
        for (DynamicObject amountType : mulBaseData) {
            bastdataidList.add(amountType.getLong("fbasedataid.id"));
        }
        return bastdataidList;
    }

    public static Set<Long> getBaseDataIdSet(List<DynamicObject> mulBaseData, String bdtype) {
        HashSet<Long> bastdataidSet = new HashSet<Long>();
        for (DynamicObject row : mulBaseData) {
            if (AssistDataType.isBaseDataType(bdtype)) {
                bastdataidSet.add(row.getLong("fbasedataid_id"));
                continue;
            }
            bastdataidSet.add(row.getLong("assistvalue"));
        }
        return bastdataidSet;
    }

    private static Map<String, Object> getAssActTypes(Set<Long> ids) {
        Map<String, String> fFieldMap;
        HashMap<String, Object> asstActTypeMap = new HashMap<String, Object>(2);
        HashMap<String, String> valueSorceTypes = new HashMap<String, String>(ids.size());
        ArrayList<String> flexIds = new ArrayList<String>(ids.size());
        asstActTypeMap.put("valuesource", valueSorceTypes);
        asstActTypeMap.put("flexid", flexIds);
        Map<String, String> map = flexsMap.get();
        if (map == null) {
            map = new HashMap<String, String>(16);
            flexsMap.set(map);
        }
        if ((fFieldMap = flexFieldsMap.get()) == null) {
            fFieldMap = new HashMap<String, String>(16);
            flexFieldsMap.set(fFieldMap);
        }
        ArrayList<Long> newIds = new ArrayList<Long>();
        String flextEntity = null;
        String flexField = null;
        for (Long id : ids) {
            flextEntity = map.get(Long.toString(id));
            flexField = fFieldMap.get(Long.toString(id));
            if (StringUtils.isEmpty((String)flextEntity) || StringUtils.isEmpty((String)flexField)) {
                newIds.add(id);
                continue;
            }
            valueSorceTypes.put(Long.toString(id), flextEntity);
            flexIds.add(flexField);
        }
        if (newIds.size() == 0) {
            return asstActTypeMap;
        }
        QFilter idFilter = new QFilter("id", "in", newIds);
        DynamicObjectCollection bizOrgColl = QueryServiceHelper.query((String)"bd_asstacttype", (String)"id,flexfield,valuetype,valuesource,assistanttype", (QFilter[])new QFilter[]{idFilter});
        if (null != bizOrgColl && bizOrgColl.size() > 0) {
            String id = null;
            String type = null;
            String entity = null;
            String ffield = null;
            for (DynamicObject relOrg : bizOrgColl) {
                id = relOrg.getString("id");
                type = relOrg.getString("valuetype");
                ffield = relOrg.getString("flexfield");
                if (AssistDataType.isBaseDataType(type)) {
                    entity = relOrg.getString("valuesource");
                } else if (AssistDataType.isAssistantDataType(type)) {
                    entity = String.valueOf(relOrg.getLong("assistanttype"));
                }
                map.put(id, AssistDataType.makeAssistKey(type, entity));
                fFieldMap.put(id, ffield);
                valueSorceTypes.put(id, AssistDataType.makeAssistKey(type, entity));
                flexIds.add(ffield);
            }
        }
        return asstActTypeMap;
    }

    public static Map<String, String> getFlexMap(Set<String> flexfields, Set<String> flexIds) {
        Map<String, String> map;
        HashMap<String, String> flexMap;
        CacheKey key;
        HashMap<String, String> retultMap;
        StringBuilder cacheKey = new StringBuilder("recon_flexmap_");
        if (flexfields != null) {
            for (String flexField : flexfields) {
                cacheKey.append(flexField).append("_");
            }
        }
        if (flexIds != null) {
            for (String flexId : flexIds) {
                cacheKey.append(flexId).append("_");
            }
        }
        if ((retultMap = LocalCacheHelper.get(key = CacheKey.getCacheKey(CacheModule.aiReconBaseData, cacheKey.toString()), Map.class)) == null || retultMap.isEmpty()) {
            DynamicObjectCollection flexColl;
            flexMap = new HashMap<String, String>();
            map = flexsMap.get();
            if (map == null) {
                map = new HashMap<String, String>();
                flexsMap.set(map);
            }
            String flexEntity = null;
            for (String flex : flexfields) {
                flexEntity = map.get(flex);
                if (flexEntity == null) {
                    flexMap.put(flex, flex);
                    map.put(flex, flex);
                    continue;
                }
                flexMap.put(flex, flexEntity);
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
            if (flexIds != null && !flexIds.isEmpty()) {
                filters.add(new QFilter("flexfield", "in", flexIds));
            }
            if (null != (flexColl = QueryServiceHelper.query((String)"bd_asstacttype", (String)"flexfield,valuetype,valuesource,assistanttype", (QFilter[])filters.toArray(new QFilter[0]))) && flexColl.size() > 0) {
                String type = null;
                String entity = null;
                String flex = null;
                for (DynamicObject flexObj : flexColl) {
                    type = flexObj.getString("valuetype");
                    flex = flexObj.getString("flexfield");
                    if (AssistDataType.isBaseDataType(type)) {
                        entity = flexObj.getString("valuesource");
                    } else if (AssistDataType.isAssistantDataType(type)) {
                        entity = String.valueOf(flexObj.getLong("assistanttype"));
                    }
                    map.put(flex, AssistDataType.makeAssistKey(type, entity));
                    flexMap.put(flex, AssistDataType.makeAssistKey(type, entity));
                }
            }
        } else {
            return retultMap;
        }
        flexsMap.set(map);
        retultMap = flexMap;
        LocalCacheHelper.put(key, flexMap);
        return retultMap;
    }

    public static String id(String str) {
        if (str != null) {
            str = str + ".id";
        }
        return str;
    }

    public static Map<Long, Set<Long>> getBizOrgIds(Set<Long> acctOrgIds, long bookType) {
        QFilter enableFilter;
        QFilter orgFilter;
        HashMap<Long, Set<Long>> acctSysMap = new HashMap<Long, Set<Long>>();
        HashSet<Long> queryAcctOrgIds = new HashSet<Long>();
        Set bizOrgs = null;
        Map<String, Set<Long>> map = orgRelationMap.get();
        if (map == null) {
            map = new HashMap<String, Set<Long>>(16);
            orgRelationMap.set(map);
        }
        for (Long l : acctOrgIds) {
            bizOrgs = map.get(l + "_" + bookType);
            if (bizOrgs == null) {
                queryAcctOrgIds.add(l);
                continue;
            }
            acctSysMap.put(l, bizOrgs);
        }
        if (queryAcctOrgIds.size() == 0) {
            return acctSysMap;
        }
        HashMap queryAcctSysMap = new HashMap(queryAcctOrgIds.size());
        for (Long l : queryAcctOrgIds) {
            HashSet<Long> orgIds = new HashSet<Long>(1);
            orgIds.add(l);
            queryAcctSysMap.put(l, orgIds);
        }
        HashMap<Long, HashSet<Object>> hashMap = new HashMap<Long, HashSet<Object>>();
        QFilter qFilter = new QFilter("bookstype", "=", (Object)bookType);
        Map acctBookColl = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (String)"org,accountingsys", (QFilter[])new QFilter[]{qFilter, orgFilter = new QFilter("org", "in", queryAcctOrgIds), enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE)});
        if (null == acctBookColl || acctBookColl.size() == 0) {
            return null;
        }
        for (DynamicObject acctBook : acctBookColl.values()) {
            Long acctSys = (Long)acctBook.get("accountingsys_id");
            Long orgId = (Long)acctBook.get("org_id");
            HashSet<Object> orgList = (HashSet<Object>)hashMap.get(acctSys);
            if (orgList == null) {
                orgList = new HashSet<Object>();
                hashMap.put(acctSys, orgList);
            }
            orgList.add(orgId);
        }
        HashMap<Long, Long> orgToAcctOrgMap = new HashMap<Long, Long>();
        for (Map.Entry entry : hashMap.entrySet()) {
            Long acctSys = (Long)entry.getKey();
            DynamicObjectCollection acctsysColl = BaseDataServiceHelper.getAccountingSysBizOrg((Long)acctSys, (Long[])((Set)entry.getValue()).toArray(new Long[0]));
            if (null == acctsysColl || acctsysColl.size() <= 0) continue;
            for (DynamicObject acctBook : acctsysColl) {
                Long acctorgId = (Long)acctBook.get("bizacctorg");
                Long orgId = (Long)acctBook.get("bizorg");
                HashSet<Long> orgList = (HashSet<Long>)queryAcctSysMap.get(acctorgId);
                if (orgList == null) {
                    orgList = new HashSet<Long>();
                    orgList.add(acctorgId);
                    queryAcctSysMap.put(acctorgId, orgList);
                }
                orgList.add(orgId);
                orgToAcctOrgMap.put(orgId, acctorgId);
            }
        }
        QFilter j = new QFilter("toorg", "in", acctOrgIds);
        QFilter k = new QFilter("typerelation.totype", "=", (Object)"10");
        Map bizOrgColl = BusinessDataServiceHelper.loadFromCache((String)"bos_org_orgrelation", (String)"fromorg,toorg,id", (QFilter[])new QFilter[]{j, k});
        if (null != bizOrgColl && bizOrgColl.size() > 0) {
            Long fromOrg = null;
            Long toOrg = null;
            for (DynamicObject relOrg : bizOrgColl.values()) {
                fromOrg = relOrg.getLong("fromorg.id");
                toOrg = relOrg.getLong("toorg.id");
                if (orgToAcctOrgMap.containsKey(fromOrg) || (bizOrgs = (Set)queryAcctSysMap.get(toOrg)) == null) continue;
                bizOrgs.add(fromOrg);
            }
        }
        for (Map.Entry entry : queryAcctSysMap.entrySet()) {
            map.put(entry.getKey() + "_" + bookType, (Set<Long>)entry.getValue());
        }
        acctSysMap.putAll(queryAcctSysMap);
        return acctSysMap;
    }

    public static Set<Long> getAllByMasterId(String entitykey, Set<Long> masterIds) {
        HashSet<Long> result = new HashSet<Long>(masterIds.size() * 2);
        HashSet<Long> mIds = new HashSet<Long>(masterIds.size() * 2);
        String[] entitySplit = entitykey.split("\\.");
        String entityId = "";
        entityId = AssistDataType.isBaseDataType(entitySplit[0]) ? entitySplit[1] : "bos_assistantdata_detail";
        DynamicObjectCollection masterids = QueryServiceHelper.query((String)entityId, (String)"masterid", (QFilter[])new QFilter("masterid", "in", masterIds).or(new QFilter("id", "in", masterIds)).toArray());
        for (DynamicObject id : masterids) {
            mIds.add(id.getLong("masterid"));
        }
        List ids = QueryServiceHelper.queryPrimaryKeys((String)entityId, (QFilter[])new QFilter("masterid", "in", mIds).toArray(), null, (int)-1);
        for (Object id : ids) {
            result.add((Long)id);
        }
        return result;
    }

    public static Map<Long, Set<Long>> getLeafs(String entityID, Set<Long> parentIDs) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>();
        Map<String, Map<Long, Set<Long>>> leafMap = allLeafsMap.get();
        if (leafMap == null) {
            leafMap = new HashMap<String, Map<Long, Set<Long>>>();
            allLeafsMap.set(leafMap);
        }
        HashSet<Long> needQueryIds = new HashSet<Long>();
        Map<Long, Set<Long>> eachLeafs = leafMap.get(entityID);
        if (eachLeafs == null) {
            needQueryIds.addAll(parentIDs);
        } else {
            Set<Long> allLeafs = null;
            for (Long id : parentIDs) {
                allLeafs = eachLeafs.get(id);
                if (allLeafs == null) {
                    needQueryIds.add(id);
                    continue;
                }
                result.put(id, allLeafs);
            }
        }
        if (!needQueryIds.isEmpty()) {
            MainEntityType meta = MetadataServiceHelper.getDataEntityType((String)entityID);
            IDataEntityProperty isLeafProp = meta.findProperty("isleaf");
            if (isLeafProp != null) {
                HashMap<Long, Long> nodeIDParentID = new HashMap<Long, Long>();
                ReconciliationUtil.querySubNode(result, entityID, needQueryIds, nodeIDParentID, needQueryIds);
                if (eachLeafs == null) {
                    eachLeafs = new HashMap<Long, Set<Long>>(needQueryIds.size());
                }
                for (Long needId : needQueryIds) {
                    if (result.containsKey(needId)) continue;
                    eachLeafs.put(needId, new HashSet());
                }
            } else {
                ReconciliationUtil.queryParantNode(result, entityID, parentIDs);
            }
            if (eachLeafs == null) {
                eachLeafs = new HashMap<Long, Set<Long>>();
            }
            eachLeafs.putAll(result);
            leafMap.put(entityID, eachLeafs);
            allLeafsMap.set(leafMap);
        }
        return result;
    }

    private static void queryParantNode(Map<Long, Set<Long>> result, String entityID, Set<Long> parentIDs) {
        QFilter selfLeafFilter = new QFilter("id", "in", parentIDs);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)ReconciliationUtil.class.getName(), (String)entityID, (String)"id,masterid", (QFilter[])new QFilter[]{selfLeafFilter}, null);){
            Row row = null;
            while (ds.hasNext()) {
                row = ds.next();
                Long id = row.getLong("id");
                Long masterid = row.getLong("masterid");
                result.computeIfAbsent(masterid, p -> new HashSet(16)).add(id);
            }
        }
    }

    private static void querySubNode(Map<Long, Set<Long>> result, String entityID, Set<Long> parentIDs, Map<Long, Long> nodeIDParentID, Set<Long> oriParentIDs) {
        QFilter selfIsLeafFilter = new QFilter("isleaf", "=", (Object)"1");
        QFilter selfLeafFilter = new QFilter("id", "in", parentIDs);
        selfIsLeafFilter.and(selfLeafFilter);
        QFilter parentFilter = new QFilter("parent", "in", parentIDs);
        parentFilter.or(selfIsLeafFilter);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)ReconciliationUtil.class.getName(), (String)entityID, (String)"id,parent,isleaf", (QFilter[])new QFilter[]{parentFilter}, null);){
            Row row = null;
            HashSet<Long> nextParentIDs = new HashSet<Long>();
            while (ds.hasNext()) {
                row = ds.next();
                boolean isLeaf = row.getBoolean("isleaf");
                Long id = row.getLong("id");
                Long parentid = row.getLong("parent");
                if (oriParentIDs.contains(id)) {
                    nodeIDParentID.put(id, id);
                } else {
                    nodeIDParentID.put(id, parentid);
                }
                if (isLeaf) {
                    Long topID = ReconciliationUtil.getTopNodeID(id, nodeIDParentID);
                    Set<Long> ids = result.get(topID);
                    if (ids == null) {
                        ids = new HashSet<Long>();
                        result.put(topID, ids);
                    }
                    ids.add(id);
                    continue;
                }
                nextParentIDs.add(id);
            }
            if (!nextParentIDs.isEmpty()) {
                ReconciliationUtil.querySubNode(result, entityID, nextParentIDs, nodeIDParentID, oriParentIDs);
            }
        }
    }

    private static Long getTopNodeID(Long nodeID, Map<Long, Long> nodeIDParentID) {
        Long parentid = nodeIDParentID.get(nodeID);
        if (parentid == null) {
            return nodeID;
        }
        if (parentid.equals(nodeID)) {
            return parentid;
        }
        return ReconciliationUtil.getTopNodeID(parentid, nodeIDParentID);
    }

    public static DynamicObject getDataRule(Long ruleId, ReconAmountTypeEnum reconAmountType) {
        if (ruleId == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d6\u6570\u89c4\u5219\u4e0d\u5b58\u5728id=%s\u3002", (String)"ReconciliationUtil_01", (String)"fi-frm-common", (Object[])new Object[0]), ruleId));
        }
        DynamicObject newDataRule = null;
        StringBuilder selectors = new StringBuilder();
        selectors.append("id,bizapp.id,bizapp.number,createorg.id,useorg.org,preset,disable,bizassist,assistentry.bdtype,assistentry.sourcenumber");
        for (String field : ENTRYS) {
            selectors.append(",entryentity.").append(field);
        }
        HashSet<String> dataTypeSet = new HashSet<String>(5);
        if (reconAmountType == null) {
            dataTypeSet.add(String.valueOf(BizDataTypeEnum.PeriodStart.getValue()));
            dataTypeSet.add(String.valueOf(BizDataTypeEnum.Close.getValue()));
            dataTypeSet.add(String.valueOf(BizDataTypeEnum.Debit.getValue()));
            dataTypeSet.add(String.valueOf(BizDataTypeEnum.Credit.getValue()));
        } else {
            switch (reconAmountType) {
                case DEBIT: {
                    dataTypeSet.add(String.valueOf(BizDataTypeEnum.Debit.getValue()));
                    break;
                }
                case CREDIT: {
                    dataTypeSet.add(String.valueOf(BizDataTypeEnum.Credit.getValue()));
                    break;
                }
                case DEBIT_CREDIT: {
                    dataTypeSet.add(String.valueOf(BizDataTypeEnum.Debit.getValue()));
                    dataTypeSet.add(String.valueOf(BizDataTypeEnum.Credit.getValue()));
                    break;
                }
                default: {
                    dataTypeSet.add(String.valueOf(BizDataTypeEnum.PeriodStart.getValue()));
                    dataTypeSet.add(String.valueOf(BizDataTypeEnum.Close.getValue()));
                    dataTypeSet.add(String.valueOf(BizDataTypeEnum.Debit.getValue()));
                    dataTypeSet.add(String.valueOf(BizDataTypeEnum.Credit.getValue()));
                }
            }
        }
        dataTypeSet.add(String.valueOf(BizDataTypeEnum.Init.getValue()));
        QFilter idFilter = new QFilter("id", "=", (Object)ruleId);
        DynamicObject dataRule = BusinessDataServiceHelper.loadSingleFromCache((String)"frm_recdatarule", (String)selectors.toString(), (QFilter[])new QFilter[]{idFilter});
        if (dataRule != null) {
            newDataRule = (DynamicObject)new CloneUtils(true, false).clone((IDataEntityBase)dataRule);
            DynamicObjectCollection cols = newDataRule.getDynamicObjectCollection("entryentity");
            Iterator ite = cols.iterator();
            DynamicObject entry = null;
            while (ite.hasNext()) {
                entry = (DynamicObject)ite.next();
                if (!entry.getBoolean("disable") && dataTypeSet.contains(entry.getString("datatype"))) continue;
                ite.remove();
            }
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d6\u6570\u89c4\u5219\u4e0d\u5b58\u5728id=%s\u3002", (String)"ReconciliationUtil_01", (String)"fi-frm-common", (Object[])new Object[0]), ruleId));
        }
        return newDataRule;
    }

    public static Map<String, String> queryAssistEntityName(Set<String> entityKeySet) {
        DynamicObject[] load;
        HashMap<String, String> entityNameMap = new HashMap<String, String>();
        List bdEntity = entityKeySet.stream().filter(key -> AssistDataType.isBaseDataType(key.split("\\.")[0])).map(key -> key.split("\\.")[1]).collect(Collectors.toList());
        List adEntity = entityKeySet.stream().filter(key -> !AssistDataType.isBaseDataType(key.split("\\.")[0])).map(key -> Long.parseLong(key.split("\\.")[1])).collect(Collectors.toList());
        if (bdEntity.size() > 0) {
            for (DynamicObject entity : load = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("number", "in", bdEntity)})) {
                entityNameMap.put(AssistDataType.makeAssistKey(AssistDataType.BASEDATA.getBdType(), entity.getString("number")), entity.getString("name"));
            }
        }
        if (adEntity.size() > 0) {
            for (DynamicObject entity : load = BusinessDataServiceHelper.load((String)"bos_assistantdatagroup", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", adEntity)})) {
                entityNameMap.put(AssistDataType.makeAssistKey(AssistDataType.ASSISTASNT.getBdType(), entity.getString("id")), entity.getString("name"));
            }
        }
        return entityNameMap;
    }

    public static Map<String, Map<String, String>> getBaseDataName(Map<String, Set<Long>> baseDataMap) {
        HashMap<String, Map<String, String>> baseDataNameMap = new HashMap<String, Map<String, String>>(16);
        HashMap<String, String> nameMap = null;
        Map<String, String> dimConfigMap = ReconciliationUtil.getRecDimConfig(baseDataMap.keySet());
        for (Map.Entry<String, Set<Long>> assist : baseDataMap.entrySet()) {
            String key = assist.getKey();
            String[] keySplit = key.split("\\.");
            Set<Long> ids = assist.getValue();
            ids.remove(0L);
            ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
            QFilter idFilter = new QFilter("masterid", "in", ids);
            filters.add(idFilter);
            nameMap = new HashMap<String, String>(6);
            String showType = dimConfigMap.get(key);
            if (AssistDataType.isBaseDataType(keySplit[0])) {
                ReconciliationUtil.queryBaseDataName(keySplit[1], showType, filters, nameMap);
                baseDataNameMap.put(key, nameMap);
                continue;
            }
            ReconciliationUtil.queryAssistantName(keySplit[1], showType, filters, nameMap);
            baseDataNameMap.put(key, nameMap);
        }
        return baseDataNameMap;
    }

    private static Set<Long> queryBaseDataName(String entityKey, String showType, List<QFilter> filters, Map<String, String> nameMap) {
        HashSet<Long> idSet = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)entityKey, (String)entityKey, (String)ReconciliationUtil.getSelectFields(showType), (QFilter[])filters.toArray(new QFilter[0]), null);){
            Iterator childIte = dataSet.iterator();
            Row row = null;
            String showName = "";
            while (childIte.hasNext()) {
                row = (Row)childIte.next();
                showName = "A".equals(showType) ? row.getString("number") : ("C".equals(showType) ? String.format("%s %s", row.getString("number"), row.getString("name")) : ("D".equals(showType) ? row.getString("longnumber") : ("E".equals(showType) ? row.getString("fullname") : row.getString("name"))));
                nameMap.put(row.getString("masterid"), showName);
                nameMap.put(row.getString("id"), showName);
                idSet.add(row.getLong("masterid"));
            }
        }
        catch (EntityNotExistsException entityNotExistsException) {
            // empty catch block
        }
        return idSet;
    }

    private static Set<Long> queryAssistantName(String assistantGroup, String showType, List<QFilter> filters, Map<String, String> nameMap) {
        HashSet<Long> idSet = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryAssistantName", (String)"bos_assistantdata_detail", (String)"id,masterid,number,name", (QFilter[])filters.toArray(new QFilter[0]), null);){
            Iterator childIte = dataSet.iterator();
            Row row = null;
            String showName = "";
            while (childIte.hasNext()) {
                row = (Row)childIte.next();
                showName = row.getString("name");
                nameMap.put(row.getString("masterid"), showName);
                nameMap.put(row.getString("id"), showName);
                idSet.add(row.getLong("masterid"));
            }
        }
        return idSet;
    }

    public static <T, E> void mergeAssistMap(Map<String, Set<T>> sourceMap, Map<String, Set<T>> targetMap, E zero) {
        sourceMap.forEach((k, v) -> targetMap.merge((String)k, (Set)v, (v1, v2) -> {
            HashSet set = new HashSet(v1);
            set.addAll(v2);
            if (set.size() > 1) {
                set.remove(zero);
            }
            return new HashSet(set);
        }));
    }

    public static Map<String, Set<Object>> mergeAssistStr(String sourceStr, String targetStr) {
        Map sourceSetMap = MapUtil.str2SetMap(sourceStr);
        Map<String, Set<Object>> targetSetMap = MapUtil.str2SetMap(targetStr);
        ReconciliationUtil.mergeAssistMap(sourceSetMap, targetSetMap, "0");
        return targetSetMap;
    }

    private static Map<String, String> getRecDimConfig(Set<String> entityKey) {
        HashMap<String, String> ret = new HashMap<String, String>(16);
        if (entityKey != null && !entityKey.isEmpty()) {
            HashSet<String> bdAssistKeySet = new HashSet<String>(entityKey.size());
            for (String key : entityKey) {
                if (key.startsWith(AssistDataType.ASSISTASNT.getBdType())) continue;
                bdAssistKeySet.add(key.split("\\.")[1]);
            }
            String cacheKey = String.join((CharSequence)",", bdAssistKeySet);
            return (Map)ThreadCache.get((Object)ThreadCacheKey.getDimConfigIdKey(cacheKey), () -> {
                QFilter dimFilter = new QFilter("recdimension", "in", (Object)bdAssistKeySet);
                QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ReconciliationUtil.getRecDimConfig", (String)KEY_AI_DIMCONFIG, (String)"recdimension,recdimshowtype", (QFilter[])new QFilter[]{dimFilter, enableFilter}, null);){
                    Iterator iter = ds.iterator();
                    Row row = null;
                    while (iter.hasNext()) {
                        row = (Row)iter.next();
                        ret.put(AssistDataType.makeAssistKey("1", row.getString("recdimension")), row.getString("recdimshowtype"));
                    }
                }
                return ret;
            }, (boolean)true);
        }
        return ret;
    }

    private static String getSelectFields(String showType) {
        StringBuilder sbRet = new StringBuilder("id,masterid,");
        if ("A".equals(showType)) {
            sbRet.append("number");
        } else if ("C".equals(showType)) {
            sbRet.append("number,name");
        } else if ("D".equals(showType)) {
            sbRet.append("longnumber");
        } else if ("E".equals(showType)) {
            sbRet.append("fullname");
        } else {
            sbRet.append("name");
        }
        return sbRet.toString();
    }

    @Deprecated
    public static Map<String, Map<String, String>> getBaseDataName(Set<BizDataKey> bizKeys) {
        return null;
    }

    public static BizReconPlanModel getPlanModel(Long bookTypeId, Long orgId, String appId, Long periodId, Long planDetailId) {
        Long acctTableId = AccountRefUtils.getCurPeriodAccountTableId((long)orgId, (long)bookTypeId, (long)periodId);
        logger.error(String.format("\u8c03\u7528\u63a5\u53e3\u83b7\u53d6\u5bf9\u5e94\u7248\u672c\u7684\u79d1\u76ee\u8868, %s, %s, %s, %s, %s", orgId, bookTypeId, periodId, acctTableId, appId));
        Long planId = ReconciliationUtil.getPlanModelId(bookTypeId, orgId, appId, acctTableId);
        if (planId == null) {
            return null;
        }
        BizReconPlanModel planModel = ReconciliationUtil.getReconciliationPlanById(planId, periodId, acctTableId, orgId, planDetailId);
        return planModel;
    }

    public static Long getPlanModelId(Long bookTypeId, Long orgId, String appId, Long acctTableId) {
        DynamicObject[] planMap = ReconciliationUtil.getRecScheme(acctTableId, orgId, appId);
        if (planMap == null || planMap.length == 0) {
            return null;
        }
        return ReconciliationUtil.getOptimalPlanId(planMap, orgId, bookTypeId);
    }

    public static Long getOptimalPlanId(DynamicObject[] planMap, Long orgId, Long bookTypeId) {
        Long planId = null;
        Long secondPlanId = null;
        Long threePlanId = null;
        DynamicObject acctBook = null;
        for (DynamicObject plan : planMap) {
            acctBook = plan.getDynamicObject("booktype");
            if (orgId.equals(plan.getLong("createorg.id"))) {
                if (acctBook != null && acctBook.getLong("id") != bookTypeId.longValue()) continue;
                planId = plan.getLong("id");
                break;
            }
            if (acctBook != null && acctBook.getLong("id") == bookTypeId.longValue()) {
                secondPlanId = plan.getLong("id");
                continue;
            }
            if (acctBook != null) continue;
            threePlanId = plan.getLong("id");
        }
        if (planId == null) {
            planId = secondPlanId != null ? secondPlanId : threePlanId;
        }
        return planId;
    }

    public static DynamicObject[] getRecScheme(Long acctTableId, Long orgId, String appId) {
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"frm_reconciliation_scheme", (Long)orgId);
        if (orgFilter != null) {
            logger.info("frm-base-filter:" + orgFilter.toString());
            QFilter appFilter = new QFilter("bizapp", "=", (Object)appId);
            QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
            QFilter acctTableFilter = new QFilter("accounttable", "=", (Object)acctTableId);
            QFilter bakFilter = new QFilter("bak", "=", (Object)false);
            return BusinessDataServiceHelper.load((String)"frm_reconciliation_scheme", (String)"id,createorg,booktype", (QFilter[])new QFilter[]{acctTableFilter, orgFilter, statusFilter, appFilter, bakFilter}, null);
        }
        orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"ai_reconciliation_scheme", (Long)orgId);
        logger.info("ai-base-filter:" + orgFilter.toString());
        QFilter appFilter = new QFilter("bizapp", "=", (Object)appId);
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        QFilter acctTableFilter = new QFilter("accounttable", "=", (Object)acctTableId);
        QFilter bakFilter = new QFilter("bak", "=", (Object)false);
        return BusinessDataServiceHelper.load((String)"ai_reconciliation_scheme", (String)"id,createorg,booktype", (QFilter[])new QFilter[]{acctTableFilter, orgFilter, statusFilter, appFilter, bakFilter}, null);
    }

    public static List<String> resolveExpression(String content, String formulaPattern) {
        ArrayList<String> ret = new ArrayList<String>(6);
        try {
            Pattern compile = Pattern.compile(formulaPattern);
            Matcher matcher = compile.matcher(content);
            while (matcher.find()) {
                ret.add(matcher.group());
            }
            return ret;
        }
        catch (Exception e) {
            logger.error(String.format("\u5904\u7406\u5bf9\u8d26\u65b9\u6848\u53d6\u6570\u89c4\u5219\u53d6\u503c\u6761\u4ef6leaf|leafid\u51fd\u6570\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s", e));
            ErrorCode errCode = new ErrorCode("AI_HANDLE_LEAFMETHOD", ResManager.loadKDString((String)"\u5904\u7406\u5bf9\u8d26\u65b9\u6848\u53d6\u6570\u89c4\u5219\u53d6\u503c\u6761\u4ef6leaf|leafid\u51fd\u6570\u51fa\u9519", (String)"ReconciliationUtil_0", (String)"fi-frm-common", (Object[])new Object[0]));
            throw new KDException((Throwable)e, errCode, new Object[0]);
        }
    }

    public static Set<String> getAppIds() {
        QFilter modeltypeQfilter = new QFilter("modeltype", "=", (Object)"BillFormModel");
        QFilter voucherQfilter = new QFilter("voucher", "=", (Object)CheckBoxEnum.TRUE.getValue());
        QFilter appFilter = new QFilter("bizappid.deploystatus", "=", (Object)"2");
        DynamicObject[] entitys = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"bizappid.id", (QFilter[])new QFilter[]{voucherQfilter, modeltypeQfilter, appFilter}, (String)"bizappid.id");
        HashSet<String> appIds = new HashSet<String>(entitys.length);
        for (DynamicObject entity : entitys) {
            appIds.add(entity.getString("bizappid.id"));
        }
        return appIds;
    }

    public static Set<Long> getAccountIdByMasterId(Set<Long> masterIdSet) {
        HashSet<Long> accountIdSet = new HashSet<Long>(16);
        if (masterIdSet != null && masterIdSet.size() > 0) {
            QFilter masterIdFilter = new QFilter("masterid", "in", masterIdSet);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getAccountIdByMasterId", (String)"bd_accountview", (String)"id", (QFilter[])masterIdFilter.toArray(), null);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    accountIdSet.add(row.getLong("id"));
                }
            }
        }
        return accountIdSet;
    }

    public static void getDetailAccountId(Long orgId, Long accountTableId, Long periodId, Set<Long> accountIds, Set<Long> acctIdSet, Set<Long> acctMasterSet) {
        Set<Long> accountIdByMasterId;
        ReconciliationUtil.initAccountInfo(orgId, accountTableId, periodId, accountIds, acctIdSet, acctMasterSet, new HashMap<Long, Integer>());
        if (acctMasterSet.size() > 0 && (accountIdByMasterId = ReconciliationUtil.getAccountIdByMasterId(acctMasterSet)).size() > 0) {
            acctIdSet.addAll(accountIdByMasterId);
        }
    }

    public static void initAccountInfo(Long orgId, Long acctTableId, Long periodId, Set<Long> accountIds, Set<Long> acctIdSet, Set<Long> acctMasterSet, Map<Long, Integer> dcMap) {
        QFilter idFilter = new QFilter("id", "in", accountIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"initAccountInfo", (String)"bd_accountview", (String)"id,longnumber", (QFilter[])idFilter.toArray(), null);){
            HashSet<String> longNumberSet = new HashSet<String>(5);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                longNumberSet.add(row.getString("longnumber"));
            }
            ReconciliationUtil.getLeafAccountByLongNumber(longNumberSet, periodId, orgId, acctTableId, acctIdSet, acctMasterSet, dcMap);
        }
    }

    public static void getLeafAccountByLongNumber(Set<String> longNumberSet, Long periodId, Long orgId, Long acctTableId, Set<Long> acctIdSet, Set<Long> acctMasterSet, Map<Long, Integer> dcMap) {
        QFilter tableFilter = new QFilter("accounttable", "=", (Object)acctTableId);
        QFilter periodIdFilter = new QFilter("id", "=", (Object)periodId);
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"enddate", (QFilter[])new QFilter[]{periodIdFilter});
        Date endDate = period.getDate("enddate");
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)endDate).and(new QFilter("enddate", ">", (Object)endDate));
        QFilter acctFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
        QFilter leafFilter = new QFilter("isleaf", "=", (Object)true);
        if (longNumberSet.size() == 1) {
            QFilter longNumberFilter = new QFilter("longnumber", "like", (Object)(longNumberSet.toArray(new String[0])[0] + "_%"));
            longNumberFilter.or(new QFilter("longnumber", "=", (Object)longNumberSet.toArray(new String[0])[0]));
            QFilter[] qFilters = new QFilter[]{tableFilter, acctFilter, dateFilter, leafFilter, longNumberFilter};
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getLeafAccountByLongNumber_1", (String)"bd_accountview", (String)SIMP_ACCT_SELECTOR, (QFilter[])qFilters, (String)"longnumber");
            while (dataSet.hasNext()) {
                Row leaf = dataSet.next();
                acctIdSet.add(leaf.getLong("id"));
                acctMasterSet.add(leaf.getLong("masterid"));
                dcMap.put(leaf.getLong("masterid"), leaf.getInteger("dc"));
            }
        } else {
            QFilter[] qFilters = new QFilter[]{tableFilter, acctFilter, dateFilter, leafFilter};
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getLeafAccountByLongNumber_2", (String)"bd_accountview", (String)SIMP_ACCT_SELECTOR, (QFilter[])qFilters, (String)"longnumber");
            String tempLongNumber = null;
            while (dataSet.hasNext()) {
                Row leaf = dataSet.next();
                tempLongNumber = leaf.getString("longnumber");
                for (String longNumber : longNumberSet) {
                    if (!longNumber.equals(tempLongNumber) && !tempLongNumber.toLowerCase(Locale.ENGLISH).startsWith(longNumber.toLowerCase(Locale.ENGLISH) + "_")) continue;
                    acctIdSet.add(leaf.getLong("id"));
                    acctMasterSet.add(leaf.getLong("masterid"));
                    dcMap.put(leaf.getLong("masterid"), leaf.getInteger("dc"));
                }
            }
        }
    }

    public static FrmLogger initFrmLoggerCache(FrmLogger frmLogger) {
        return (FrmLogger)ThreadCache.get((Object)"init.frmlogger.cache", () -> frmLogger);
    }

    public static Set<Long> queryAssistAllSubDatas(String assistKey, Set<Long> queryNodeIds) {
        String[] split = assistKey.split("\\.");
        String bdtype = split[0];
        String entityId = split[1];
        HashSet<Long> allNodeids = null;
        if (AssistDataType.isBaseDataType(bdtype)) {
            boolean treeBaseData = ReconciliationUtil.isTreeBaseData(entityId);
            if (treeBaseData) {
                allNodeids = new HashSet();
                ReconciliationUtil.queryBaseDataAllSubDatas(entityId, allNodeids, queryNodeIds);
            } else {
                allNodeids = new HashSet<Long>(queryNodeIds);
            }
        } else if (AssistDataType.isAssistantDataType(bdtype)) {
            allNodeids = new HashSet<Long>();
            ReconciliationUtil.queryBaseDataAllSubDatas("bos_assistantdata_detail", allNodeids, queryNodeIds);
        }
        return allNodeids;
    }

    private static boolean isTreeBaseData(String entityId) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        DataEntityPropertyCollection properties = entityType.getProperties();
        boolean hasIsLeafField = Boolean.FALSE;
        boolean hasParentField = Boolean.FALSE;
        for (IDataEntityProperty property : properties) {
            if (hasIsLeafField && hasParentField) break;
            if ("isleaf".equalsIgnoreCase(property.getName()) && "fisleaf".equalsIgnoreCase(property.getAlias())) {
                hasIsLeafField = Boolean.TRUE;
                continue;
            }
            if (!"parent".equalsIgnoreCase(property.getName()) || !"fparentid".equalsIgnoreCase(property.getAlias())) continue;
            hasParentField = Boolean.TRUE;
        }
        return hasIsLeafField && hasParentField;
    }

    private static void queryBaseDataAllSubDatas(String entityId, Set<Long> resultNodeIds, Set<Long> queryNodeIds) {
        resultNodeIds.addAll(queryNodeIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)ReconciliationUtil.class.getName(), (String)entityId, (String)"id,isleaf,parent", (QFilter[])new QFilter[]{new QFilter("parent", "in", queryNodeIds)}, (String)"");
        HashSet<Long> curBatchNodeIds = new HashSet<Long>();
        HashSet<Long> nextBatchNodeIds = new HashSet<Long>();
        for (Row row : dataSet) {
            Long id = row.getLong("id");
            curBatchNodeIds.add(id);
            Boolean isleaf = row.getBoolean("isleaf");
            if (isleaf == null || isleaf.booleanValue()) continue;
            nextBatchNodeIds.add(id);
        }
        resultNodeIds.addAll(curBatchNodeIds);
        if (nextBatchNodeIds.size() > 0) {
            ReconciliationUtil.queryBaseDataAllSubDatas(entityId, resultNodeIds, nextBatchNodeIds);
        }
    }

    public static void initSysParam(ReconciliationParamModel paramModel, String appNumber) throws ParseException {
        SysParam sysParam = new SysParam();
        Long orgId = paramModel.getOrgIds().toArray(new Long[0])[0];
        String ruleEntryIdStr = SystemParamHelper.getStringSysParam("ruleid", orgId, null);
        sysParam.setRuleEntryIdStr(ruleEntryIdStr);
        Date minDate = SystemParamHelper.getDateSysParam("beginyear", orgId, "yyyy-MM-dd", null);
        sysParam.setMinDate(minDate);
        int splitStep = SystemParamHelper.getIntegerSysParam("daterange", orgId, -1);
        sysParam.setSplitStep(splitStep);
        Long beginPeriod = SystemParamHelper.getLongSysParam("beginperiod", orgId, -1L);
        sysParam.setBeginPeriod(beginPeriod);
        paramModel.setSysParam(sysParam);
        if (appNumber != null && !paramModel.isEnableMq()) {
            boolean enablemq = FaBillParamUtils.getBooleanValue(0L, "frm_mq_enable");
            if (!enablemq) {
                enablemq = SystemParamHelper.getMultiParam("enablebiz", orgId).contains(appNumber);
            }
            paramModel.setEnableMq(enablemq);
        }
    }

    public static Set<Long> getLongBaseDataIdSet(DynamicObjectCollection mulBaseData) {
        HashSet<Long> bastDataIdSet = new HashSet<Long>();
        for (DynamicObject amountType : mulBaseData) {
            bastDataIdSet.add(amountType.getLong("fbasedataid_id"));
        }
        return bastDataIdSet;
    }

    public static Long getBaseDataIdAndMasterIdMap(String entityName, String idStr) {
        Long masterId = 0L;
        Long id = 0L;
        try {
            id = Long.parseLong(idStr);
        }
        catch (Throwable e) {
            return 0L;
        }
        if (id == 0L) {
            return masterId;
        }
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        Map baseDataMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"id,masterid", (QFilter[])new QFilter[]{idFilter}, null);
        if (baseDataMap != null && !baseDataMap.isEmpty()) {
            for (Map.Entry ety : baseDataMap.entrySet()) {
                DynamicObject dyBD = (DynamicObject)ety.getValue();
                masterId = dyBD.getLong("masterid");
            }
        }
        return masterId;
    }

    public static BigDecimal getBalanceDc(BalanceDcEnum balanceDcEnum) {
        BigDecimal balanceDc = BigDecimal.ZERO;
        switch (balanceDcEnum) {
            case DEBIT: {
                balanceDc = BigDecimal.ONE;
                break;
            }
            case CREDIT: {
                balanceDc = new BigDecimal(-1);
                break;
            }
        }
        return balanceDc;
    }

    public static BalanceDcEnum getBalanceDc(int accountDc) {
        if (accountDc == 1) {
            return BalanceDcEnum.DEBIT;
        }
        if (accountDc == -1) {
            return BalanceDcEnum.CREDIT;
        }
        return BalanceDcEnum.EMPTY;
    }

    public static String dumpDataSet(DataSet ds) {
        DataSet copy = ds.copy();
        StringBuilder sb = new StringBuilder();
        int cols = copy.getRowMeta().getFieldCount();
        for (int i = 0; i < cols; ++i) {
            sb.append(copy.getRowMeta().getField(i)).append(',');
        }
        sb.append("\r\n");
        for (Row row : copy) {
            for (int i = 0; i < cols; ++i) {
                row.get(i);
                sb.append(row.get(i)).append(',');
            }
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public static Set<String> getAssistKeyFromDataRule(Long dataRuleId, Collection<Long> amountTypes) {
        DynamicObject dataRule = ReconciliationUtil.getDataRule(dataRuleId, null);
        DynamicObjectCollection ruleEntryEntity = dataRule.getDynamicObjectCollection("entryentity");
        Set matchCommonFilterIds = ruleEntryEntity.stream().filter(row -> !row.getBoolean("disable")).filter(row -> amountTypes.contains(row.getLong("amttype_id"))).map(row -> row.getLong("commonfilter_id")).collect(Collectors.toSet());
        Map matchCommonFilters = BusinessDataServiceHelper.loadFromCache((String)"frm_rec_common_filter", (QFilter[])new QFilter[]{new QFilter("id", "in", matchCommonFilterIds)});
        HashSet<String> dimSet = new HashSet<String>(16);
        int index = 0;
        for (Map.Entry commonFilter : matchCommonFilters.entrySet()) {
            DynamicObjectCollection dyAssistCols = ((DynamicObject)commonFilter.getValue()).getDynamicObjectCollection("fieldmapentry");
            HashSet<String> currentDimSet = new HashSet<String>(dyAssistCols.size());
            for (DynamicObject dyAssist : dyAssistCols) {
                String bdtype = dyAssist.getString("datatype");
                String entityId = dyAssist.getString("entityid");
                if (AssistDataType.isBaseDataType(bdtype) && "bd_currency".equals(entityId)) continue;
                currentDimSet.add(AssistDataType.makeAssistKey(bdtype, entityId));
            }
            if (index == 0) {
                dimSet.addAll(currentDimSet);
            } else {
                if (currentDimSet.contains("1.bos_org")) {
                    dimSet.add("1.bos_org");
                } else if (currentDimSet.contains("1.bos_adminorg")) {
                    dimSet.add("1.bos_adminorg");
                }
                Iterator iterator = dimSet.iterator();
                while (iterator.hasNext()) {
                    boolean hasOrg;
                    String next = (String)iterator.next();
                    boolean isOrg = "1.bos_org".equals(next) || "1.bos_adminorg".equals(next);
                    boolean bl = hasOrg = currentDimSet.contains("1.bos_org") || currentDimSet.contains("1.bos_adminorg");
                    if (isOrg && hasOrg || currentDimSet.contains(next)) continue;
                    iterator.remove();
                }
            }
            ++index;
        }
        return dimSet;
    }

    public static Map<String, Set<Long>> getBizAssistMap(String bizAssist) {
        List bizAssistTable;
        HashMap<String, Set<Long>> bizAssistMap = new HashMap<String, Set<Long>>(8);
        if (StringUtils.isNotEmpty((String)bizAssist) && (bizAssistTable = (List)SerializationUtils.fromJsonString((String)bizAssist, List.class)) != null && bizAssistTable.size() > 0) {
            List head = (List)bizAssistTable.get(0);
            for (int i = 1; i < bizAssistTable.size(); ++i) {
                List bodyRow = (List)bizAssistTable.get(i);
                for (int j = 0; j < bodyRow.size(); ++j) {
                    Set masterIdSet = bizAssistMap.computeIfAbsent(head.get(j).toString(), coll -> new HashSet());
                    masterIdSet.add(Long.valueOf(bodyRow.get(j).toString()));
                }
            }
        }
        return bizAssistMap;
    }

    public static <T> Map<String, Set<Long>> getIdByMasterId(Map<String, Set<T>> assistMap) {
        HashMap<String, Set<Long>> assistIdMap = new HashMap<String, Set<Long>>(assistMap.size());
        for (Map.Entry<String, Set<T>> entry : assistMap.entrySet()) {
            String assistEntityKey = entry.getKey();
            String[] entitySplit = assistEntityKey.split("\\.");
            Set<T> masterIds = entry.getValue();
            HashSet<Long> masterIdSet = new HashSet<Long>(masterIds.size());
            for (T assistId : masterIds) {
                masterIdSet.add(Long.parseLong(String.valueOf(assistId)));
            }
            if (masterIdSet.remove(0L) && masterIdSet.size() == 0) {
                masterIdSet.add(0L);
                assistIdMap.put(assistEntityKey, masterIdSet);
                continue;
            }
            String entityId = "";
            entityId = AssistDataType.isBaseDataType(entitySplit[0]) ? entitySplit[1] : "bos_assistantdata_detail";
            QFilter masterIdFilter = new QFilter("masterid", "in", masterIdSet);
            DynamicObjectCollection allAssetCategory = QueryServiceHelper.query((String)entityId, (String)"id", (QFilter[])new QFilter[]{masterIdFilter});
            HashSet<Long> allAssistId = new HashSet<Long>(allAssetCategory.size());
            for (DynamicObject dynamicObject : allAssetCategory) {
                allAssistId.add(dynamicObject.getLong("id"));
            }
            assistIdMap.put(assistEntityKey, allAssistId);
        }
        return assistIdMap;
    }

    public static <T> boolean mergeAssist(Map<String, Set<T>> assIdSetMap, Map<String, Set<T>> bizAssistIdSetMap, Map<String, Set<T>> queryAssistIdSetMap) {
        if (CollectionUtils.isEmpty(assIdSetMap)) {
            queryAssistIdSetMap.putAll(bizAssistIdSetMap);
            return true;
        }
        if (CollectionUtils.isEmpty(bizAssistIdSetMap)) {
            queryAssistIdSetMap.putAll(assIdSetMap);
            return true;
        }
        boolean needQuery = true;
        queryAssistIdSetMap.putAll(bizAssistIdSetMap);
        for (Map.Entry<String, Set<T>> entry : assIdSetMap.entrySet()) {
            boolean bizAssistOnlyZero;
            String assistKey = entry.getKey();
            Set<Object> assistIds = entry.getValue();
            if (!bizAssistIdSetMap.containsKey(assistKey)) {
                queryAssistIdSetMap.put(assistKey, assistIds);
                continue;
            }
            Set<Object> bizAssist = bizAssistIdSetMap.get(assistKey);
            if (bizAssist.size() == 0) {
                needQuery = false;
                break;
            }
            boolean assistOnlyZero = assistIds.size() == 1 && Long.parseLong(String.valueOf(assistIds.toArray(new Object[0])[0])) == 0L;
            boolean bl = bizAssistOnlyZero = bizAssist.size() == 1 && Long.parseLong(String.valueOf(bizAssist.toArray(new Object[0])[0])) == 0L;
            if (bizAssistOnlyZero) {
                queryAssistIdSetMap.put(assistKey, bizAssist);
                continue;
            }
            if (assistOnlyZero) {
                queryAssistIdSetMap.put(assistKey, assistIds);
                continue;
            }
            assistIds.retainAll(bizAssist);
            if (assistIds.size() == 0) {
                needQuery = false;
                break;
            }
            queryAssistIdSetMap.put(assistKey, assistIds);
        }
        return needQuery;
    }

    public static void planDetailAssist(BizReconPlanDetailModel planDetailModel, Long orgId) {
        if (planDetailModel.isDealAssist()) {
            return;
        }
        ArrayList<Map<String, String>> bizFilterAssistMapList = new ArrayList<Map<String, String>>(8);
        if (AssistTypeEnum.Acct == planDetailModel.getAssistType()) {
            String assistFilterInfoTag = planDetailModel.getAssistFilterInfoTag();
            Row row = null;
            if (StringUtils.isNotEmpty((String)assistFilterInfoTag)) {
                List entryData = JSONArray.parseArray((String)assistFilterInfoTag, Map.class);
                for (Map rowData : entryData) {
                    HashMap<String, String> assistFilterMap = new HashMap<String, String>(rowData.size(), 1.0f);
                    for (Map.Entry entry : rowData.entrySet()) {
                        HashSet<Long> includeChildIdSet = new HashSet<Long>(30);
                        String assistKey = (String)entry.getKey();
                        Set assistIdSet = ((List)entry.getValue()).stream().mapToLong(d -> Long.parseLong(d.toString())).boxed().collect(Collectors.toSet());
                        if (assistIdSet.isEmpty()) continue;
                        String[] split = assistKey.split("\\.");
                        String queryEntity = "";
                        queryEntity = AssistDataType.isBaseDataType(split[0]) ? split[1] : "bos_assistantdata_detail";
                        HashSet<Long> masterIdSet = new HashSet<Long>(assistIdSet.size());
                        QFilter selfLeafFilter2 = new QFilter("id", "in", assistIdSet);
                        try (DataSet ds = QueryServiceHelper.queryDataSet((String)ReconciliationUtil.class.getName(), (String)queryEntity, (String)"masterid", (QFilter[])new QFilter[]{selfLeafFilter2}, (String)"");){
                            while (ds.hasNext()) {
                                row = ds.next();
                                masterIdSet.add(row.getLong("masterid"));
                            }
                        }
                        selfLeafFilter2 = new QFilter("masterid", "in", masterIdSet);
                        ds = QueryServiceHelper.queryDataSet((String)ReconciliationUtil.class.getName(), (String)queryEntity, (String)"id", (QFilter[])new QFilter[]{selfLeafFilter2}, (String)"");
                        var19_52 = null;
                        try {
                            while (ds.hasNext()) {
                                row = ds.next();
                                includeChildIdSet.add(row.getLong("id"));
                            }
                        }
                        catch (Throwable throwable) {
                            var19_52 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (ds != null) {
                                if (var19_52 != null) {
                                    try {
                                        ds.close();
                                    }
                                    catch (Throwable throwable) {
                                        var19_52.addSuppressed(throwable);
                                    }
                                } else {
                                    ds.close();
                                }
                            }
                        }
                        assistFilterMap.put(assistKey, new QFilter("id", "in", includeChildIdSet).toSerializedString());
                    }
                    bizFilterAssistMapList.add(assistFilterMap);
                }
                planDetailModel.setBizFilterAssistMapList(bizFilterAssistMapList);
                planDetailModel.setGroupAssistFilter(bizFilterAssistMapList.size() > 0);
            } else {
                HashMap<String, String> bizAssitMap = new HashMap<String, String>(8);
                List<AccountAssistInfo> firstTabAssistInfoList = planDetailModel.getFirstTabAssistInfoList();
                for (AccountAssistInfo accountAssistInfo : firstTabAssistInfoList) {
                    String bdtype = accountAssistInfo.getBdType();
                    String entityId = accountAssistInfo.getEntityId();
                    Set<Long> assistSet = accountAssistInfo.getAssistIdSet();
                    String queryEntity = "";
                    queryEntity = AssistDataType.isBaseDataType(bdtype) ? entityId : "bos_assistantdata_detail";
                    HashSet<Long> masterIdSet = new HashSet<Long>(assistSet.size());
                    QFilter selfLeafFilter = new QFilter("id", "in", assistSet);
                    try (DataSet ds = QueryServiceHelper.queryDataSet((String)ReconciliationUtil.class.getName(), (String)queryEntity, (String)"masterid", (QFilter[])new QFilter[]{selfLeafFilter}, (String)"");){
                        for (Row tmpRow : ds) {
                            masterIdSet.add(tmpRow.getLong("masterid"));
                        }
                    }
                    selfLeafFilter = new QFilter("masterid", "in", masterIdSet);
                    ds = QueryServiceHelper.queryDataSet((String)ReconciliationUtil.class.getName(), (String)queryEntity, (String)"id", (QFilter[])new QFilter[]{selfLeafFilter}, (String)"");
                    var16_41 = null;
                    try {
                        for (Row tmpRow : ds) {
                            assistSet.add(tmpRow.getLong("id"));
                        }
                    }
                    catch (Throwable selfLeafFilter2) {
                        var16_41 = selfLeafFilter2;
                        throw selfLeafFilter2;
                    }
                    finally {
                        if (ds != null) {
                            if (var16_41 != null) {
                                try {
                                    ds.close();
                                }
                                catch (Throwable selfLeafFilter2) {
                                    var16_41.addSuppressed(selfLeafFilter2);
                                }
                            } else {
                                ds.close();
                            }
                        }
                    }
                    bizAssitMap.put(AssistDataType.makeAssistKey(bdtype, entityId), new QFilter("id", "in", assistSet).toSerializedString());
                }
                planDetailModel.setBizFilterAssistMapList(Collections.singletonList(bizAssitMap));
            }
        } else {
            List<MulassistConfigModel> asstTypeCondList = planDetailModel.getAsstTypeCondList();
            HashMap<String, String> assistTypes_conditionMap = new HashMap<String, String>(asstTypeCondList.size());
            for (MulassistConfigModel condModel : asstTypeCondList) {
                assistTypes_conditionMap.put(condModel.getAssistId(), condModel.getConditionTag());
            }
            Set<Long> typesIds = assistTypes_conditionMap.keySet().stream().map(Long::parseLong).collect(Collectors.toSet());
            Map<String, Object> asstActTypeMap = ReconciliationUtil.getAssActTypes(typesIds);
            Map valueSourceMap = (Map)asstActTypeMap.get("valuesource");
            int bizDimFieldIndex = 1;
            HashMap<String, Integer> allBizDimIndexMap = new HashMap<String, Integer>(8);
            HashMap<String, Map<String, Integer>> asstTypeMappingIndex = new HashMap<String, Map<String, Integer>>(4);
            for (MulassistConfigModel condModel : asstTypeCondList) {
                String glDimKey = (String)valueSourceMap.get(condModel.getAssistId());
                if (condModel.getAssistMapMasterId() != null) {
                    Set<String> asstTypeMappingAssists = ReconciliationUtil.getAsstTypeMappingAssists(orgId, condModel.getAssistMapMasterId());
                    if (CollectionUtils.isEmpty(asstTypeMappingAssists)) continue;
                    planDetailModel.getAssistDataMapping().put(glDimKey, condModel.getAssistMapMasterId());
                    HashMap currentBizDimIndexMap = new HashMap(4);
                    for (String dimKey : asstTypeMappingAssists) {
                        if (!allBizDimIndexMap.containsKey(dimKey)) {
                            allBizDimIndexMap.put(dimKey, bizDimFieldIndex++);
                        }
                        currentBizDimIndexMap.put(dimKey, allBizDimIndexMap.get(dimKey));
                    }
                    asstTypeMappingIndex.put(glDimKey, currentBizDimIndexMap);
                    continue;
                }
                allBizDimIndexMap.put(glDimKey, bizDimFieldIndex++);
            }
            planDetailModel.setBizAssistIndexMap(allBizDimIndexMap);
            planDetailModel.setAsstTypeMappingIndex(asstTypeMappingIndex);
            planDetailModel.setAssistAcctTypeList(new ArrayList<String>(valueSourceMap.values()));
            planDetailModel.setAssistFlexIdList((List)asstActTypeMap.get("flexid"));
            ReconciliationUtil.setAssistValueRange(valueSourceMap, assistTypes_conditionMap, planDetailModel);
        }
        planDetailModel.setDealAssist(true);
    }
}

