/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.common.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class ShowConfirmUtil {
    public static final String STOP_TASK = "stopTask";
    public static final String EXIST_TASK_IDS = "existTaskIds";

    public static void showTaskConfirm(IFormView view, IPageCache pageCache, DynamicObjectCollection existTasks) {
        HashSet<Long> existTaskIds = new HashSet<Long>(existTasks.size());
        for (DynamicObject existTask : existTasks) {
            existTaskIds.add(existTask.getLong("id"));
        }
        pageCache.put(EXIST_TASK_IDS, SerializationUtils.toJsonString(existTaskIds));
        String message = ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5f00\u59cb\u6216\u8fdb\u884c\u4e2d\u7684\u5bf9\u8d26\u4efb\u52a1\uff0c\u5982\u9700\u53d1\u8d77\u65b0\u4efb\u52a1\uff0c\u8bf7\u5148\u505c\u6b62\u539f\u5bf9\u8d26\u4efb\u52a1\u3002", (String)"ShowConfirmUtil_0", (String)"fi-frm-common", (Object[])new Object[0]);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(2, ResManager.loadKDString((String)"\u53d6\u6d88", (String)"ShowConfirmUtil_1", (String)"fi-frm-common", (Object[])new Object[0]));
        btnNameMaps.put(6, ResManager.loadKDString((String)"\u5904\u7406", (String)"ShowConfirmUtil_2", (String)"fi-frm-common", (Object[])new Object[0]));
        view.showConfirm(message, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(STOP_TASK), btnNameMaps);
    }

    public static void taskConfirm(MessageBoxClosedEvent messageBoxClosedEvent, String existTaskIds, IFormView view) {
        List existTaskIdList;
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)result) && (existTaskIdList = (List)SerializationUtils.fromJsonString((String)existTaskIds, List.class)) != null && existTaskIdList.size() > 0) {
            ShowConfirmUtil.showTaskList(existTaskIdList, view);
        }
    }

    private static void showTaskList(List existTaskIdList, IFormView view) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("frm_task_layout");
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("1000");
        styleCss.setHeight("400");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setHasRight(true);
        ListFilterParameter parameter = new ListFilterParameter();
        parameter.setFilter(new QFilter("id", "in", (Object)existTaskIdList));
        showParameter.setListFilterParameter(parameter);
        view.showForm((FormShowParameter)showParameter);
    }

    public static boolean isUnitTest() {
        StackTraceElement[] stackTraces = Thread.currentThread().getStackTrace();
        String rootTrace = stackTraces[stackTraces.length - 1].toString();
        return rootTrace.indexOf("kd.bos.unittest") == 0;
    }
}

