/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.asstdimaptype.AsstDimMapLoader;
import kd.fi.bd.vo.AccountMapTypeFieldMapEntry;
import kd.fi.bd.vo.AsstDimMapType;
import kd.fi.bd.vo.AsstDimMapTypeEntry;
import kd.fi.bd.vo.AsstactType;
import kd.fi.frm.common.enums.AssistDataType;
import kd.fi.frm.common.util.ReconciliationUtil;
import kd.fi.frm.mservice.model.AssistMappingModel;

public class AssistMappingUtil {
    private static final Log logger = LogFactory.getLog(AssistMappingUtil.class);

    public static AssistMappingModel getAssistMappingInfo(Long assistMappingId, Long orgId, Map<String, Integer> bizAssistIndexMap) {
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"ai_asstdimmaptype", (Long)orgId);
        DynamicObject assistMappingDyn = BusinessDataServiceHelper.loadSingle((String)"ai_asstdimmaptype", (String)"id", (QFilter[])new QFilter[]{baseDataFilter, new QFilter("masterid", "=", (Object)assistMappingId)});
        if (assistMappingDyn == null) {
            return null;
        }
        AsstDimMapType asstDimMapType = AsstDimMapLoader.loadAsstdimmaptype((Long)assistMappingDyn.getLong("id"));
        AsstactType asstactType = asstDimMapType.getAsstactType();
        String valuetype = asstactType.getValueType();
        String entityId = asstactType.getValuesourceID();
        AssistMappingModel model = new AssistMappingModel();
        model.setAssistMappingId(assistMappingId);
        model.setAsstTypeId(asstactType.getAssistanttypeID());
        model.setAsstDimKey(AssistDataType.makeAssistKey((String)valuetype, (String)entityId));
        for (AccountMapTypeFieldMapEntry fieldMapEntry : asstDimMapType.fieldMapEntrys) {
            String bizDimKey = AssistDataType.makeAssistKey((String)(Integer.parseInt(fieldMapEntry.getDataType()) + 1 + ""), (String)fieldMapEntry.getEntityid());
            Integer seq = bizAssistIndexMap.get(bizDimKey);
            model.getBizAssistIndexMap().add((Tuple<String, Integer>)new Tuple((Object)bizDimKey, (Object)seq));
        }
        for (AsstDimMapTypeEntry dataRow : asstDimMapType.entrys) {
            Object asstTypeValId;
            String[] bizData = new String[asstDimMapType.fieldMapEntrys.size()];
            for (AccountMapTypeFieldMapEntry fieldRow : asstDimMapType.fieldMapEntrys) {
                String fieldKey = fieldRow.getFieldkey();
                String dimVal = String.valueOf(dataRow.getMapData().get(fieldKey));
                String bizDimKey = AssistDataType.makeAssistKey((String)(Integer.parseInt(fieldRow.getDataType()) + 1 + ""), (String)fieldRow.getEntityid());
                Integer seq = bizAssistIndexMap.get(bizDimKey);
                bizData[seq.intValue() - 1] = dimVal;
            }
            Object object = asstTypeValId = AssistDataType.isBaseDataType((String)valuetype) ? dataRow.getAsstMasterId() : dataRow.getAsstdataid();
            if (asstTypeValId == null) {
                logger.warn("\u6620\u5c04\u6570\u636e\u6838\u7b97\u7ef4\u5ea6\u503c\u4e3a\u7a7a{}", (Object)SerializationUtils.toJsonString((Object)dataRow));
                model.getMappingData().add((Tuple<String[], Long>)new Tuple((Object)bizData, (Object)0L));
                continue;
            }
            model.getMappingData().add((Tuple<String[], Long>)new Tuple((Object)bizData, (Object)Long.valueOf(asstTypeValId.toString())));
        }
        return model;
    }

    public static boolean getAssistQueryMap(Long orgId, Map<String, Long> assistDataMapping, String bizAssistTable, String assist, List<Map<String, Set<Long>>> bizAssistIdSetMapList, Map<String, Set<Long>> assistQueryMap) {
        Map<Object, Object> assistMasterIdMap = new HashMap(8);
        HashMap<String, Set<Long>> assistMap = new HashMap<String, Set<Long>>(8);
        if (!StringUtils.isEmpty((Object)assist)) {
            Map assistListMap = (Map)SerializationUtils.fromJsonString((String)assist, Map.class);
            for (Map.Entry entry : assistListMap.entrySet()) {
                List list = (List)entry.getValue();
                HashSet<Long> tmpSet = new HashSet<Long>(list.size());
                for (Object obj : list) {
                    tmpSet.add(Long.parseLong(String.valueOf(obj)));
                }
                assistMap.put((String)entry.getKey(), (Set<Long>)tmpSet);
            }
        }
        Map bizAssistMap = new HashMap(8);
        if (!StringUtils.isEmpty((Object)bizAssistTable)) {
            bizAssistMap = ReconciliationUtil.getBizAssistMap((String)bizAssistTable);
        }
        if (CollectionUtils.isEmpty(assistDataMapping)) {
            assistMasterIdMap = assistMap;
        } else if (!CollectionUtils.isEmpty(assistMap)) {
            boolean needQueryMapping = true;
            block2: for (Map.Entry entry : assistMap.entrySet()) {
                Set assistSet = (Set)entry.getValue();
                for (Long assistId : assistSet) {
                    if (-1L != assistId) continue;
                    needQueryMapping = false;
                    break block2;
                }
            }
            if (needQueryMapping) {
                assistMasterIdMap = AssistMappingUtil.getAssistMapByMapping(orgId, assistMap, assistDataMapping);
                if (assistMasterIdMap.size() == 0) {
                    return false;
                }
            } else {
                assistMasterIdMap = bizAssistMap;
            }
        } else if (!CollectionUtils.isEmpty(bizAssistMap)) {
            assistMasterIdMap = bizAssistMap;
        }
        Map assistIdMap = ReconciliationUtil.getIdByMasterId(assistMasterIdMap);
        if (CollectionUtils.isEmpty(bizAssistIdSetMapList)) {
            assistQueryMap.putAll(assistIdMap);
            return true;
        }
        Map<String, Set<Long>> map = bizAssistIdSetMapList.get(0);
        return ReconciliationUtil.mergeAssist((Map)assistIdMap, map, assistQueryMap);
    }

    private static Map<String, Set<Long>> getAssistMapByMapping(Long orgId, Map<String, Set<Long>> assistMap, Map<String, Long> assistDataMapping) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>(8);
        HashMap<String, String> fieldKeyMap = new HashMap<String, String>(8);
        for (Map.Entry<String, Set<Long>> assistEntry : assistMap.entrySet()) {
            String assistKey = assistEntry.getKey();
            Set<Long> assistSet = assistEntry.getValue();
            String bdType = assistKey.split("\\.")[0];
            if (assistDataMapping.get(assistKey) == null) {
                result.put(assistKey, new HashSet<Long>(assistSet));
                continue;
            }
            Long assistMappingId = assistDataMapping.get(assistKey);
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"ai_asstdimmaptype", (Long)orgId);
            DynamicObject assistMappingDyn = BusinessDataServiceHelper.loadSingle((String)"ai_asstdimmaptype", (String)"id", (QFilter[])new QFilter[]{baseDataFilter, new QFilter("masterid", "=", (Object)assistMappingId)});
            if (assistMappingDyn == null) {
                result.put(assistKey, new HashSet<Long>(assistSet));
                continue;
            }
            AsstDimMapType asstDimMapType = AsstDimMapLoader.loadAsstdimmaptype((Long)assistMappingDyn.getLong("id"));
            List entrys = asstDimMapType.entrys;
            List fieldMapEntrys = asstDimMapType.fieldMapEntrys;
            for (AccountMapTypeFieldMapEntry fieldMapEntry : fieldMapEntrys) {
                String newAssistKey = AssistDataType.makeAssistKey((String)(Integer.parseInt(fieldMapEntry.getDataType()) + 1 + ""), (String)fieldMapEntry.getEntityid());
                fieldKeyMap.put(newAssistKey, fieldMapEntry.getFieldkey());
            }
            ArrayList<Long> assistIds = new ArrayList<Long>(assistSet.size());
            for (Long object : assistSet) {
                assistIds.add(Long.parseLong(String.valueOf(object)));
            }
            for (Long assistId : assistIds) {
                for (AsstDimMapTypeEntry entry : entrys) {
                    Long asstTypeValMasterId;
                    Object asstTypeValId;
                    Object object = asstTypeValId = AssistDataType.isBaseDataType((String)bdType) ? entry.getAsstMasterId() : entry.getAsstdataid();
                    if (asstTypeValId == null) {
                        logger.warn("\u6620\u5c04\u6570\u636e\u6838\u7b97\u7ef4\u5ea6\u503c\u4e3a\u7a7a{}", (Object)SerializationUtils.toJsonString((Object)entry));
                        asstTypeValId = 0L;
                    }
                    if (!(asstTypeValMasterId = Long.valueOf(asstTypeValId.toString())).equals(assistId)) continue;
                    Map mapData = entry.getMapData();
                    for (Map.Entry fieldEntry : fieldKeyMap.entrySet()) {
                        if (mapData.get(fieldEntry.getValue()) == null) continue;
                        result.computeIfAbsent((String)fieldEntry.getKey(), (Function<String, Set<Long>>)((Function<String, Set>)b -> new HashSet(16))).add(Long.parseLong(String.valueOf(mapData.get(fieldEntry.getValue()))));
                    }
                }
            }
        }
        return result;
    }

    public static List<Map<String, Set<Long>>> acctBizFilterToBizAssistMap(List<Map<String, String>> bizFilterAssistMapList) {
        ArrayList<Map<String, Set<Long>>> bizAssistIdSetMapList = new ArrayList<Map<String, Set<Long>>>(8);
        for (Map<String, String> bizAssistFilterMap : bizFilterAssistMapList) {
            if (bizAssistFilterMap == null || bizAssistFilterMap.size() <= 0) continue;
            HashMap<String, Set> bizAssistIdSetMap = new HashMap<String, Set>(16);
            for (Map.Entry<String, String> bizAssist : bizAssistFilterMap.entrySet()) {
                String filterCond = bizAssist.getValue();
                if (kd.bos.util.StringUtils.isEmpty((String)filterCond)) continue;
                String entityKey = bizAssist.getKey();
                if (!entityKey.contains(".")) {
                    entityKey = "1." + entityKey;
                }
                QFilter idFilter = QFilter.fromSerializedString((String)filterCond);
                Set basedataIds = (Set)idFilter.getValue();
                Set allLeafs = ReconciliationUtil.queryAssistAllSubDatas((String)entityKey, (Set)basedataIds);
                bizAssistIdSetMap.put(entityKey, allLeafs);
            }
            if (bizAssistIdSetMap.size() <= 0) continue;
            bizAssistIdSetMapList.add(bizAssistIdSetMap);
        }
        return bizAssistIdSetMapList;
    }
}

