/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice;

import kd.fi.frm.common.enums.AssistTypeEnum;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanDetailModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanModel;
import kd.fi.frm.mservice.impl.AbstractReconTabService;
import kd.fi.frm.mservice.impl.ReconService4Account;
import kd.fi.frm.mservice.impl.ReconService4AccountAssist;
import kd.fi.frm.mservice.impl.ReconService4Assist;

public class ReconTabServiceExecutor {
    public static ReconTabServiceBuilder serviceBuilder(AssistTypeEnum assistTypeEnum) {
        return new ReconTabServiceBuilder(assistTypeEnum);
    }

    public static class ReconTabServiceBuilder {
        private final AssistTypeEnum assistTypeEnum;
        private ReconciliationParamModel paramModel;
        private BizReconPlanDetailModel planDetailModel;
        private BizReconPlanModel planModel;

        public ReconTabServiceBuilder(AssistTypeEnum assistTypeEnum) {
            this.assistTypeEnum = assistTypeEnum;
        }

        public ReconTabServiceBuilder paramModel(ReconciliationParamModel paramModel) {
            this.paramModel = paramModel;
            return this;
        }

        public ReconTabServiceBuilder planModel(BizReconPlanModel planModel) {
            this.planModel = planModel;
            return this;
        }

        public ReconTabServiceBuilder detailModel(BizReconPlanDetailModel planDetailModel) {
            this.planDetailModel = planDetailModel;
            return this;
        }

        public AbstractReconTabService build() {
            if (AssistTypeEnum.Acct == this.assistTypeEnum) {
                return new ReconService4Account(this.paramModel, this.planModel, this.planDetailModel);
            }
            if (AssistTypeEnum.Asstact == this.assistTypeEnum) {
                return new ReconService4AccountAssist(this.paramModel, this.planModel, this.planDetailModel);
            }
            return new ReconService4Assist(this.paramModel, this.planModel, this.planDetailModel);
        }
    }
}

