/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterInfo;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterService;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.constant.ReconciliationFormConstant;
import kd.fi.frm.common.enums.ReconcilationResultEnum;
import kd.fi.frm.common.model.ReconciliationParam;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.task.TaskDao;
import kd.fi.frm.common.task.TaskInfo;
import kd.fi.frm.common.task.TaskStatusEnum;
import kd.fi.frm.common.util.AppBookConfig;
import kd.fi.frm.common.util.DapCache;
import kd.fi.frm.common.util.DapUtil;
import kd.fi.frm.common.util.RecAccountBookResult;
import kd.fi.frm.common.util.RecAccountBookUtil;
import kd.fi.frm.common.util.ThrowableHelper;
import kd.fi.frm.mservice.ReconciliationResult;
import kd.fi.frm.mservice.api.ReconciliationService;
import kd.fi.frm.mservice.impl.AbstractReconciliationService;
import kd.fi.frm.mservice.impl.ReconciliationInitService;
import kd.fi.frm.mservice.impl.ReconciliationPeriodCloseService;

public class ReconciliationServiceImpl
implements ReconciliationService,
ReconciliationFormConstant {
    private static final Log logger = LogFactory.getLog(ReconciliationServiceImpl.class);

    public String execute(String paramStr) {
        logger.info("frm_api_param:" + paramStr);
        String result = null;
        ReconciliationParamModel paramModel = new ReconciliationParamModel();
        paramModel.setApi(true);
        TaskInfo taskInfo = null;
        try (TXHandle h = TX.notSupported();){
            result = this.innerExecute(paramModel, paramStr);
            taskInfo = paramModel.getTaskInfo();
        }
        catch (KDBizException e) {
            logger.error("\u63a5\u53e3\u5bf9\u8d26\u5f02\u5e38", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.error("\u63a5\u53e3\u5bf9\u8d26\u5f02\u5e38", e);
            throw new KDBizException(e, new ErrorCode(ReconcilationResultEnum.error.getIndexString(), StringUtils.isEmpty((String)e.getMessage()) ? ThrowableHelper.toString((Throwable)e) : e.getMessage() + "_"), new Object[]{ThrowableHelper.toString((Throwable)e)});
        }
        finally {
            String taskCache = AppCacheHelper.getTaskCache((String)paramModel.getTaskInfo().getBatchNo(), (String)String.valueOf(paramModel.getTaskInfo().getId()));
            if (StringUtils.isNotEmpty((String)taskCache)) {
                taskInfo = (TaskInfo)SerializationUtils.deSerializeFromBase64((String)taskCache);
            }
            boolean consumed = paramModel.getTaskInfo().isConsumed();
            if (taskInfo != null && consumed) {
                if (!paramModel.isEnableMq() && taskInfo.getTaskStatus() == TaskStatusEnum.DOING || TaskStatusEnum.FINISHED == taskInfo.getTaskStatus()) {
                    AppCacheHelper.updateTaskStatusWithDB((String)taskInfo.getBatchNo(), (String)taskInfo.getId().toString(), (ReconcilationResultEnum)taskInfo.getCode(), (String)taskInfo.getStatus(), (TaskStatusEnum)taskInfo.getTaskStatus(), null, (String[])taskInfo.getError());
                } else if (taskInfo.getTaskStatus() == TaskStatusEnum.ERROR) {
                    TaskDao.failTask((String)taskInfo.getBatchNo(), (Long)taskInfo.getId());
                }
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String innerExecute(ReconciliationParamModel paramModel, String paramStr) {
        ErrorCode code;
        String errorMsg;
        String apiResult = "";
        TaskInfo taskInfo = null;
        ReconciliationResult result = new ReconciliationResult();
        try {
            logger.info(String.format("\u8c03\u7528\u5bf9\u8d26API\uff1aparam=%s", paramStr));
            ReconciliationParam param = (ReconciliationParam)SerializationUtils.fromJsonString((String)paramStr, ReconciliationParam.class);
            if (param == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u53c2\u6570\u4e0d\u6b63\u786e,param=%s", (String)"ReconciliationServiceImpl_1", (String)"fi-frm-mservice", (Object[])new Object[0]), paramStr));
            }
            paramModel.setInit(param.isInit());
            paramModel.setEnableMq(param.isEnableRuleMq());
            paramModel.setOriResult(param.isOriResult());
            try (TXHandle h = TX.requiresNew();){
                try {
                    taskInfo = this.buildTask(param, paramStr);
                    taskInfo.setConsumed(true);
                    paramModel.setTaskInfo(taskInfo);
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
            this.setAcctBooksTypeId(paramModel, param, taskInfo, result);
            apiResult = JSONObject.toJSONString((Object)paramModel);
            if (!result.isSuccess()) {
                ErrorCode code2 = null;
                if (result.getCode() != null) {
                    if (!(param.isOriResult() || ReconcilationResultEnum.moreBook != result.getCode() && ReconcilationResultEnum.noBook != result.getCode() && ReconcilationResultEnum.notonly != result.getCode())) {
                        TaskDao.finishTask((long)taskInfo.getId(), (ReconcilationResultEnum)result.getCode());
                        return null;
                    }
                    code2 = new ErrorCode(result.getCode().getIndexString(), result.getCode().getName() + "");
                    throw new KDBizException(code2, new Object[]{""});
                } else {
                    code2 = new ErrorCode(ReconcilationResultEnum.error.getIndexString(), result.getErrorMsg() + "");
                }
                throw new KDBizException(code2, new Object[]{""});
            }
            paramModel.setOriResult(param.isOriResult());
            this.execute(paramModel);
        }
        catch (Throwable e) {
            ErrorCode code3;
            String taskCache = AppCacheHelper.getTaskCache((String)paramModel.getTaskInfo().getBatchNo(), (String)String.valueOf(paramModel.getTaskInfo().getId()));
            if (StringUtils.isNotEmpty((String)taskCache)) {
                taskInfo = (TaskInfo)SerializationUtils.deSerializeFromBase64((String)taskCache);
            }
            if (taskInfo == null) {
                ErrorCode code4 = new ErrorCode(ReconcilationResultEnum.error.getIndexString(), e.getMessage() + "");
                throw new KDBizException(code4, new Object[]{ThrowableHelper.toString((Throwable)e)});
            }
            if (taskInfo.getError() == null) {
                String[] error = new String[2];
                String message = ThrowableHelper.toString((Throwable)e);
                if (message.length() > 100) {
                    message = message.substring(0, 99);
                }
                error[0] = message;
                error[1] = ThrowableHelper.toString((Throwable)e);
                taskInfo.setError(error);
            }
            if (paramModel.isOriResult()) {
                code3 = new ErrorCode(taskInfo.getCode().getIndexString(), taskInfo.getError()[1]);
            } else {
                code3 = new ErrorCode(ReconcilationResultEnum.error.getIndexString(), taskInfo.getError()[1]);
                taskInfo.setCode(ReconcilationResultEnum.error);
            }
            AppCacheHelper.updateTaskStatusWithDB((String)taskInfo.getBatchNo(), (String)String.valueOf(taskInfo.getId()), (ReconcilationResultEnum)taskInfo.getCode(), null, (TaskStatusEnum)TaskStatusEnum.FINISHED, (Integer)100, (String[])taskInfo.getError());
            throw new KDBizException(code3, new Object[]{ThrowableHelper.toString((Throwable)e)});
        }
        taskInfo = this.getResult(paramModel, taskInfo);
        String[] error = taskInfo.getError();
        if (error != null && StringUtils.isNotEmpty((String)(errorMsg = error[1]))) {
            code = new ErrorCode(ReconcilationResultEnum.error.getIndexString(), errorMsg + "");
            throw new KDBizException(code, new Object[]{errorMsg});
        }
        ReconcilationResultEnum reconcilationResult = taskInfo.getCode();
        if (paramModel.isOriResult()) {
            result.setCode(reconcilationResult);
            if (reconcilationResult == ReconcilationResultEnum.Pass) return apiResult;
            code = new ErrorCode(result.getCode().getIndex() + "", result.getCode().getName() + "");
            logger.info("\u63a5\u53e3\u5bf9\u8d26\u83b7\u53d6\u5f02\u5e38\u7ed3\u679c,\u4efb\u52a1ID={}\uff0ccode={}", (Object)taskInfo.getId(), (Object)result.getCode());
            throw new KDBizException(code, new Object[]{apiResult});
        }
        if (reconcilationResult != ReconcilationResultEnum.closeParamOff && reconcilationResult != ReconcilationResultEnum.Pass) {
            result.setCode(ReconcilationResultEnum.fail);
            code = new ErrorCode(result.getCode().getIndex() + "", result.getCode().getName() + "");
            throw new KDBizException(code, new Object[]{apiResult});
        }
        result.setCode(ReconcilationResultEnum.Pass);
        return apiResult;
    }

    private TaskInfo getResult(ReconciliationParamModel paramModel, TaskInfo taskInfo) {
        String taskCacheStr = AppCacheHelper.getTaskCache((String)paramModel.getTaskInfo().getBatchNo(), (String)paramModel.getTaskInfo().getId().toString());
        if (taskCacheStr != null) {
            TaskInfo taskCache = (TaskInfo)SerializationUtils.deSerializeFromBase64((String)taskCacheStr);
            logger.info("\u63a5\u53e3\u5bf9\u8d26\u83b7\u53d6\u7ed3\u679c,\u4efb\u52a1ID={}\uff0ccode={}", (Object)taskInfo.getId(), (Object)taskCache.getCode());
            if (paramModel.isEnableMq()) {
                if (TaskStatusEnum.FINISHED == taskCache.getTaskStatus() || TaskStatusEnum.ERROR == taskCache.getTaskStatus() || TaskStatusEnum.STOPPED == taskCache.getTaskStatus()) {
                    return taskCache;
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    logger.error("reconimpl wait error", (Throwable)e);
                }
                return this.getResult(paramModel, taskInfo);
            }
            return taskCache;
        }
        taskInfo.addError(ResManager.loadKDString((String)"\u5bf9\u8d26\u7f13\u5b58\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u5bf9\u8d26\uff01", (String)"ReconciliationServiceImpl_2", (String)"fi-ai-mservice", (Object[])new Object[0]));
        return taskInfo;
    }

    private TaskInfo buildTask(ReconciliationParam param, String apiParam) {
        long orgId = param.getOrgId();
        MainEntityType taskMetaType = EntityMetadataCache.getDataEntityType((String)"frm_task");
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        String instanceNumber = Instance.getInstanceId();
        DynamicObject task = (DynamicObject)taskMetaType.createInstance();
        task.set("org_id", (Object)orgId);
        task.set("createorg_id", (Object)orgId);
        task.set("creator_id", (Object)currUserId);
        task.set("createtime", (Object)now);
        boolean init = param.isInit();
        task.set("init", (Object)init);
        task.set("taskstatus", (Object)TaskStatusEnum.DOING.getValue());
        task.set("reconresulttype", (Object)4);
        task.set("suppinst", (Object)instanceNumber);
        Long id = DB.genLongId((String)"t_frm_task");
        String batchno = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        task.set("batchno", (Object)batchno);
        task.set("id", (Object)id);
        task.set("consinst", (Object)instanceNumber);
        task.set("begintime", (Object)now);
        task.set("period", (Object)param.getPeriodId());
        task.set("apiparam_tag", (Object)apiParam);
        String shortParam = apiParam;
        if (apiParam.length() > 100) {
            shortParam = apiParam.substring(0, 99);
        }
        task.set("apiparam", (Object)shortParam);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
        TaskInfo taskInfo = TaskDao.getTaskInfo((Long)Long.parseLong(task.getPkValue().toString()));
        AppCacheHelper.putTaskCache((String)batchno, (String)String.valueOf(task.get("id")), (String)SerializationUtils.serializeToBase64((Object)taskInfo));
        return taskInfo;
    }

    private void execute(ReconciliationParamModel paramModel) {
        paramModel.setApi(true);
        AbstractReconciliationService service = null;
        Boolean isInit = paramModel.isInit();
        service = isInit != false ? new ReconciliationInitService(paramModel) : new ReconciliationPeriodCloseService(paramModel);
        service.execute();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setAcctBooksTypeId(ReconciliationParamModel paramModel, ReconciliationParam param, TaskInfo taskInfo, ReconciliationResult resultCode) {
        String appNumber = param.getAppNumber();
        Map appObj = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)appNumber)});
        if (appObj == null || appObj.size() == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u5e94\u7528\u4e0d\u5b58\u5728\uff0c\u4e0d\u652f\u6301\u5bf9\u8d26", (String)"ReconciliationServiceImpl_0", (String)"fi-frm-mservice", (Object[])new Object[0]);
            this.setErrorResult(taskInfo, resultCode, ReconcilationResultEnum.error, appNumber, false, String.format(errorMsg, appNumber));
            return;
        }
        String appId = appObj.keySet().toArray(new String[0])[0];
        Long bizBookId = param.getBizBookId();
        Long bizOrgId = param.getOrgId();
        HashSet acctBookTypeIds = new HashSet(16);
        boolean glAccountBookConfig = false;
        RecAccountBookResult acctBook = null;
        boolean newAccountBook = RecAccountBookUtil.isNewAccountBook();
        if (newAccountBook) {
            BookRegisterInfo bookRegisterInfo = BookRegisterService.queryByBizApp((String)appNumber);
            if (bookRegisterInfo != null) {
                glAccountBookConfig = true;
                acctBook = RecAccountBookUtil.checkNewAcctBooksTypeId((ReconciliationParam)param, (String)appId);
            }
        } else if (RecAccountBookUtil.getAppConfig().containsKey(appNumber) || RecAccountBookUtil.getOrgConfig().containsKey(appNumber)) {
            AppBookConfig abCfg;
            Long bizId;
            glAccountBookConfig = true;
            if (RecAccountBookUtil.getAppConfig().containsKey(appNumber)) {
                bizId = param.getBizBookId();
                abCfg = (AppBookConfig)DapCache.getAppConfig().get(param.getAppNumber());
            } else {
                bizId = bizOrgId;
                abCfg = (AppBookConfig)DapCache.getOrgConfig().get(param.getAppNumber());
            }
            acctBook = RecAccountBookUtil.getAcctBookFromBiz((String)abCfg.acctBookEnryTableName, (long)bizId);
        }
        if (glAccountBookConfig && acctBook != null) {
            ReconcilationResultEnum code = acctBook.getCode();
            if (ReconcilationResultEnum.Pass == code) {
                paramModel.addAppId(appId);
                paramModel.setBookTypeId(acctBook.getAcctBookTypeId());
                paramModel.setInit(param.isInit());
                paramModel.setPeriodId(param.getPeriodId());
                paramModel.addOrg(acctBook.getAcctOrgId());
                paramModel.addBizOrgIds(bizBookId);
                paramModel.addBizOrgIds(bizOrgId);
                taskInfo.setAppId(appId);
                taskInfo.setBookTypeId(paramModel.getBookTypeId());
                TaskDao.updateTaskHeader((TaskInfo)taskInfo);
                paramModel.setTaskInfo(taskInfo);
                return;
            }
            if (ReconcilationResultEnum.noBook != code) {
                this.setErrorResult(taskInfo, resultCode, code, appNumber, false, code.getName());
                return;
            }
            Set acctOrgs = DapUtil.getAcctOrgIncludeSelf((long)bizOrgId);
            QFilter orgFilter = new QFilter("org", "in", (Object)acctOrgs);
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            taskInfo.setAppId(appId);
            if (RecAccountBookUtil.getAppConfig().containsKey(appNumber)) {
                RecAccountBookResult result = RecAccountBookUtil.getAcctBookByBizBook((String)appNumber, (Long)param.getOrgId(), (QFilter)orgFilter, (QFilter)enableFilter, acctBookTypeIds);
                taskInfo.setBookTypeId(result.getAcctBookTypeId());
                if (result.getCode() != null) {
                    this.setErrorResult(taskInfo, resultCode, result.getCode(), appNumber, false, result.getCode().getName());
                    TaskDao.updateTaskHeader((TaskInfo)taskInfo);
                    return;
                }
            } else {
                String tableName;
                AppBookConfig config = (AppBookConfig)DapCache.getOrgConfig().get(param.getAppNumber());
                String string = tableName = config == null ? null : config.acctBookEnryTableName;
                if (tableName != null) {
                    RecAccountBookResult result = RecAccountBookUtil.getAcctBook4Org((String)tableName, (Long)bizOrgId, (QFilter)orgFilter, (QFilter)enableFilter, acctBookTypeIds);
                    code = result.getCode();
                    taskInfo.setBookTypeId(result.getAcctBookTypeId());
                }
                if (code != null) {
                    this.setErrorResult(taskInfo, resultCode, code, appNumber, false, code.getName());
                    TaskDao.updateTaskHeader((TaskInfo)taskInfo);
                    return;
                }
            }
            TaskDao.updateTaskHeader((TaskInfo)taskInfo);
        } else {
            QFilter enableFilter;
            Set acctOrgs = DapUtil.getAcctOrgIncludeSelf((long)bizOrgId);
            QFilter orgFilter = new QFilter("org", "in", (Object)acctOrgs);
            RecAccountBookResult result = RecAccountBookUtil.getAcctBook4Org(null, (Long)bizOrgId, (QFilter)orgFilter, (QFilter)(enableFilter = new QFilter("enable", "=", (Object)"1")), acctBookTypeIds);
            if (ReconcilationResultEnum.Pass != result.getCode()) {
                this.setErrorResult(taskInfo, resultCode, result.getCode(), appNumber, false, result.getCode().getName());
                return;
            }
        }
        if (acctBookTypeIds.size() == 1) {
            paramModel.addAppId(appId);
            paramModel.setBookTypeId((Long)acctBookTypeIds.iterator().next());
            paramModel.setInit(param.isInit());
            paramModel.setPeriodId(param.getPeriodId());
            paramModel.addOrg(bizOrgId);
            paramModel.addBizOrgIds(bizBookId);
            paramModel.addBizOrgIds(bizOrgId);
            taskInfo.setAppId(appId);
            taskInfo.setBookTypeId(paramModel.getBookTypeId());
            TaskDao.updateTaskHeader((TaskInfo)taskInfo);
            paramModel.setTaskInfo(taskInfo);
            return;
        }
        if (acctBookTypeIds.size() > 1) {
            this.setErrorResult(taskInfo, resultCode, ReconcilationResultEnum.moreBook, appNumber, false, ReconcilationResultEnum.moreBook.getName());
            return;
        }
        this.setErrorResult(taskInfo, resultCode, ReconcilationResultEnum.noBook, appNumber, false, ReconcilationResultEnum.noBook.getName());
    }

    private void setErrorResult(TaskInfo taskInfo, ReconciliationResult result, ReconcilationResultEnum code, String appNumber, boolean success, String errorMsg) {
        result.setCode(code);
        result.setAppNumber(appNumber);
        result.setSuccess(success);
        result.setErrorMsg(errorMsg);
        AppCacheHelper.updateTaskStatus((String)taskInfo.getBatchNo(), (String)String.valueOf(taskInfo.getId()), (ReconcilationResultEnum)code, null, null, null, (String[])new String[]{errorMsg, errorMsg});
    }
}

