/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.bizdata;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.bdsync.BDSyncThreadContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.ConfigurationUtil;
import kd.fi.frm.algox.BigFilter;
import kd.fi.frm.algox.DataInputFactory;
import kd.fi.frm.algox.DataRangeHolder;
import kd.fi.frm.algox.SumGroupReduceFunction;
import kd.fi.frm.common.builder.ISingleTaskContext;
import kd.fi.frm.common.builder.SingleTaskContext;
import kd.fi.frm.common.builder.getvaluehandle.AmountGetHandle;
import kd.fi.frm.common.builder.getvaluehandle.SourceFieldGetHandle;
import kd.fi.frm.common.builder.getvaluemode.IVariableMode;
import kd.fi.frm.common.builder.getvaluemode.SourceBillFieldMode;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.enums.AssistTypeEnum;
import kd.fi.frm.common.enums.DataTypeEnum;
import kd.fi.frm.common.enums.DetailDcEnum;
import kd.fi.frm.common.enums.ReconcilationResultEnum;
import kd.fi.frm.common.model.FRMDataSetModel;
import kd.fi.frm.common.model.FrmLogger;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.SelectedSourceEntity;
import kd.fi.frm.common.model.SysParam;
import kd.fi.frm.common.model.bizdata.BizDataParam;
import kd.fi.frm.common.model.bizdata.BizDataResult;
import kd.fi.frm.common.model.bizdata.BizDataSourceConfig;
import kd.fi.frm.common.model.bizdata.BizDataTypeEnum;
import kd.fi.frm.common.model.bizdata.ItemClassPropModel;
import kd.fi.frm.common.task.TaskDao;
import kd.fi.frm.common.task.TaskInfo;
import kd.fi.frm.common.util.AppBookConfig;
import kd.fi.frm.common.util.BuildHelper;
import kd.fi.frm.common.util.DapCache;
import kd.fi.frm.common.util.DateUtil;
import kd.fi.frm.common.util.FaBillParamUtils;
import kd.fi.frm.common.util.FrmFilterUtil;
import kd.fi.frm.common.util.FrmQueryServiceHelper;
import kd.fi.frm.common.util.RecAccountBookUtil;
import kd.fi.frm.common.util.ReconciliationUtil;
import kd.fi.frm.common.util.ThrowableHelper;
import kd.fi.frm.common.util.TraceOQLUtil;
import kd.fi.frm.mservice.bizdata.BizDataServicePreviewHandler;
import kd.fi.frm.mservice.bizdata.CommonFilterAnalyseUtil;
import kd.fi.frm.mservice.bizdata.ext.custom.AbstractCustomParamService;

public class BizDataService {
    private static final Log logger = LogFactory.getLog(BizDataService.class);
    private final BizDataParam param;
    protected MainEntityType mainEntityType;
    protected SourceFieldGetHandle<Long> bizOrgGetHandle;
    private static final String EXPR_DATE_REGEX = "DATE\\('(.+?)'\\)";
    private static final Pattern EXPR_DATE_PATTERN = Pattern.compile("DATE\\('(.+?)'\\)");
    private DynamicObject period = null;
    private boolean enable_algox = false;
    private List<String> enable_algox_apps;
    private boolean previewMode = false;
    private BizDataServicePreviewHandler previewHandler;
    private ReconciliationParamModel paramModel;
    private SelectedSourceEntity selectedSourceEntity = new SelectedSourceEntity();
    private Map<Long, Boolean> needSplitMap = new HashMap<Long, Boolean>(16);
    private Map<Long, Boolean> needSplitPeriodMap = new HashMap<Long, Boolean>(16);
    private final BizDataResult dataResult;
    private SysParam sysParam;
    private int amountIndex = 10;
    private static final String CON_START_DATE = "con_startdate";
    private Map<String, IVariableMode> DETAIL_SELECT_FIELDS = new HashMap<String, IVariableMode>(4);
    private DataSet assistGroupDataSet;
    private boolean isBigData = Boolean.FALSE;
    boolean functionEnable;
    int pkTableMinSize;
    private boolean resultCache;
    private AbstractCustomParamService customParamService;

    public void registerFilterByAssistGroup(DataSet assistGroupDataSet) {
        this.assistGroupDataSet = assistGroupDataSet;
    }

    public void setCustomParamService(AbstractCustomParamService customParamService) {
        this.customParamService = customParamService;
    }

    public BizDataService(BizDataParam param, ReconciliationParamModel paramModel) {
        this.dataResult = new BizDataResult();
        this.param = param;
        this.paramModel = paramModel;
        this.initParam();
    }

    public void setResultCache(boolean resultCache) {
        this.resultCache = resultCache;
    }

    private void initParam() {
        this.mainEntityType = MetadataServiceHelper.getDataEntityType((String)this.param.getEntityKey());
        this.period = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"begindate,enddate,periodyear,periodnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.param.getPeriodid())});
        String apps = System.getProperty("prop.fi.ai.recon.algox.apps", "ar,ap,cal");
        this.enable_algox_apps = Arrays.asList(apps.split(","));
        this.enable_algox = Boolean.parseBoolean(System.getProperty("prop.fi.ai.recon.algox", "false"));
        if (this.paramModel.getSysParam() != null) {
            this.sysParam = this.paramModel.getSysParam();
        }
        RowMeta rowMeta = FRMDataSetModel.getBizRowMeta((DataTypeEnum)this.paramModel.getDataType());
        DataSetBuilder dataSetBuilder = Algo.create((String)"fi.frm.bizdata").createDataSetBuilder(rowMeta);
        this.dataResult.setDataSetBuilder(dataSetBuilder);
    }

    public void execute() {
        this.compile();
        QFilter idFilter = null;
        if (this.param.getBillIdSet() != null && !this.param.getBillIdSet().isEmpty()) {
            idFilter = new QFilter("id", "in", (Object)this.param.getBillIdSet());
        }
        if (this.param.getIgnoreBillIdSet() != null && !this.param.getIgnoreBillIdSet().isEmpty()) {
            idFilter = new QFilter("id", "not in", (Object)this.param.getIgnoreBillIdSet());
        }
        if (BizDataTypeEnum.PeriodStart == this.param.getSourceConfig().getType() || BizDataTypeEnum.Init == this.param.getSourceConfig().getType()) {
            this.amountIndex = 10;
        } else if (BizDataTypeEnum.Debit == this.param.getSourceConfig().getType()) {
            this.amountIndex = 11;
        } else if (BizDataTypeEnum.Credit == this.param.getSourceConfig().getType()) {
            this.amountIndex = 12;
        } else if (BizDataTypeEnum.Close == this.param.getSourceConfig().getType()) {
            this.amountIndex = 13;
        }
        this.generateBuildResultTasks(idFilter);
    }

    public void preview(BizDataServicePreviewHandler previewHandler) throws ParseException {
        this.previewMode = true;
        this.previewHandler = previewHandler;
        ReconciliationUtil.initSysParam((ReconciliationParamModel)this.paramModel, (String)this.param.getAppNumber());
        this.sysParam = this.paramModel.getSysParam();
        this.compile();
        this.generateBuildResultTasks(null);
    }

    private void handleBillData(BizDataSourceConfig cfg, List<List<QFilter>> allFilterList) {
        for (List<QFilter> filterList : allFilterList) {
            boolean enableAlgox;
            if (CollectionUtils.isEmpty(filterList)) continue;
            ArrayList<QFilter[]> allFilters = new ArrayList<QFilter[]>(16);
            QFilter[] filters = new QFilter[filterList.size()];
            filterList.toArray(filters);
            allFilters.add(filters);
            TraceOQLUtil.traceSql((String)this.param.getEntityKey(), (BizDataSourceConfig)cfg, (String)"id", (QFilter[])filters, null, (int)-1, (boolean)this.previewMode);
            TaskInfo taskInfo = this.paramModel.getTaskInfo();
            if (TaskDao.isTaskOver((TaskInfo)taskInfo)) {
                return;
            }
            Long ruleEntryId = cfg.getRuleEntryId();
            boolean needSplit = ruleEntryId != null && this.needSplitMap.get(ruleEntryId) != null && this.needSplitMap.get(ruleEntryId) != false;
            List splitFilters = FrmFilterUtil.getSplitFiltersByDate(allFilters, (boolean)needSplit, (Date)this.period.getDate("begindate"), (Date)this.sysParam.getMinDate(), (int)this.sysParam.getSplitStep());
            boolean splitAlgox = splitFilters.size() > 1;
            boolean buttonAlgox = this.paramModel.isEnableAlgox();
            boolean oriAlgox = this.enable_algox && DataTypeEnum.Detail != this.param.getDataType() && this.enable_algox_apps.contains(this.param.getAppNumber());
            boolean bl = enableAlgox = splitAlgox || buttonAlgox || oriAlgox;
            if (!this.previewMode && enableAlgox) {
                this.load4AlgoxPatch(cfg, this.selectedSourceEntity, splitFilters);
                continue;
            }
            this.handleBillData4Normal(cfg, splitFilters);
        }
    }

    private void handleBillData4Normal(BizDataSourceConfig cfg, List<QFilter[]> splitFilters) {
        List<Object> bigFilterList = new ArrayList(splitFilters.size());
        if (this.isBigData) {
            for (QFilter[] qFilterArray : splitFilters) {
                bigFilterList.add(BigFilter.getNormalQFilter((QFilter[])qFilterArray));
            }
        } else {
            bigFilterList = splitFilters;
        }
        for (QFilter[] qFilterArray : bigFilterList) {
            this.load(cfg, this.selectedSourceEntity, qFilterArray);
        }
    }

    private void load(BizDataSourceConfig cfg, SelectedSourceEntity sourceEntity, QFilter[] filters) {
        int round = 0;
        String selectString = sourceEntity.getSelectString();
        int top = -1;
        if (this.previewMode) {
            this.previewHandler.setOriginalFilters(filters);
            HashMap<String, Set<String>> dimPropMap = new HashMap<String, Set<String>>();
            BizDataSourceConfig sourceConfig = this.param.getSourceConfig();
            Map dimPropMap2 = sourceConfig.getDimPropMap();
            for (Map.Entry entry : dimPropMap2.entrySet()) {
                HashSet dimProps = (HashSet)dimPropMap.get(entry.getKey());
                if (dimProps == null) {
                    dimProps = new HashSet(10);
                    dimPropMap.put((String)entry.getKey(), dimProps);
                }
                dimProps.add(entry.getValue());
            }
            this.previewHandler.setDimPropMap(dimPropMap);
            selectString = this.previewHandler.getSelectString();
            filters = this.previewHandler.getQueryFilter();
            top = this.previewHandler.getQueryTop();
        }
        String msg = String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u67e5\u8be2round-\uff0c\u53d6\u6570\u89c4\u5219\u5206\u5f55ID\uff1a%s", (String)"BizDataService_3", (String)"fi-ai-mservice", (Object[])new Object[0]), cfg.getRuleEntryId());
        StringBuilder sbInfo = new StringBuilder(msg);
        if (this.previewMode) {
            sbInfo.append(", oql=select ").append(sourceEntity.getSelectString()).append(" from ").append(this.param.getEntityKey()).append(" where ").append(Arrays.toString(filters));
        }
        logger.info(sbInfo.toString());
        FrmFilterUtil.createAndSetShardingHintContext((String)this.param.getEntityKey(), (Set)this.paramModel.getBizOrgIds(), (Date)this.period.getDate("begindate"), (Date)this.period.getDate("enddate"));
        BDSyncThreadContext ignored = BDSyncThreadContext.create((String)"recon");
        Object object = null;
        try {
            this.queryBizData(selectString, filters, top, cfg, sourceEntity, round);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ignored != null) {
                if (object != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ignored.close();
                }
            }
        }
    }

    private void queryBizData(String selectString, QFilter[] filters, int top, BizDataSourceConfig cfg, SelectedSourceEntity sourceEntity, int round) {
        DataSet sumBizData;
        FrmLogger frmLogger = this.paramModel.getFrmLogger();
        DataSet dsBizData = FrmQueryServiceHelper.queryDataSet((FrmLogger)frmLogger, (String)this.getClass().getName(), (String)this.param.getEntityKey(), (String)selectString, (QFilter[])filters, null, (int)top, (boolean)this.paramModel.isPreviewMode());
        if (this.assistGroupDataSet != null) {
            String[] selectFields = (String[])Arrays.stream(dsBizData.getRowMeta().getFields()).map(Field::getName).toArray(String[]::new);
            JoinDataSet joinDataSet = dsBizData.join(this.assistGroupDataSet);
            Map bizAssistMap = (Map)this.param.getBizAssistIdSetMapList().get(0);
            for (Object dimKey : bizAssistMap.keySet()) {
                String fieldkey = "f" + ((String)dimKey).replace(".", "_");
                String leftJoinField = this.previewMode ? (String)cfg.getDimPropMap().get(dimKey) + ".id" : (String)sourceEntity.getFldAlias().get(cfg.getDimPropMap().get(dimKey));
                String rightJoinField = fieldkey + "_id";
                joinDataSet = joinDataSet.on(leftJoinField, rightJoinField);
            }
            dsBizData = joinDataSet.select(selectFields, new String[0]).finish();
        }
        if (this.previewMode) {
            this.previewHandler.appendExecFilter(filters);
            this.previewHandler.handleDataSet(dsBizData);
            return;
        }
        if (cfg.getAmountGetHandle().getValueMode().isFunCall()) {
            sumBizData = dsBizData;
        } else if (cfg.getAmountGetHandle().getVars().size() == 1) {
            Collection groupBySet = cfg.getDimPropMap().values();
            HashSet aliasSet = new HashSet(groupBySet.size());
            for (Object groupField : groupBySet) {
                aliasSet.add(sourceEntity.getFldAlias().get(groupField));
            }
            if (StringUtils.isNotEmpty((CharSequence)this.param.getCurrencyField())) {
                aliasSet.add(sourceEntity.getFldAlias().get(this.param.getCurrencyField()));
            }
            if (DataTypeEnum.Detail == this.paramModel.getDataType() && this.DETAIL_SELECT_FIELDS.size() > 0) {
                Map fldAlias = this.selectedSourceEntity.getFldAlias();
                for (String fieldName : this.DETAIL_SELECT_FIELDS.keySet()) {
                    if (fldAlias.get(fieldName) == null) continue;
                    aliasSet.add(fldAlias.get(fieldName));
                }
            }
            GroupbyDataSet groupByBizData = dsBizData.groupBy(aliasSet.toArray(new String[0]));
            List amountFields = cfg.getAmountGetHandle().getVars();
            HashSet sumFields = new HashSet(amountFields.size());
            for (IVariableMode variableMode : amountFields) {
                sumFields.add(sourceEntity.getFldAlias().get(variableMode.getVar()));
            }
            for (String sumField : sumFields) {
                groupByBizData.sum(sumField);
            }
            sumBizData = groupByBizData.finish();
        } else {
            sumBizData = dsBizData;
        }
        Row row = null;
        int bizDataCount = 0;
        while (sumBizData.hasNext()) {
            row = sumBizData.next();
            this.buildEachConfig(sourceEntity, cfg, row);
            ++bizDataCount;
        }
        logger.info("taskId\uff1a{}\uff0c\u53d6\u6570\u89c4\u5219ID\uff1a{},\u6570\u636e\u91cf : {}", new Object[]{this.paramModel.getTaskInfo().getId(), cfg.getRuleEntryId(), bizDataCount});
    }

    private void load4AlgoxPatch(BizDataSourceConfig cfg, SelectedSourceEntity sourceEntity, List<QFilter[]> splitFilters) {
        int round = 0;
        JobSession session = AlgoX.createSession((String)BizDataService.class.getName(), (String)"bizDataService");
        Integer timeoutTime = Math.max(180, Integer.parseInt(System.getProperty("prop.fi.ai.thread.timeoutsecs", Integer.toString(180))));
        DataRangeHolder holder = new DataRangeHolder(this.param, cfg, sourceEntity, splitFilters);
        Collection groupBySet = holder.getCfg().getDimPropMap().values();
        HashSet<Object> aliasSet = new HashSet<Object>(groupBySet.size());
        for (String groupField : groupBySet) {
            aliasSet.add(sourceEntity.getFldAlias().get(groupField));
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)this.param.getCurrencyField())) {
            aliasSet.add(sourceEntity.getFldAlias().get(this.param.getCurrencyField()));
        }
        DataInputFactory factory = new DataInputFactory(holder);
        DataSetX bizDataSetX = session.fromInput(factory.createQueryBizDataInput());
        Input[] bigInputs = factory.createQueryBigDataInput();
        if (bigInputs.length > 0) {
            aliasSet.add("ori_ai_bigfield");
            DataSetX materialX = session.fromInput(factory.createQueryBigDataInput());
            String[] fields = bizDataSetX.getRowMeta().getFieldNames();
            ArrayList newFields = new ArrayList(fields.length);
            String groupField = factory.getBigFilter().getBigProp().toString();
            for (String field : fields) {
                if (field.equals(groupField)) continue;
                newFields.add(field);
            }
            bizDataSetX = bizDataSetX.join(materialX).on("ori_ai_bigfield", "ori_ai_bigfield").select(newFields.toArray(new String[0]), new String[0]);
        }
        List amountFields = cfg.getAmountGetHandle().getVars();
        HashSet sumFields = new HashSet(amountFields.size());
        for (IVariableMode variableMode : amountFields) {
            sumFields.add(sourceEntity.getFldAlias().get(variableMode.getVar()));
        }
        bizDataSetX = bizDataSetX.groupBy(aliasSet.toArray(new String[0])).reduceGroup((GroupReduceFunction)new SumGroupReduceFunction(bizDataSetX.getRowMeta(), sumFields));
        logger.info("\u7ed3\u675f\u67e5\u8be2round-" + round + "/" + 1);
        DataSetOutput resultSet = new DataSetOutput(bizDataSetX.getRowMeta());
        bizDataSetX.output((Output)resultSet);
        session.commit(timeoutTime.intValue(), TimeUnit.SECONDS);
        DataSet outDataSet = session.readDataSet(resultSet.getId());
        outDataSet = outDataSet.addNullField("id").updateField("id", "0");
        int index = 0;
        Row row = null;
        while (outDataSet.hasNext()) {
            ++index;
            row = outDataSet.next();
            this.buildEachConfig(sourceEntity, cfg, row);
        }
        logger.info("had round-" + round + ",algox\u5f53\u524d\u5df2\u5904\u7406\u884c\u6570=" + index);
    }

    private void generateBuildResultTasks(QFilter idFilter) {
        if (!this.param.isNeedQueryBiz()) {
            logger.info("\u4e1a\u52a1\u8fc7\u6ee4\u67e5\u4e0d\u5230\u6570\u636e\uff0c\u4e0d\u67e5\u4e1a\u52a1\u6570\u636e\u76f4\u63a5\u8fd4\u56de\u3002");
            return;
        }
        QFilter acctFilter = this.getAcctFilter();
        String fldKey = "billstatus";
        DynamicProperty prop = this.mainEntityType.getProperty(fldKey);
        QFilter statusF = null;
        if (prop != null) {
            statusF = new QFilter(fldKey, ">=", (Object)"C");
        }
        boolean hasMaterial = false;
        boolean hasMaterialCategory = false;
        HashMap filterPropsMap = new HashMap(8);
        BizDataSourceConfig c = this.param.getSourceConfig();
        Map filterProp = c.getFilterPropMap();
        for (Map.Entry e : filterProp.entrySet()) {
            String assistKey = (String)e.getKey();
            if ("1.bd_material".equals(assistKey)) {
                hasMaterial = true;
            } else if ("1.bd_materialcategory".equals(assistKey)) {
                hasMaterialCategory = true;
            }
            HashSet props = (Set)filterPropsMap.get(assistKey);
            if (props == null) {
                props = new HashSet(10);
                filterPropsMap.put(assistKey, props);
            }
            props.add(e.getValue());
        }
        List assistIdSetMapList = this.param.getBizAssistIdSetMapList();
        if (DataTypeEnum.Detail == this.paramModel.getDataType() && AssistTypeEnum.Acct != this.paramModel.getAssistTypeEnum() && CollectionUtils.isEmpty((Collection)assistIdSetMapList)) {
            return;
        }
        boolean reserveItemClassPropFilter = false;
        if (this.param.getItemClassPropMap().size() > 0) {
            reserveItemClassPropFilter = true;
        }
        ArrayList<QFilter> assFilterList = new ArrayList<QFilter>(8);
        for (Map assistIdSetMap : assistIdSetMapList) {
            QFilter assFilter = null;
            for (Map.Entry assEntry : assistIdSetMap.entrySet()) {
                Set assFilterIds;
                Set idSet;
                String assistKey = (String)assEntry.getKey();
                if (hasMaterial && hasMaterialCategory && "1.bd_material".equals(assistKey) || (idSet = (Set)assEntry.getValue()) == null || idSet.isEmpty() || (assFilterIds = (Set)filterPropsMap.get(assistKey)) == null) continue;
                for (String p : assFilterIds) {
                    QFilter asf = null;
                    if (reserveItemClassPropFilter && this.param.getItemClassPropMap().containsKey(assistKey)) {
                        ItemClassPropModel itemClassPropModel = (ItemClassPropModel)this.param.getItemClassPropMap().get(assistKey);
                        Map subEntityBaseDatas = BusinessDataServiceHelper.loadFromCache((String)itemClassPropModel.getEntityTypeId(), (String)"id", (QFilter[])new QFilter[]{new QFilter(itemClassPropModel.getSubFilterProp(), "in", (Object)idSet)});
                        Set reserveIdSet = subEntityBaseDatas.values().stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
                        asf = new QFilter(itemClassPropModel.getFilterProp(), "in", reserveIdSet);
                    } else {
                        asf = new QFilter(p, "in", (Object)idSet);
                    }
                    if (assFilter == null) {
                        assFilter = asf;
                        continue;
                    }
                    assFilter = assFilter.and(asf);
                }
            }
            if (assFilter == null) continue;
            assFilterList.add(assFilter);
        }
        QFilter statusFCopy = statusF;
        QFilter curFilter = null;
        if (StringUtils.isNotEmpty((CharSequence)this.param.getCurrencyField())) {
            if (DataTypeEnum.Detail == this.paramModel.getDataType() || this.paramModel.isLocalCurrency()) {
                if (this.paramModel.getCurrency() != 0L) {
                    curFilter = new QFilter(this.param.getCurrencyField(), "=", (Object)this.paramModel.getCurrency());
                }
            } else if (this.param.getCurrencyIds().size() > 0) {
                curFilter = new QFilter(this.param.getCurrencyField(), "in", (Object)this.param.getCurrencyIds());
            }
        }
        QFilter currencyFilter = curFilter;
        ReconcilationResultEnum code = null;
        Long taskEntryId = c.getTaskEntryId();
        TaskInfo taskInfo = this.paramModel.getTaskInfo();
        ArrayList<List<QFilter>> allFilterList = new ArrayList<List<QFilter>>(8);
        try {
            String cacheId;
            CachedDataSet cache;
            DataSet bizDataSet;
            if (taskInfo != null) {
                TaskDao.startExecuteRuleEntry((Long)this.paramModel.getTaskInfo().getId(), (Long)c.getRuleEntryId(), (Long)taskEntryId);
            }
            List billFilters = c.getBillFilters();
            ArrayList<QFilter> pkTableFilters = new ArrayList<QFilter>(billFilters.size());
            ArrayList splitBillFilters = new ArrayList(billFilters.size());
            if (billFilters.size() > 0) {
                Boolean needSplitPeriod = this.needSplitPeriodMap.get(c.getRuleEntryId());
                Iterator specialFilter = null;
                for (QFilter currentBillFilter : billFilters) {
                    QFilter pkTableFilter;
                    Set splitPeriodFilters;
                    if (currentBillFilter.toString().contains("tmpBaseDataId_")) {
                        specialFilter = this.splitBillFilter(currentBillFilter);
                        currentBillFilter = (QFilter)((Tuple)specialFilter).item1;
                    }
                    if ((splitPeriodFilters = FrmFilterUtil.getSplitPeriodFilter((Boolean)needSplitPeriod, (QFilter)currentBillFilter, (SysParam)this.sysParam, (int)this.period.getInt("periodyear"), (int)this.period.getInt("periodnumber"))).size() > 0) {
                        splitBillFilters.addAll(splitPeriodFilters);
                    }
                    if ((pkTableFilter = FrmFilterUtil.getPkTableFilter(specialFilter, assFilterList, (MainEntityType)this.mainEntityType)) == null) continue;
                    pkTableFilters.add(pkTableFilter);
                }
            }
            List<QFilter> filterList = this.fillFilterList(c, currencyFilter, acctFilter, statusFCopy, pkTableFilters);
            if (idFilter != null) {
                filterList.add(idFilter);
            }
            if (splitBillFilters.size() == 0) {
                for (QFilter assFilter : assFilterList) {
                    ArrayList<QFilter> tmpList = new ArrayList<QFilter>(filterList.size() + 1);
                    tmpList.addAll(filterList);
                    tmpList.add(assFilter);
                    allFilterList.add(tmpList);
                }
            } else {
                for (QFilter currentBillFilter : splitBillFilters) {
                    ArrayList<QFilter> tmpFilterList = new ArrayList<QFilter>(filterList.size() + 1);
                    tmpFilterList.addAll(filterList);
                    if (currentBillFilter != null) {
                        tmpFilterList.add(currentBillFilter);
                    }
                    if (assFilterList.size() == 0) {
                        allFilterList.add(tmpFilterList);
                        continue;
                    }
                    for (QFilter assFilter : assFilterList) {
                        ArrayList<QFilter> tmpList = new ArrayList<QFilter>(tmpFilterList.size() + 1);
                        tmpList.addAll(tmpFilterList);
                        tmpList.add(assFilter);
                        allFilterList.add(tmpList);
                    }
                }
            }
            if (allFilterList.size() == 0) {
                allFilterList.add(filterList);
            }
            this.handleBillData(c, allFilterList);
            if (DataTypeEnum.OnlyStatus == this.param.getDataType() || DataTypeEnum.NotDetail == this.param.getDataType()) {
                bizDataSet = this.dataResult.getDataSetBuilder().build();
                bizDataSet = bizDataSet.groupBy(new String[]{"rule", "currency", "assist1_app", "assist2_app", "assist3_app", "assist4_app", "assist5_app", "assist6_app", "assist7_app", "assist8_app"}).sum("openingbalance_app").sum("debitamount_app").sum("creditamount_app").sum("closingbalance_app").finish();
                cache = bizDataSet.cache(CacheHint.getDefault());
                cacheId = cache.getCacheId();
                this.dataResult.setResultCacheId(cacheId);
            } else if (DataTypeEnum.Detail == this.param.getDataType() && this.resultCache) {
                bizDataSet = this.dataResult.getDataSetBuilder().build();
                cache = bizDataSet.cache(CacheHint.getDefault());
                cacheId = cache.getCacheId();
                this.dataResult.setResultCacheId(cacheId);
            }
            if (!this.paramModel.isEnableMq() && taskInfo != null) {
                TaskDao.finishExecuteRuleEntry((Long)taskInfo.getId(), (Long)c.getRuleEntryId(), (Long)taskEntryId, (int)this.dataResult.getDataSize(), (String)" ");
                if (DataTypeEnum.Detail != this.param.getDataType()) {
                    AppCacheHelper.updateTaskStatusWithDB((String)taskInfo.getBatchNo(), (String)taskInfo.getId().toString(), code, null, null, (Integer)1, null);
                }
            }
        }
        catch (Throwable e) {
            logger.error("\u4e1a\u52a1\u53d6\u6570\u6267\u884c\u5f02\u5e38", e);
            String msg = ResManager.loadKDString((String)"\u5bf9\u8d26\u83b7\u53d6\u4e1a\u52a1\u6570\u636eID\u62a5\u9519\uff1a", (String)"BizDataService_8", (String)"fi-ai-mservice", (Object[])new Object[0]);
            String errorMsg = msg + ThrowableHelper.toString((Throwable)e);
            if (taskInfo != null) {
                TaskDao.failExecuteRuleEntry((Long)taskInfo.getId(), (Long)c.getRuleEntryId(), (Long)taskEntryId);
            }
            throw new KDException(errorMsg);
        }
    }

    private List<QFilter> fillFilterList(BizDataSourceConfig c, QFilter currencyFilter, QFilter acctFilter, QFilter statusFCopy, List<QFilter> pkTableFilters) {
        QFilter periodFilter = this.getPeriodFilter(c);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        if (currencyFilter != null) {
            filterList.add(currencyFilter);
        }
        if (this.param.getRecordIds() != null && !this.param.getRecordIds().isEmpty()) {
            filterList.add(new QFilter("id", "not in", (Object)this.param.getRecordIds()));
        }
        if (acctFilter != null) {
            filterList.add(acctFilter);
        }
        if ("fa_card_fin".equalsIgnoreCase(this.param.getEntityKey()) && BizDataTypeEnum.Close == c.getType()) {
            if (statusFCopy != null) {
                filterList.add(statusFCopy);
            }
        } else {
            if (periodFilter != null) {
                filterList.add(periodFilter);
            }
            if (!this.param.isInit() && statusFCopy != null) {
                filterList.add(statusFCopy);
            }
        }
        if (this.paramModel.isAnalyzeMode() && DataTypeEnum.Detail == this.paramModel.getDataType() && this.paramModel.getAnalyzeBillId() > 0L) {
            filterList.add(new QFilter("id", "=", (Object)this.paramModel.getAnalyzeBillId()));
        }
        if (pkTableFilters.size() > 0) {
            filterList.addAll(pkTableFilters);
        }
        return filterList;
    }

    private List<Date> handleExprContainsDate(String expr) {
        Matcher m = EXPR_DATE_PATTERN.matcher(expr);
        ArrayList<Date> dateLst = new ArrayList<Date>(8);
        while (m.find()) {
            try {
                String dateStr = m.group(1);
                SimpleDateFormat dFormat = dateStr.contains(":") ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd");
                dateLst.add(dFormat.parse(dateStr));
            }
            catch (ParseException e) {
                throw new KDException(ThrowableHelper.toString((Exception)e, (String)"dateStr: %s", (Object[])new Object[]{m.group(1)}));
            }
        }
        return dateLst;
    }

    private QFilter dealConFormular(String expr, Long ruleEntryId, BizDataTypeEnum bizDataTypeEnum) {
        List<Date> dateLst;
        QFilter filter = null;
        if (expr.indexOf("con_period_year") > -1) {
            expr = expr.replaceAll("con_period_year", this.period.getString("periodyear"));
        }
        if (expr.indexOf("con_period_number") > -1) {
            expr = expr.replaceAll("con_period_number", this.period.getString("periodnumber"));
        }
        if (expr.indexOf("con_period") > -1) {
            expr = expr.replaceAll("con_period", this.period.getString("id"));
        }
        HashMap<String, Date> dateMap = new HashMap<String, Date>();
        boolean needSplit = FrmFilterUtil.needSplit((BizDataTypeEnum)bizDataTypeEnum, (Long)ruleEntryId, (String)expr, (SysParam)this.sysParam, (Date)this.period.getDate("begindate"));
        this.needSplitMap.put(ruleEntryId, needSplit);
        if (!needSplit) {
            dateMap.put(CON_START_DATE, this.period.getDate("begindate"));
        }
        dateMap.put("con_enddata", this.period.getDate("enddate"));
        dateMap.put("con_preperiod_enddate", DateUtil.addDay((Date)this.period.getDate("begindate"), (int)-1));
        List<Date> dateValues = this.buildDateParams(expr, dateMap);
        if (!dateValues.isEmpty()) {
            for (String key : dateMap.keySet()) {
                expr = expr.replace(key, "?");
            }
        }
        if (!(dateLst = this.handleExprContainsDate(expr)).isEmpty()) {
            String[] split = expr.split(EXPR_DATE_REGEX);
            int index = 0;
            for (int i = 0; i < dateLst.size(); ++i) {
                int count = split[i].split("\\?").length - 1;
                dateValues.add(index + count, dateLst.get(i));
                index += count + 1;
            }
            expr = expr.replaceAll(EXPR_DATE_REGEX, "?");
        }
        filter = dateValues.isEmpty() ? QFilter.of((String)expr, (Object[])new Object[0]) : QFilter.of((String)expr, (Object[])dateValues.toArray());
        return filter;
    }

    private Tuple<QFilter, QFilter> splitBillFilter(QFilter billFilter) {
        Object value = billFilter.getValue();
        List nests = billFilter.getNests(false);
        QFilter first = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        QFilter second = null;
        if (value.toString().contains("tmpBaseDataId_") && value instanceof List) {
            second = billFilter;
            for (QFilter.QFilterNest nest : nests) {
                if ("AND".equals(nest.getOp())) {
                    first.and(nest.getFilter());
                    continue;
                }
                first.or(nest.getFilter());
            }
        } else {
            billFilter.clearNests();
            first = billFilter;
            for (QFilter.QFilterNest nest : nests) {
                QFilter nestFilter = nest.getFilter();
                String nestFilterStr = nestFilter.toString();
                if (nestFilterStr.contains("tmpBaseDataId_")) {
                    Tuple<QFilter, QFilter> tuple = this.splitBillFilter(nestFilter);
                    second = (QFilter)tuple.item2;
                    first.and((QFilter)tuple.item1);
                    continue;
                }
                if ("AND".equals(nest.getOp())) {
                    first.and(nestFilter);
                    continue;
                }
                first.or(nestFilter);
            }
        }
        return new Tuple((Object)first, (Object)second);
    }

    private List<Date> buildDateParams(String exp, Map<String, Date> dateMap) {
        ArrayList<Date> result = new ArrayList<Date>(8);
        while (!exp.isEmpty()) {
            String firstOccurKey = null;
            int firstOccurIndex = exp.length() - 1;
            for (String key : dateMap.keySet()) {
                int index = exp.indexOf(key);
                if (index < 0 || index >= firstOccurIndex) continue;
                firstOccurIndex = index;
                firstOccurKey = key;
            }
            if (firstOccurKey == null) break;
            result.add(dateMap.get(firstOccurKey));
            int nextBeginIndex = firstOccurIndex + firstOccurKey.length();
            if (nextBeginIndex >= exp.length()) break;
            exp = exp.substring(nextBeginIndex);
        }
        return result;
    }

    private QFilter getPeriodFilter(BizDataSourceConfig c) {
        QFilter periodFilter = null;
        if (StringUtils.isNotBlank((CharSequence)c.getPeriodField())) {
            periodFilter = new QFilter(c.getPeriodField(), "=", (Object)this.param.getPeriodid());
        } else if (StringUtils.isNotBlank((CharSequence)c.getBizDateField())) {
            periodFilter = new QFilter(c.getBizDateField(), ">=", (Object)this.period.getDate("begindate")).and(new QFilter(c.getBizDateField(), "<=", (Object)this.period.getDate("enddate")));
        }
        return periodFilter;
    }

    private QFilter getAcctFilter() {
        QFilter acctFilter = null;
        Set bizOrgIds = this.paramModel.getBizOrgIds();
        if (RecAccountBookUtil.getAppConfig().containsKey(this.param.getAppNumber())) {
            AppBookConfig abCfg = (AppBookConfig)DapCache.getAppConfig().get(this.param.getAppNumber());
            if (bizOrgIds != null && bizOrgIds.size() > 0) {
                String billBookField = DapCache.getBillBookField((String)this.param.getEntityKey());
                if (StringUtils.isBlank((CharSequence)billBookField)) {
                    String billBookTypeField = DapCache.getBillBookTypeField((String)this.param.getEntityKey());
                    if (!StringUtils.isBlank((CharSequence)billBookTypeField)) {
                        Map bizBooks = BusinessDataServiceHelper.loadFromCache((String)abCfg.bookEntity, (String)(abCfg.bookEntityOrgField + "," + abCfg.bookEntityTypeField), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)bizOrgIds)});
                        for (DynamicObject bizBook : bizBooks.values()) {
                            QFilter oneBook = new QFilter(this.param.getBizOrgField(), "=", (Object)bizBook.getLong(abCfg.bookEntityOrgField + ".id")).and(new QFilter(billBookTypeField, "=", (Object)bizBook.getLong(abCfg.bookEntityTypeField + ".id")));
                            if (acctFilter == null) {
                                acctFilter = oneBook;
                                continue;
                            }
                            acctFilter = acctFilter.or(oneBook);
                        }
                    }
                } else {
                    acctFilter = new QFilter(billBookField, "in", (Object)bizOrgIds);
                }
            }
        }
        if (acctFilter == null) {
            acctFilter = new QFilter(this.param.getBizOrgField(), "in", (Object)bizOrgIds);
        }
        return acctFilter;
    }

    private void buildEachConfig(SelectedSourceEntity selectedSourceEntity, BizDataSourceConfig cfg, Row row) {
        Map dic = selectedSourceEntity.getFldAlias();
        try {
            Long currencyId = null;
            currencyId = this.paramModel.isLocalCurrency() ? this.paramModel.getCurrency() : row.getLong((String)dic.get(this.param.getCurrencyField()));
            BigDecimal amount = BigDecimal.ZERO;
            try {
                Object amountObj = cfg.getAmountGetHandle().GetVchFldValue(row, dic);
                if (amountObj != null) {
                    amount = new BigDecimal(String.valueOf(amountObj));
                }
            }
            catch (Exception e) {
                logger.error("Get bizAmount failed !");
                throw new KDBizException((Throwable)e, new ErrorCode(String.valueOf(ReconcilationResultEnum.error.getIndex()), e.getMessage()), new Object[0]);
            }
            if (amount == null || amount.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            Map assistIndexMap = this.param.getAssistIndexMap();
            Long[] bizAssistVal = new Long[assistIndexMap.size()];
            boolean needIgnore = false;
            Long id = 0L;
            for (Map.Entry entry : cfg.getDimPropGetHandle().entrySet()) {
                Object idObj = ((SourceFieldGetHandle)entry.getValue()).GetVchFldValue(row, dic);
                if (idObj == null) {
                    if (this.param.isIgnoreEmpty()) {
                        needIgnore = true;
                        break;
                    }
                    id = 0L;
                } else {
                    id = (Long)idObj;
                }
                this.customParamService.fillBizAssistVal(bizAssistVal, this.param.getAssistIndexMap(), (String)entry.getKey(), id);
            }
            if (needIgnore) {
                return;
            }
            for (Map.Entry entry : assistIndexMap.entrySet()) {
                Set idSet = this.dataResult.getNeedQueryBasedata().computeIfAbsent(entry.getKey(), coll -> new HashSet());
                idSet.add(bizAssistVal[(Integer)entry.getValue() - 1]);
            }
            String ruleId = String.valueOf(this.getRuleId());
            if (DataTypeEnum.OnlyStatus == this.param.getDataType() || DataTypeEnum.NotDetail == this.param.getDataType()) {
                Object[] values = new Object[]{ruleId, currencyId, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
                if (AssistTypeEnum.Acct != this.param.getAssistType()) {
                    for (int i = 0; i < bizAssistVal.length; ++i) {
                        values[2 + i] = bizAssistVal[i];
                    }
                }
                values[this.amountIndex] = amount;
                this.dataResult.appendRow(values);
            }
            if (DataTypeEnum.Detail == this.param.getDataType()) {
                if (cfg.getType() != BizDataTypeEnum.Credit && cfg.getType() != BizDataTypeEnum.Debit) {
                    return;
                }
                Long billId = (Long)this.getPropValue(dic, row, this.mainEntityType.getPrimaryKey().getName());
                if (billId == null) {
                    return;
                }
                this.dataResult.getBillIdBitSet().set(billId.longValue());
                String billNo = (String)this.getPropValue(dic, row, "billno");
                Long billOrg = (Long)this.getPropValue(dic, row, this.param.getBizOrgField());
                BizDataTypeEnum type = cfg.getType();
                int bizDc = 0;
                if (BizDataTypeEnum.Debit == type) {
                    bizDc = DetailDcEnum.DEBIT.getValue();
                } else if (BizDataTypeEnum.Credit == type) {
                    bizDc = DetailDcEnum.CREDIT.getValue();
                }
                Object[] values = new Object[]{ruleId, currencyId, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, this.param.getEntityKey(), billId, billNo, bizDc, amount, billOrg};
                for (int i = 0; i < bizAssistVal.length; ++i) {
                    values[2 + i] = bizAssistVal[i];
                }
                this.dataResult.appendRow(values);
            }
        }
        catch (Exception e) {
            logger.error("load data error", (Throwable)e);
            String msg = "entityName: %s\nid: %s\ncfg:%s\n";
            Object errorBillId = this.getPropValue(dic, row, this.mainEntityType.getPrimaryKey().getName());
            msg = String.format(msg, this.mainEntityType.getName(), errorBillId, SerializationUtils.toJsonString((Object)cfg));
            throw new KDBizException((Throwable)e, new ErrorCode(String.valueOf(ReconcilationResultEnum.error.getIndex()), msg), new Object[0]);
        }
    }

    private void compile() {
        HashMap<String, IVariableMode> sourceFields;
        BizDataSourceConfig cfg;
        SingleTaskContext taskContext;
        block19: {
            taskContext = new SingleTaskContext();
            taskContext.setSrcEntityType(this.mainEntityType);
            cfg = this.param.getSourceConfig();
            sourceFields = new HashMap<String, IVariableMode>(16);
            sourceFields.clear();
            if (DataTypeEnum.Detail == this.param.getDataType()) {
                SourceBillFieldMode pkVar = new SourceBillFieldMode(this.mainEntityType.getPrimaryKey().getName(), new String[]{this.mainEntityType.getPrimaryKey().getName()}, (IDataEntityProperty)this.mainEntityType.getPrimaryKey());
                BuildHelper.AddVarToFldList(this.DETAIL_SELECT_FIELDS, (IVariableMode)pkVar);
                DynamicProperty BillNoProperty = this.mainEntityType.getProperty("billno");
                if (BillNoProperty != null) {
                    SourceBillFieldMode billNoVar = new SourceBillFieldMode("billno", new String[]{"billno"}, (IDataEntityProperty)BillNoProperty);
                    BuildHelper.AddVarToFldList(this.DETAIL_SELECT_FIELDS, (IVariableMode)billNoVar);
                }
                this.bizOrgGetHandle = new SourceFieldGetHandle((ISingleTaskContext)taskContext, this.param.getBizOrgField(), null);
                this.bizOrgGetHandle.Compile();
                BuildHelper.AddVarsToFldList(this.DETAIL_SELECT_FIELDS, (List)this.bizOrgGetHandle.getVars());
                this.customParamService.addSpecialFieldToFldList(this.paramModel.getCustomParam(), cfg, (ISingleTaskContext)taskContext, sourceFields, this.DETAIL_SELECT_FIELDS);
            }
            this.functionEnable = FaBillParamUtils.getBooleanValue((Long)0L, (String)"frm_function_enable");
            Integer minSize = FaBillParamUtils.getIntegerValue((Long)0L, (String)"frm_pktable_minsize");
            this.pkTableMinSize = minSize == null ? 2000 : minSize;
            String expression = null;
            if (cfg.getBillFilter() != null) {
                List rows;
                FilterCondition filters;
                if (this.previewMode) {
                    logger.info("getBizId_condition:{}", (Object)SerializationUtils.toJsonString((Object)cfg.getBillFilter()));
                }
                if ((filters = cfg.getBillFilter().getFilterCondition()) != null && (rows = filters.getFilterRow()) != null) {
                    String fieldName = null;
                    IDataEntityProperty prop = null;
                    for (SimpleFilterRow simpleFilterRow : rows) {
                        if (simpleFilterRow == null) continue;
                        fieldName = simpleFilterRow.getFieldName();
                        String[] names = fieldName.split("\\.");
                        prop = this.mainEntityType.findProperty(fieldName = names[0]);
                        if (prop == null) continue;
                        fieldName = CommonFilterAnalyseUtil.getFieldName(prop.getParent(), this.mainEntityType.getName(), fieldName);
                        StringBuilder fieldNameBuilder = new StringBuilder(fieldName);
                        for (int i = 1; i < names.length; ++i) {
                            fieldNameBuilder.append('.');
                            fieldNameBuilder.append((String)names[i]);
                        }
                        simpleFilterRow.setFieldName(fieldNameBuilder.toString());
                    }
                }
                if ((expression = cfg.getBillFilter().buildFullFormula(this.mainEntityType)) != null && expression.contains("bigdata[")) {
                    this.isBigData = Boolean.TRUE;
                }
                try {
                    cfg.getBillFilters().add(SerializationUtils.deSerializeFromBase64((String)expression));
                }
                catch (Throwable e) {
                    if (!StringUtils.isNotBlank((CharSequence)expression)) break block19;
                    if (expression.contains("balanceperiod(")) {
                        this.needSplitPeriodMap.put(cfg.getRuleEntryId(), Boolean.TRUE);
                        expression = CommonFilterAnalyseUtil.dealSplitPeriodFilter(expression, this.period.getInt("periodyear"), this.period.getInt("periodnumber"));
                    }
                    long taskId = this.previewMode ? 0L : this.paramModel.getTaskInfo().getId();
                    String batchNo = this.previewMode ? "0" : this.paramModel.getTaskInfo().getBatchNo();
                    List<String> list = CommonFilterAnalyseUtil.dealLeafFormular(cfg, expression, this.param, this.previewMode, String.valueOf(taskId), batchNo, this.pkTableMinSize, this.functionEnable, this.paramModel);
                    if (list == null || list.size() <= 0) break block19;
                    for (String currentExpression : list) {
                        cfg.getBillFilters().add(this.dealConFormular(currentExpression, cfg.getRuleEntryId(), cfg.getType()));
                    }
                }
            }
        }
        Map dimPropMap = cfg.getDimPropMap();
        for (Map.Entry entry : dimPropMap.entrySet()) {
            SourceFieldGetHandle dimGetHandle = new SourceFieldGetHandle((ISingleTaskContext)taskContext, (String)entry.getValue(), null);
            dimGetHandle.Compile();
            BuildHelper.AddVarsToFldList(sourceFields, (List)dimGetHandle.getVars());
            cfg.getDimPropGetHandle().put(entry.getKey(), dimGetHandle);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.param.getCurrencyField())) {
            SourceFieldGetHandle dimGetHandle = new SourceFieldGetHandle((ISingleTaskContext)taskContext, this.param.getCurrencyField(), null);
            dimGetHandle.Compile();
            BuildHelper.AddVarsToFldList(sourceFields, (List)dimGetHandle.getVars());
        }
        AmountGetHandle amountHandle = new AmountGetHandle((ISingleTaskContext)taskContext, cfg.getAmountExp());
        cfg.setAmountGetHandle(amountHandle);
        amountHandle.Compile();
        BuildHelper.AddVarsToFldList(sourceFields, (List)amountHandle.getVars());
        HashMap amountFlds = new HashMap(amountHandle.getVars().size(), 1.0f);
        BuildHelper.AddVarsToFldList(amountFlds, (List)amountHandle.getVars());
        EntityType entity1 = null;
        for (Map.Entry entry : amountFlds.entrySet()) {
            IVariableMode var = (IVariableMode)entry.getValue();
            EntityType entity2 = null;
            if (var instanceof SourceBillFieldMode) {
                entity2 = (EntityType)((SourceBillFieldMode)var).getSourceField().getParent();
            }
            entity1 = BuildHelper.ComparerEntity(entity1, entity2);
        }
        if (entity1 == null) {
            String bizObj = EntityMetadataCache.getDataEntityType((String)this.param.getEntityKey()).getDisplayName().getLocaleValue();
            String string = cfg.getType().getName();
            String error = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e3a[%1$s]\uff0c\u53d6\u503c\u7c7b\u578b\u4e3a[%2$s]\uff0c\u5206\u5f55id\u4e3a[%3$s]\u7684\u53d6\u6570\u89c4\u5219\u7684\u91d1\u989d\u53d6\u503c\u516c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u586b\u5199", (String)"AbstractReconciliationService_1", (String)"fi-frm-mservice", (Object[])new Object[0]), bizObj, string, cfg.getRuleEntryId());
            throw new KDBizException(new ErrorCode(String.valueOf(ReconcilationResultEnum.error.getIndex()), error), new Object[0]);
        }
        cfg.setSelectedSourceEntity(entity1);
        cfg.getSelectedEntityKeys().add(this.mainEntityType.getName());
        if (entity1 instanceof SubEntryType) {
            cfg.getSelectedEntityKeys().add(entity1.getParent().getName());
        }
        if (entity1 != null) {
            BuildHelper.AddRange((HashSet)cfg.getSelectedEntityKeys(), (String)entity1.getName());
        }
        this.selectedSourceEntity.setEntityType(cfg.getSelectedSourceEntity());
        this.AddVarsToFldList(this.selectedSourceEntity.getSelectedFields(), this.DETAIL_SELECT_FIELDS);
        this.AddVarsToFldList(this.selectedSourceEntity.getSelectedFields(), sourceFields);
        this.BuildSelectString(this.selectedSourceEntity);
    }

    private void AddVarsToFldList(Map<String, SourceBillFieldMode> selectedFields, Map<String, IVariableMode> vars) {
        for (Map.Entry<String, IVariableMode> varItem : vars.entrySet()) {
            if (!(varItem.getValue() instanceof SourceBillFieldMode)) continue;
            selectedFields.put(varItem.getKey(), (SourceBillFieldMode)varItem.getValue());
        }
    }

    private void BuildSelectString(SelectedSourceEntity selectedSourceEntity) {
        ArrayList<Object> selectFldStrings = new ArrayList<Object>(selectedSourceEntity.getSelectedFields().size());
        int fldIndex = 0;
        if (DataTypeEnum.Detail == this.paramModel.getDataType()) {
            String pkPropName = this.mainEntityType.getPrimaryKey().getName();
            if (!selectedSourceEntity.getFldAlias().containsKey(pkPropName)) {
                selectedSourceEntity.getFldAlias().put(pkPropName, pkPropName);
                selectFldStrings.add(pkPropName);
                ++fldIndex;
            }
            String string = selectedSourceEntity.getEntryPKPropName();
            if (!selectedSourceEntity.getFldAlias().containsKey(string)) {
                String alias = "f" + fldIndex;
                selectedSourceEntity.getFldAlias().put(string, alias);
                if (selectedSourceEntity.getEntityType() instanceof SubEntryType) {
                    selectFldStrings.add(selectedSourceEntity.getEntityType().getParent().getName() + "." + string + " " + alias);
                } else {
                    selectFldStrings.add(string + " " + alias);
                }
                ++fldIndex;
            }
        }
        for (Map.Entry entry : selectedSourceEntity.getSelectedFields().entrySet()) {
            SourceBillFieldMode fldMode = (SourceBillFieldMode)entry.getValue();
            String var = fldMode.getVar();
            if (selectedSourceEntity.getFldAlias().containsKey(var)) continue;
            String fldAlias = "f" + fldIndex;
            String selectFldString = fldMode.getFullPropName() + " " + fldAlias;
            selectFldStrings.add(selectFldString);
            selectedSourceEntity.getFldAlias().put(var, fldAlias);
            ++fldIndex;
        }
        String selectString = StringUtils.join((Object[])selectFldStrings.toArray(new Object[selectFldStrings.size()]), (String)",");
        selectedSourceEntity.setSelectString(selectString);
    }

    private Object getPropValue(Map<String, String> fldProperties, Row row, String propName) {
        String prop = fldProperties.get(propName);
        if (prop != null) {
            return row.get(prop);
        }
        return null;
    }

    public boolean hasResult() {
        return this.dataResult.getDataSize() > 0;
    }

    public BizDataResult getDataResult() {
        return this.dataResult;
    }

    public DataSet getBizDataSet() {
        DataSet firstSumDataSet = this.dataResult.getDataSetBuilder().build();
        if (DataTypeEnum.OnlyStatus == this.param.getDataType() || DataTypeEnum.NotDetail == this.param.getDataType()) {
            firstSumDataSet = firstSumDataSet.groupBy(new String[]{"rule", "currency", "assist1_app", "assist2_app", "assist3_app", "assist4_app", "assist5_app", "assist6_app", "assist7_app", "assist8_app"}).sum("openingbalance_app").sum("debitamount_app").sum("creditamount_app").sum("closingbalance_app").finish();
        }
        return firstSumDataSet;
    }

    public String getCacheDataSetId() {
        CacheHint cacheHint = new CacheHint();
        cacheHint.setPageSize(ConfigurationUtil.getInteger((String)"bos.billlist.pagesize", (Integer)100000).intValue());
        int timeout = 7200;
        cacheHint.setTimeout((long)timeout, TimeUnit.SECONDS);
        DataSet bizDataSet = this.getBizDataSet();
        return bizDataSet.cache(cacheHint).getCacheId();
    }

    public Long getRuleId() {
        return this.param.getSourceConfig().getRuleEntryId();
    }

    public Long getAmountTypeId() {
        return this.param.getSourceConfig().getAmountTypeID();
    }

    public BizDataParam getParam() {
        return this.param;
    }
}

