/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.bizdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.orm.query.QFilter;
import kd.fi.frm.common.builder.ISingleTaskContext;
import kd.fi.frm.common.builder.SingleTaskContext;
import kd.fi.frm.common.builder.getvaluehandle.AmountGetHandle;
import kd.fi.frm.common.builder.getvaluemode.IVariableMode;

public class BizDataServicePreviewHandler {
    private QFilter[] originalFilters;
    private BillEntityType billEntityType;
    private _ColumnManager columnManager;
    private String amountExpr;
    private QFilter diffFilter;
    private List<List<Object>> dataLst = new ArrayList<List<Object>>();
    private int queryTop = 1000;
    private Set<String> dimPropNames;
    private boolean needFilterByAssistGroup;
    private DataSet assistGroupDataSet;
    private List<QFilter[]> allExecFilters = new ArrayList<QFilter[]>(1);

    private void analyzePropertyName(_ColumnManager columnManager, BillEntityType billEntityType, String propertyName) {
        StringJoiner propNamejoiner = new StringJoiner(".");
        StringJoiner displayNamejoiner = new StringJoiner(".");
        if (propertyName.contains(".")) {
            String[] split = propertyName.split("\\.");
            BillEntityType _entityType = billEntityType;
            for (int i = 0; i < split.length - 1; ++i) {
                String _propName = split[i];
                if (_entityType == null) break;
                DynamicProperty _property = this.getProperty((EntityType)_entityType, _propName, propNamejoiner, displayNamejoiner);
                if (_property == null) {
                    String errMsg = String.format("Property not found. billEntityType: %s, propertyName: %s, index: %s, _propName: %s", billEntityType.getName(), propertyName, i, _propName);
                    throw new KDBizException(errMsg);
                }
                propNamejoiner.add(_propName);
                displayNamejoiner.add(_property.getDisplayName().getLocaleValue());
                if (_property instanceof EntryProp) {
                    _entityType = (EntryType)((EntryProp)_property).getDynamicCollectionItemPropertyType();
                    continue;
                }
                if (_property instanceof ItemClassProp) {
                    _entityType = null;
                    continue;
                }
                if (!(_property instanceof BasedataProp)) continue;
                _entityType = (BillEntityType)((BasedataProp)_property).getComplexType();
            }
            if (_entityType == null) {
                return;
            }
            String propNamePrefix = propNamejoiner.toString() + ".";
            String displayNamePrefix = displayNamejoiner.toString() + ".";
            propertyName = split[split.length - 1];
            DynamicProperty property = _entityType.getProperty(propertyName);
            if (property == null) {
                _entityType = EntityMetadataCache.getDataEntityType((String)_entityType.getName());
                property = _entityType.getProperty(propertyName);
            }
            columnManager.addProp(propNamePrefix, displayNamePrefix, property);
        } else {
            DynamicProperty property = this.getProperty((EntityType)billEntityType, propertyName, propNamejoiner, displayNamejoiner);
            if (property == null) {
                String errMsg = String.format("Property not found. billEntityType: %s, propertyName: %s", billEntityType.getName(), propertyName);
                throw new KDBizException(errMsg);
            }
            String propNamePrefix = "";
            String displayNamePrefix = "";
            if (propNamejoiner.length() > 0) {
                propNamePrefix = propNamejoiner.toString() + ".";
                displayNamePrefix = displayNamejoiner.toString() + ".";
            }
            columnManager.addProp(propNamePrefix, displayNamePrefix, property);
        }
    }

    private DynamicProperty getProperty(EntityType entityType, String propertyName, StringJoiner propNamejoiner, StringJoiner displayNamejoiner) {
        if (entityType == null) {
            return null;
        }
        DynamicProperty _property = entityType.getProperty(propertyName);
        if (_property == null && entityType instanceof BillEntityType) {
            if (_property == null) {
                entityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityType.getName());
                _property = entityType.getProperty(propertyName);
            }
            if (_property == null) {
                List entryTypeLst = ((BillEntityType)entityType).getAllEntities().values().stream().filter(v -> v instanceof EntryType).collect(Collectors.toList());
                for (EntityType entryType : entryTypeLst) {
                    if (entryType.getProperty(propertyName) == null) continue;
                    _property = entryType.getProperty(propertyName);
                    if (entryType instanceof SubEntryType) {
                        IDataEntityType parent = entryType.getParent();
                        propNamejoiner.add(parent.getName());
                        displayNamejoiner.add(parent.getDisplayName().getLocaleValue());
                    }
                    propNamejoiner.add(entryType.getName());
                    displayNamejoiner.add(entryType.getDisplayName().getLocaleValue());
                    break;
                }
            }
        }
        return _property;
    }

    private String convertColumnKey(String columnKey) {
        return columnKey.replace(".", "\u00b7");
    }

    private String obj2Str(Object o) {
        return o != null ? o.toString() : "";
    }

    public BizDataServicePreviewHandler(String entityName, String amountExpr) {
        this.billEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityName);
        this.columnManager = new _ColumnManager(this.billEntityType);
        this.amountExpr = amountExpr;
    }

    public void setOriginalFilters(QFilter[] filters) {
        this.originalFilters = filters;
    }

    public String getSelectString() {
        ArrayList<QFilter> filterLst = new ArrayList<QFilter>(this.originalFilters.length + 5);
        for (QFilter qFilter : this.originalFilters) {
            filterLst.add(qFilter);
            List nests = qFilter.getNests(true);
            for (QFilter.QFilterNest nest : nests) {
                filterLst.add(nest.getFilter());
            }
        }
        for (QFilter qFilter : filterLst) {
            this.analyzePropertyName(this.columnManager, this.billEntityType, qFilter.getProperty());
            if (!qFilter.isExpressValue()) continue;
            String[] extractVariables = FormulaEngine.extractVariables((String)((String)qFilter.getValue()));
            for (String var : extractVariables) {
                this.analyzePropertyName(this.columnManager, this.billEntityType, var);
            }
        }
        SingleTaskContext taskContext = new SingleTaskContext();
        taskContext.setSrcEntityType((MainEntityType)this.billEntityType);
        AmountGetHandle amountHandle = new AmountGetHandle((ISingleTaskContext)taskContext, this.amountExpr);
        amountHandle.Compile();
        List vars = amountHandle.getVars();
        for (IVariableMode var : vars) {
            this.analyzePropertyName(this.columnManager, this.billEntityType, var.getVar());
        }
        for (String dimPropName : this.dimPropNames) {
            this.analyzePropertyName(this.columnManager, this.billEntityType, dimPropName);
        }
        return this.columnManager.getSelectFields();
    }

    public QFilter[] getQueryFilter() {
        if (this.diffFilter == null) {
            ArrayList<QFilter> filterLst = new ArrayList<QFilter>();
            filterLst.addAll(Arrays.asList(this.originalFilters));
            return filterLst.toArray(new QFilter[0]);
        }
        return this.diffFilter.toArray();
    }

    public void handleDataSet(DataSet dataSet) {
        int rowIndex = 1 + this.dataLst.size();
        for (Row row : dataSet) {
            ArrayList<Integer> rowData = new ArrayList<Integer>();
            rowData.add(rowIndex);
            rowData.add(rowIndex);
            rowData.addAll(this.columnManager.fieldNameSet.stream().map(v -> this.obj2Str(row.get(v))).collect(Collectors.toList()));
            this.dataLst.add(rowData);
            ++rowIndex;
        }
    }

    public List<List<Object>> getDataLst() {
        return this.dataLst;
    }

    public List<Column> getColumns() {
        return this.columnManager.getColumns();
    }

    public QFilter[] getOriginalFilter() {
        return this.originalFilters;
    }

    public void setQueryTop(int queryTop) {
        this.queryTop = queryTop;
    }

    public int getQueryTop() {
        return this.queryTop;
    }

    public void setDiffFilter(QFilter diffFilter) {
        this.diffFilter = diffFilter;
    }

    public void setDimPropMap(Map<String, Set<String>> dimPropMap) {
        this.dimPropNames = dimPropMap.values().stream().flatMap(v -> v.stream()).collect(Collectors.toSet());
    }

    public boolean isNeedFilterByAssistGroup() {
        return this.needFilterByAssistGroup;
    }

    public void setNeedFilterByAssistGroup(boolean needFilterByAssistGroup) {
        this.needFilterByAssistGroup = needFilterByAssistGroup;
    }

    public DataSet getAssistGroupDataSet() {
        return this.assistGroupDataSet;
    }

    public void setAssistGroupDataSet(DataSet assistGroupDataSet) {
        this.assistGroupDataSet = assistGroupDataSet;
    }

    public void appendExecFilter(QFilter[] filters) {
        this.allExecFilters.add(filters);
    }

    public List<QFilter[]> getAllExecFilters() {
        return this.allExecFilters;
    }

    public static class Column {
        public final String name;
        public final LocaleString displayName;

        private Column(String name, LocaleString displayName) {
            this.name = name;
            this.displayName = displayName;
        }
    }

    private class _ColumnManager {
        LinkedHashSet<String> fieldNameSet = new LinkedHashSet();
        LinkedHashSet<LocaleString> fieldDisplayNameSet = new LinkedHashSet();

        public _ColumnManager(BillEntityType billEntityType) {
            DynamicProperty noProp;
            this.fieldNameSet.add(billEntityType.getPrimaryKey().getName());
            this.fieldDisplayNameSet.add(new LocaleString(billEntityType.getPrimaryKey().getName()));
            String billNoPropName = billEntityType.getBillNo();
            if (StringUtils.isEmpty((CharSequence)billNoPropName) && (noProp = billEntityType.getProperty("billno")) != null) {
                billNoPropName = noProp.getName();
            }
            if (StringUtils.isNotEmpty((CharSequence)billNoPropName)) {
                this.fieldNameSet.add(billNoPropName);
                this.fieldDisplayNameSet.add(billEntityType.getProperty(billNoPropName).getDisplayName());
            }
        }

        public List<Column> getColumns() {
            ArrayList<Column> lst = new ArrayList<Column>(this.fieldNameSet.size());
            int i = 0;
            ArrayList<LocaleString> fieldDisplayNameLst = new ArrayList<LocaleString>(this.fieldDisplayNameSet);
            for (String fieldName : this.fieldNameSet) {
                lst.add(new Column(BizDataServicePreviewHandler.this.convertColumnKey(fieldName), (LocaleString)fieldDisplayNameLst.get(i)));
                ++i;
            }
            return lst;
        }

        public String getSelectFields() {
            return String.join((CharSequence)",", this.fieldNameSet);
        }

        public void addProp(String propNamePrefix, String displayNamePrefix, DynamicProperty property) {
            if (property instanceof BasedataProp) {
                BasedataEntityType bdType = (BasedataEntityType)((BasedataProp)property).getComplexType();
                DynamicProperty bdNumberProp = bdType.getProperty(bdType.getNumberProperty());
                DynamicProperty bdNameProp = bdType.getProperty(bdType.getNameProperty());
                this.fieldNameSet.add(propNamePrefix + property.getName() + ".id");
                this.fieldDisplayNameSet.add(new LocaleString(displayNamePrefix + property.getDisplayName() + ".id"));
                this.fieldNameSet.add(propNamePrefix + property.getName() + "." + bdNumberProp.getName());
                this.fieldDisplayNameSet.add(new LocaleString(displayNamePrefix + property.getDisplayName() + "." + bdNumberProp.getDisplayName()));
                this.fieldNameSet.add(propNamePrefix + property.getName() + "." + bdNameProp.getName());
                this.fieldDisplayNameSet.add(new LocaleString(displayNamePrefix + property.getDisplayName() + "." + bdNameProp.getDisplayName()));
            } else {
                this.fieldNameSet.add(propNamePrefix + property.getName());
                this.fieldDisplayNameSet.add(new LocaleString(displayNamePrefix + property.getDisplayName()));
            }
        }
    }
}

