/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.bizdata;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.botp.CRCondition;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.model.FrmFunctionModel;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.bizdata.BizDataParam;
import kd.fi.frm.common.model.bizdata.BizDataSourceConfig;
import kd.fi.frm.common.relation.DaptrackerService;
import kd.fi.frm.common.task.TaskInfo;
import kd.fi.frm.common.util.ReconciliationUtil;
import kd.fi.frm.common.util.SystemParamHelper;
import kd.fi.frm.common.util.ThrowableHelper;

public class CommonFilterAnalyseUtil
extends ReconciliationUtil {
    private static final Log logger = LogFactory.getLog(CommonFilterAnalyseUtil.class);
    private static final DBRoute DB_ROUTE_FI = DBRoute.of((String)"fi");
    public static final ThreadPool BIZ_OBJ_THREAD_POOL = ThreadPools.newFixedThreadPool((String)"frm-selectbasedatafrombizobj", (int)4);
    private static final Map<String, String> FRM_FUNC_DESC_MAP = new HashMap<String, String>(5);

    public static List<String> dealLeafFormular(BizDataSourceConfig cfg, String expr, BizDataParam bizDataParam, boolean preview, String taskId, String batchNo, int pkTableMinSize, boolean functionEnable, ReconciliationParamModel paramModel) {
        String msg;
        String entityKey = bizDataParam.getEntityKey();
        long acctOrgID = bizDataParam.getAcctOrgID();
        String splitConfig = SystemParamHelper.getStringSysParam((String)"splitconfig", (long)acctOrgID, null);
        String periodConfig = SystemParamHelper.getStringSysParam((String)"periodcombo", (long)acctOrgID, null);
        if (StringUtils.isNotEmpty((CharSequence)splitConfig) && StringUtils.isNotEmpty((CharSequence)periodConfig)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u5f00\u542f\u57fa\u7840\u8d44\u6599\u8fc7\u6ee4\u5206\u6279\u548c\u57fa\u7840\u8d44\u6599\u67e5\u8be2\u914d\u7f6e\uff0c\u8bf7\u8c03\u6574\u5bf9\u8d26\u7ba1\u7406\u7cfb\u7edf\u53c2\u6570\u3002", (String)"CommonFilterAnalyseUtil_17", (String)"fi-frm-mservice", (Object[])new Object[0]));
        }
        HashMap<String, Integer> splitConfigMap = new HashMap(8);
        if (StringUtils.isNotEmpty((CharSequence)splitConfig)) {
            try {
                splitConfigMap = (Map)SerializationUtils.fromJsonString((String)splitConfig, Map.class);
            }
            catch (Throwable t) {
                logger.error("Serialize splitConfig failed !");
                logger.error(ThrowableHelper.toString((Throwable)t));
                throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5171\u8bbe\u7f6e-\u7cfb\u7edf\u53c2\u6570-\u5e94\u7528-\u5bf9\u8d26\u7ba1\u7406\uff1a\u57fa\u7840\u8d44\u6599\u5206\u6279\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CommonFilterAnalyseUtil_15", (String)"fi-frm-mservice", (Object[])new Object[0]));
            }
        }
        Map functionPkMap = null;
        if (StringUtils.isNotEmpty((CharSequence)periodConfig)) {
            functionPkMap = paramModel.getFunctionPkMap();
        }
        String oldExpr = expr;
        List<String> exprList = null;
        if (expr != null && expr.indexOf("leafid[") > -1) {
            if (preview) {
                msg = String.format(ResManager.loadKDString((String)"1.\u5bf9\u8d26\u53d6\u6570\u89c4\u5219\u5904\u7406leafid\u51fd\u6570:\u67e5\u8be2\u5b9e\u4f53(%1$s\uff0c\u53d6\u503c\u7c7b\u578b\uff1a%2$s\uff0c\u53d6\u6570\u89c4\u5219\u5206\u5f55ID\uff1a%3$s)\uff0c\u5904\u7406\u524d\u8868\u8fbe\u5f0f\u4e3a\uff1a%4$s\uff0c\u5904\u7406\u540e\u8868\u8fbe\u5f0f\u4e3a\uff1a%5$s", (String)"CommonFilterAnalyseUtil_8", (String)"fi-frm-mservice", (Object[])new Object[0]), entityKey, cfg.getType().getName(), cfg.getRuleEntryId(), oldExpr, expr);
                logger.info(msg);
            }
            exprList = CommonFilterAnalyseUtil.dealAllLeafIdFilter(expr, taskId, batchNo, pkTableMinSize, functionEnable, preview, bizDataParam, splitConfigMap, functionPkMap);
            if (StringUtils.isNotEmpty((CharSequence)splitConfig)) {
                return exprList;
            }
            expr = exprList.get(0);
        }
        if (expr != null && expr.indexOf("leaf[") > -1) {
            if (preview) {
                msg = String.format(ResManager.loadKDString((String)"2.\u5bf9\u8d26\u53d6\u6570\u89c4\u5219\u5904\u7406leaf\u51fd\u6570:\u67e5\u8be2\u5b9e\u4f53(%1$s\uff0c\u53d6\u503c\u7c7b\u578b\uff1a%2$s\uff0c\u53d6\u6570\u89c4\u5219\u5206\u5f55ID\uff1a%3$s)\uff0c\u5904\u7406\u524d\u8868\u8fbe\u5f0f\u4e3a\uff1a%4$s\uff0c\u5904\u7406\u540e\u8868\u8fbe\u5f0f\u4e3a\uff1a%5$s", (String)"CommonFilterAnalyseUtil_9", (String)"fi-frm-mservice", (Object[])new Object[0]), entityKey, cfg.getType().getName(), cfg.getRuleEntryId(), oldExpr, expr);
                logger.info(msg);
            }
            exprList = CommonFilterAnalyseUtil.dealAllLeafFilter(expr);
            if (StringUtils.isNotEmpty((CharSequence)splitConfig)) {
                return exprList;
            }
            expr = exprList.get(0);
        }
        if (expr != null && expr.indexOf("getbasedataid[") > -1) {
            if (preview) {
                msg = String.format(ResManager.loadKDString((String)"3.\u5bf9\u8d26\u53d6\u6570\u89c4\u5219\u5904\u7406getBaseDataId\u51fd\u6570:\u67e5\u8be2\u5b9e\u4f53(%1$s\uff0c\u53d6\u503c\u7c7b\u578b\uff1a%2$s\uff0c\u53d6\u6570\u89c4\u5219\u5206\u5f55ID\uff1a%3$s)\uff0c\u5904\u7406\u524d\u8868\u8fbe\u5f0f\u4e3a\uff1a%4$s\uff0c\u5904\u7406\u540e\u8868\u8fbe\u5f0f\u4e3a\uff1a%5$s", (String)"CommonFilterAnalyseUtil_10", (String)"fi-frm-mservice", (Object[])new Object[0]), entityKey, cfg.getType().getName(), cfg.getRuleEntryId(), oldExpr, expr);
                logger.info(msg);
            }
            exprList = CommonFilterAnalyseUtil.dealBaseDataIdFilter(expr, taskId, batchNo, pkTableMinSize, functionEnable, preview, bizDataParam, splitConfigMap, functionPkMap);
            if (StringUtils.isNotEmpty((CharSequence)splitConfig)) {
                return exprList;
            }
            expr = exprList.get(0);
        }
        if (expr != null && expr.indexOf("getbasedata[") > -1) {
            if (preview) {
                msg = String.format(ResManager.loadKDString((String)"4.\u5bf9\u8d26\u53d6\u6570\u89c4\u5219\u5904\u7406getBaseData\u51fd\u6570:\u67e5\u8be2\u5b9e\u4f53(%1$s\uff0c\u53d6\u503c\u7c7b\u578b\uff1a%2$s\uff0c\u53d6\u6570\u89c4\u5219\u5206\u5f55ID\uff1a%3$s)\uff0c\u5904\u7406\u524d\u8868\u8fbe\u5f0f\u4e3a\uff1a%4$s\uff0c\u5904\u7406\u540e\u8868\u8fbe\u5f0f\u4e3a\uff1a%5$s", (String)"CommonFilterAnalyseUtil_11", (String)"fi-frm-mservice", (Object[])new Object[0]), entityKey, cfg.getType().getName(), cfg.getRuleEntryId(), oldExpr, expr);
                logger.info(msg);
            }
            exprList = CommonFilterAnalyseUtil.dealBaseDataFilter(expr);
            if (StringUtils.isNotEmpty((CharSequence)splitConfig)) {
                return exprList;
            }
            expr = exprList.get(0);
        }
        if (expr != null && expr.contains("trim(EMPTY_TO_TEXT(")) {
            expr = CommonFilterAnalyseUtil.dealNullFilter(expr);
            if (preview) {
                msg = String.format(ResManager.loadKDString((String)"5.\u5bf9\u8d26\u53d6\u6570\u89c4\u5219\u5904\u7406empty_to_text\u51fd\u6570:\u67e5\u8be2\u5b9e\u4f53(%1$s\uff0c\u53d6\u503c\u7c7b\u578b\uff1a%2$s\uff0c\u53d6\u6570\u89c4\u5219\u5206\u5f55ID\uff1a%3$s)\uff0c\u5904\u7406\u524d\u8868\u8fbe\u5f0f\u4e3a\uff1a%4$s\uff0c\u5904\u7406\u540e\u8868\u8fbe\u5f0f\u4e3a\uff1a%5$s", (String)"CommonFilterAnalyseUtil_12", (String)"fi-frm-mservice", (Object[])new Object[0]), entityKey, cfg.getType().getName(), cfg.getRuleEntryId(), oldExpr, expr);
                logger.info(msg);
            }
            ArrayList<String> expressions = new ArrayList<String>(1);
            expressions.add(expr);
            return expressions;
        }
        if (expr != null && expr.contains("'getassistantdataid[")) {
            if (preview) {
                msg = String.format(ResManager.loadKDString((String)"6.\u5bf9\u8d26\u53d6\u6570\u89c4\u5219\u5904\u7406getassistantdataid\u51fd\u6570:\u67e5\u8be2\u5b9e\u4f53(%1$s\uff0c\u53d6\u503c\u7c7b\u578b\uff1a%2$s\uff0c\u53d6\u6570\u89c4\u5219\u5206\u5f55ID\uff1a%3$s)\uff0c\u5904\u7406\u524d\u8868\u8fbe\u5f0f\u4e3a\uff1a%4$s\uff0c\u5904\u7406\u540e\u8868\u8fbe\u5f0f\u4e3a\uff1a%5$s", (String)"CommonFilterAnalyseUtil_13", (String)"fi-frm-mservice", (Object[])new Object[0]), entityKey, cfg.getType().getName(), cfg.getRuleEntryId(), oldExpr, expr);
                logger.info(msg);
            }
            exprList = CommonFilterAnalyseUtil.dealAssistantDataIdFilter(expr, splitConfigMap);
            if (StringUtils.isNotEmpty((CharSequence)splitConfig)) {
                return exprList;
            }
            expr = exprList.get(0);
        }
        if (expr != null && expr.contains("'getbasedataidbyassistant[")) {
            if (preview) {
                msg = String.format(ResManager.loadKDString((String)"7.\u5bf9\u8d26\u53d6\u6570\u89c4\u5219\u5904\u7406getbasedataidbyassistant\u51fd\u6570:\u67e5\u8be2\u5b9e\u4f53(%1$s\uff0c\u53d6\u503c\u7c7b\u578b\uff1a%2$s\uff0c\u53d6\u6570\u89c4\u5219\u5206\u5f55ID\uff1a%3$s)\uff0c\u5904\u7406\u524d\u8868\u8fbe\u5f0f\u4e3a\uff1a%4$s\uff0c\u5904\u7406\u540e\u8868\u8fbe\u5f0f\u4e3a\uff1a%5$s", (String)"CommonFilterAnalyseUtil_14", (String)"fi-frm-mservice", (Object[])new Object[0]), entityKey, cfg.getType().getName(), cfg.getRuleEntryId(), oldExpr, expr);
                logger.info(msg);
            }
            exprList = CommonFilterAnalyseUtil.dealBaseDataIdByAssistantFilter(expr, taskId, batchNo, pkTableMinSize, functionEnable, preview, bizDataParam, splitConfigMap, functionPkMap);
            if (StringUtils.isNotEmpty((CharSequence)splitConfig)) {
                return exprList;
            }
            expr = exprList.get(0);
        }
        if (exprList == null) {
            exprList = new ArrayList<String>(1);
            exprList.add(expr);
        }
        return exprList;
    }

    private static List<String> dealBaseDataIdByAssistantFilter(String expr, String taskId, String batchNo, int pkTableMinSize, boolean functionEnable, boolean preview, BizDataParam bizDataParam, Map<String, Integer> splitConfigMap, Map<String, Set<Object>> functionPkMap) {
        int index = 0;
        HashMap<Integer, String> indexFieldMap = new HashMap<Integer, String>(4);
        CommonFilterAnalyseUtil.getFunctionFieldByPrefix(expr, indexFieldMap, index, "getbasedataidbyassistant[");
        List paramSet = CommonFilterAnalyseUtil.resolveExpression((String)expr, (String)"(?<=getbasedataidbyassistant\\[)(.+?)(?=\\])");
        boolean singleFunction = paramSet.size() == 1;
        Iterator iter = paramSet.iterator();
        ArrayList<String> expressions = new ArrayList<String>(16);
        index = 0;
        while (iter.hasNext()) {
            List<String> replacements;
            String resolveExres = (String)iter.next();
            String[] childs = StringUtils.split((String)resolveExres, (String)",");
            childs[0] = CommonFilterAnalyseUtil.shapeExpPart(childs[0]);
            childs[1] = CommonFilterAnalyseUtil.shapeExpPart(childs[1]);
            childs[2] = CommonFilterAnalyseUtil.shapeExpPart(childs[2]);
            childs[3] = CommonFilterAnalyseUtil.shapeExpPart(childs[3]);
            String assistantFilterField = childs[3];
            HashSet<String> assistantFilterValues = new HashSet<String>(childs.length - 1);
            for (int i = 4; i < childs.length; ++i) {
                assistantFilterValues.add(CommonFilterAnalyseUtil.shapeExpPart(childs[i]));
            }
            QFilter filter = new QFilter(assistantFilterField, "in", assistantFilterValues);
            QFilter groupFilter = new QFilter("group.number", "=", (Object)childs[2]);
            filter = filter.and(groupFilter);
            QFilter pkFilter = CommonFilterAnalyseUtil.getPkFilter(bizDataParam, functionPkMap, (String)indexFieldMap.get(index));
            if (!functionEnable || preview) {
                List<Object> assistantIdList = CommonFilterAnalyseUtil.getAssistantIdList(childs[0], filter, childs[1], pkFilter);
                boolean split = splitConfigMap.get(childs[0]) != null && splitConfigMap.get(childs[0]) > 0 && singleFunction;
                replacements = CommonFilterAnalyseUtil.getBaseDataIdReplacement(assistantIdList, split, splitConfigMap.get(childs[0]));
                expr = expr.contains("'getbasedataidbyassistant[") ? expr.replace("'getbasedataidbyassistant[" + resolveExres + "]'", replacements.get(0)) : expr.replace("getbasedataidbyassistant[" + resolveExres + "]'", replacements.get(0));
            } else {
                FrmFunctionModel functionModel = new FrmFunctionModel();
                functionModel.setType("getbasedataidbyassistant");
                functionModel.setParam1(childs[0]);
                functionModel.setParam2(childs[1]);
                functionModel.setParam3(childs[2]);
                functionModel.setParam4(childs[3]);
                functionModel.setParam5(Arrays.toString(assistantFilterValues.toArray()));
                functionModel.setEnable(Boolean.TRUE.booleanValue());
                String functionStr = "getbasedataidbyassistant" + childs[0] + childs[1] + childs[2] + childs[3] + Arrays.toString(assistantFilterValues.toArray());
                String replacement = CommonFilterAnalyseUtil.getReplacement(functionStr, childs[0], filter, childs[1], taskId, batchNo, functionModel, pkTableMinSize, bizDataParam.getAppNumber());
                replacements = new ArrayList<String>(1);
                replacements.add(replacement);
                if (expr.contains("'getbasedataidbyassistant[")) {
                    for (String tmpReplacement : replacements) {
                        expressions.add(expr.replace("'getbasedataidbyassistant[" + resolveExres + "]'", tmpReplacement));
                    }
                } else {
                    for (String tmpReplacement : replacements) {
                        expressions.add(expr.replace("getbasedataidbyassistant[" + resolveExres + "]", tmpReplacement));
                    }
                }
            }
            ++index;
        }
        if (expressions.size() == 0) {
            expressions.add(expr);
        }
        return expressions;
    }

    private static QFilter getPkFilter(BizDataParam bizDataParam, Map<String, Set<Object>> functionPkMap, String field) {
        if (bizDataParam == null || bizDataParam.getSourceConfig() == null) {
            return QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        }
        String identification = bizDataParam.getEntityKey() + "," + bizDataParam.getSourceConfig().getCommonFilterId() + "," + field;
        if (functionPkMap != null && functionPkMap.get(identification) != null) {
            return new QFilter("id", "in", functionPkMap.get(identification));
        }
        return QFilter.of((String)"1 = 1", (Object[])new Object[0]);
    }

    private static List<String> dealAssistantDataIdFilter(String expr, Map<String, Integer> splitConfigMap) {
        List paramSet = CommonFilterAnalyseUtil.resolveExpression((String)expr, (String)"(?<=getassistantdataid\\[)(.+?)(?=\\])");
        boolean singleFunction = paramSet.size() == 1;
        Iterator iter = paramSet.iterator();
        ArrayList<String> expressions = new ArrayList<String>(16);
        while (iter.hasNext()) {
            String resolveExres = (String)iter.next();
            String[] childs = StringUtils.split((String)resolveExres, (String)",");
            HashSet<String> numbers = new HashSet<String>(childs.length - 1);
            for (int i = 2; i < childs.length; ++i) {
                numbers.add(CommonFilterAnalyseUtil.shapeExpPart(childs[i]));
            }
            QFilter filter = new QFilter(childs[1], "in", numbers);
            childs[0] = CommonFilterAnalyseUtil.shapeExpPart(childs[0]);
            QFilter groupFilter = new QFilter("group.number", "=", (Object)childs[0]);
            List ids = QueryServiceHelper.queryPrimaryKeys((String)"bos_assistantdata_detail", (QFilter[])new QFilter[]{groupFilter, filter}, null, (int)-1);
            if (ids.size() == 0) {
                ids.add(129348576L);
            }
            boolean split = splitConfigMap.get(childs[0]) != null && splitConfigMap.get(childs[0]) > 0 && singleFunction;
            List<String> replacements = CommonFilterAnalyseUtil.getBaseDataIdReplacement(ids, split, splitConfigMap.get(childs[0]));
            if (expr.contains("'getassistantdataid[")) {
                for (String replacement : replacements) {
                    expressions.add(expr.replace("'getassistantdataid[" + resolveExres + "]'", replacement));
                }
                continue;
            }
            for (String replacement : replacements) {
                expressions.add(expr.replace("getassistantdataid[" + resolveExres + "]", replacement));
            }
        }
        return expressions;
    }

    private static String shapeExpPart(String expPart) {
        if (expPart.contains("'")) {
            expPart = expPart.replaceAll("'", "");
        }
        expPart = expPart.trim();
        return expPart;
    }

    private static String dealNullFilter(String expression) {
        List paramSet = CommonFilterAnalyseUtil.resolveExpression((String)expression, (String)"(?<=trim\\(EMPTY_TO_TEXT\\()(.+?)(?=\\)\\))");
        for (String resolveExpression : paramSet) {
            String[] children = StringUtils.split((String)resolveExpression, (String)",");
            String isNullText = "trim(EMPTY_TO_TEXT(" + resolveExpression + ")) = ''";
            String isNotNullText = "trim(EMPTY_TO_TEXT(" + resolveExpression + ")) != ''";
            if (expression.contains(isNullText)) {
                expression = expression.replace(isNullText, children[0] + " = ' '");
                continue;
            }
            if (!expression.contains(isNotNullText)) continue;
            expression = expression.replace(isNotNullText, children[0] + " != ' '");
        }
        return expression;
    }

    private static List<String> dealAllLeafFilter(String expression) {
        List paramSet = CommonFilterAnalyseUtil.resolveExpression((String)expression, (String)"(?<=leaf\\[)(.+?)(?=\\])");
        Iterator iter = paramSet.iterator();
        while (iter != null && iter.hasNext()) {
            String resolveExres = (String)iter.next();
            String[] childs = StringUtils.split((String)resolveExres, (String)",");
            HashSet<String> numbers = new HashSet<String>(childs.length - 1);
            for (int i = 1; i < childs.length; ++i) {
                numbers.add(CommonFilterAnalyseUtil.shapeExpPart(childs[i]));
            }
            QFilter filter = new QFilter("number", "in", numbers);
            childs[0] = CommonFilterAnalyseUtil.shapeExpPart(childs[0]);
            List ids = QueryServiceHelper.queryPrimaryKeys((String)childs[0], (QFilter[])new QFilter[]{filter}, null, (int)-1);
            HashSet<Long> parentIds = new HashSet<Long>(ids.size());
            for (Object id : ids) {
                parentIds.add(Long.parseLong(id.toString()));
            }
            Map leafIds = CommonFilterAnalyseUtil.getLeafs((String)childs[0], parentIds);
            HashSet allLeafIds = new HashSet();
            for (Set leaf : leafIds.values()) {
                allLeafIds.addAll(leaf);
            }
            DataSet ds = QueryServiceHelper.queryDataSet((String)"CommonFilterAnalyseUtil", (String)childs[0], (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", allLeafIds)}, null);
            Throwable throwable = null;
            try {
                Row row = null;
                StringBuilder sbRet = new StringBuilder();
                while (ds.hasNext()) {
                    row = ds.next();
                    sbRet.append('\'').append(row.getString("number")).append('\'').append(',');
                }
                if (sbRet.length() > 0) {
                    sbRet.deleteCharAt(sbRet.length() - 1);
                } else {
                    sbRet.append("'0_0'");
                }
                if (expression.contains("'leaf[")) {
                    expression = expression.replace("'leaf[" + resolveExres + "]'", sbRet.toString());
                    continue;
                }
                expression = expression.replace("leaf[" + resolveExres + "]", sbRet.toString());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        ArrayList<String> expressions = new ArrayList<String>(1);
        expressions.add(expression);
        return expressions;
    }

    private static List<String> dealAllLeafIdFilter(String expression, String taskId, String batchNo, int pkTableMinSize, boolean functionEnable, boolean preview, BizDataParam bizDataParam, Map<String, Integer> splitConfigMap, Map<String, Set<Object>> functionPkMap) {
        int index = 0;
        HashMap<Integer, String> indexFieldMap = new HashMap<Integer, String>(4);
        CommonFilterAnalyseUtil.getFunctionFieldByPrefix(expression, indexFieldMap, index, "leafid[");
        List paramSet = CommonFilterAnalyseUtil.resolveExpression((String)expression, (String)"(?<=leafid\\[)(.+?)(?=\\])");
        boolean singleFunction = paramSet.size() == 1;
        Iterator iter = paramSet.iterator();
        ArrayList<String> expressions = new ArrayList<String>(16);
        index = 0;
        while (iter.hasNext()) {
            List<String> replacements;
            String resolveExres = (String)iter.next();
            String[] childs = StringUtils.split((String)resolveExres, (String)",");
            HashSet<String> numbers = new HashSet<String>(childs.length - 1);
            for (int i = 1; i < childs.length; ++i) {
                numbers.add(CommonFilterAnalyseUtil.shapeExpPart(childs[i]));
            }
            QFilter filter = new QFilter("number", "in", numbers);
            childs[0] = CommonFilterAnalyseUtil.shapeExpPart(childs[0]);
            filter = filter.and(CommonFilterAnalyseUtil.getPkFilter(bizDataParam, functionPkMap, (String)indexFieldMap.get(index)));
            if (!functionEnable || preview) {
                List<Object> leafIdList = CommonFilterAnalyseUtil.getLeafIdList(childs[0], filter);
                boolean split = splitConfigMap.get(childs[0]) != null && splitConfigMap.get(childs[0]) > 0 && singleFunction;
                replacements = CommonFilterAnalyseUtil.getBaseDataIdReplacement(leafIdList, split, splitConfigMap.get(childs[0]));
                expression = expression.contains("'leafid[") ? expression.replace("'leafid[" + resolveExres + "]'", replacements.get(0)) : expression.replace("leafid[" + resolveExres + "]", replacements.get(0));
            } else {
                FrmFunctionModel functionModel = new FrmFunctionModel();
                functionModel.setType("leafid");
                functionModel.setParam1(childs[0]);
                functionModel.setParam2(Arrays.toString(numbers.toArray()));
                functionModel.setEnable(Boolean.TRUE.booleanValue());
                String functionStr = "leafid" + childs[0] + Arrays.toString(numbers.toArray());
                String replacement = CommonFilterAnalyseUtil.getReplacement(functionStr, childs[0], filter, null, taskId, batchNo, functionModel, pkTableMinSize, bizDataParam.getAppNumber());
                replacements = new ArrayList<String>(1);
                replacements.add(replacement);
                if (expression.contains("'leafid[")) {
                    for (String tmpReplacement : replacements) {
                        expressions.add(expression.replace("'leafid[" + resolveExres + "]'", tmpReplacement));
                    }
                } else {
                    for (String tmpReplacement : replacements) {
                        expressions.add(expression.replace("leafid[" + resolveExres + "]", tmpReplacement));
                    }
                }
            }
            ++index;
        }
        if (expressions.size() == 0) {
            expressions.add(expression);
        }
        return expressions;
    }

    private static List<String> dealBaseDataIdFilter(String expression, String taskId, String batchNo, int pkTableMinSize, boolean functionEnable, boolean preview, BizDataParam bizDataParam, Map<String, Integer> splitConfigMap, Map<String, Set<Object>> functionPkMap) {
        int index = 0;
        HashMap<Integer, String> indexFieldMap = new HashMap<Integer, String>(4);
        CommonFilterAnalyseUtil.getFunctionFieldByPrefix(expression, indexFieldMap, index, "getbasedataid[");
        List paramSet = CommonFilterAnalyseUtil.resolveExpression((String)expression, (String)"(?<=getbasedataid\\[)(.+?)(?=\\])");
        boolean singleFunction = paramSet.size() == 1;
        Iterator iter = paramSet.iterator();
        ArrayList<String> expressions = new ArrayList<String>(16);
        index = 0;
        while (iter.hasNext()) {
            List<String> replacements;
            String resolveExres = (String)iter.next();
            String[] childs = StringUtils.split((String)resolveExres, (String)",");
            HashSet<String> numbers = new HashSet<String>(childs.length - 1);
            for (int i = 2; i < childs.length; ++i) {
                numbers.add(CommonFilterAnalyseUtil.shapeExpPart(childs[i]));
            }
            childs[1] = CommonFilterAnalyseUtil.shapeExpPart(childs[1]);
            QFilter filter = new QFilter(childs[1], "in", numbers);
            childs[0] = CommonFilterAnalyseUtil.shapeExpPart(childs[0]);
            filter = filter.and(CommonFilterAnalyseUtil.getPkFilter(bizDataParam, functionPkMap, (String)indexFieldMap.get(index)));
            if (!functionEnable || preview) {
                List<Object> baseDataIdList = CommonFilterAnalyseUtil.getBaseDataId(childs[0], filter);
                boolean split = splitConfigMap.get(childs[0]) != null && splitConfigMap.get(childs[0]) > 0 && singleFunction;
                replacements = CommonFilterAnalyseUtil.getBaseDataIdReplacement(baseDataIdList, split, splitConfigMap.get(childs[0]));
                expression = expression.contains("'getbasedataid[") ? expression.replace("'getbasedataid[" + resolveExres + "]'", replacements.get(0)) : expression.replace("getbasedataid[" + resolveExres + "]", replacements.get(0));
            } else {
                FrmFunctionModel functionModel = new FrmFunctionModel();
                functionModel.setType("getbasedataid");
                functionModel.setParam1(childs[0]);
                functionModel.setParam2(childs[1]);
                functionModel.setParam3(Arrays.toString(numbers.toArray()));
                functionModel.setEnable(Boolean.TRUE.booleanValue());
                String functionStr = "getbasedataid" + childs[0] + childs[1] + Arrays.toString(numbers.toArray());
                String replacement = CommonFilterAnalyseUtil.getReplacement(functionStr, childs[0], filter, null, taskId, batchNo, functionModel, pkTableMinSize, bizDataParam.getAppNumber());
                replacements = new ArrayList<String>(1);
                replacements.add(replacement);
                if (expression.contains("'getbasedataid[")) {
                    for (String tmpReplacement : replacements) {
                        expressions.add(expression.replace("'getbasedataid[" + resolveExres + "]'", tmpReplacement));
                    }
                } else {
                    for (String tmpReplacement : replacements) {
                        expressions.add(expression.replace("getbasedataid[" + resolveExres + "]", tmpReplacement));
                    }
                }
            }
            ++index;
        }
        if (expressions.size() == 0) {
            expressions.add(expression);
        }
        return expressions;
    }

    private static List<String> dealBaseDataFilter(String expression) {
        List paramSet = CommonFilterAnalyseUtil.resolveExpression((String)expression, (String)"(?<=getbasedata\\[)(.+?)(?=\\])");
        Iterator iter = paramSet.iterator();
        while (iter != null && iter.hasNext()) {
            String resolveExres = (String)iter.next();
            String[] childs = StringUtils.split((String)resolveExres, (String)",");
            HashSet<String> numbers = new HashSet<String>(childs.length - 1);
            for (int i = 2; i < childs.length; ++i) {
                numbers.add(CommonFilterAnalyseUtil.shapeExpPart(childs[i]));
            }
            childs[0] = CommonFilterAnalyseUtil.shapeExpPart(childs[0]);
            childs[1] = CommonFilterAnalyseUtil.shapeExpPart(childs[1]);
            QFilter filter = new QFilter(childs[1], "in", numbers);
            List ids = QueryServiceHelper.queryPrimaryKeys((String)childs[0], (QFilter[])new QFilter[]{filter}, null, (int)-1);
            DataSet ds = QueryServiceHelper.queryDataSet((String)"CommonFilterAnalyseUtil", (String)childs[0], (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)}, null);
            Throwable throwable = null;
            try {
                Row row = null;
                StringBuilder sbRet = new StringBuilder();
                while (ds.hasNext()) {
                    row = ds.next();
                    sbRet.append('\'').append(row.getString("number")).append('\'').append(',');
                }
                if (sbRet.length() > 0) {
                    sbRet.deleteCharAt(sbRet.length() - 1);
                } else {
                    sbRet.append("'0_0'");
                }
                if (expression.contains("'getbasedata[")) {
                    expression = expression.replace("'getbasedata[" + resolveExres + "]'", sbRet.toString());
                    continue;
                }
                expression = expression.replace("getbasedata[" + resolveExres + "]", sbRet.toString());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        ArrayList<String> expressions = new ArrayList<String>(1);
        expressions.add(expression);
        return expressions;
    }

    public static String dealSplitPeriodFilter(String expression, int periodYear, int periodNumber) {
        List paramSet = CommonFilterAnalyseUtil.resolveExpression((String)expression, (String)"(?<=balanceperiod\\()(.+?)(?=\\))");
        Iterator iter = paramSet.iterator();
        long period = 100L * (long)periodYear + (long)periodNumber;
        while (iter != null && iter.hasNext()) {
            String resolveExres = (String)iter.next();
            String[] childs = StringUtils.split((String)resolveExres, (String)",");
            StringBuilder sbRet = new StringBuilder();
            if ("short_period".equals(childs[2])) {
                sbRet.append(childs[0]).append(" < ").append(period).append(" and ").append(childs[1]).append(" >= ").append(period);
            }
            expression = expression.replace("balanceperiod(" + resolveExres + ")", sbRet.toString());
        }
        return expression;
    }

    public static String digest(String s) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        try {
            byte[] btInput = s.getBytes();
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            return " ";
        }
    }

    private static TaskInfo getTaskInfoCache(String taskId, String batchNo) {
        String taskCache = AppCacheHelper.getTaskCache((String)batchNo, (String)taskId);
        TaskInfo taskInfo = null;
        if (StringUtils.isNotEmpty((CharSequence)taskCache)) {
            taskInfo = (TaskInfo)SerializationUtils.deSerializeFromBase64((String)taskCache);
        }
        return taskInfo;
    }

    private static List<Object> getBaseDataId(String entityKey, QFilter qFilter) {
        List ids = QueryServiceHelper.queryPrimaryKeys((String)entityKey, (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
        if (ids.size() == 0) {
            ids.add(129348576L);
        }
        return ids;
    }

    private static String getMd5FromIdList(List<Object> list) {
        list = list.stream().sorted().collect(Collectors.toList());
        StringBuilder stringBuilder = new StringBuilder();
        for (Object id : list) {
            stringBuilder.append(id).append(",");
        }
        return CommonFilterAnalyseUtil.digest(stringBuilder.toString());
    }

    private static DataSet getFunctionDataSet(FrmFunctionModel functionModel) {
        SqlBuilder sqlSb = new SqlBuilder();
        sqlSb.append("SELECT fid,fmd5 FROM T_FRM_FUNCTION WHERE ", new Object[0]);
        sqlSb.append("ftype = ? ", new Object[]{functionModel.getType()});
        if (StringUtils.isNotEmpty((CharSequence)functionModel.getParam1())) {
            sqlSb.append(" and fparam1 = ? ", new Object[]{functionModel.getParam1()});
        }
        if (StringUtils.isNotEmpty((CharSequence)functionModel.getParam2())) {
            sqlSb.append(" and fparam2 = ? ", new Object[]{functionModel.getParam2()});
        }
        if (StringUtils.isNotEmpty((CharSequence)functionModel.getParam3())) {
            sqlSb.append(" and fparam3 = ? ", new Object[]{functionModel.getParam3()});
        }
        if (StringUtils.isNotEmpty((CharSequence)functionModel.getParam4())) {
            sqlSb.append(" and fparam4 = ? ", new Object[]{functionModel.getParam4()});
        }
        if (StringUtils.isNotEmpty((CharSequence)functionModel.getParam5())) {
            sqlSb.append(" and fparam5 = ? ", new Object[]{functionModel.getParam5()});
        }
        sqlSb.append("and fenable = ?", new Object[]{functionModel.isEnable()});
        return DB.queryDataSet((String)"CommonFilterAnalyseUtil.getFunctionDataSet", (DBRoute)DB_ROUTE_FI, (SqlBuilder)sqlSb);
    }

    private static void saveFunction(FrmFunctionModel functionModel, List<Object> baseDataList, DBRoute pkTableDbRoute) {
        if (pkTableDbRoute.getRouteKey().equalsIgnoreCase(DB_ROUTE_FI.getRouteKey())) {
            CommonFilterAnalyseUtil.saveSameRouteFunction(functionModel, baseDataList, pkTableDbRoute);
        } else {
            CommonFilterAnalyseUtil.saveDiffRouteFunction(functionModel, baseDataList, pkTableDbRoute);
        }
    }

    private static void saveSameRouteFunction(FrmFunctionModel functionModel, List<Object> baseDataList, DBRoute pkTableDbRoute) {
        try (TXHandle ignored = TX.requiresNew();){
            try {
                CommonFilterAnalyseUtil.saveFunctionInfo(functionModel);
                CommonFilterAnalyseUtil.saveDataId(baseDataList, functionModel.getId(), pkTableDbRoute);
            }
            catch (Throwable e) {
                logger.error("Save function error\uff1a", (Object)e.getMessage());
                ignored.markRollback();
                throw e;
            }
        }
    }

    private static void saveDiffRouteFunction(FrmFunctionModel functionModel, List<Object> baseDataList, DBRoute pkTableDbRoute) {
        try (TXHandle functionTx = TX.requiresNew();){
            try {
                CommonFilterAnalyseUtil.saveFunctionInfo(functionModel);
                try (TXHandle pkTableTx = TX.requiresNew();){
                    try {
                        CommonFilterAnalyseUtil.saveDataId(baseDataList, functionModel.getId(), pkTableDbRoute);
                    }
                    catch (Throwable e) {
                        logger.error("Save pkTable error\uff1a", (Object)e.getMessage());
                        pkTableTx.markRollback();
                        throw e;
                    }
                }
            }
            catch (Throwable e) {
                logger.error("Save function error\uff1a", (Object)e.getMessage());
                functionTx.markRollback();
                throw e;
            }
        }
    }

    private static void saveAndDisableFunction(FrmFunctionModel functionModel, List<Object> baseDataList, Long disableFunctionId, DBRoute pkTableDbRoute) {
        if (pkTableDbRoute.getRouteKey().equalsIgnoreCase(DB_ROUTE_FI.getRouteKey())) {
            CommonFilterAnalyseUtil.saveAndDisableFunctionSameRoute(functionModel, baseDataList, disableFunctionId, pkTableDbRoute);
        } else {
            CommonFilterAnalyseUtil.saveAndDisableFunctionDiffRoute(functionModel, baseDataList, disableFunctionId, pkTableDbRoute);
        }
    }

    private static void saveAndDisableFunctionSameRoute(FrmFunctionModel functionModel, List<Object> baseDataList, Long disableFunctionId, DBRoute pkTableDbRoute) {
        try (TXHandle ignored = TX.requiresNew();){
            try {
                CommonFilterAnalyseUtil.saveFunctionInfo(functionModel);
                CommonFilterAnalyseUtil.saveDataId(baseDataList, functionModel.getId(), pkTableDbRoute);
                CommonFilterAnalyseUtil.disableOldFunction(disableFunctionId);
            }
            catch (Throwable e) {
                logger.error("Save function error\uff1a", (Object)e.getMessage());
                ignored.markRollback();
                throw e;
            }
        }
    }

    private static void saveAndDisableFunctionDiffRoute(FrmFunctionModel functionModel, List<Object> baseDataList, Long disableFunctionId, DBRoute pkTableDbRoute) {
        try (TXHandle functionTx = TX.requiresNew();){
            try {
                CommonFilterAnalyseUtil.saveFunctionInfo(functionModel);
                CommonFilterAnalyseUtil.disableOldFunction(disableFunctionId);
                try (TXHandle pkTableTx = TX.requiresNew();){
                    try {
                        CommonFilterAnalyseUtil.saveDataId(baseDataList, functionModel.getId(), pkTableDbRoute);
                    }
                    catch (Throwable e) {
                        logger.error("Save pkTable error\uff1a", (Object)e.getMessage());
                        pkTableTx.markRollback();
                        throw e;
                    }
                }
            }
            catch (Throwable e) {
                logger.error("Save function error\uff1a", (Object)e.getMessage());
                functionTx.markRollback();
                throw e;
            }
        }
    }

    private static void disableOldFunction(Long functionId) {
        SqlBuilder disableSqlSb = new SqlBuilder();
        disableSqlSb.append("UPDATE T_FRM_FUNCTION SET fenable = ? WHERE fid = ?", new Object[]{false, functionId});
        DB.execute((DBRoute)DB_ROUTE_FI, (SqlBuilder)disableSqlSb);
    }

    private static void saveFunctionInfo(FrmFunctionModel functionModel) {
        SqlBuilder functionSqlSb = new SqlBuilder();
        Long functionId = functionModel.getId();
        functionSqlSb.append("INSERT INTO T_FRM_FUNCTION(fid,ftype,fparam1,fparam2,fparam3,fparam4,fparam5,fmd5,fenable,fdatacount) VALUES(?,?,?,?,?,?,?,?,?,?)", new Object[]{functionId, functionModel.getType(), functionModel.getParam1(), functionModel.getParam2(), functionModel.getParam3(), functionModel.getParam4(), functionModel.getParam5(), functionModel.getMd5(), functionModel.isEnable(), functionModel.getDataCount()});
        DB.execute((DBRoute)DB_ROUTE_FI, (SqlBuilder)functionSqlSb);
    }

    private static void saveDataId(List<Object> baseDataList, Long functionId, DBRoute pkTableDbRoute) {
        if (CollectionUtils.isEmpty(baseDataList)) {
            return;
        }
        long[] pkTableFids = DB.genLongIds((String)"t_frm_pktable", (int)baseDataList.size());
        ArrayList<Object[]> params = new ArrayList<Object[]>(baseDataList.size());
        for (int i = 0; i < baseDataList.size(); ++i) {
            Object[] objs = new Object[]{pkTableFids[i], functionId, baseDataList.get(i)};
            params.add(objs);
        }
        String sql = "INSERT INTO t_frm_pktable(fid,ffunctionid,fdataid) VALUES (?,?,?)";
        DB.executeBatch((DBRoute)pkTableDbRoute, (String)sql, params);
    }

    private static String getReplacement(String functionStr, String baseDataEntityKey, QFilter baseDataFilter, String baseDataFilterField, String taskId, String batchNo, FrmFunctionModel functionModel, int pkTableMinSize, String appNumber) {
        TaskInfo taskInfo = CommonFilterAnalyseUtil.getTaskInfoCache(taskId, batchNo);
        Map functionMap = taskInfo == null ? new HashMap(1) : taskInfo.getFunctionMap();
        String md5 = CommonFilterAnalyseUtil.digest(functionStr);
        String replacement = null;
        String functionType = functionModel.getType();
        if (functionMap.get(md5) == null) {
            long functionStart = System.currentTimeMillis();
            try (DLock dLock = null;){
                long functionId;
                dLock = DLock.create((String)md5).fastMode();
                boolean getLock = dLock.tryLock(10000L);
                if (!getLock) {
                    logger.error("\u5904\u7406\u5bf9\u8d26\u51fd\u6570\u83b7\u53d6\u9501\u5931\u8d25,taskID={} !", (Object)taskId);
                }
                Map map = functionMap = (taskInfo = CommonFilterAnalyseUtil.getTaskInfoCache(taskId, batchNo)) == null ? new HashMap(1) : taskInfo.getFunctionMap();
                if (functionMap.get(md5) != null) {
                    long functionId2 = (Long)functionMap.get(md5);
                    replacement = "tmpBaseDataId_" + functionId2;
                    CommonFilterAnalyseUtil.addReuseTime(functionId2);
                    String string = replacement;
                    return string;
                }
                List<Object> baseDataList = null;
                switch (functionType) {
                    case "leafid": {
                        baseDataList = CommonFilterAnalyseUtil.getLeafIdList(baseDataEntityKey, baseDataFilter);
                        break;
                    }
                    case "getbasedataid": {
                        baseDataList = CommonFilterAnalyseUtil.getBaseDataId(baseDataEntityKey, baseDataFilter);
                        break;
                    }
                    case "getbasedataidbyassistant": {
                        baseDataList = CommonFilterAnalyseUtil.getAssistantIdList(baseDataEntityKey, baseDataFilter, baseDataFilterField, null);
                        break;
                    }
                    default: {
                        baseDataList = new ArrayList<Object>(0);
                    }
                }
                if (baseDataList.size() < pkTableMinSize) {
                    replacement = CommonFilterAnalyseUtil.getBaseDataIdReplacement(baseDataList, false, 0).get(0);
                }
                DBRoute pkTableDbRoute = DBRoute.of((String)appNumber);
                String baseDataIdMd5 = CommonFilterAnalyseUtil.getMd5FromIdList(baseDataList);
                DataSet dataSet = CommonFilterAnalyseUtil.getFunctionDataSet(functionModel);
                Iterator iterator = dataSet.iterator();
                if (!iterator.hasNext()) {
                    functionId = DB.genLongId((String)"T_FRM_FUNCTION");
                    functionModel.setId(Long.valueOf(functionId));
                    functionModel.setMd5(baseDataIdMd5);
                    functionModel.setDataCount(Integer.valueOf(baseDataList.size()));
                    CommonFilterAnalyseUtil.saveFunction(functionModel, baseDataList, pkTableDbRoute);
                    CommonFilterAnalyseUtil.updateDuration(functionStart, functionId);
                    AppCacheHelper.updateFunctionMap((String)batchNo, (String)taskId, (String)md5, (Long)functionId);
                } else {
                    Row functionRow = (Row)iterator.next();
                    String oldMd5 = functionRow.getString("fmd5");
                    functionId = functionRow.getLong("fid");
                    if (!oldMd5.equals(baseDataIdMd5)) {
                        functionId = DB.genLongId((String)"T_FRM_FUNCTION");
                        functionModel.setId(Long.valueOf(functionId));
                        functionModel.setMd5(baseDataIdMd5);
                        functionModel.setDataCount(Integer.valueOf(baseDataList.size()));
                        CommonFilterAnalyseUtil.saveAndDisableFunction(functionModel, baseDataList, functionRow.getLong("fid"), pkTableDbRoute);
                        CommonFilterAnalyseUtil.updateDuration(functionStart, functionId);
                        AppCacheHelper.updateFunctionMap((String)batchNo, (String)taskId, (String)md5, (Long)functionId);
                    } else {
                        CommonFilterAnalyseUtil.addReuseTime(functionId);
                    }
                }
                replacement = "tmpBaseDataId_" + functionId;
            }
        } else {
            long functionId = (Long)functionMap.get(md5);
            replacement = "tmpBaseDataId_" + functionId;
            CommonFilterAnalyseUtil.addReuseTime(functionId);
        }
        return replacement;
    }

    private static List<Object> getLeafIdList(String entityKey, QFilter qFilter) {
        List ids = QueryServiceHelper.queryPrimaryKeys((String)entityKey, (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
        HashSet<Long> parentIds = new HashSet<Long>(ids.size());
        for (Object id : ids) {
            parentIds.add(Long.valueOf(id.toString()));
        }
        Map leafIds = CommonFilterAnalyseUtil.getLeafs((String)entityKey, parentIds);
        ArrayList<Object> allLeafIds = new ArrayList<Object>(10);
        for (Set leaf : leafIds.values()) {
            allLeafIds.addAll(leaf);
        }
        if (allLeafIds.size() == 0) {
            allLeafIds.add(129348576L);
        }
        return allLeafIds;
    }

    private static List<Object> getAssistantIdList(String entityKey, QFilter qfilter, String filterField, QFilter pkFilter) {
        List assistantIds = QueryServiceHelper.queryPrimaryKeys((String)"bos_assistantdata_detail", (QFilter[])new QFilter[]{qfilter}, null, (int)-1);
        List<Object> baseDataIds = new ArrayList<Object>(2000);
        if (assistantIds.size() > 0) {
            if (filterField.contains("'")) {
                filterField = filterField.replaceAll("'", "");
            }
            QFilter baseDataFilter = new QFilter(filterField, "in", (Object)assistantIds);
            baseDataIds = QueryServiceHelper.queryPrimaryKeys((String)entityKey, (QFilter[])new QFilter[]{baseDataFilter, pkFilter}, null, (int)-1);
            if (baseDataIds.size() == 0) {
                baseDataIds.add(129348576L);
            }
        } else {
            baseDataIds.add(129348576L);
        }
        return baseDataIds;
    }

    private static List<String> getBaseDataIdReplacement(List<Object> baseDataIdList, boolean singleFunction, Integer batchSize) {
        ArrayList<String> replacements = new ArrayList<String>(16);
        if (singleFunction) {
            ArrayList<Object> tmpList;
            int index = 0;
            int dataSize = baseDataIdList.size();
            while ((index + 1) * batchSize <= dataSize) {
                tmpList = new ArrayList<Object>(batchSize);
                tmpList.addAll(baseDataIdList.subList(index * batchSize, (index + 1) * batchSize));
                replacements.add(CommonFilterAnalyseUtil.buildReplacement(tmpList));
                ++index;
            }
            if (index * batchSize < dataSize) {
                tmpList = new ArrayList(batchSize);
                tmpList.addAll(baseDataIdList.subList(index * batchSize, dataSize));
                replacements.add(CommonFilterAnalyseUtil.buildReplacement(tmpList));
            }
        } else {
            replacements.add(CommonFilterAnalyseUtil.buildReplacement(baseDataIdList));
        }
        return replacements;
    }

    private static String buildReplacement(List<Object> baseDataIdList) {
        StringBuilder sbRet = new StringBuilder();
        for (Object baseData : baseDataIdList) {
            sbRet.append(baseData).append(',');
        }
        if (sbRet.length() > 0) {
            sbRet.deleteCharAt(sbRet.length() - 1);
        }
        return sbRet.toString();
    }

    private static List<Object> removeAll(List<Object> data, List<Object> beDelete) {
        LinkedList<Object> linkedList = new LinkedList<Object>(data);
        HashSet<Object> hashSet = new HashSet<Object>(beDelete);
        linkedList.removeIf(hashSet::contains);
        return linkedList;
    }

    private static void addReuseTime(Long functionId) {
        String sql = "UPDATE t_frm_function SET freusetimes = freusetimes + 1 where fid = ?";
        Object[] params = new Object[]{functionId};
        DB.execute((DBRoute)DB_ROUTE_FI, (String)sql, (Object[])params);
    }

    private static void updateDuration(Long functionStart, Long functionId) {
        String sql = "UPDATE t_frm_function SET fduration = ? where fid = ?";
        Object[] params = new Object[2];
        long duration = System.currentTimeMillis() - functionStart;
        params[0] = Integer.parseInt(String.valueOf(duration));
        params[1] = functionId;
        DB.execute((DBRoute)DB_ROUTE_FI, (String)sql, (Object[])params);
    }

    public static String getLeafIdIdentification(String expr) {
        List paramSet = CommonFilterAnalyseUtil.resolveExpression((String)expr, (String)"(?<=leafid\\[)(.+?)(?=\\])");
        Iterator iter = paramSet.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        String next = (String)iter.next();
        String[] children = StringUtils.split((String)next, (String)",");
        HashSet<String> numbers = new HashSet<String>(children.length - 1);
        for (int i = 1; i < children.length; ++i) {
            numbers.add(CommonFilterAnalyseUtil.shapeExpPart(children[i]));
        }
        children[0] = CommonFilterAnalyseUtil.shapeExpPart(children[0]);
        return CommonFilterAnalyseUtil.digest("leafid" + children[0] + Arrays.toString(numbers.toArray()));
    }

    public static String getBaseDataIdIdentification(String expr) {
        List paramSet = CommonFilterAnalyseUtil.resolveExpression((String)expr, (String)"(?<=getbasedataid\\[)(.+?)(?=\\])");
        Iterator iter = paramSet.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        String next = (String)iter.next();
        String[] children = StringUtils.split((String)next, (String)",");
        HashSet<String> numbers = new HashSet<String>(children.length - 1);
        for (int i = 2; i < children.length; ++i) {
            numbers.add(CommonFilterAnalyseUtil.shapeExpPart(children[i]));
        }
        children[0] = CommonFilterAnalyseUtil.shapeExpPart(children[0]);
        children[1] = CommonFilterAnalyseUtil.shapeExpPart(children[1]);
        return CommonFilterAnalyseUtil.digest("getbasedataid" + children[0] + children[1] + Arrays.toString(numbers.toArray()));
    }

    public static String getAssistantDataIdIdentification(String expr) {
        return null;
    }

    public static String getBaseDataIdByAssistantIdIdentification(String expr) {
        List paramSet = CommonFilterAnalyseUtil.resolveExpression((String)expr, (String)"(?<=getbasedataidbyassistant\\[)(.+?)(?=\\])");
        Iterator iter = paramSet.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        String next = (String)iter.next();
        String[] childs = StringUtils.split((String)next, (String)",");
        childs[0] = CommonFilterAnalyseUtil.shapeExpPart(childs[0]);
        childs[1] = CommonFilterAnalyseUtil.shapeExpPart(childs[1]);
        childs[2] = CommonFilterAnalyseUtil.shapeExpPart(childs[2]);
        childs[3] = CommonFilterAnalyseUtil.shapeExpPart(childs[3]);
        HashSet<String> assistantFilterValues = new HashSet<String>(childs.length - 1);
        for (int i = 4; i < childs.length; ++i) {
            assistantFilterValues.add(CommonFilterAnalyseUtil.shapeExpPart(childs[i]));
        }
        return CommonFilterAnalyseUtil.digest("getbasedataidbyassistant" + childs[0] + childs[1] + childs[2] + childs[3] + Arrays.toString(assistantFilterValues.toArray()));
    }

    public static void getFunctionField(String expression, Map<String, String> functionIdentification) {
        List nests;
        String expressionWithSingleQuotation = CommonFilterAnalyseUtil.checkValidInAndNotIn(expression);
        QFilter filter = QFilter.of((String)expressionWithSingleQuotation, (Object[])new Object[0]);
        String property = filter.getProperty();
        String value = String.valueOf(filter.getValue());
        String identification = null;
        if (value != null && value.contains("leafid[")) {
            identification = CommonFilterAnalyseUtil.getLeafIdIdentification(value);
        } else if (value != null && value.contains("getbasedataid[")) {
            identification = CommonFilterAnalyseUtil.getBaseDataIdIdentification(value);
        } else if (value != null && value.contains("getassistantdataid[")) {
            identification = CommonFilterAnalyseUtil.getAssistantDataIdIdentification(value);
        } else if (value != null && value.contains("getbasedataidbyassistant[")) {
            identification = CommonFilterAnalyseUtil.getBaseDataIdByAssistantIdIdentification(value);
        }
        if (!StringUtils.isEmpty((CharSequence)identification)) {
            functionIdentification.put(property, identification);
        }
        if ((nests = filter.getNests(true)).size() == 0) {
            return;
        }
        for (QFilter.QFilterNest nest : nests) {
            CommonFilterAnalyseUtil.getFunctionField(nest.getFilter().toString(), functionIdentification);
        }
    }

    public static void getFunctionFieldByPrefix(String expression, Map<Integer, String> indexFieldMap, int index, String functionPrefix) {
        List nests;
        boolean isBaseDataIdByAssistant;
        String expressionWithSingleQuotation = CommonFilterAnalyseUtil.checkValidInAndNotIn(expression);
        QFilter filter = QFilter.of((String)expressionWithSingleQuotation, (Object[])new Object[0]);
        String property = filter.getProperty();
        String value = String.valueOf(filter.getValue());
        boolean isLeafId = "leafid[".equals(functionPrefix) && value != null && value.contains("leafid[");
        boolean isBaseDataId = "getbasedataid[".equals(functionPrefix) && value != null && value.contains("getbasedataid[");
        boolean bl = isBaseDataIdByAssistant = "getbasedataidbyassistant[".equals(functionPrefix) && value != null && value.contains("getbasedataidbyassistant[");
        if (isLeafId || isBaseDataId || isBaseDataIdByAssistant) {
            indexFieldMap.put(index, property);
            ++index;
        }
        if ((nests = filter.getNests(true)).size() == 0) {
            return;
        }
        for (QFilter.QFilterNest nest : nests) {
            CommonFilterAnalyseUtil.getFunctionFieldByPrefix(nest.getFilter().toString(), indexFieldMap, index, functionPrefix);
        }
    }

    public static void handleRuleFunction(ReconciliationParamModel paramModel, DynamicObjectCollection dataRuleEntryEntity, Map<Object, DynamicObject> commonFilterMap, String periodConfig) {
        if (StringUtils.isEmpty((CharSequence)periodConfig)) {
            return;
        }
        Long periodId = paramModel.getPeriodId();
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"begindate,enddate,periodyear,periodnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)periodId)});
        HashMap<String, Set<String>> toSelectMap = new HashMap<String, Set<String>>(dataRuleEntryEntity.size());
        for (DynamicObject dataRuleEntry : dataRuleEntryEntity) {
            String exp = dataRuleEntry.getString("datafilter_tag");
            if (kd.bos.util.StringUtils.isEmpty((String)exp)) continue;
            String entityKey = dataRuleEntry.getDynamicObject("bizobj").getString("number");
            CRCondition cdb = (CRCondition)SerializationUtils.fromJsonString((String)exp, CRCondition.class);
            String expression = cdb.getExpression();
            if (!StringUtils.isNotEmpty((CharSequence)expression)) continue;
            HashMap<String, String> functionIdentification = new HashMap<String, String>(4);
            if (!expression.contains("leafid[") && !expression.contains("getbasedataid[") && !expression.contains("'getassistantdataid[") && !expression.contains("'getbasedataidbyassistant[")) continue;
            CommonFilterAnalyseUtil.getFunctionField(expression, functionIdentification);
            if (CollectionUtils.isEmpty(functionIdentification)) continue;
            Set selectFieldSet = functionIdentification.keySet();
            long commonFilterId = dataRuleEntry.getLong("commonfilter.id");
            DynamicObject commonFilterInfo = commonFilterMap.get(commonFilterId);
            String orgField = commonFilterInfo.getString("bizorg");
            String periodField = commonFilterInfo.getString("period");
            String bizDateField = commonFilterInfo.getString("bizdate");
            String key = entityKey + "," + orgField + "," + periodField + "," + bizDateField + "," + commonFilterId + "," + dataRuleEntry.get("id");
            toSelectMap.computeIfAbsent(key, k -> new HashSet(4)).addAll(selectFieldSet);
        }
        if (toSelectMap.size() > 0) {
            String enableAlgox = SystemParamHelper.getStringSysParam((String)"algoxcombo", (long)paramModel.getTaskInfo().getOrgId(), (String)"0");
            long beforeSelect = System.currentTimeMillis();
            if ("1".equals(enableAlgox)) {
                CommonFilterAnalyseUtil.queryBaseDataPkByAlgox(toSelectMap, periodConfig, periodId, period, paramModel);
            } else if ("2".equals(enableAlgox)) {
                CommonFilterAnalyseUtil.queryBaseDataPkByThreadPool(toSelectMap, periodConfig, periodId, period, paramModel);
            } else {
                CommonFilterAnalyseUtil.queryBaseDataPk(toSelectMap, periodConfig, periodId, period, paramModel);
            }
            long afterSelect = System.currentTimeMillis();
            logger.info("Select baseDataPk from biz takes : {}", (Object)(afterSelect - beforeSelect));
        }
    }

    private static void queryBaseDataPk(Map<String, Set<String>> toSelectMap, String periodConfig, Long periodId, DynamicObject period, ReconciliationParamModel paramModel) {
        DynamicObjectCollection collection = null;
        for (Map.Entry<String, Set<String>> entry : toSelectMap.entrySet()) {
            QFilter periodFilter;
            String key = entry.getKey();
            String[] split = key.split(",");
            String entityKey = split[0];
            String orgField = split[1];
            QFilter orgFilter = new QFilter(orgField, "in", (Object)paramModel.getBizOrgIds());
            String periodField = split[2];
            String bizDateField = split[3];
            Set<String> fieldSet = entry.getValue();
            String selectFields = String.join((CharSequence)",", fieldSet);
            if (StringUtils.isNotEmpty((CharSequence)periodField)) {
                if ("2".equals(periodConfig)) {
                    periodFilter = new QFilter(periodField, "<=", (Object)periodId);
                    collection = QueryServiceHelper.query((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{periodFilter, orgFilter});
                } else if ("3".equals(periodConfig)) {
                    periodFilter = new QFilter(periodField, "<", (Object)periodId);
                    collection = QueryServiceHelper.query((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{periodFilter, orgFilter});
                    periodFilter = new QFilter(periodField, "=", (Object)periodId);
                    collection.addAll((Collection)QueryServiceHelper.query((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{periodFilter, orgFilter}));
                } else {
                    collection = QueryServiceHelper.query((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{orgFilter});
                }
            } else if (StringUtils.isNotEmpty((CharSequence)bizDateField)) {
                if ("2".equals(periodConfig)) {
                    periodFilter = new QFilter(bizDateField, "<=", (Object)period.getDate("enddate"));
                    collection = QueryServiceHelper.query((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{periodFilter, orgFilter});
                } else if ("3".equals(periodConfig)) {
                    periodFilter = new QFilter(bizDateField, "<=", (Object)period.getDate("begindate"));
                    collection = QueryServiceHelper.query((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{periodFilter, orgFilter});
                    periodFilter = new QFilter(bizDateField, "<=", (Object)period.getDate("enddate")).and(new QFilter(bizDateField, ">=", (Object)period.getDate("begindate")));
                    collection.addAll((Collection)QueryServiceHelper.query((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{periodFilter, orgFilter}));
                } else {
                    collection = QueryServiceHelper.query((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{orgFilter});
                }
            } else {
                collection = QueryServiceHelper.query((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{orgFilter});
            }
            if (CollectionUtils.isEmpty((Collection)collection)) continue;
            String commonFilterIdStr = split[4];
            try {
                for (String field : fieldSet) {
                    HashSet<Object> pks = new HashSet<Object>(collection.size());
                    for (DynamicObject row : collection) {
                        pks.add(row.get(field));
                    }
                    String identification = entityKey + "," + commonFilterIdStr + "," + field;
                    paramModel.getFunctionPkMap().put(identification, pks);
                }
            }
            catch (Throwable t) {
                logger.error("Field match error ! RuleEntryid is {},Key is {}, Select fields is {}", new Object[]{split[5], key, selectFields});
                throw new KDBizException(ThrowableHelper.toString((Throwable)t));
            }
        }
    }

    private static void queryBaseDataPkByThreadPool(Map<String, Set<String>> toSelectMap, String periodConfig, Long periodId, DynamicObject period, ReconciliationParamModel paramModel) {
        ConcurrentHashMap functionPkMap = new ConcurrentHashMap(200);
        CountDownLatch countDownLatch = new CountDownLatch(toSelectMap.size());
        for (Map.Entry<String, Set<String>> entry : toSelectMap.entrySet()) {
            BIZ_OBJ_THREAD_POOL.execute(() -> {
                block21: {
                    try {
                        QFilter periodFilter;
                        String key = (String)entry.getKey();
                        String[] split = key.split(",");
                        String entityKey = split[0];
                        String orgField = split[1];
                        QFilter orgFilter = new QFilter(orgField, "in", (Object)paramModel.getBizOrgIds());
                        String periodField = split[2];
                        String bizDateField = split[3];
                        Set fieldSet = (Set)entry.getValue();
                        String selectFields = String.join((CharSequence)",", fieldSet);
                        DynamicObjectCollection collection = null;
                        if (StringUtils.isNotEmpty((CharSequence)periodField)) {
                            if ("2".equals(periodConfig)) {
                                periodFilter = new QFilter(periodField, "<=", (Object)periodId);
                                collection = QueryServiceHelper.query((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{periodFilter, orgFilter});
                            } else if ("3".equals(periodConfig)) {
                                periodFilter = new QFilter(periodField, "<", (Object)periodId);
                                collection = QueryServiceHelper.query((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{periodFilter, orgFilter});
                                periodFilter = new QFilter(periodField, "=", (Object)periodId);
                                collection.addAll((Collection)QueryServiceHelper.query((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{periodFilter, orgFilter}));
                            } else {
                                collection = QueryServiceHelper.query((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{orgFilter});
                            }
                        } else if (StringUtils.isNotEmpty((CharSequence)bizDateField)) {
                            if ("2".equals(periodConfig)) {
                                periodFilter = new QFilter(bizDateField, "<=", (Object)period.getDate("enddate"));
                                collection = QueryServiceHelper.query((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{periodFilter, orgFilter});
                            } else if ("3".equals(periodConfig)) {
                                periodFilter = new QFilter(bizDateField, "<=", (Object)period.getDate("begindate"));
                                collection = QueryServiceHelper.query((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{periodFilter, orgFilter});
                                periodFilter = new QFilter(bizDateField, "<=", (Object)period.getDate("enddate")).and(new QFilter(bizDateField, ">=", (Object)period.getDate("begindate")));
                                collection.addAll((Collection)QueryServiceHelper.query((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{periodFilter, orgFilter}));
                            } else {
                                collection = QueryServiceHelper.query((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{orgFilter});
                            }
                        } else {
                            collection = QueryServiceHelper.query((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{orgFilter});
                        }
                        if (CollectionUtils.isEmpty((Collection)collection)) break block21;
                        String commonFilterIdStr = split[4];
                        try {
                            for (String field : fieldSet) {
                                HashSet<Object> pks = new HashSet<Object>(collection.size());
                                for (DynamicObject row : collection) {
                                    pks.add(row.get(field));
                                }
                                String identification = entityKey + "," + commonFilterIdStr + "," + field;
                                functionPkMap.put(identification, pks);
                            }
                        }
                        catch (Throwable t) {
                            logger.error("Field match error ! RuleEntryid is {},Key is {}, Select fields is {}", new Object[]{split[5], key, selectFields});
                            throw new KDBizException(ThrowableHelper.toString((Throwable)t));
                        }
                    }
                    catch (Throwable t) {
                        logger.error(ThrowableHelper.toString((Throwable)t));
                        throw new KDBizException(ThrowableHelper.toString((Throwable)t));
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            }, RequestContext.get());
        }
        try {
            countDownLatch.await();
            if (functionPkMap.size() > 0) {
                paramModel.getFunctionPkMap().putAll(functionPkMap);
            }
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage());
            throw new KDBizException((Throwable)e, new ErrorCode("queryBaseDataPkByThreadPoolError", "%s"), new Object[]{ThrowableHelper.toString((Exception)e)});
        }
    }

    private static void queryBaseDataPkByAlgox(Map<String, Set<String>> toSelectMap, String periodConfig, Long periodId, DynamicObject period, ReconciliationParamModel paramModel) {
        String algoKey = CommonFilterAnalyseUtil.class.getName();
        for (Map.Entry<String, Set<String>> entry : toSelectMap.entrySet()) {
            OrmInput input;
            QFilter periodFilter;
            String key = entry.getKey();
            String[] split = key.split(",");
            String entityKey = split[0];
            String orgField = split[1];
            QFilter orgFilter = new QFilter(orgField, "in", (Object)paramModel.getBizOrgIds());
            String periodField = split[2];
            String bizDateField = split[3];
            Set<String> fieldSet = entry.getValue();
            String selectFields = String.join((CharSequence)",", fieldSet);
            ArrayList<OrmInput> inputList = new ArrayList<OrmInput>();
            if (StringUtils.isNotEmpty((CharSequence)periodField)) {
                if ("2".equals(periodConfig)) {
                    periodFilter = new QFilter(periodField, "<=", (Object)periodId);
                    input = new OrmInput(algoKey, entityKey, selectFields, new QFilter[]{periodFilter, orgFilter});
                    inputList.add(input);
                } else if ("3".equals(periodConfig)) {
                    periodFilter = new QFilter(periodField, "<", (Object)periodId);
                    input = new OrmInput(algoKey, entityKey, selectFields, new QFilter[]{periodFilter, orgFilter});
                    inputList.add(input);
                    periodFilter = new QFilter(periodField, "=", (Object)periodId);
                    input = new OrmInput(algoKey, entityKey, selectFields, new QFilter[]{periodFilter, orgFilter});
                    inputList.add(input);
                } else {
                    input = new OrmInput(algoKey, entityKey, selectFields, new QFilter[]{orgFilter});
                    inputList.add(input);
                }
            } else if (StringUtils.isNotEmpty((CharSequence)bizDateField)) {
                if ("2".equals(periodConfig)) {
                    periodFilter = new QFilter(bizDateField, "<=", (Object)period.getDate("enddate"));
                    input = new OrmInput(algoKey, entityKey, selectFields, new QFilter[]{periodFilter, orgFilter});
                    inputList.add(input);
                } else if ("3".equals(periodConfig)) {
                    periodFilter = new QFilter(bizDateField, "<=", (Object)period.getDate("begindate"));
                    input = new OrmInput(algoKey, entityKey, selectFields, new QFilter[]{periodFilter, orgFilter});
                    inputList.add(input);
                    periodFilter = new QFilter(bizDateField, "<=", (Object)period.getDate("enddate")).and(new QFilter(bizDateField, ">=", (Object)period.getDate("begindate")));
                    input = new OrmInput(algoKey, entityKey, selectFields, new QFilter[]{periodFilter, orgFilter});
                    inputList.add(input);
                } else {
                    input = new OrmInput(algoKey, entityKey, selectFields, new QFilter[]{orgFilter});
                    inputList.add(input);
                }
            } else {
                input = new OrmInput(algoKey, entityKey, selectFields, new QFilter[]{orgFilter});
                inputList.add(input);
            }
            JobSession session = AlgoX.createSession((String)DaptrackerService.class.getName(), (String)"voucher");
            DataSetX dataSetx = session.fromInput(inputList.toArray(new Input[0]));
            DataSetOutput resultSet = new DataSetOutput(dataSetx.getRowMeta());
            dataSetx.output((Output)resultSet);
            int timeoutTime = Math.max(180, Integer.parseInt(System.getProperty("prop.fi.ai.thread.timeoutsecs", Integer.toString(180))));
            session.commit(timeoutTime, TimeUnit.SECONDS);
            DataSet dataSet = session.readDataSet(resultSet.getId());
            String commonFilterIdStr = split[4];
            try {
                for (String field : fieldSet) {
                    HashSet<Object> pks = new HashSet<Object>(1000);
                    for (Row row : dataSet) {
                        pks.add(row.get(field));
                    }
                    String identification = entityKey + "," + commonFilterIdStr + "," + field;
                    paramModel.getFunctionPkMap().put(identification, pks);
                }
            }
            catch (Throwable t) {
                logger.error("Field match error ! RuleEntryid is {},Key is {}, Select fields is {}", new Object[]{split[5], key, selectFields});
                throw new KDBizException(ThrowableHelper.toString((Throwable)t));
            }
        }
    }

    public static String getFieldName(IDataEntityType parent, String entityName, String fieldName) {
        if (!entityName.equals(parent.getName())) {
            fieldName = CommonFilterAnalyseUtil.getFieldName(parent.getParent(), entityName, parent.getName() + "." + fieldName);
        }
        return fieldName;
    }

    public static String replaceFrmFunctionDesc(String expressionDesc) {
        for (Map.Entry<String, String> entry : FRM_FUNC_DESC_MAP.entrySet()) {
            String functionStr = entry.getKey();
            if (!expressionDesc.contains(functionStr)) continue;
            expressionDesc = expressionDesc.replace(functionStr, entry.getValue());
        }
        return expressionDesc;
    }

    public static String dealFrmFunctionFormula(String expr) {
        if (expr != null && expr.contains("leafid[")) {
            expr = CommonFilterAnalyseUtil.dealLeafIdFormula(expr);
        }
        if (expr != null && expr.contains("getbasedataid[")) {
            expr = CommonFilterAnalyseUtil.dealGetBaseDataIdFormula(expr);
        }
        if (expr != null && expr.contains("getassistantdataid[")) {
            expr = CommonFilterAnalyseUtil.dealGetAssistantDataIdFormula(expr);
        }
        if (expr != null && expr.contains("getbasedataidbyassistant[")) {
            expr = CommonFilterAnalyseUtil.dealGetBaseDataIdByAssistantFormula(expr);
        }
        return expr;
    }

    private static String dealLeafIdFormula(String expr) {
        String replacement = ResManager.loadKDString((String)"\u83b7\u53d6\u4e0b\u7ea7\u6570\u636e\u51fd\u6570", (String)"CommonFilterAnalyseUtil_0", (String)"fi-frm-mservice", (Object[])new Object[0]);
        expr = expr.replace("leafid[", replacement + "[");
        return expr;
    }

    private static String dealGetBaseDataIdFormula(String expr) {
        String replacement = ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u53d6\u6570\u51fd\u6570", (String)"CommonFilterAnalyseUtil_1", (String)"fi-frm-mservice", (Object[])new Object[0]);
        expr = expr.replace("getbasedataid[", replacement + "[");
        return expr;
    }

    private static String dealGetAssistantDataIdFormula(String expr) {
        String replacement = ResManager.loadKDString((String)"\u8f85\u52a9\u8d44\u6599\u53d6\u6570\u51fd\u6570", (String)"CommonFilterAnalyseUtil_2", (String)"fi-frm-mservice", (Object[])new Object[0]);
        expr = expr.replace("getassistantdataid[", replacement + "[");
        return expr;
    }

    private static String dealGetBaseDataIdByAssistantFormula(String expr) {
        String replacement = ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u4e2d\u7684\u8f85\u52a9\u8d44\u6599\u53d6\u6570\u51fd\u6570", (String)"CommonFilterAnalyseUtil_3", (String)"fi-frm-mservice", (Object[])new Object[0]);
        expr = expr.replace("getbasedataidbyassistant[", replacement + "[");
        return expr;
    }

    public static String checkValidInAndNotIn(String expression) {
        expression = CommonFilterAnalyseUtil.addSingleQuotationToFrmFunc(expression, "leafid[", "(?<=leafid\\[)(.+?)(?=\\])", "'leafid[", "'leafid[");
        expression = CommonFilterAnalyseUtil.addSingleQuotationToFrmFunc(expression, "leaf[", "(?<=leaf\\[)(.+?)(?=\\])", "'leaf[", "'leaf[");
        expression = CommonFilterAnalyseUtil.addSingleQuotationToFrmFunc(expression, "getbasedataid[", "(?<=getbasedataid\\[)(.+?)(?=\\])", "'getbasedataid[", "'getbasedataid[");
        expression = CommonFilterAnalyseUtil.addSingleQuotationToFrmFunc(expression, "getbasedata[", "(?<=getbasedata\\[)(.+?)(?=\\])", "'getbasedata[", "'getbasedata[");
        return expression;
    }

    private static String addSingleQuotationToFrmFunc(String expression, String symbol, String pattern, String quote, String newSymbol) {
        if (!expression.contains(symbol)) {
            return expression;
        }
        List paramSet = CommonFilterAnalyseUtil.resolveExpression((String)expression, (String)pattern);
        for (String resolveExres : paramSet) {
            if (expression.contains(quote)) continue;
            expression = expression.replace(symbol + resolveExres + "]", newSymbol + resolveExres + "]'");
        }
        return expression;
    }

    static {
        FRM_FUNC_DESC_MAP.put("balanceperiod(period,endperiod,short_period)", ResManager.loadKDString((String)"\u5b58\u8d27\u671f\u521d\u4f59\u989d\u5206\u6bb5\u53d6\u6570\u51fd\u6570", (String)"CommonFilterAnalyseUtil_16", (String)"fi-frm-formplugin", (Object[])new Object[0]));
        FRM_FUNC_DESC_MAP.put("leafid[entityId,filterValue]", ResManager.loadKDString((String)"\u83b7\u53d6\u4e0b\u7ea7\u6570\u636e\u51fd\u6570[\u57fa\u7840\u8d44\u6599\u6807\u8bc6,\u57fa\u7840\u8d44\u6599\u7f16\u53f7\uff08\u591a\u4e2a\u7f16\u53f7\u7528\u82f1\u6587\u9017\u53f7\u5206\u5272\uff09]", (String)"CommonFilterAnalyseUtil_4", (String)"fi-frm-formplugin", (Object[])new Object[0]));
        FRM_FUNC_DESC_MAP.put("getbasedataid[entityId,filterField,filterValue]", ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u53d6\u6570\u51fd\u6570[\u57fa\u7840\u8d44\u6599\u6807\u8bc6,\u57fa\u7840\u8d44\u6599\u8fc7\u6ee4\u5c5e\u6027,\u8fc7\u6ee4\u5c5e\u6027\u503c\uff08\u591a\u4e2a\u503c\u7528\u82f1\u6587\u9017\u53f7\u5206\u5272\uff09]", (String)"CommonFilterAnalyseUtil_5", (String)"fi-frm-formplugin", (Object[])new Object[0]));
        FRM_FUNC_DESC_MAP.put("getassistantdataid[groupNumber,filterField,filterValue]", ResManager.loadKDString((String)"\u8f85\u52a9\u8d44\u6599\u53d6\u6570\u51fd\u6570[\u8f85\u52a9\u8d44\u6599\u5206\u7c7b,\u8f85\u52a9\u8d44\u6599\u8fc7\u6ee4\u5c5e\u6027,\u8f85\u52a9\u8d44\u6599\u8fc7\u6ee4\u5c5e\u6027\u503c\uff08\u591a\u4e2a\u503c\u7528\u82f1\u6587\u9017\u53f7\u5206\u5272\uff09]", (String)"CommonFilterAnalyseUtil_6", (String)"fi-frm-formplugin", (Object[])new Object[0]));
        FRM_FUNC_DESC_MAP.put("getbasedataidbyassistant[entityId,assistantField,groupNumber,filterField,filterValue]", ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u4e2d\u7684\u8f85\u52a9\u8d44\u6599\u53d6\u6570\u51fd\u6570[\u57fa\u7840\u8d44\u6599\u6807\u8bc6,\u57fa\u7840\u8d44\u6599\u7684\u8f85\u52a9\u8d44\u6599\u5c5e\u6027\u540d,\u8f85\u52a9\u8d44\u6599\u5206\u7c7b,\u8f85\u52a9\u8d44\u6599\u8fc7\u6ee4\u5c5e\u6027,\u8f85\u52a9\u8d44\u6599\u8fc7\u6ee4\u5c5e\u6027\u503c\uff08\u591a\u4e2a\u503c\u7528\u82f1\u6587\u9017\u53f7\u5206\u5272\uff09]", (String)"CommonFilterAnalyseUtil_7", (String)"fi-frm-formplugin", (Object[])new Object[0]));
    }
}

