/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.bizdata.ext.custom;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.frm.common.builder.ISingleTaskContext;
import kd.fi.frm.common.builder.getvaluehandle.SourceFieldGetHandle;
import kd.fi.frm.common.builder.getvaluemode.IVariableMode;
import kd.fi.frm.common.model.FrmLogger;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.bizdata.BizDataSourceConfig;
import kd.fi.frm.common.model.bizdata.BizReconPlanDetailModel;
import kd.fi.frm.common.model2.RelationDataParam3;
import kd.fi.frm.common.util.BuildHelper;
import kd.fi.frm.common.util.ReconciliationUtil;
import kd.fi.frm.mservice.bizdata.ext.custom.AbstractCustomParamService;

public class CalCustomParamService
extends AbstractCustomParamService {
    protected String materialAssistKey;
    protected String materialCategoryAssistKey;
    private static final String MATERIAL_ASSIST_KEY = "1.bd_material";
    private static final String MATERIAL_CATEGORY_ASSIST_KEY = "1.bd_materialcategory";

    @Override
    public void getParamMap(BizReconPlanDetailModel planDetailModel, Long orgId) {
        this.turnCategoryToMaterial(planDetailModel, orgId, null, null);
    }

    @Override
    public void getDetailParamMap(ReconciliationParamModel paramModel, BizReconPlanDetailModel planDetailModel, RelationDataParam3 param) {
        this.turnCategoryToMaterial(planDetailModel, param.getAcctOrgID(), param, paramModel);
    }

    @Override
    public void resetParam(List<Object[]> rows, Map<String, Integer> assistIndexMap, ReconciliationParamModel paramModel) {
        if (!this.isMaterialCategory(paramModel)) {
            return;
        }
        if (assistIndexMap == null || assistIndexMap.size() == 0) {
            return;
        }
        Object needConvert = this.paramMap.get("materialCategoryNeedConvert");
        if (needConvert == null || !Boolean.parseBoolean(needConvert.toString())) {
            return;
        }
        HashMap<Integer, String> indexMap = new HashMap<Integer, String>(assistIndexMap.size());
        for (Map.Entry<String, Integer> entry : assistIndexMap.entrySet()) {
            indexMap.put(entry.getValue(), entry.getKey());
        }
        Map materialCategoryMap = (Map)this.paramMap.get("materialCategoryMap");
        Map indexMaterialCategoryMap = (Map)this.paramMap.get("indexMaterialCategoryMap");
        for (Object[] row : rows) {
            for (int i = 1; i <= 8; ++i) {
                String assistNumber = (String)indexMap.get(i);
                String assistId = String.valueOf(row[i]);
                if ("0".equals(assistId) || !this.materialAssistKey.equals(assistNumber)) continue;
                row[1 + i] = indexMaterialCategoryMap.get(materialCategoryMap.get(assistId));
            }
        }
    }

    @Override
    public void addSpecialFieldToFldList(Map<String, Object> customParam, BizDataSourceConfig cfg, ISingleTaskContext taskContext, Map<String, IVariableMode> sourceFields, Map<String, IVariableMode> detailSelectFields) {
        boolean isMaterialCategory;
        Object isMaterialCategoryObj = customParam.get("materialCategory");
        boolean bl = isMaterialCategory = isMaterialCategoryObj != null && Boolean.parseBoolean(String.valueOf(isMaterialCategoryObj));
        if (isMaterialCategory) {
            Map filterPropMap = cfg.getFilterPropMap();
            for (Map.Entry entry : filterPropMap.entrySet()) {
                if (!MATERIAL_ASSIST_KEY.equalsIgnoreCase((String)entry.getKey())) continue;
                SourceFieldGetHandle dimGetHandle = new SourceFieldGetHandle(taskContext, (String)entry.getValue(), null);
                dimGetHandle.Compile();
                BuildHelper.AddVarsToFldList(sourceFields, (List)dimGetHandle.getVars());
                cfg.getDimPropGetHandle().put(entry.getKey(), dimGetHandle);
                SourceFieldGetHandle materialGetHandle = new SourceFieldGetHandle(taskContext, (String)entry.getValue(), null);
                materialGetHandle.Compile();
                BuildHelper.AddVarsToFldList(detailSelectFields, (List)materialGetHandle.getVars());
                break;
            }
        }
    }

    @Override
    public void fillBizAssistVal(Long[] bizAssistVal, Map<String, Integer> assistIndexMap, String entityName, Long id) {
        if (MATERIAL_ASSIST_KEY.equalsIgnoreCase(entityName) && assistIndexMap.get(entityName) == null && assistIndexMap.get(MATERIAL_CATEGORY_ASSIST_KEY) != null) {
            bizAssistVal[assistIndexMap.get((Object)MATERIAL_CATEGORY_ASSIST_KEY).intValue() - 1] = id;
        } else if (!MATERIAL_CATEGORY_ASSIST_KEY.equalsIgnoreCase(entityName) && assistIndexMap.get(entityName) != null) {
            bizAssistVal[assistIndexMap.get((Object)entityName).intValue() - 1] = id;
        }
    }

    @Override
    public void fillIndexAssistMap(String assistKey, Integer index, Map<Integer, String> indexAssistMap) {
        if (assistKey.equalsIgnoreCase(MATERIAL_CATEGORY_ASSIST_KEY)) {
            indexAssistMap.put(index, MATERIAL_ASSIST_KEY);
        } else {
            indexAssistMap.put(index, assistKey);
        }
    }

    private boolean isMaterialCategory(ReconciliationParamModel paramModel) {
        Map customParam = paramModel.getCustomParam();
        Object isMaterialCategory = customParam.get("materialCategory");
        return isMaterialCategory != null && Boolean.parseBoolean(String.valueOf(isMaterialCategory));
    }

    private void turnCategoryToMaterial(BizReconPlanDetailModel planDetailModel, Long orgId, RelationDataParam3 relationDataParam3, ReconciliationParamModel paramModel) {
        List bizFilterAssistMapList = planDetailModel.getBizFilterAssistMapList();
        if (CollectionUtils.isEmpty((Collection)bizFilterAssistMapList)) {
            this.paramMap.put("materialCategoryNeedConvert", Boolean.FALSE);
            return;
        }
        HashMap<Long, Integer> materialCategoryIndexMap = new HashMap<Long, Integer>(2000);
        HashMap<Integer, Long> indexMaterialCategoryMap = new HashMap<Integer, Long>(2000);
        int index = 0;
        HashMap materialCategoryMap = new HashMap(2000);
        HashSet<Long> allMaterialSet = new HashSet<Long>(16);
        for (Map bizAssistMap : bizFilterAssistMapList) {
            if (CollectionUtils.isEmpty((Map)bizAssistMap)) continue;
            HashSet<Long> materialCategoryIds = new HashSet<Long>(16);
            for (Map.Entry entry : bizAssistMap.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.contains(".bd_materialcategory")) continue;
                QFilter qFilter = QFilter.fromSerializedString((String)((String)entry.getValue()));
                materialCategoryIds.addAll((Collection)qFilter.getValue());
                this.materialCategoryAssistKey = key;
            }
            if (CollectionUtils.isEmpty(materialCategoryIds)) continue;
            for (Long materialCategoryId : materialCategoryIds) {
                materialCategoryIndexMap.putIfAbsent(materialCategoryId, index);
                indexMaterialCategoryMap.putIfAbsent(index, materialCategoryId);
                ++index;
            }
            Map<Long, Map<Long, Set<Long>>> orgCategoryMaterial = this.getOrgCategoryMaterial(orgId, materialCategoryIds);
            HashSet<Long> tmpMaterialSet = new HashSet<Long>(16);
            for (Map.Entry<Long, Map<Long, Set<Long>>> longMapEntry : orgCategoryMaterial.entrySet()) {
                Set<Map.Entry<Long, Set<Long>>> categoryMaterialEntrySet = longMapEntry.getValue().entrySet();
                for (Map.Entry<Long, Set<Long>> longSetEntry : categoryMaterialEntrySet) {
                    Set<Long> materialSet = longSetEntry.getValue();
                    Long materialCategoryId = longSetEntry.getKey();
                    if (materialSet == null || materialSet.size() <= 0) continue;
                    for (Long materialId : materialSet) {
                        materialCategoryMap.put(String.valueOf(materialId), materialCategoryIndexMap.get(materialCategoryId));
                        tmpMaterialSet.add(materialId);
                        allMaterialSet.add(materialId);
                    }
                }
            }
            this.materialAssistKey = MATERIAL_ASSIST_KEY;
            if (bizAssistMap.get(this.materialAssistKey) != null) {
                QFilter materialQFilter = QFilter.fromSerializedString((String)((String)bizAssistMap.get(this.materialAssistKey)));
                Set originValue = (Set)materialQFilter.getOriginValue();
                originValue.retainAll(tmpMaterialSet);
                if (originValue.size() == 0) {
                    originValue.add(129348576L);
                }
                bizAssistMap.put(this.materialAssistKey, new QFilter("id", "in", (Object)originValue).toSerializedString());
                continue;
            }
            if (tmpMaterialSet.size() == 0) {
                tmpMaterialSet.add(129348576L);
            }
            bizAssistMap.put(this.materialAssistKey, new QFilter("id", "in", tmpMaterialSet).toSerializedString());
        }
        if (CollectionUtils.isEmpty(allMaterialSet)) {
            this.paramMap.put("materialCategoryNeedConvert", Boolean.FALSE);
            return;
        }
        this.paramMap.put("indexMaterialCategoryMap", indexMaterialCategoryMap);
        this.paramMap.put("materialCategoryMap", materialCategoryMap);
        if (relationDataParam3 != null && relationDataParam3.getBizAssistMap() != null && relationDataParam3.getBizAssistMap().get(this.materialCategoryAssistKey) != null) {
            relationDataParam3.getBizAssistMap().remove(this.materialCategoryAssistKey);
            relationDataParam3.getBizAssistMap().put(this.materialAssistKey, allMaterialSet);
        }
        this.paramMap.put("materialCategoryNeedConvert", Boolean.TRUE);
    }

    private Map<Long, Map<Long, Set<Long>>> getOrgCategoryMaterial(Long orgId, Set<Long> materialCategoryIds) {
        HashMap<Long, Set<Long>> param = new HashMap<Long, Set<Long>>(16);
        param.put(orgId, materialCategoryIds);
        FrmLogger frmLogger = ReconciliationUtil.initFrmLoggerCache((FrmLogger)new FrmLogger());
        frmLogger.begin("===== MaterialCategoryService start =====");
        frmLogger.log(String.format("MaterialCategoryService param : %s", SerializationUtils.toJsonString(param)));
        Map orgCategoryMaterial = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"MaterialCategoryService", (String)"getMaterialByOrgAndMaterialCategory", (Object[])new Object[]{param});
        frmLogger.log(String.format("MaterialCategoryService result : %s", SerializationUtils.toJsonString((Object)orgCategoryMaterial)));
        frmLogger.end("===== MaterialCategoryService end =====");
        return orgCategoryMaterial;
    }
}

