/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.datamatch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.fi.frm.mservice.algo.DistinctConcatAggFunction;
import kd.fi.frm.mservice.datamatch.IGroupDataHandler;

public class CollectionCompGroupEngine {
    private DataSet leftIt;
    private DataSet rightIt;
    private String compareField;
    private Integer groupIndex;
    private IGroupDataHandler handler;

    private CollectionCompGroupEngine() {
    }

    public static CollectionCompGroupEngine getRowService() {
        return new CollectionCompGroupEngine();
    }

    public CollectionCompGroupEngine data(DataSet leftMainData, DataSet rightMainData) {
        this.leftIt = leftMainData;
        this.rightIt = rightMainData;
        return this;
    }

    public CollectionCompGroupEngine compareField(String fieldKey) {
        this.compareField = fieldKey;
        return this;
    }

    public CollectionCompGroupEngine maxGroupIndex(Integer groupIndex) {
        this.groupIndex = groupIndex;
        return this;
    }

    public CollectionCompGroupEngine groupDataHandler(IGroupDataHandler handler) {
        this.handler = handler;
        return this;
    }

    public void start() {
        if (this.leftIt == null && this.rightIt == null) {
            return;
        }
        if (this.leftIt == null) {
            for (Row rightRow : this.rightIt) {
                boolean next = this.handler.handle(Collections.emptyList(), Collections.singletonList(rightRow));
                if (next) continue;
                return;
            }
            return;
        }
        if (this.rightIt == null) {
            for (Row leftRow : this.leftIt) {
                boolean next = this.handler.handle(Collections.singletonList(leftRow), Collections.emptyList());
                if (next) continue;
                return;
            }
            return;
        }
        DataSet[] leftSplitDataSet = this.leftIt.splitByFilter(new String[]{this.compareField + " is null"}, true);
        DataSet onlyLeftDs = leftSplitDataSet[0];
        for (Row leftRow : onlyLeftDs) {
            boolean next = this.handler.handle(Collections.singletonList(leftRow), Collections.emptyList());
            if (next) continue;
            return;
        }
        DataSet[] rightSplitDataSet = this.rightIt.splitByFilter(new String[]{this.compareField + " is null"}, true);
        DataSet onlyRightDs = rightSplitDataSet[0];
        for (Row rightRow : onlyRightDs) {
            boolean next = this.handler.handle(Collections.emptyList(), Collections.singletonList(rightRow));
            if (next) continue;
            return;
        }
        DataSet leftRelateDs = leftSplitDataSet[1].orderBy(new String[]{this.compareField + " asc"});
        DataSet rightRelateDs = rightSplitDataSet[1].groupBy(new String[]{"id", "rptvchid", "rptvchno", this.compareField}).agg((CustomAggFunction)new DistinctConcatAggFunction("distinctGroupConcat", (DataType)DataType.StringType), "account", "account").sum("debit").sum("credit").finish().orderBy(new String[]{this.compareField + " asc"});
        Iterator leftCursor = leftRelateDs.iterator();
        Iterator rightCursor = rightRelateDs.iterator();
        ArrayList<Row> leftBuff = new ArrayList<Row>(10);
        ArrayList<Row> rightBuff = new ArrayList<Row>();
        Row tmpLeft = null;
        int tmpLeftIdx = 0;
        Row tmpRight = null;
        int tmpRightIdx = 0;
        for (int i = 1; i <= this.groupIndex; ++i) {
            int groupIdx;
            Row next;
            if (tmpLeftIdx == i) {
                leftBuff.add(tmpLeft);
            }
            while (leftCursor.hasNext()) {
                next = (Row)leftCursor.next();
                groupIdx = next.getInteger(this.compareField);
                if (groupIdx == i) {
                    leftBuff.add(next);
                    continue;
                }
                tmpLeft = next;
                tmpLeftIdx = groupIdx;
                break;
            }
            if (tmpRightIdx == i) {
                rightBuff.add(tmpRight);
            }
            while (rightCursor.hasNext()) {
                next = (Row)rightCursor.next();
                groupIdx = next.getInteger(this.compareField);
                if (groupIdx == i) {
                    rightBuff.add(next);
                    continue;
                }
                tmpRight = next;
                tmpRightIdx = groupIdx;
                break;
            }
            this.handler.handle(leftBuff, rightBuff);
            leftBuff.clear();
            rightBuff.clear();
        }
    }
}

