/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.detailstore;

import java.math.BigDecimal;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.enums.DetailDcEnum;
import kd.fi.frm.common.model.ReconDiffSummeryModel;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model2.RelationDataParam3;
import kd.fi.frm.common.task.TaskInfo;
import kd.fi.frm.mservice.detailstore.AbstractDataRowCollector;

public class DataSetRowCollector
extends AbstractDataRowCollector {
    protected DataSetBuilder builder;
    private ReconDiffSummeryModel summeryModel;
    protected int maxRows = 10000;
    protected ReconciliationParamModel paramModel;

    public DataSetRowCollector(ReconciliationParamModel paramModel, RowMeta rowMeta, int maxCollectRows) {
        this.rowMeta = rowMeta;
        this.builder = Algo.create((String)"fi.frm.DataSetRowCollector").createDataSetBuilder(rowMeta);
        this.maxRows = maxCollectRows;
        this.summeryModel = new ReconDiffSummeryModel();
        this.paramModel = paramModel;
    }

    public ReconDiffSummeryModel getSummeryModel() {
        return this.summeryModel;
    }

    @Override
    public boolean collectEqualRow() {
        return false;
    }

    @Override
    public boolean isStop() {
        return this.collectedRows >= this.maxRows + 1;
    }

    @Override
    protected void handleRow(Row row, BigDecimal leftSum, BigDecimal rightSum) {
        if (this.collectedRows <= this.maxRows) {
            this.builder.append(row);
            this.sumRowAmt(this.summeryModel, row, leftSum, rightSum);
        }
    }

    @Override
    public void calcEqualsAmount(DetailDcEnum dcEnum, BigDecimal amount) {
        this.summeryModel.incrAmount(dcEnum.getValue(), true, true, amount);
    }

    @Override
    public Object finishWithResult(RelationDataParam3 detailParam) {
        DataSet dataSet = this.builder.build();
        TaskInfo taskInfo = this.paramModel.getTaskInfo();
        CachedDataSet cache = dataSet.cache(CacheHint.getDefault());
        String cacheId = cache.getCacheId();
        AppCacheHelper.putTaskCache((String)(taskInfo.getBatchNo() + ".detail.row"), (String)("" + taskInfo.getId()), (String)cacheId);
        AppCacheHelper.putResultCache((String)("DETAIL_NOT_ALL:" + taskInfo.getId()), (Object)Boolean.toString(this.collectedRows >= this.maxRows));
        AppCacheHelper.addList((String)(this.paramModel.getTaskInfo().getId() + ".detail.summery"), (String)SerializationUtils.toJsonString((Object)this.summeryModel));
        return cacheId;
    }
}

