/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.detailstore;

import java.math.BigDecimal;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.enums.DetailDcEnum;
import kd.fi.frm.common.model.ReconDiffSummeryModel;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model2.RelationDataParam3;
import kd.fi.frm.common.task.TaskInfo;
import kd.fi.frm.mservice.detailstore.DataSetRowCollector;

public class DataSumCollector
extends DataSetRowCollector {
    private ReconDiffSummeryModel allSummeryModel = new ReconDiffSummeryModel();

    public DataSumCollector(ReconciliationParamModel paramModel, RowMeta rowMeta, int maxCollectRows) {
        super(paramModel, rowMeta, maxCollectRows);
    }

    @Override
    public boolean isStop() {
        return false;
    }

    @Override
    public void calcEqualsAmount(DetailDcEnum dcEnum, BigDecimal amount) {
        this.allSummeryModel.incrAmount(dcEnum.getValue(), true, true, amount);
    }

    @Override
    protected void handleRow(Row row, BigDecimal leftSum, BigDecimal rightSum) {
        if (this.collectedRows < this.maxRows + 1) {
            this.builder.append(row);
        }
        this.sumRowAmt(this.allSummeryModel, row, leftSum, rightSum);
    }

    @Override
    public Object finishWithResult(RelationDataParam3 detailParam) {
        DataSet dataSet = this.builder.build();
        CachedDataSet cache = dataSet.cache(CacheHint.getDefault());
        String cacheId = cache.getCacheId();
        TaskInfo taskInfo = this.paramModel.getTaskInfo();
        AppCacheHelper.putTaskCache((String)(taskInfo.getBatchNo() + ".detail.row"), (String)("" + taskInfo.getId()), (String)cacheId);
        AppCacheHelper.putResultCache((String)("DETAIL_NOT_ALL:" + taskInfo.getId()), (Object)"false");
        AppCacheHelper.addList((String)(this.paramModel.getTaskInfo().getId() + ".detail.summery"), (String)SerializationUtils.toJsonString((Object)this.allSummeryModel));
        return this.allSummeryModel;
    }
}

