/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.detailstore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.io.IOUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.cache.gl.CacheHelper;
import kd.fi.frm.common.enums.AmountDataTypeEnum;
import kd.fi.frm.common.enums.DetailDcEnum;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanDetailModel;
import kd.fi.frm.common.model2.RelationDataParam3;
import kd.fi.frm.common.util.FaBillParamUtils;
import kd.fi.frm.common.util.ReconciliationUtil;
import kd.fi.frm.common.util.ThrowableHelper;
import kd.fi.frm.mservice.detailstore.AbstractDataRowCollector;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class ExportExcelCollector
extends AbstractDataRowCollector {
    private static final String[] EXPORT_FIELD_LIST = new String[]{"groupIdx", "billorg", "billentity", "billno", "billassist", "billamount", "bizdc", "acctnum", "vchno", "dc", "glamount", "bizamt", "glamt", "diff"};
    private int PER_SHEET_DATAROWS = 100000;
    private int groupIdx = 0;
    private int sheetCnt = 1;
    private SXSSFWorkbook wb;
    private SXSSFSheet currentSheet;
    private int currentSheetRow = 0;
    private CellStyle style;
    private DataEntityPropertyCollection propertyCol;
    private ReconciliationParamModel paramModel;
    private final int exportType;
    private Map<String, String> acctNameMap = new HashMap<String, String>(8);
    private Map<String, String> entityNameMap = new HashMap<String, String>(8);
    private Map<Long, String> vchTypeName = new HashMap<Long, String>();
    private Map<Long, DynamicObject> billOrgMap;
    private Map<Integer, String> bizIndexAssistMap = new HashMap<Integer, String>(8);

    public ExportExcelCollector(ReconciliationParamModel paramModel, int exportType) {
        this.paramModel = paramModel;
        this.exportType = exportType;
    }

    @Override
    public boolean collectEqualRow() {
        return 2 == this.exportType;
    }

    @Override
    public void prepare(BizReconPlanDetailModel detailModel, Set<String> billTypes) {
        super.prepare(detailModel, billTypes);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"frm_rec_detail");
        EntityType entryType = (EntityType)entityType.getAllEntities().get("entryentity");
        this.propertyCol = entryType.getProperties();
        this.PER_SHEET_DATAROWS = FaBillParamUtils.getIntegerValue((Long)0L, (String)"frm_export_sheet_rowsize", (int)this.PER_SHEET_DATAROWS);
        this.getAcctNameMap(this.paramModel);
        Set bizOrgIds = this.paramModel.getBizOrgIds();
        DynamicObject[] billOrgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)bizOrgIds)});
        this.billOrgMap = Arrays.stream(billOrgs).collect(Collectors.toMap(org -> org.getLong("id"), org -> org));
        for (String billType : billTypes) {
            String billTypeName = MetadataServiceHelper.getDataEntityType((String)billType).getDisplayName().getLocaleValue();
            this.entityNameMap.put(billType, billTypeName);
        }
        Map bizAssistIndexMap = detailModel.getBizAssistIndexMap();
        bizAssistIndexMap.forEach((assist, idx) -> this.bizIndexAssistMap.put((Integer)idx, (String)assist));
        DynamicObjectCollection voucherTypes = QueryServiceHelper.query((String)"gl_vouchertype", (String)"id,name", (QFilter[])new QFilter[0]);
        for (DynamicObject voucherType : voucherTypes) {
            this.vchTypeName.put(voucherType.getLong("id"), voucherType.getString("name"));
        }
        this.wb = new SXSSFWorkbook(1000);
        this.wb.setCompressTempFiles(true);
        DataFormat dataFormat = this.wb.createDataFormat();
        this.style = this.getHeadColumnStyle(this.wb);
        this.style.setAlignment(HorizontalAlignment.CENTER);
        Long currencyId = this.paramModel.getCurrency();
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
        int amt = 2;
        if (currency != null) {
            amt = currency.getInt("amtprecision");
        }
        StringBuilder formatBuilder = new StringBuilder("#,##0.");
        for (int i = 0; i < amt; ++i) {
            formatBuilder.append(0);
        }
        this.style.setDataFormat(dataFormat.getFormat(formatBuilder.toString()));
    }

    @Override
    public void calcEqualsAmount(DetailDcEnum dcEnum, BigDecimal amount) {
    }

    @Override
    protected void handleRow(Row groupRow, BigDecimal leftSum, BigDecimal rightSum) {
        if (this.currentSheet == null) {
            this.currentSheet = this.wb.createSheet();
            this.setTableHead(this.currentSheet);
        } else if (this.currentSheetRow >= this.PER_SHEET_DATAROWS + 2) {
            this.currentSheet = this.wb.createSheet();
            this.currentSheetRow = 0;
            this.setTableHead(this.currentSheet);
            ++this.sheetCnt;
        }
        SXSSFRow createRow = this.currentSheet.createRow(this.currentSheetRow++);
        SXSSFCell cell = createRow.createCell(0);
        cell.setCellStyle(this.style);
        for (int i = 0; i < EXPORT_FIELD_LIST.length; ++i) {
            String number = EXPORT_FIELD_LIST[i];
            String value = "";
            Object rawValue = this.getValue(groupRow, number);
            if (rawValue == null) {
                value = "";
            } else if (rawValue instanceof String) {
                value = rawValue.toString();
            } else if (rawValue instanceof BigDecimal && (StringUtils.isBlank((CharSequence)(value = rawValue.toString())) || value.equals("0E-10") || Double.parseDouble(value) == 0.0)) {
                value = "";
            }
            cell = createRow.createCell(i);
            if (rawValue instanceof BigDecimal) {
                if (BigDecimal.ZERO == rawValue) {
                    cell.setCellValue("");
                } else {
                    double amount = StringUtils.isEmpty((CharSequence)value) ? 0.0 : Double.parseDouble(value);
                    cell.setCellValue(amount);
                }
            } else {
                cell.setCellValue(value);
            }
            cell.setCellStyle(this.style);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object finishWithResult(RelationDataParam3 detailParam) {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            String prefixName2332 = ResManager.loadKDString((String)"\u5bf9\u8d26\u5dee\u5f02\u660e\u7ec6\u8868", (String)"ReconciliationAssistDetailExportUtil_0", (String)"fi-frm-formplugin", (Object[])new Object[0]);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmssSSS");
            String currDateTime = dateFormat.format(new Date());
            String userName = RequestContext.get().getUserName();
            String fileName = prefixName2332 + "-" + currDateTime + "-" + userName + ".xlsx";
            outStream = new ByteArrayOutputStream();
            this.wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String fileUrl = CacheHelper.getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 3600);
            AppCacheHelper.putTaskCache((String)this.paramModel.getTaskInfo().getBatchNo(), (String)(this.paramModel.getTaskInfo().getId() + ".detail.export"), (String)fileUrl);
        }
        catch (IOException ex) {
            try {
                throw new KDBizException(ThrowableHelper.toString((Exception)ex));
            }
            catch (Throwable throwable) {
                try {
                    IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{outStream, inStream});
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{outStream, inStream});
            return null;
        }
        catch (Exception prefixName2332) {
            return null;
        }
    }

    private Object getValue(Row row, String number) {
        if ("groupIdx".equals(number)) {
            Long pid = row.getLong("pid");
            if (pid == 0L) {
                ++this.groupIdx;
            }
            return String.valueOf(this.groupIdx);
        }
        if ("bizdc".equals(number) || "dc".equals(number)) {
            Integer bizDc = row.getInteger("dc".equals(number) ? "vchdc" : number);
            if (bizDc != null) {
                return AmountDataTypeEnum.getName((int)bizDc);
            }
            return "";
        }
        if ("acctnum".equals(number)) {
            String acctId = row.getString("account");
            String acctName = "";
            if (this.acctNameMap.containsKey(acctId)) {
                acctName = this.acctNameMap.get(acctId);
            }
            return acctName;
        }
        if ("billentity".equals(number)) {
            String entityKey;
            String entityName = entityKey = row.getString("billentity");
            if (this.entityNameMap.containsKey(entityKey)) {
                entityName = this.entityNameMap.get(entityKey);
            }
            return entityName;
        }
        if ("billorg".equalsIgnoreCase(number)) {
            Long acctnum = row.getLong(number);
            if (acctnum == null || acctnum == 0L) {
                return "";
            }
            DynamicObject org = this.billOrgMap.get(acctnum);
            if (org == null) {
                return acctnum;
            }
            String orgNum = org.getString("number");
            String orgName = org.getString("name");
            return orgNum + " " + orgName;
        }
        if ("billassist".equals(number)) {
            Map baseDataName = this.paramModel.getBaseDataName();
            Map baseDataTypeName = this.paramModel.getBaseDataTypeName();
            Long billId = row.getLong("billid");
            if (billId == null || billId == 0L) {
                return "";
            }
            StringBuilder tmpVal = new StringBuilder();
            for (Map.Entry<Integer, String> assistEntry : this.bizIndexAssistMap.entrySet()) {
                String assistShowName;
                String typeName;
                Integer idx = assistEntry.getKey();
                String assistKey = assistEntry.getValue();
                Long assistId = row.getLong("assist" + idx + "_app");
                if (assistId != null && assistId == 0L) {
                    typeName = "";
                    assistShowName = "";
                } else {
                    Map assistIdMap = (Map)baseDataName.get(assistKey);
                    assistShowName = (String)assistIdMap.get(String.valueOf(assistId));
                    typeName = (String)baseDataTypeName.get(assistKey);
                }
                tmpVal.append(typeName).append(":").append(assistShowName).append(";");
            }
            return tmpVal.toString();
        }
        if ("vchno".equals(number)) {
            String rptvchno = row.getString("rptvchno");
            if (StringUtils.isEmpty((CharSequence)rptvchno)) {
                return "";
            }
            if (rptvchno.contains(" ")) {
                return rptvchno;
            }
            Long vouchertype = row.getLong("rptvchid");
            String typeName = this.vchTypeName.get(vouchertype);
            return typeName + " " + rptvchno;
        }
        return row.get(number);
    }

    private void getAcctNameMap(ReconciliationParamModel paramModel) {
        Set acctIds = paramModel.getAccountIds();
        if (acctIds.size() > 0) {
            HashSet acctMasterSet = new HashSet(12);
            ReconciliationUtil.getDetailAccountId((Long)paramModel.getOrgIds().toArray(new Long[0])[0], (Long)paramModel.getAccountTable(), (Long)paramModel.getPeriodId(), (Set)acctIds, new HashSet(12), acctMasterSet);
            Set accountIdSet = ReconciliationUtil.getAccountIdByMasterId(acctMasterSet);
            QFilter accountIdFilter = new QFilter("id", "in", (Object)accountIdSet);
            DataSet accountDataSet = QueryServiceHelper.queryDataSet((String)ReconciliationUtil.class.getName(), (String)"bd_accountview", (String)"id,number,name", (QFilter[])new QFilter[]{accountIdFilter}, (String)"");
            while (accountDataSet.hasNext()) {
                Row row = accountDataSet.next();
                this.acctNameMap.put(row.getString("id"), row.getString("number") + "," + row.getString("name"));
            }
        }
    }

    private void setTableHead(SXSSFSheet sheet) {
        SXSSFRow row = sheet.createRow(this.currentSheetRow++);
        SXSSFRow row1 = sheet.createRow(this.currentSheetRow++);
        int[] cellRange = null;
        for (int i = 0; i < EXPORT_FIELD_LIST.length; ++i) {
            String number = EXPORT_FIELD_LIST[i];
            DynamicProperty property = (DynamicProperty)this.propertyCol.get((Object)number);
            SXSSFCell cell = row.createCell(i);
            switch (number) {
                case "groupIdx": {
                    cell.setCellValue((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"\u6279\u6b21\u53f7", (String)"ReconciliationAssistDetailExportUtil_3", (String)"fi-frm-formplugin", (Object[])new Object[0])));
                    CellRangeAddress cellRange0 = new CellRangeAddress(0, 1, i, i);
                    sheet.addMergedRegion(cellRange0);
                    break;
                }
                case "billorg": {
                    cell.setCellValue((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"ReconciliationAssistDetailExportUtil_1", (String)"fi-frm-formplugin", (Object[])new Object[0])));
                    cellRange = new int[]{i, i + 5};
                    CellRangeAddress cellRange0 = new CellRangeAddress(0, 0, cellRange[0], cellRange[1]);
                    sheet.addMergedRegion(cellRange0);
                    break;
                }
                case "acctnum": {
                    cell.setCellValue((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"\u51ed\u8bc1", (String)"ReconciliationAssistDetailExportUtil_2", (String)"fi-frm-formplugin", (Object[])new Object[0])));
                    cellRange = new int[]{i, i + 3};
                    CellRangeAddress cellRange1 = new CellRangeAddress(0, 0, cellRange[0], cellRange[1]);
                    sheet.addMergedRegion(cellRange1);
                    break;
                }
            }
            if (property != null) {
                LocaleString name = property.getDisplayName();
                if (cellRange != null && i > cellRange[1]) {
                    cell.setCellValue(name.getLocaleValue());
                    CellRangeAddress cellRange3 = new CellRangeAddress(0, 1, (int)((short)i), (int)((short)i));
                    sheet.addMergedRegion(cellRange3);
                } else {
                    SXSSFCell cell1 = row1.createCell(i);
                    cell1.setCellValue(name.getLocaleValue());
                }
            }
            cell.setCellStyle(this.style);
        }
    }

    private CellStyle getHeadColumnStyle(SXSSFWorkbook wb) {
        CellStyle headColumnStyle = wb.createCellStyle();
        if (headColumnStyle == null) {
            headColumnStyle = wb.createCellStyle();
            headColumnStyle.setBorderBottom(BorderStyle.THIN);
            headColumnStyle.setBorderTop(BorderStyle.THIN);
            headColumnStyle.setBorderLeft(BorderStyle.THIN);
            headColumnStyle.setBorderRight(BorderStyle.THIN);
            headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
            headColumnStyle.setHidden(false);
        }
        return headColumnStyle;
    }
}

