/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.gldata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.RowMeta;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.frm.common.enums.AssistTypeEnum;
import kd.fi.frm.common.enums.DataTypeEnum;
import kd.fi.frm.common.model.BaseGlDataParam;
import kd.fi.frm.common.model.FrmLogger;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.gldata.GLAccountConfig;
import kd.fi.frm.common.model.gldata.GLDataParam;
import kd.fi.frm.common.model2.GLDataParam2;
import kd.fi.frm.common.util.ReconciliationUtil;

public abstract class AbstractGLDataService {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected FrmLogger frmLogger;
    protected BaseGlDataParam param;
    protected ReconciliationParamModel paramModel;
    protected List<Object[]> cacheRows = new ArrayList<Object[]>(2000);
    protected Map<Long, Integer> dcMap = new HashMap<Long, Integer>(16);
    protected static final String ENTITY_ACCOUNTVIEW = "bd_accountview";
    protected static final String ENTITY_GLBALANCE = "gl_balance";
    protected static final String ENTITY_GLASSIST = "gl_assist";
    protected static final String ENTITY_GLASSISTBD = "gl_assist_bd";
    public static final String ENTITY_GLVOUCHER = "gl_voucher";
    protected static final String ENTITY_BDCURRENCY = "bd_currency";
    protected static final String SIMP_ACCT_SELECTOR = "id,masterid,longnumber";
    protected RowMeta rowMeta = null;
    protected static final String BALANCESELECTOR = "account,assgrp.id assgrp, assgrp.value assvals,beginlocal,currency,debitlocal,creditlocal,endlocal";
    protected static final String BALANCESELECTOR_DEBIT = "account,assgrp.id assgrp, assgrp.value assvals,0 beginlocal,currency,debitlocal,0 creditlocal,0 endlocal";
    protected static final String BALANCESELECTOR_CREDIT = "account,assgrp.id assgrp, assgrp.value assvals,0 beginlocal,currency,0 debitlocal,creditlocal,0 endlocal";
    protected static final String BALANCESELECTOR_DEBIT_CREDIT = "account,assgrp.id assgrp, assgrp.value assvals,0 beginlocal,currency,debitlocal,creditlocal,0 endlocal";
    protected static final String BALANCESELECTOR_ACCT = "beginlocal,currency,account,debitlocal,creditlocal,endlocal";
    protected static final String BALANCESELECTOR_ACCT_DEBIT = "0 beginlocal,currency,account,debitlocal,0 creditlocal,0 endlocal";
    protected static final String BALANCESELECTOR_ACCT_CREDIT = "0 beginlocal,currency,account,0 debitlocal,creditlocal,0 endlocal";
    protected static final String BALANCESELECTOR_ACCT_DEBIT_CREDIT = "0 beginlocal,currency,account,debitlocal,creditlocal,0 endlocal";
    protected static final String BALANCEFIELDS = "fid,fperiodid,fendperiodid,faccounttableid,forgid,fbooktypeid,faccountid,fassgrpid,fcurrencyid,fbeginlocal,fdebitlocal,fcreditlocal,fendlocal";
    protected static final String CURRENCYBALANCESELECTOR = "account,assgrp.id assgrp, assgrp.value assvals,beginfor beginlocal,currency,debitfor debitlocal,creditfor creditlocal,endfor endlocal";
    protected static final String CURRENCYBALANCESELECTOR_DEBIT = "account,assgrp.id assgrp, assgrp.value assvals,0 beginlocal,currency,debitfor debitlocal,0 creditlocal,0 endlocal";
    protected static final String CURRENCYBALANCESELECTOR_CREDIT = "account,assgrp.id assgrp, assgrp.value assvals,0 beginlocal,currency,0 debitlocal,creditfor creditlocal,0 endlocal";
    protected static final String CURRENCYBALANCESELECTOR_DEBIT_CREDIT = "account,assgrp.id assgrp, assgrp.value assvals,0 beginlocal,currency,debitfor debitlocal,creditfor creditlocal,0 endlocal";
    protected static final String CURRENCYBALANCESELECTOR_ACCT = "account,beginfor beginlocal,currency,debitfor debitlocal,creditfor creditlocal,endfor endlocal";
    protected static final String CURRENCYBALANCESELECTOR_ACCT_DEBIT = "account,0 beginlocal,currency,debitfor debitlocal,0 creditlocal,0 endlocal";
    protected static final String CURRENCYBALANCESELECTOR_ACCT_CREDIT = "account,0 beginlocal,currency,0 debitlocal,creditfor creditlocal,0 endlocal";
    protected static final String CURRENCYBALANCESELECTOR_ACCT_DEBIT_CREDIT = "account,0 beginlocal,currency,debitfor debitlocal,creditfor creditlocal,0 endlocal";
    protected static final String CURRENCYBALANCEFIELDS = "fid,fperiodid,fendperiodid,faccounttableid,forgid,fbooktypeid,faccountid,fassgrpid,fcurrencyid,fbeginfor,fdebitfor,fcreditfor,fendfor";
    public static final String voucherSelector = "id,billno,vouchertype,sourcetype,entries.debitlocal debit,entries.creditlocal credit,entries.account account, billstatus, sourcebilltype srcentity";
    public static final String voucherSelector_dc = "id,entries.debitlocal debit,entries.creditlocal credit,entries.account account,sourcebilltype srcentity";
    public static final String VOUCHER_SELECTOR_DEBIT = "id,billno,vouchertype,sourcetype,entries.debitlocal debit,0 credit,entries.account account, billstatus, sourcebilltype srcentity";
    public static final String VOUCHER_SELECTOR_DEBIT_DC = "id,entries.debitlocal debit,entries.creditlocal credit,entries.account account,sourcebilltype srcentity";
    public static final String VOUCHER_SELECTOR_CREDIT = "id,billno,vouchertype,sourcetype,0 debit,entries.creditlocal credit,entries.account account, billstatus, sourcebilltype srcentity";
    public static final String VOUCHER_SELECTOR_CREDIT_DC = "id,entries.debitlocal debit,entries.creditlocal credit,entries.account account,sourcebilltype srcentity";
    protected static final String voucherFields = "a.fid,a.fnumber,a.fbillstatus,a.forgid,a.fperiodid,a.fbookid,a.ftypeid,b.fcurrencyid,b.faccountid, b.flocaldebit,b.flocalcredit";
    public static final String currencyVoucherSelector = "id,billno,vouchertype,sourcetype,entries.debitori debit,entries.creditori credit,entries.account account, billstatus, sourcebilltype srcentity";
    public static final String currencyVoucherSelector_dc = "id,entries.debitori debit,entries.creditori credit,entries.account account,sourcebilltype srcentity";
    public static final String CURRENCY_VOUCHER_SELECTOR_DEBIT = "id,billno,vouchertype,sourcetype,entries.debitori debit,0 credit,entries.account account, billstatus, sourcebilltype srcentity";
    public static final String CURRENCY_VOUCHER_SELECTOR_DEBIT_DC = "id,entries.debitori debit,entries.creditori credit,entries.account account,sourcebilltype srcentity";
    public static final String CURRENCY_VOUCHER_SELECTOR_CREDIT = "id,billno,vouchertype,sourcetype,0 debit,entries.creditori credit,entries.account account, billstatus, sourcebilltype srcentity";
    public static final String CURRENCY_VOUCHER_SELECTOR_CREDIT_DC = "id,entries.debitori debit,entries.creditori credit,entries.account account,sourcebilltype srcentity";
    protected static final String currencyVoucherFields = "a.fid,a.fnumber,a.fbillstatus,a.forgid,a.fperiodid,a.fbookid,a.ftypeid,b.fcurrencyid,b.faccountid, b.foriginaldebit,b.foriginalcredit";
    protected static final String logGLDataWhereString = " from t_gl_voucher a left join t_gl_voucherentry b  on a.fid = b.fid where a.fperiodid in(?) and a.forgid in (?) and a.fbooktypeid in (?) and a.fsourcetype=? and a.fsourcebilltype=? and b.faccountid in (?) and b.fcurrencyid=? params =";
    protected int BATCH_SIZE = 0;
    protected static final String DC_DEBIT = "1";
    protected static final String DC_CREDIT = "-1";

    public AbstractGLDataService(BaseGlDataParam param, ReconciliationParamModel paramModel) {
        this.param = param;
        this.paramModel = paramModel;
        this.frmLogger = paramModel.getFrmLogger();
    }

    public abstract DataSet execute();

    protected List<QFilter>[] getQueryFilter() {
        GLAccountConfig accountConfig;
        ArrayList[] resultFilter = new ArrayList[2];
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        HashSet acctIdSet = new HashSet(16);
        HashSet acctMasterSet = new HashSet(16);
        HashSet accountIds = null;
        if (AssistTypeEnum.Acct == this.param.getType()) {
            accountConfig = ((GLDataParam)this.param).getAccountConfig();
            accountIds = new HashSet(accountConfig.getAccountIds().size());
            accountIds.addAll(accountConfig.getAccountIds());
        } else {
            accountConfig = ((GLDataParam2)this.param).getAccountConfig();
            accountIds = new HashSet(accountConfig.getAccountIds().size());
            accountIds.addAll(accountConfig.getAccountIds());
        }
        ReconciliationUtil.initAccountInfo((Long)this.param.getAcctOrgID(), (Long)this.param.getAccountTableID(), (Long)this.param.getPeriodid(), accountIds, acctIdSet, acctMasterSet, this.dcMap);
        filterList.add(new QFilter("account", "in", acctMasterSet));
        filterList.add(new QFilter("org", "=", (Object)this.param.getAcctOrgID()));
        filterList.add(new QFilter("booktype", "=", (Object)this.param.getAcctBookTypeID()));
        filterList.add(new QFilter("accounttable", "=", (Object)this.param.getAccountTableID()));
        filterList.add(new QFilter("endperiod", ">", (Object)this.param.getPeriodid()));
        ArrayList<QFilter> filterList2 = new ArrayList<QFilter>(filterList);
        filterList.add(new QFilter("period", "=", (Object)this.param.getPeriodid()));
        filterList2.add(new QFilter("period", "<", (Object)this.param.getPeriodid()));
        resultFilter[0] = filterList;
        resultFilter[1] = filterList2;
        return resultFilter;
    }

    public DataSet getDataSet(List<Object[]> rowList, DataTypeEnum dataType) {
        GroupbyDataSet groupbyDataSet = null;
        DataSet sumDataSet = null;
        Algo algo = Algo.create((String)"GLDataService");
        DataSetBuilder builder = algo.createDataSetBuilder(this.rowMeta);
        for (Object[] row : rowList) {
            builder.append(row);
        }
        if (AssistTypeEnum.Assist == this.param.getType() || AssistTypeEnum.Asstact == this.param.getType()) {
            groupbyDataSet = builder.build().groupBy(new String[]{"currency_gl", "assist1_gl", "assist2_gl", "assist3_gl", "assist4_gl", "assist5_gl", "assist6_gl", "assist7_gl", "assist8_gl"}).groupConcat("glassgrps").groupConcat("account").sum("openingbalance_gl").sum("debitamount_gl").sum("creditamount_gl").sum("closingbalance_gl");
            sumDataSet = groupbyDataSet.finish();
        } else if (AssistTypeEnum.Acct == this.param.getType()) {
            groupbyDataSet = builder.build().groupBy(new String[]{"currency_gl"}).sum("openingbalance_gl").sum("debitamount_gl").sum("creditamount_gl").sum("closingbalance_gl");
            sumDataSet = groupbyDataSet.finish();
        } else {
            sumDataSet = builder.build();
        }
        return sumDataSet;
    }

    protected DataSet buildEmptyGlDataSet() {
        DataSetBuilder builder = Algo.create((String)"AbstractGLDataService.buildEmptyGlDataSet").createDataSetBuilder(this.rowMeta);
        DataSet sumDataSet = builder.build();
        if (AssistTypeEnum.Assist == this.param.getType() || AssistTypeEnum.Asstact == this.param.getType()) {
            sumDataSet = sumDataSet.groupBy(new String[]{"currency_gl", "assist1_gl", "assist2_gl", "assist3_gl", "assist4_gl", "assist5_gl", "assist6_gl", "assist7_gl", "assist8_gl"}).groupConcat("glassgrps").groupConcat("account").sum("openingbalance_gl").sum("debitamount_gl").sum("creditamount_gl").sum("closingbalance_gl").finish();
        } else if (AssistTypeEnum.Acct == this.param.getType()) {
            sumDataSet = sumDataSet.groupBy(new String[]{"currency_gl"}).sum("openingbalance_gl").sum("debitamount_gl").sum("creditamount_gl").sum("closingbalance_gl").finish();
        }
        return sumDataSet;
    }
}

