/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.gldata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.cache.frm.ReconModelCacheHelper;
import kd.fi.frm.common.enums.AssistDataType;
import kd.fi.frm.common.enums.DetailDataTypeEnum;
import kd.fi.frm.common.model.FRMDataSetModel;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanDetailModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanModel;
import kd.fi.frm.common.model2.RelationDataParam3;
import kd.fi.frm.common.relation.DaptrackerService;
import kd.fi.frm.common.util.FaBillParamUtils;
import kd.fi.frm.common.util.ReconciliationUtil;
import kd.fi.frm.mservice.bizdata.ext.custom.AbstractCustomParamService;
import kd.fi.frm.mservice.bizdata.ext.custom.CustomParamUtil;
import kd.fi.frm.mservice.rpt.RptBizAppConfigServiceHelper;

public class DetailDataFormat {
    public static Map<Long, String> getAllOrgName(ReconciliationParamModel paramModel) {
        Set idSet = paramModel.getBizOrgIds();
        idSet.addAll(paramModel.getOrgIds());
        HashMap<Long, String> orgNameMap = new HashMap<Long, String>();
        QFilter idFilter = new QFilter("id", "in", (Object)idSet);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)("DetailDataFormat" + System.currentTimeMillis()), (String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{idFilter}, null);){
            for (Row row : ds) {
                orgNameMap.put(row.getLong("id"), String.format("%s %s", row.getString("number"), row.getString("name")));
            }
        }
        return orgNameMap;
    }

    public static List<Row> getRowByType(String taskId, DetailDataTypeEnum detailDataType) {
        ArrayList<Row> cacheList = new ArrayList<Row>(1000);
        Map cacheIdMap = AppCacheHelper.getAll((String)(taskId + detailDataType.getValue()));
        if (cacheIdMap == null || cacheIdMap.size() == 0) {
            return cacheList;
        }
        for (String cacheId : cacheIdMap.values()) {
            CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cacheId);
            List tmpRows = cacheDataSet.getList(0, cacheDataSet.getRowCount());
            if (tmpRows == null || tmpRows.size() <= 0) continue;
            cacheList.addAll(tmpRows);
        }
        return cacheList;
    }

    public static List<Row> initCacheRowList(List<String> fieldNameList, String taskId, boolean allRows) {
        RowMeta rowMeta = null;
        ArrayList<String> suffixList = new ArrayList<String>(3);
        if (allRows) {
            suffixList.add(DetailDataTypeEnum.EQUAL.getValue());
        }
        suffixList.add(DetailDataTypeEnum.HAND_BILL.getValue());
        suffixList.add(DetailDataTypeEnum.HAND_VCH.getValue());
        suffixList.add(DetailDataTypeEnum.NOT_EQUAL.getValue());
        List<Object> rowList = new ArrayList<Row>(1000);
        for (String suffix : suffixList) {
            Map cacheIdMap = AppCacheHelper.getAll((String)(taskId + suffix));
            if (cacheIdMap == null || cacheIdMap.size() == 0) continue;
            for (String cacheId : cacheIdMap.values()) {
                CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cacheId);
                rowMeta = cacheDataSet.getRowMeta();
                List tmpRows = cacheDataSet.getList(0, cacheDataSet.getRowCount());
                if (tmpRows == null || tmpRows.size() <= 0) continue;
                rowList.addAll(tmpRows);
            }
        }
        if (rowMeta != null) {
            fieldNameList.addAll(Arrays.asList(rowMeta.getFieldNames()));
        }
        int detailLimit = RelationDataParam3.getDetailLimit();
        if (!allRows && rowList.size() > detailLimit) {
            rowList = rowList.subList(0, detailLimit);
        }
        return rowList;
    }

    public static Map<Integer, String> initAssistIndexMap(Long recPlanId, ReconciliationParamModel paramModel) {
        DynamicObject planDynamicObject = QueryServiceHelper.queryOne((String)"frm_reconciliation_scheme", (String)"reconciliactionconfig", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)recPlanId)});
        DynamicObject dataRule = ReconciliationUtil.getDataRule((Long)planDynamicObject.getLong("reconciliactionconfig"), null);
        CustomParamUtil.setCustomParam(paramModel, dataRule);
        AbstractCustomParamService customService = CustomParamUtil.getCustomService(paramModel);
        Long planDetailId = paramModel.getPlanDetailId();
        HashMap<Integer, String> indexAssistMap = new HashMap<Integer, String>(16);
        BizReconPlanModel planModel = ReconModelCacheHelper.getPlanModel((String)String.valueOf(recPlanId));
        if (planModel.getDetail() != null) {
            BizReconPlanDetailModel detailModel = null;
            for (BizReconPlanDetailModel planDetailModel : planModel.getDetail()) {
                if (!planDetailModel.getId().equals(planDetailId)) continue;
                detailModel = planDetailModel;
                break;
            }
            if (detailModel != null) {
                ReconciliationUtil.planDetailAssist((BizReconPlanDetailModel)detailModel, (Long)paramModel.getOrgIds().toArray(new Long[0])[0]);
                Map originAssistIndexMap = detailModel.getBizAssistIndexMap();
                originAssistIndexMap.forEach((k, v) -> customService.fillIndexAssistMap((String)k, (Integer)v, (Map<Integer, String>)indexAssistMap));
            }
        }
        return indexAssistMap;
    }

    public static void initBaseData(List<Row> rowList, List<String> fieldNameList, Map<Integer, String> indexAssistMap, Map<String, Map<String, String>> baseDataName, Map<String, String> vchMap, Map<Object, DynamicObject> acctMaps, boolean isVchIdStr) {
        HashSet<Long> acctIds = new HashSet<Long>(6);
        HashMap<String, Set> needQueryBaseData = new HashMap<String, Set>(10);
        ArrayList<String> vchIds = new ArrayList<String>(rowList.size());
        for (Row row : rowList) {
            String vchId;
            Long billId = row.getLong("billid");
            if (0L != billId) {
                for (int i = 1; i <= 8; ++i) {
                    Long assistId;
                    if (indexAssistMap.get(i) == null) continue;
                    Set assistIdSet = needQueryBaseData.computeIfAbsent(indexAssistMap.get(i), k -> new HashSet(20));
                    String assistField = "assist" + i + "_app";
                    if (!fieldNameList.contains(assistField) || (assistId = row.getLong(assistField)) == null || assistId == 0L) continue;
                    assistIdSet.add(assistId);
                }
            }
            if (!StringUtils.isNotEmpty((String)(vchId = row.getString("vchid"))) || "0".equals(vchId) || vchIds.contains(vchId)) continue;
            vchIds.add(vchId);
            acctIds.add(row.getLong("account"));
        }
        baseDataName.putAll(ReconciliationUtil.getBaseDataName(needQueryBaseData));
        if (!isVchIdStr) {
            List<Long> vchIdList = vchIds.stream().map(Long::parseLong).collect(Collectors.toList());
            boolean enableAlgox = Boolean.parseBoolean(System.getProperty("prop.fi.ai.recon.algox", "false"));
            Integer bigdataBatchSize = FaBillParamUtils.getIntegerValue((Long)0L, (String)"frm_bigdata_batch_size");
            int batchSize = bigdataBatchSize == null ? 100000 : bigdataBatchSize;
            DataSet dataSet = null;
            if (vchIds.size() > batchSize) {
                dataSet = enableAlgox ? DetailDataFormat.queryVoucherByAlgox(vchIdList, batchSize) : DetailDataFormat.queryVoucherBySplit(vchIdList, batchSize);
            } else if (vchIdList.size() > 0) {
                dataSet = QueryServiceHelper.queryDataSet((String)"gl_voucher_detail_data_format", (String)"gl_voucher", (String)"id, vouchertype.name type, billno", (QFilter[])new QFilter[]{new QFilter("id", "in", vchIdList)}, null);
            }
            if (dataSet != null) {
                for (Row row : dataSet) {
                    vchMap.put(row.getString("id"), row.getString("type") + " " + row.getString("billno"));
                }
            }
        }
        if (acctMaps != null) {
            acctMaps.putAll(BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (QFilter[])new QFilter("id", "in", acctIds).toArray()));
        }
    }

    private static DataSet queryVoucherByAlgox(List<Long> vchIdList, int billSize) {
        OrmInput input;
        String algoKey = "kd.fi.frm.mservice.gldata.DetailDataFormat";
        String entityName = "gl_voucher";
        String selectFields = "id, vouchertype.name type, billno";
        ArrayList<OrmInput> inputList = new ArrayList<OrmInput>();
        while (vchIdList.size() >= billSize) {
            ArrayList<Long> tmpBillIdList = new ArrayList<Long>(billSize);
            tmpBillIdList.addAll(vchIdList.subList(0, billSize));
            input = new OrmInput(algoKey, entityName, selectFields, new QFilter[]{new QFilter("id", "in", tmpBillIdList)});
            inputList.add(input);
            vchIdList = DetailDataFormat.removeAll(vchIdList, tmpBillIdList);
        }
        if (vchIdList.size() > 0) {
            input = new OrmInput(algoKey, entityName, selectFields, new QFilter[]{new QFilter("id", "in", vchIdList)});
            inputList.add(input);
        }
        JobSession session = AlgoX.createSession((String)DaptrackerService.class.getName(), (String)"voucher");
        DataSetX dataSetx = session.fromInput(inputList.toArray(new Input[0]));
        DataSetOutput resultSet = new DataSetOutput(dataSetx.getRowMeta());
        dataSetx.output((Output)resultSet);
        int timeoutTime = Math.max(180, Integer.parseInt(System.getProperty("prop.fi.ai.thread.timeoutsecs", Integer.toString(180))));
        session.commit(timeoutTime, TimeUnit.SECONDS);
        return session.readDataSet(resultSet.getId());
    }

    private static DataSet queryVoucherBySplit(List<Long> vchIdList, int billSize) {
        DataSet result = null;
        while (vchIdList.size() >= billSize) {
            ArrayList<Long> tmpBillIdList = new ArrayList<Long>(billSize);
            tmpBillIdList.addAll(vchIdList.subList(0, billSize));
            QFilter qFilter = new QFilter("id", "in", tmpBillIdList);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"gl_voucher_detail_data_format", (String)"gl_voucher", (String)"id, vouchertype.name type, billno", (QFilter[])new QFilter[]{qFilter}, null);
            result = result == null ? dataSet : result.union(dataSet);
            vchIdList = DetailDataFormat.removeAll(vchIdList, tmpBillIdList);
        }
        if (vchIdList.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", vchIdList);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"gl_voucher_detail_data_format", (String)"gl_voucher", (String)"id, vouchertype.name type, billno", (QFilter[])new QFilter[]{qFilter}, null);
            result = result == null ? dataSet : result.union(dataSet);
        }
        return result;
    }

    public static List<Long> removeAll(List<Long> data, List<Long> beDelete) {
        LinkedList<Long> linkedList = new LinkedList<Long>(data);
        HashSet<Long> hashSet = new HashSet<Long>(beDelete);
        linkedList.removeIf(hashSet::contains);
        return linkedList;
    }

    public static String getBizAssist(Map<Integer, String> indexAssitMap, Map<String, Map<String, String>> baseDataName, Row item) {
        StringBuilder appAssistName = new StringBuilder();
        for (int j = 1; j <= 8; ++j) {
            MainEntityType dataEntityType;
            String entityKey = indexAssitMap.get(j);
            if (StringUtils.isEmpty((String)entityKey)) continue;
            String[] entitySplit = entityKey.split("\\.");
            String assistPrefix = "";
            if (AssistDataType.isBaseDataType((String)entitySplit[0])) {
                dataEntityType = MetadataServiceHelper.getDataEntityType((String)entitySplit[1]);
                assistPrefix = dataEntityType.getDisplayName().getLocaleValue();
            } else {
                dataEntityType = (DynamicObject)ThreadCache.get((Object)entitySplit[1], () -> BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(entitySplit[1]), (String)"bos_assistantdatagroup", (String)"name"));
                if (dataEntityType != null) {
                    assistPrefix = dataEntityType.getString("name");
                }
            }
            Map<String, String> assistId2NameMap = baseDataName.get(entityKey);
            Long appAssistVal = item.getLong("assist" + j + "_app");
            appAssistName.append(assistPrefix).append(":");
            if (appAssistVal != null && appAssistVal != 0L) {
                appAssistName.append(assistId2NameMap.get(String.valueOf(appAssistVal)));
            }
            appAssistName.append(";");
        }
        if (appAssistName.lastIndexOf(";") > -1) {
            appAssistName.deleteCharAt(appAssistName.length() - 1);
        }
        return appAssistName.toString();
    }

    public static DataSet getExportDataSet(boolean enableMore, String taskId, String batchNo, Long recPlanId, ReconciliationParamModel paramModel, boolean showAll) {
        ArrayList<String> fieldNameList = new ArrayList<String>(16);
        List<Row> diffList = DetailDataFormat.getDiffList(enableMore, fieldNameList, batchNo, taskId, showAll);
        if (CollectionUtils.isEmpty(diffList)) {
            return null;
        }
        DynamicObject bizAppConfig = RptBizAppConfigServiceHelper.getBizAppRefGlConfig(paramModel.getAppIds().toArray(new String[0])[0]);
        boolean isVchIdStr = bizAppConfig != null && "2".equals(bizAppConfig.getString("vchidtype"));
        Map<Integer, String> indexAssistMap = DetailDataFormat.initAssistIndexMap(recPlanId, paramModel);
        HashMap<String, Map<String, String>> baseDataName = new HashMap<String, Map<String, String>>(5);
        HashMap<String, String> vchMap = new HashMap<String, String>(1000);
        DetailDataFormat.initBaseData(diffList, fieldNameList, indexAssistMap, baseDataName, vchMap, null, isVchIdStr);
        Algo algo = Algo.create((String)"DetailDataFormat");
        DataSetBuilder builder = algo.createDataSetBuilder(FRMDataSetModel.getDetailExportRowMeta());
        for (int i = 0; i < diffList.size(); ++i) {
            Object[] objects = new Object[FRMDataSetModel.EXPORT_FIELD.length];
            Arrays.fill(objects, null);
            Row item = diffList.get(i);
            Long billId = item.getLong("billid");
            boolean hasBill = billId != 0L;
            String vchId = item.getString("vchid");
            boolean hasVch = StringUtils.isNotEmpty((String)vchId) && !"0".equals(vchId);
            String billEntity = item.getString("billentity");
            if (StringUtils.isNotEmpty((String)billEntity)) {
                objects[0] = item.getString("billorg");
                objects[1] = MetadataServiceHelper.getDataEntityType((String)billEntity).getDisplayName().getLocaleValue();
            }
            if (hasBill) {
                objects[2] = item.getString("billno");
                objects[3] = DetailDataFormat.getBizAssist(indexAssistMap, baseDataName, item);
                objects[4] = item.getBigDecimal("billamount");
                objects[5] = item.getString("bizdc");
            }
            if (hasVch) {
                objects[6] = item.getLong("account");
                objects[7] = isVchIdStr ? item.getString("rptvchno") : vchMap.get(vchId);
                objects[8] = item.getInteger("vchdc");
            }
            objects[9] = item.getBigDecimal("bizamt");
            objects[10] = item.getBigDecimal("glamt");
            objects[11] = item.getBigDecimal("diff");
            objects[12] = item.getLong("pid");
            Integer nodeSize = item.getInteger("nodesize");
            if (hasBill && nodeSize != null && nodeSize > 1) {
                objects[10] = BigDecimal.ZERO;
            }
            if (hasVch && nodeSize != null && nodeSize > 1) {
                objects[4] = BigDecimal.ZERO;
            }
            builder.append(objects);
        }
        return builder.build();
    }

    public static List<Row> getDiffList(boolean dapMulEnable, List<String> fieldNameList, String batchNo, String taskId, boolean showAll) {
        List<Object> diffList = new ArrayList(1);
        if (dapMulEnable) {
            String cacheId = AppCacheHelper.getTaskCache((String)(batchNo + ".detail.row"), (String)taskId);
            CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cacheId);
            if (cacheDataSet.getRowCount() > 0) {
                diffList = cacheDataSet.getList(0, cacheDataSet.getRowCount());
                fieldNameList.addAll(Arrays.asList(cacheDataSet.getRowMeta().getFieldNames()));
            }
        } else {
            diffList = DetailDataFormat.initCacheRowList(fieldNameList, taskId, showAll);
        }
        return diffList;
    }
}

