/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.gldata;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.fi.frm.common.enums.BalanceDcEnum;
import kd.fi.frm.common.enums.ReconAmountTypeEnum;
import kd.fi.frm.common.model.BaseGlDataParam;
import kd.fi.frm.common.model.FRMDataSetModel;
import kd.fi.frm.common.model.FrmLogger;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.gldata.GLDataParam;
import kd.fi.frm.common.util.FrmQueryServiceHelper;
import kd.fi.frm.common.util.ReconciliationUtil;
import kd.fi.frm.mservice.gldata.AbstractGLDataService;

public class GLDataService
extends AbstractGLDataService {
    private GLDataParam glDataParam = (GLDataParam)this.param;

    public GLDataService(GLDataParam param, ReconciliationParamModel paramModel) {
        super((BaseGlDataParam)param, paramModel);
        this.rowMeta = FRMDataSetModel.getGLAcctRowMeta();
    }

    @Override
    public DataSet execute() {
        List<QFilter>[] queryFilter = this.getQueryFilter();
        QFilter currencyFilter = null;
        if (this.glDataParam.isSpecialCurrency()) {
            currencyFilter = new QFilter("currency", "in", (Object)this.glDataParam.getCurrencyIds());
        }
        queryFilter[0].add(currencyFilter);
        queryFilter[1].add(currencyFilter);
        String balanceSelector = this.getSelectField();
        QFilter[] equalPeriodFilters = queryFilter[0].toArray(new QFilter[0]);
        this.getGLAmount(balanceSelector, equalPeriodFilters, Boolean.TRUE);
        ReconAmountTypeEnum reconAmountType = this.glDataParam.getReconAmountType();
        if (ReconAmountTypeEnum.DEBIT_CREDIT_CLOSE == reconAmountType || this.paramModel.isInit()) {
            QFilter[] lessPeriodFilters = queryFilter[1].toArray(new QFilter[0]);
            this.getGLAmount(balanceSelector, lessPeriodFilters, Boolean.FALSE);
        }
        return this.getDataSet(this.cacheRows, this.paramModel.getDataType());
    }

    private void getGLAmount(String balanceSelector, QFilter[] filters, boolean periodEqual) {
        block37: {
            StringBuilder sbLog = new StringBuilder("ReconService4Account.GLDataService.getGlAmount.round-: select ");
            sbLog.append(balanceSelector).append(" from t_gl_balance where ").append(Arrays.toString(filters));
            this.logger.info(sbLog.toString());
            try (DataSet ds = FrmQueryServiceHelper.queryDataSet((FrmLogger)this.frmLogger, (String)this.getClass().getName(), (String)"gl_balance", (String)balanceSelector, (QFilter[])filters, null);){
                if (this.param.isInit()) {
                    String sumAmountField = periodEqual ? "beginlocal" : "endlocal";
                    try (DataSet sumData = ds.groupBy(new String[]{"currency", "account"}).sum(sumAmountField).finish().select("currency,account," + sumAmountField + " beginlocal");){
                        this.frmLogger.logDataSet("sumData:", sumData);
                        this.getAmounts(sumData, periodEqual);
                        break block37;
                    }
                }
                try (DataSet sumData = ds.groupBy(new String[]{"currency", "account"}).sum("beginlocal").sum("debitlocal").sum("creditlocal").sum("endlocal").finish();){
                    this.frmLogger.logDataSet("sumData:", sumData);
                    this.getAmounts(sumData, periodEqual);
                }
            }
        }
    }

    private void getAmounts(DataSet ds, boolean periodEqual) {
        Long currencyId = null;
        Long localCurrency = this.glDataParam.getCurrencyIds().toArray(new Long[0])[0];
        BalanceDcEnum balanceDc = this.param.getBalanceDc();
        for (Row row : ds) {
            Object[] amountValues;
            currencyId = this.glDataParam.isLocalCurrency() ? localCurrency : row.getLong("currency");
            BigDecimal beginLoc = row.getBigDecimal("beginlocal");
            BigDecimal debitLoc = null;
            BigDecimal creditLoc = null;
            BigDecimal endLoc = BigDecimal.ZERO;
            if (!this.param.isInit()) {
                endLoc = row.getBigDecimal("endlocal");
            }
            if (balanceDc != BalanceDcEnum.EMPTY) {
                int accountDc = (Integer)this.dcMap.get(row.getLong("account"));
                if (accountDc == -1) {
                    BigDecimal accountDcBigDecimal = new BigDecimal(accountDc);
                    beginLoc = beginLoc.multiply(accountDcBigDecimal);
                    endLoc = endLoc.multiply(accountDcBigDecimal);
                }
                if (balanceDc != ReconciliationUtil.getBalanceDc((int)accountDc)) {
                    BigDecimal balanceDcBigDecimal = new BigDecimal(-1);
                    beginLoc = beginLoc.multiply(balanceDcBigDecimal);
                    endLoc = endLoc.multiply(balanceDcBigDecimal);
                }
            }
            if (this.param.isInit()) {
                if (beginLoc == null || BigDecimal.ZERO.compareTo(beginLoc) == 0) continue;
                amountValues = new Object[]{currencyId, beginLoc, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
                this.cacheRows.add(amountValues);
                continue;
            }
            if (periodEqual) {
                debitLoc = row.getBigDecimal("debitlocal");
                creditLoc = row.getBigDecimal("creditlocal");
                this.cacheRows.add(new Object[]{currencyId, beginLoc, debitLoc, creditLoc, endLoc});
                continue;
            }
            amountValues = new Object[]{currencyId, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
            amountValues[1] = endLoc;
            amountValues[4] = endLoc;
            this.cacheRows.add(amountValues);
        }
    }

    private String getSelectField() {
        String balanceSelector = null;
        if (this.param.isInit()) {
            balanceSelector = this.glDataParam.isLocalCurrency() ? "beginlocal,endlocal,currency,account" : "beginfor beginlocal,endfor endlocal,currency,account";
        } else if (this.glDataParam.isLocalCurrency()) {
            switch (this.param.getReconAmountType()) {
                case DEBIT: {
                    balanceSelector = "0 beginlocal,currency,account,debitlocal,0 creditlocal,0 endlocal";
                    break;
                }
                case CREDIT: {
                    balanceSelector = "0 beginlocal,currency,account,0 debitlocal,creditlocal,0 endlocal";
                    break;
                }
                case DEBIT_CREDIT: {
                    balanceSelector = "0 beginlocal,currency,account,debitlocal,creditlocal,0 endlocal";
                    break;
                }
                case DEBIT_CREDIT_CLOSE: {
                    balanceSelector = "beginlocal,currency,account,debitlocal,creditlocal,endlocal";
                    break;
                }
            }
        } else {
            switch (this.param.getReconAmountType()) {
                case DEBIT: {
                    balanceSelector = "account,0 beginlocal,currency,debitfor debitlocal,0 creditlocal,0 endlocal";
                    break;
                }
                case CREDIT: {
                    balanceSelector = "account,0 beginlocal,currency,0 debitlocal,creditfor creditlocal,0 endlocal";
                    break;
                }
                case DEBIT_CREDIT: {
                    balanceSelector = "account,0 beginlocal,currency,debitfor debitlocal,creditfor creditlocal,0 endlocal";
                    break;
                }
                case DEBIT_CREDIT_CLOSE: {
                    balanceSelector = "account,beginfor beginlocal,currency,debitfor debitlocal,creditfor creditlocal,endfor endlocal";
                    break;
                }
            }
        }
        return balanceSelector;
    }
}

