/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.gldata;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.frm.common.enums.AssistTypeEnum;
import kd.fi.frm.common.enums.BalanceDcEnum;
import kd.fi.frm.common.enums.ReconAmountTypeEnum;
import kd.fi.frm.common.model.BaseGlDataParam;
import kd.fi.frm.common.model.FRMDataSetModel;
import kd.fi.frm.common.model.FrmLogger;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model2.GLAccountConfig2;
import kd.fi.frm.common.model2.GLDataParam2;
import kd.fi.frm.common.util.FrmQueryServiceHelper;
import kd.fi.frm.common.util.ReconciliationUtil;
import kd.fi.frm.mservice.gldata.AbstractGLDataService;

public class GLDataService2
extends AbstractGLDataService {
    private GLDataParam2 glDataParam = (GLDataParam2)this.param;

    public GLDataService2(GLDataParam2 param, ReconciliationParamModel paramModel) {
        super((BaseGlDataParam)param, paramModel);
        this.rowMeta = FRMDataSetModel.getGLRowMeta();
    }

    @Override
    public DataSet execute() {
        if (!this.glDataParam.isNeedQueryGl()) {
            this.logger.info("\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u67e5\u4e0d\u5230\u6570\u636e\uff0c\u4e0d\u67e5\u603b\u8d26\u76f4\u63a5\u8fd4\u56de\u3002");
            return this.buildEmptyGlDataSet();
        }
        List<QFilter>[] queryFilter = this.getQueryFilter();
        String balanceSelector = this.getSelectField();
        String fields = "fid,fperiodid,fendperiodid,faccounttableid,forgid,fbooktypeid,faccountid,fassgrpid,fcurrencyid,fbeginlocal,fdebitlocal,fcreditlocal,fendlocal";
        if (!this.glDataParam.isLocalCurrency()) {
            fields = "fid,fperiodid,fendperiodid,faccounttableid,forgid,fbooktypeid,faccountid,fassgrpid,fcurrencyid,fbeginfor,fdebitfor,fcreditfor,fendfor";
        }
        Object[] filters = queryFilter[0].toArray(new QFilter[0]);
        StringBuilder sbLog = new StringBuilder("ReconService4AccountAssist.GLDataService2.getGlAmount.round- equalPeriod: select ");
        sbLog.append(fields).append(" from t_gl_balance where ").append(Arrays.toString(filters));
        this.logger.info(sbLog.toString());
        try (DataSet ds = FrmQueryServiceHelper.queryDataSet((FrmLogger)this.frmLogger, (String)this.getClass().getName(), (String)"gl_balance", (String)balanceSelector, (QFilter[])filters, null);
             DataSet sumData = ds.groupBy(new String[]{"currency", "assvals", "assgrp", "account"}).sum("beginlocal").sum("debitlocal").sum("creditlocal").sum("endlocal").finish();){
            this.frmLogger.logDataSet("sumData:", sumData);
            this.getAmounts(this.glDataParam.getAccountConfig(), sumData, !CollectionUtils.isEmpty((Collection)this.glDataParam.getAccountConfig().getFlexfields()), Boolean.TRUE);
        }
        ReconAmountTypeEnum reconAmountType = this.glDataParam.getReconAmountType();
        if (ReconAmountTypeEnum.DEBIT_CREDIT_CLOSE == reconAmountType || this.paramModel.isInit()) {
            filters = queryFilter[1].toArray(new QFilter[0]);
            sbLog = new StringBuilder("ReconService4AccountAssist.GLDataService2.getGlAmount.round- lessPeriod: select ");
            sbLog.append(fields).append(" from t_gl_balance where ").append(Arrays.toString(filters));
            this.logger.info(sbLog.toString());
            try (DataSet ds = FrmQueryServiceHelper.queryDataSet((FrmLogger)this.frmLogger, (String)this.getClass().getName(), (String)"gl_balance", (String)balanceSelector, (QFilter[])filters, null);
                 DataSet sumData = ds.groupBy(new String[]{"currency", "assvals", "assgrp", "account"}).sum("beginlocal").sum("debitlocal").sum("creditlocal").sum("endlocal").finish();){
                this.frmLogger.logDataSet("sumData:", sumData);
                this.getAmounts(this.glDataParam.getAccountConfig(), sumData, !CollectionUtils.isEmpty((Collection)this.glDataParam.getAccountConfig().getFlexfields()), Boolean.FALSE);
            }
        }
        return this.getDataSet(this.cacheRows, this.paramModel.getDataType());
    }

    private void getAmounts(GLAccountConfig2 cfg, DataSet ds, boolean assist, boolean periodEqual) {
        if (assist) {
            boolean isAssist = false;
            if (this.glDataParam.getType() == AssistTypeEnum.Assist) {
                isAssist = true;
            }
            Map assistValueRange = cfg.getAssistValueRange();
            String[] bizAssistVal = this.glDataParam.getAssistIndexMap().keySet().toArray(new String[0]);
            Long currencyId = null;
            BalanceDcEnum balanceDc = this.param.getBalanceDc();
            for (Row row : ds) {
                Object[] values = new Object[this.rowMeta.getFieldNames().length];
                currencyId = this.glDataParam.isLocalCurrency() ? Long.valueOf(this.glDataParam.getCurrencyId()) : row.getLong("currency");
                values[0] = currencyId;
                String assvals = row.getString("assvals");
                HashMap resultMap = new HashMap(5);
                if (StringUtils.isNotEmpty((String)assvals)) {
                    Map dimDataMap = (Map)SerializationUtils.fromJsonString((String)assvals, Map.class);
                    Map flexMap = ReconciliationUtil.getFlexMap(dimDataMap.keySet(), (Set)cfg.getAsstTypeflexIds());
                    boolean allEmpty = true;
                    boolean unMatch = false;
                    for (String flexId : this.glDataParam.getAccountConfig().getAsstTypeflexIds()) {
                        Object value = dimDataMap.get(flexId);
                        if (value == null) {
                            value = "0";
                        } else {
                            allEmpty = false;
                        }
                        Set assistValueRange_one = (Set)assistValueRange.get(flexId);
                        if (assistValueRange_one != null && !assistValueRange_one.contains(Long.parseLong(value.toString()))) {
                            unMatch = true;
                            break;
                        }
                        resultMap.put(flexMap.get(flexId), value);
                    }
                    if (unMatch || allEmpty && this.glDataParam.getAccountConfig().isIgnoreEmpty()) continue;
                    Long assgrpId = row.getLong("assgrp");
                    values[13] = assgrpId;
                    if (isAssist) {
                        for (String flex : cfg.getAsstTypeflexIds()) {
                            if (resultMap.containsKey(flexMap.get(flex))) continue;
                            resultMap.put(flexMap.get(flex), "0");
                        }
                    }
                } else {
                    if (cfg.hasAssistValueRange() || this.glDataParam.getAccountConfig().isIgnoreEmpty()) continue;
                    Long assgrpId = row.getLong("assgrp");
                    values[13] = assgrpId;
                    for (String flex : this.glDataParam.getAssistIndexMap().keySet()) {
                        resultMap.put(flex, "0");
                    }
                }
                for (int i = 1; i <= 8; ++i) {
                    values[i] = 0L;
                }
                for (Map.Entry entry : this.glDataParam.getAssistIndexMap().entrySet()) {
                    values[((Integer)entry.getValue()).intValue() + 1] = resultMap.get(entry.getKey());
                }
                BigDecimal beginLoc = null;
                BigDecimal debitLoc = null;
                BigDecimal creditLoc = null;
                BigDecimal endLoc = null;
                if (periodEqual) {
                    beginLoc = row.getBigDecimal("beginlocal");
                    debitLoc = row.getBigDecimal("debitlocal");
                    creditLoc = row.getBigDecimal("creditlocal");
                    endLoc = row.getBigDecimal("endlocal");
                } else {
                    beginLoc = row.getBigDecimal("endlocal");
                    debitLoc = BigDecimal.ZERO;
                    creditLoc = BigDecimal.ZERO;
                    endLoc = row.getBigDecimal("endlocal");
                }
                if (balanceDc != BalanceDcEnum.EMPTY) {
                    int accountDc = (Integer)this.dcMap.get(row.getLong("account"));
                    if (accountDc == -1) {
                        BigDecimal accountDcBigDecimal = new BigDecimal(accountDc);
                        beginLoc = beginLoc.multiply(accountDcBigDecimal);
                        endLoc = endLoc.multiply(accountDcBigDecimal);
                    }
                    if (balanceDc != ReconciliationUtil.getBalanceDc((int)accountDc)) {
                        BigDecimal balanceDcBigDecimal = new BigDecimal(-1);
                        beginLoc = beginLoc.multiply(balanceDcBigDecimal);
                        endLoc = endLoc.multiply(balanceDcBigDecimal);
                    }
                }
                values[9] = beginLoc == null ? BigDecimal.ZERO : beginLoc;
                values[10] = debitLoc == null ? BigDecimal.ZERO : debitLoc;
                values[11] = creditLoc == null ? BigDecimal.ZERO : creditLoc;
                values[12] = endLoc == null ? BigDecimal.ZERO : endLoc;
                values[14] = row.getString("account");
                this.cacheRows.add(values);
            }
        }
    }

    private String getSelectField() {
        String balanceSelector = null;
        if (this.param.isInit()) {
            balanceSelector = this.glDataParam.isLocalCurrency() ? "account,assgrp.id assgrp, assgrp.value assvals,beginlocal,currency,debitlocal,creditlocal,endlocal" : "account,assgrp.id assgrp, assgrp.value assvals,beginfor beginlocal,currency,debitfor debitlocal,creditfor creditlocal,endfor endlocal";
        } else if (this.glDataParam.isLocalCurrency()) {
            switch (this.param.getReconAmountType()) {
                case DEBIT: {
                    balanceSelector = "account,assgrp.id assgrp, assgrp.value assvals,0 beginlocal,currency,debitlocal,0 creditlocal,0 endlocal";
                    break;
                }
                case CREDIT: {
                    balanceSelector = "account,assgrp.id assgrp, assgrp.value assvals,0 beginlocal,currency,0 debitlocal,creditlocal,0 endlocal";
                    break;
                }
                case DEBIT_CREDIT: {
                    balanceSelector = "account,assgrp.id assgrp, assgrp.value assvals,0 beginlocal,currency,debitlocal,creditlocal,0 endlocal";
                    break;
                }
                case DEBIT_CREDIT_CLOSE: {
                    balanceSelector = "account,assgrp.id assgrp, assgrp.value assvals,beginlocal,currency,debitlocal,creditlocal,endlocal";
                    break;
                }
            }
        } else {
            switch (this.param.getReconAmountType()) {
                case DEBIT: {
                    balanceSelector = "account,assgrp.id assgrp, assgrp.value assvals,0 beginlocal,currency,debitfor debitlocal,0 creditlocal,0 endlocal";
                    break;
                }
                case CREDIT: {
                    balanceSelector = "account,assgrp.id assgrp, assgrp.value assvals,0 beginlocal,currency,0 debitlocal,creditfor creditlocal,0 endlocal";
                    break;
                }
                case DEBIT_CREDIT: {
                    balanceSelector = "account,assgrp.id assgrp, assgrp.value assvals,0 beginlocal,currency,debitfor debitlocal,creditfor creditlocal,0 endlocal";
                    break;
                }
                case DEBIT_CREDIT_CLOSE: {
                    balanceSelector = "account,assgrp.id assgrp, assgrp.value assvals,beginfor beginlocal,currency,debitfor debitlocal,creditfor creditlocal,endfor endlocal";
                    break;
                }
            }
        }
        return balanceSelector;
    }
}

