/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.frm.common.enums.AssistTypeEnum;
import kd.fi.frm.common.enums.ReconAmountTypeEnum;
import kd.fi.frm.common.enums.ReconcilationResultEnum;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanDetailModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanModel;
import kd.fi.frm.common.task.TaskDao;
import kd.fi.frm.common.task.TaskInfo;
import kd.fi.frm.common.util.ReconciliationParmUtil;
import kd.fi.frm.common.util.ReconciliationUtil;
import kd.fi.frm.mservice.AssistMappingUtil;
import kd.fi.frm.mservice.algo.DistinctConcatAggFunction;
import kd.fi.frm.mservice.bizdata.ext.custom.AbstractCustomParamService;
import kd.fi.frm.mservice.bizdata.ext.custom.CustomParamUtil;
import kd.fi.frm.mservice.impl.ReconServiceHelper;
import kd.fi.frm.mservice.model.AssistMappingModel;

public abstract class AbstractReconTabService {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected ReconciliationParamModel paramModel;
    protected BizReconPlanDetailModel planDetailModel;
    protected BizReconPlanModel planModel;
    protected ReconcilationResultEnum reconCode = ReconcilationResultEnum.Pass;

    public AbstractReconTabService(ReconciliationParamModel paramModel, BizReconPlanModel planModel, BizReconPlanDetailModel planDetailModel) {
        this.paramModel = paramModel;
        this.planDetailModel = planDetailModel;
        this.planModel = planModel;
    }

    public ReconcilationResultEnum getReconCode() {
        return this.reconCode;
    }

    protected abstract int getReconTabIndex();

    public abstract DataSet getGlAmount();

    public void execute(BizReconPlanModel planModel, Long orgId, String appId, DynamicObject dataRule, TaskInfo taskInfo, Boolean enablePlatformThreadPool) {
        if (TaskDao.isTaskOver((TaskInfo)taskInfo)) {
            return;
        }
        ReconciliationUtil.planDetailAssist((BizReconPlanDetailModel)this.planDetailModel, (Long)orgId);
        AbstractCustomParamService customParamService = CustomParamUtil.paramConversion(this.paramModel, this.planDetailModel, orgId);
        List params = ReconciliationParmUtil.getDataRuleParam((BizReconPlanDetailModel)this.planDetailModel, (DynamicObject)dataRule, (List)this.planDetailModel.getAmountTypeList(), (ReconciliationParamModel)this.paramModel, (Long)orgId, (ReconAmountTypeEnum)planModel.getReconAmountType());
        long bizStart = System.currentTimeMillis();
        DataSet bizDataSet = ReconServiceHelper.getBizData(this.paramModel, params, orgId, appId, taskInfo, this.planDetailModel, customParamService, enablePlatformThreadPool);
        bizStart = System.currentTimeMillis() - bizStart;
        this.logger.info("taikId:{},planDetailId:{},\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u8017\u65f6\uff1a{}", new Object[]{taskInfo.getId(), this.planDetailModel.getId(), bizStart});
        if (TaskDao.isTaskOver((TaskInfo)taskInfo)) {
            return;
        }
        long glStart = System.currentTimeMillis();
        DataSet glDataSet = this.getGlAmount();
        glStart = System.currentTimeMillis() - glStart;
        this.logger.info("taikId:{},planDetailId:{},\u83b7\u53d6\u603b\u8d26\u6570\u636e\u8017\u65f6\uff1a{}", new Object[]{taskInfo.getId(), this.planDetailModel.getId(), glStart});
        if (TaskDao.isTaskOver((TaskInfo)taskInfo)) {
            return;
        }
        bizDataSet = this.getReconTabIndex() != AssistTypeEnum.Acct.getValue() ? this.bizAssistDataMapping(bizDataSet) : bizDataSet.addNullField(new String[]{"app_show_assist1", "app_show_assist2", "app_show_assist3", "app_show_assist4", "app_show_assist5", "app_show_assist6", "app_show_assist7", "app_show_assist8"});
        this.paramModel.getFrmLogger().logDataSet("before joinDataSet bizdata", bizDataSet);
        this.paramModel.getFrmLogger().logDataSet("before joinDataSet gldata", glDataSet);
        long mergeStart = System.currentTimeMillis();
        boolean reconEqual = ReconServiceHelper.joinDataSet(this.paramModel, planModel, this.planDetailModel, bizDataSet, glDataSet, this.getReconTabIndex());
        mergeStart = System.currentTimeMillis() - mergeStart;
        this.logger.info("taikId:{},planDetailId:{},\u5408\u5e76\u4e1a\u52a1\u4e0e\u603b\u8d26\u6570\u636e\u8017\u65f6\uff1a{}", new Object[]{taskInfo.getId(), this.planDetailModel.getId(), mergeStart});
        if (!reconEqual) {
            this.reconCode = ReconcilationResultEnum.fail;
        }
    }

    public DataSet bizAssistDataMapping(DataSet bizDataSet) {
        ArrayList<String> assistShowFields = new ArrayList<String>(Arrays.asList("app_show_assist1", "app_show_assist2", "app_show_assist3", "app_show_assist4", "app_show_assist5", "app_show_assist6", "app_show_assist7", "app_show_assist8"));
        bizDataSet = bizDataSet.addNullField(new String[]{"app_map_assist1", "app_map_assist2", "app_map_assist3", "app_map_assist4", "app_map_assist5", "app_map_assist6", "app_map_assist7", "app_map_assist8"});
        Map assistDataMapping = this.planDetailModel.getAssistDataMapping();
        final Map bizAssistIndexMap = this.planDetailModel.getBizAssistIndexMap();
        Map glAssistIndexMap = this.planDetailModel.getGlAssistIndexMap();
        ArrayList<Integer> mappingGroupConcatFields = new ArrayList<Integer>();
        for (Map.Entry glAssistEntry : glAssistIndexMap.entrySet()) {
            String asstDimKey = (String)glAssistEntry.getKey();
            final int asstDimSeq = 1 + (Integer)glAssistEntry.getValue();
            Long mappingId = (Long)assistDataMapping.get(glAssistEntry.getKey());
            if (mappingId != null && mappingId != 0L) {
                final AssistMappingModel assistMappingInfo = AssistMappingUtil.getAssistMappingInfo(mappingId, this.paramModel.getTaskInfo().getOrgId(), this.planDetailModel.getBizAssistIndexMap());
                if (assistMappingInfo == null) {
                    this.logger.warn("\u6838\u7b97\u7ef4\u5ea6\u6620\u5c04[]\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u5bf9\u8d26\u65b9\u6848\u914d\u7f6e", (Object)mappingId);
                    continue;
                }
                final List mappingAsistIndexMap = assistMappingInfo.getBizAssistIndexMap().stream().sorted(Comparator.comparing(tp -> (Integer)bizAssistIndexMap.get(tp.item1))).collect(Collectors.toList());
                ArrayList<String> asstDimMappingBizDims = new ArrayList<String>(bizAssistIndexMap.size());
                for (Tuple mappingField : mappingAsistIndexMap) {
                    int seq = (Integer)bizAssistIndexMap.get(mappingField.item1);
                    asstDimMappingBizDims.add("assist" + seq + "_app");
                }
                final RowMeta rowMeta = bizDataSet.getRowMeta();
                List<String> queryFields = Arrays.stream(rowMeta.getFields()).map(Field::getName).filter(key -> !asstDimMappingBizDims.contains(key)).collect(Collectors.toList());
                queryFields.add(String.format("concat(%s) app_show_assist" + asstDimSeq, String.join((CharSequence)",\",\",", asstDimMappingBizDims)));
                assistShowFields.remove("app_show_assist" + asstDimSeq);
                mappingGroupConcatFields.add(asstDimSeq);
                bizDataSet = bizDataSet.map(new MapFunction(){
                    private static final long serialVersionUID = 5931480419734199762L;

                    public Object[] map(Row row) {
                        StringBuilder appendValBuilder = new StringBuilder();
                        for (Tuple mappingField : mappingAsistIndexMap) {
                            int seq = (Integer)bizAssistIndexMap.get(mappingField.item1);
                            String assistVal = row.getString("assist" + seq + "_app");
                            appendValBuilder.append(assistVal).append(",");
                        }
                        String appendVal = appendValBuilder.substring(0, appendValBuilder.length() - 1);
                        long asstVal = -1L;
                        List<Tuple<String[], Long>> mappingData = assistMappingInfo.getMappingData();
                        for (Tuple<String[], Long> dataEntry : mappingData) {
                            CharSequence[] datas = (String[])dataEntry.item1;
                            String mapAppendVal = String.join((CharSequence)",", datas);
                            if (!mapAppendVal.equals(appendVal)) continue;
                            asstVal = (Long)dataEntry.item2;
                            break;
                        }
                        Object[] rowVal = new Object[rowMeta.getFields().length];
                        int index = 0;
                        for (Field field : rowMeta.getFields()) {
                            rowVal[index++] = field.getName().equals("app_map_assist" + asstDimSeq) ? Long.valueOf(asstVal) : row.get(field.getName());
                        }
                        return rowVal;
                    }

                    public RowMeta getResultRowMeta() {
                        return rowMeta;
                    }
                });
                bizDataSet = bizDataSet.select(queryFields.toArray(new String[0]));
                continue;
            }
            int bizAssistSeq = (Integer)bizAssistIndexMap.get(asstDimKey);
            assistShowFields.remove("app_show_assist" + asstDimSeq);
            bizDataSet = bizDataSet.addField("assist" + bizAssistSeq + "_app", "app_show_assist" + asstDimSeq);
            bizDataSet = bizDataSet.updateField("app_map_assist" + asstDimSeq, "assist" + bizAssistSeq + "_app");
        }
        bizDataSet = bizDataSet.addNullField(assistShowFields.toArray(new String[0]));
        bizDataSet = bizDataSet.updateFields(new String[]{"app_map_assist1", "app_map_assist2", "app_map_assist3", "app_map_assist4", "app_map_assist5", "app_map_assist6", "app_map_assist7", "app_map_assist8"}, new String[]{"case when app_map_assist1 is null then 0L else app_map_assist1 end", "case when app_map_assist2 is null then 0L else app_map_assist2 end", "case when app_map_assist3 is null then 0L else app_map_assist3 end", "case when app_map_assist4 is null then 0L else app_map_assist4 end", "case when app_map_assist5 is null then 0L else app_map_assist5 end", "case when app_map_assist6 is null then 0L else app_map_assist6 end", "case when app_map_assist7 is null then 0L else app_map_assist7 end", "case when app_map_assist8 is null then 0L else app_map_assist8 end"});
        DataSet[] splitMappingDataSet = bizDataSet.splitByFilter(new String[]{"app_map_assist1 = -1 or app_map_assist2 = -1 or app_map_assist3 = -1 or app_map_assist4 = -1 or app_map_assist5 = -1 or app_map_assist6 = -1 or app_map_assist7 = -1 or app_map_assist8 = -1"}, true);
        DataSet originBizDataSet = splitMappingDataSet[0];
        DataSet needMappingBizDataSet = splitMappingDataSet[1];
        ArrayList<String> groupByFields = new ArrayList<String>(Arrays.asList("currency", "app_map_assist1", "app_map_assist2", "app_map_assist3", "app_map_assist4", "app_map_assist5", "app_map_assist6", "app_map_assist7", "app_map_assist8"));
        for (int i = 1; i <= 8; ++i) {
            if (mappingGroupConcatFields.contains(i)) continue;
            String key2 = "app_show_assist" + i;
            groupByFields.add(key2);
        }
        GroupbyDataSet groupbyDataSet = needMappingBizDataSet.groupBy(groupByFields.toArray(new String[0]));
        for (Integer seq : mappingGroupConcatFields) {
            groupbyDataSet = groupbyDataSet.groupConcat("app_show_assist" + seq, "app_show_assist" + seq, ";");
        }
        needMappingBizDataSet = groupbyDataSet.agg((CustomAggFunction)new DistinctConcatAggFunction("distinctGroupConcat", (DataType)DataType.StringType), "rules", "rules").sum("openingbalance_app").sum("debitamount_app").sum("creditamount_app").sum("closingbalance_app").finish();
        needMappingBizDataSet = needMappingBizDataSet.select(new String[]{"currency", "rules", "app_map_assist1 assist1_app", "app_map_assist2 assist2_app", "app_map_assist3 assist3_app", "app_map_assist4 assist4_app", "app_map_assist5 assist5_app", "app_map_assist6 assist6_app", "app_map_assist7 assist7_app", "app_map_assist8 assist8_app", "app_show_assist1", "app_show_assist2", "app_show_assist3", "app_show_assist4", "app_show_assist5", "app_show_assist6", "app_show_assist7", "app_show_assist8", "openingbalance_app", "debitamount_app", "creditamount_app", "closingbalance_app"});
        originBizDataSet = originBizDataSet.select(new String[]{"currency", "rules", "app_map_assist1 assist1_app", "app_map_assist2 assist2_app", "app_map_assist3 assist3_app", "app_map_assist4 assist4_app", "app_map_assist5 assist5_app", "app_map_assist6 assist6_app", "app_map_assist7 assist7_app", "app_map_assist8 assist8_app", "app_show_assist1", "app_show_assist2", "app_show_assist3", "app_show_assist4", "app_show_assist5", "app_show_assist6", "app_show_assist7", "app_show_assist8", "openingbalance_app", "debitamount_app", "creditamount_app", "closingbalance_app"});
        bizDataSet = originBizDataSet.union(needMappingBizDataSet);
        return bizDataSet;
    }
}

