/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.Tracer;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.constant.ReconciliationFormConstant;
import kd.fi.frm.common.enums.AssistDataType;
import kd.fi.frm.common.enums.AssistTypeEnum;
import kd.fi.frm.common.enums.ReconAmountTypeEnum;
import kd.fi.frm.common.enums.ReconcilationResultEnum;
import kd.fi.frm.common.model.FrmLogger;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.bizdata.BizDataTypeEnum;
import kd.fi.frm.common.model.bizdata.BizReconPlanDetailModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanModel;
import kd.fi.frm.common.task.TaskDao;
import kd.fi.frm.common.task.TaskInfo;
import kd.fi.frm.common.task.TaskStatusEnum;
import kd.fi.frm.common.util.FaBillParamUtils;
import kd.fi.frm.common.util.RecAccountBookResult;
import kd.fi.frm.common.util.RecAccountBookUtil;
import kd.fi.frm.common.util.ReconciliationParmUtil;
import kd.fi.frm.common.util.ReconciliationUtil;
import kd.fi.frm.common.util.SystemParamHelper;
import kd.fi.frm.common.util.ThrowableHelper;
import kd.fi.frm.mservice.IReconciliationService;
import kd.fi.frm.mservice.ReconTabServiceExecutor;
import kd.fi.frm.mservice.bizdata.CommonFilterAnalyseUtil;
import kd.fi.frm.mservice.bizdata.ext.custom.CustomParamUtil;
import kd.fi.frm.mservice.impl.AbstractReconTabService;
import kd.fi.frm.mservice.impl.ReconServiceHelper;
import kd.fi.frm.mservice.rpt.RptBizAppConfigServiceHelper;

public class AbstractReconciliationService
implements IReconciliationService,
ReconciliationFormConstant {
    private static final Log logger = LogFactory.getLog(AbstractReconciliationService.class);
    private static final Integer MAX_POOL_SIZE = Integer.parseInt(System.getProperty("prop.fi.ai.recon.bizdata.maxpoolsize", "4"));
    private static final String SUB_THREAD_GROUP_NAME = "fi-ai-reconciliation-subbiz";
    private static final String SUB_THREAD_GROUP_ONLYSTATUS_NAME = "fi-ai-reconciliation-subbiz-onlystatus";
    private static Integer MAX_THREDTOMEOUT = 7200;
    public static final ThreadPool SUB_BIZ_THREAD_POOL = ThreadPools.newFixedThreadPool((String)"fi-ai-reconciliation-subbiz", (int)MAX_POOL_SIZE);
    public static final ThreadPool SUB_BIZ_ONLYSTATUS_THREAD_POOL = ThreadPools.newFixedThreadPool((String)"fi-ai-reconciliation-subbiz-onlystatus", (int)MAX_POOL_SIZE);
    private int type = 0;
    private static final Map<String, String> appMap = new HashMap<String, String>();
    protected ReconciliationParamModel paramModel = null;
    protected BizReconPlanModel planModel = null;
    protected DynamicObject dataRule = null;
    private FrmLogger frmLogger;
    protected boolean enablePlatformThreadPool;

    public static Integer getMAX_THREDTOMEOUT() {
        return MAX_THREDTOMEOUT;
    }

    public static void setMAX_THREDTOMEOUT(Integer mAX_THREDTOMEOUT) {
        MAX_THREDTOMEOUT = mAX_THREDTOMEOUT;
    }

    public AbstractReconciliationService() {
    }

    public AbstractReconciliationService(int type, ReconciliationParamModel paramModel) {
        this.paramModel = paramModel;
        if (paramModel.isAnalyzeMode()) {
            paramModel.setAnalyzeMode();
        }
        this.frmLogger = paramModel.getFrmLogger();
        ReconciliationUtil.initFrmLoggerCache((FrmLogger)paramModel.getFrmLogger());
        this.type = type;
        AbstractReconciliationService.setMAX_THREDTOMEOUT(Math.max(7200, Integer.parseInt(System.getProperty("prop.fi.ai.thread.timeoutsecs", Integer.toString(7200)))));
    }

    @Override
    public void execute() {
        boolean prepared = true;
        try {
            prepared = this.prepare();
        }
        catch (Exception e) {
            ErrorCode errCode = new ErrorCode("PREPARE METHOD", ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8d26\u51c6\u5907\u5de5\u4f5c\u51fa\u9519", (String)"AbstractReconciliationService_2", (String)"fi-frm-mservice", (Object[])new Object[0]));
            throw new KDException((Throwable)e, errCode, new Object[0]);
        }
        if (prepared) {
            this.innerExecute();
            try {
                IAppCache cache = AppCache.get((String)"frm");
                String frmLoggerCacheKey = "frmLogger" + this.paramModel.getTaskInfo().getId();
                cache.put(frmLoggerCacheKey, (Object)this.paramModel.getFrmLogger().getLogs());
            }
            catch (Exception e) {
                logger.error("\u5206\u6790\u6a21\u5f0f\u65e5\u5fd7\u751f\u6210\u5931\u8d25", (Throwable)e);
            }
        } else {
            TaskInfo taskInfo = this.paramModel.getTaskInfo();
            taskInfo.setTaskStatus(TaskStatusEnum.FINISHED);
            AppCacheHelper.putTaskCache((String)taskInfo.getBatchNo(), (String)taskInfo.getId().toString(), (String)SerializationUtils.serializeToBase64((Object)taskInfo));
            if (this.planModel != null) {
                TaskDao.updateTaskReconPlan((Long)taskInfo.getId(), (long)this.planModel.getId(), (long)(this.dataRule == null ? 0L : this.dataRule.getLong("id")), (Long)taskInfo.getGlAppCfgId());
            }
            TaskDao.finishTask((long)taskInfo.getId(), (ReconcilationResultEnum)taskInfo.getCode());
        }
    }

    protected boolean prepare() throws Exception {
        QFilter statusFilter;
        QFilter idFilter;
        String appId = this.paramModel.getAppIds().toArray(new String[0])[0];
        if (appMap.get(appId) == null) {
            QFilter idFilter2 = new QFilter("id", "in", (Object)this.paramModel.getAppIds());
            DynamicObjectCollection apps = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id,number", (QFilter[])new QFilter[]{idFilter2}, null);
            for (DynamicObject app : apps) {
                appMap.put(app.getString("id"), app.getString("number"));
            }
        }
        DynamicObject bizAppRefGlConfig = RptBizAppConfigServiceHelper.getBizAppRefGlConfig(appId);
        Tracer.addTag((String)"begin.execute", (String)"execute", (boolean)true);
        TaskInfo taskInfo = this.paramModel.getTaskInfo();
        Long orgId = taskInfo.getOrgId();
        if (this.paramModel.isApi()) {
            orgId = this.paramModel.getOrgIds().toArray(new Long[0])[0];
        }
        taskInfo.setGlAppCfgId(Long.valueOf(bizAppRefGlConfig == null ? 0L : bizAppRefGlConfig.getLong("id")));
        DynamicObject acctBook = null;
        if (this.paramModel.isInit()) {
            QFilter bookstypeFilter;
            QFilter endInitFilter;
            String acctorgSelectFields = "startperiod,basecurrency";
            idFilter = new QFilter("org", "=", (Object)orgId);
            statusFilter = new QFilter("enable", "=", (Object)true);
            acctBook = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)acctorgSelectFields, (QFilter[])new QFilter[]{idFilter, statusFilter, endInitFilter = new QFilter("isendinit", "=", (Object)true), bookstypeFilter = new QFilter("bookstype", "=", (Object)this.paramModel.getBookTypeId())});
            if (acctBook == null) {
                taskInfo.setPercent(Integer.valueOf(100));
                taskInfo.setCode(ReconcilationResultEnum.noInit);
                taskInfo.addError(ReconcilationResultEnum.noInit.getName());
                taskInfo.setStatus("3");
                logger.info("\u521d\u59cb\u5316\u5bf9\u8d26\u4efb\u52a1\u7ed3\u675f{}\uff0c\u6ca1\u6709\u627e\u5230\u8d26\u7c3f;\u8fd4\u56de\u72b6\u6001={}", (Object)taskInfo.getId(), (Object)taskInfo.getCode());
                return false;
            }
            if (!this.paramModel.isApi() || this.paramModel.isApi() && this.paramModel.getPeriodId() == null) {
                this.paramModel.setPeriodId(Long.valueOf(acctBook.getLong("startperiod")));
            }
            this.paramModel.setCurrency(Long.valueOf(acctBook.getLong("basecurrency")));
        }
        if (acctBook == null) {
            QFilter bookstypeFilter;
            idFilter = new QFilter("org", "=", (Object)orgId);
            statusFilter = new QFilter("enable", "=", (Object)true);
            acctBook = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"basecurrency", (QFilter[])new QFilter[]{idFilter, statusFilter, bookstypeFilter = new QFilter("bookstype", "=", (Object)this.paramModel.getBookTypeId())});
            if (acctBook != null) {
                this.paramModel.setCurrency(Long.valueOf(acctBook.getLong("basecurrency")));
            }
        } else {
            this.paramModel.setCurrency(Long.valueOf(acctBook.getLong("basecurrency")));
        }
        RecAccountBookResult accountBookResultFromFrm = RecAccountBookUtil.getAccountBookResultFromFRM((String)appMap.get(appId), (Long)orgId, (Long)this.paramModel.getBookTypeId(), (boolean)this.paramModel.isApi());
        boolean ignoreAccountBook = FaBillParamUtils.getBooleanValue((Long)0L, (String)"frm_ignore_accountbook");
        if (ignoreAccountBook) {
            this.paramModel.setBizOrgIds(accountBookResultFromFrm.getBizIds());
            taskInfo.setBizOrgIds(accountBookResultFromFrm.getBizIds());
        } else {
            if (accountBookResultFromFrm.getCode() != null) {
                taskInfo.setPercent(Integer.valueOf(100));
                taskInfo.setCode(accountBookResultFromFrm.getCode());
                taskInfo.addError(accountBookResultFromFrm.getCode().getName());
                taskInfo.setStatus("3");
                logger.info("\u5bf9\u8d26\u4efb\u52a1\u7ed3\u675f{}\uff0c\u6ca1\u6709\u627e\u5230\u8d26\u7c3f;\u8fd4\u56de\u72b6\u6001={}", (Object)taskInfo.getId(), (Object)taskInfo.getCode());
                return false;
            }
            this.paramModel.setBizOrgIds(accountBookResultFromFrm.getBizIds());
            taskInfo.setBizOrgIds(accountBookResultFromFrm.getBizIds());
        }
        Tracer.addTag((String)"build.plan", (String)("orgId:" + orgId + ",appId:" + appId), (boolean)true);
        logger.info("build.plan:orgId:" + orgId + ",appId:" + appId);
        this.planModel = ReconciliationUtil.getPlanModel((Long)this.paramModel.getBookTypeId(), (Long)orgId, (String)appId, (Long)this.paramModel.getPeriodId(), null);
        if (this.planModel == null) {
            taskInfo.setPercent(Integer.valueOf(100));
            if (this.paramModel.isApi() && !this.paramModel.isOriResult()) {
                taskInfo.setCode(ReconcilationResultEnum.Pass);
                taskInfo.setStatus("1");
            } else {
                taskInfo.setCode(ReconcilationResultEnum.noExecPlan);
                taskInfo.addError(ReconcilationResultEnum.noExecPlan.getName());
                taskInfo.setStatus("3");
            }
            logger.info("\u5bf9\u8d26\u4efb\u52a1{}\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u8d26\u65b9\u6848\u65b9\u6848;\u8fd4\u56de\u72b6\u6001={}", (Object)taskInfo.getId(), (Object)taskInfo.getCode());
            return false;
        }
        taskInfo.setPlanId(this.planModel.getId());
        taskInfo.setReconAmountType(Integer.valueOf(this.planModel.getReconAmountType().getValue()));
        taskInfo.setBalanceBasis(Integer.valueOf(this.planModel.getBalanceBasis().getValue()));
        if (this.paramModel.isApi() && !this.paramModel.isInit() && !this.planModel.isCloseParam()) {
            taskInfo.setCode(ReconcilationResultEnum.closeParamOff);
            taskInfo.setStatus("4");
            logger.info("API\u5bf9\u8d26\u4efb\u52a1\u7ed3\u675f{}\uff0c\u672a\u5f00\u542f\u5bf9\u5e73\u7ed3\u8d26\uff0c;\u8fd4\u56de\u72b6\u6001={}", (Object)taskInfo.getId(), (Object)taskInfo.getCode());
            return false;
        }
        if (this.paramModel.isAnalyzeMode()) {
            List details = this.planModel.getDetail();
            ArrayList<BizReconPlanDetailModel> details_new = new ArrayList<BizReconPlanDetailModel>();
            for (BizReconPlanDetailModel detail : details) {
                if (!detail.getId().equals(this.paramModel.getPlanDetailId())) continue;
                details_new.add(detail);
                break;
            }
            details.clear();
            details.addAll(details_new);
        }
        Tracer.addTag((String)"build.rule", (String)("orgId:" + orgId + ",appId:" + appId), (boolean)true);
        logger.info("build.rule:orgId:" + orgId + ",appId:" + appId);
        this.dataRule = ReconciliationUtil.getDataRule((Long)this.planModel.getRuleId(), (ReconAmountTypeEnum)this.planModel.getReconAmountType());
        if (this.dataRule == null) {
            taskInfo.setPercent(Integer.valueOf(100));
            taskInfo.setCode(ReconcilationResultEnum.noExecRule);
            taskInfo.addError(ReconcilationResultEnum.noExecRule.getName());
            taskInfo.setStatus("3");
            logger.info("\u5bf9\u8d26\u4efb\u52a1\u7ed3\u675f{}\uff0c\u53d6\u6570\u89c4\u5219\u4e3a\u7a7a;\u8fd4\u56de\u72b6\u6001={}", (Object)taskInfo.getId(), (Object)taskInfo.getCode());
            return false;
        }
        Map commonFilterMap = ReconciliationParmUtil.getAllCommonFilter();
        DynamicObjectCollection dataRuleEntryEntity = this.dataRule.getDynamicObjectCollection("entryentity");
        String error = "";
        String bizObjName = "";
        String dataType = "";
        Long ruleEntryId = 0L;
        boolean localCurrency = Boolean.TRUE;
        ArrayList<String> noCurrencyFieldCommonFilter = new ArrayList<String>(dataRuleEntryEntity.size());
        for (DynamicObject dynamicObject : dataRuleEntryEntity) {
            ruleEntryId = dynamicObject.getLong("id");
            bizObjName = dynamicObject.getDynamicObject("bizobj").getString("name");
            dataType = BizDataTypeEnum.getEnum((Integer)dynamicObject.getInt("datatype")).getName();
            if (StringUtils.isEmpty((String)dynamicObject.getString("amount_tag"))) {
                error = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e3a[%1$s]\uff0c\u53d6\u503c\u7c7b\u578b\u4e3a[%2$s]\uff0c\u5206\u5f55id\u4e3a[%3$s]\u7684\u53d6\u6570\u89c4\u5219\u7684\u91d1\u989d\u53d6\u503c\u516c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u586b\u5199", (String)"AbstractReconciliationService_1", (String)"fi-frm-mservice", (Object[])new Object[0]), bizObjName, dataType, ruleEntryId);
                break;
            }
            Long commonFilterId = dynamicObject.getLong("commonfilter.id");
            DynamicObject commonFilterInfo = (DynamicObject)commonFilterMap.get(commonFilterId);
            DynamicObjectCollection propEntrys = commonFilterInfo.getDynamicObjectCollection("entryentity");
            if (propEntrys.size() > 0) {
                DynamicObjectCollection dimProps = commonFilterInfo.getDynamicObjectCollection("fieldmapentry");
                boolean hasCurrencyField = Boolean.FALSE;
                for (DynamicObject dimObject : dimProps) {
                    String entityId = dimObject.getString("entityid");
                    String bdtype = dimObject.getString("datatype");
                    if (!AssistDataType.isBaseDataType((String)bdtype) || !"bd_currency".equalsIgnoreCase(entityId)) continue;
                    hasCurrencyField = Boolean.TRUE;
                    localCurrency = Boolean.FALSE;
                }
                if (!hasCurrencyField) {
                    noCurrencyFieldCommonFilter.add(commonFilterInfo.getString("number"));
                }
            }
            if (localCurrency || noCurrencyFieldCommonFilter.size() <= 0) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e3a[%1$s]\u7684\u53d6\u6570\u89c4\u5219\u5206\u5f55\uff0c\u7f16\u7801\u4e3a[%2$s]\u7684\u901a\u7528\u8bbe\u7f6e\u672a\u914d\u7f6e\u5e01\u522b", (String)"ReconciliationParmUtil_0", (String)"fi-frm-common", (Object[])new Object[0]), bizObjName, noCurrencyFieldCommonFilter.get(0));
            throw new KDBizException(new ErrorCode(String.valueOf(ReconcilationResultEnum.error.getIndex()), msg), new Object[0]);
        }
        this.paramModel.setLocalCurrency(localCurrency);
        if (StringUtils.isNotEmpty((String)error)) {
            taskInfo.setPercent(Integer.valueOf(100));
            taskInfo.setCode(ReconcilationResultEnum.error);
            taskInfo.addError(error);
            taskInfo.setStatus("3");
            return false;
        }
        this.initFunctionPk(orgId, commonFilterMap);
        taskInfo.setDataRuleId(Long.valueOf(this.dataRule.getLong("id")));
        DynamicObjectCollection cols = this.dataRule.getDynamicObjectCollection("entryentity");
        if (this.paramModel.isAnalyzeMode() && !this.paramModel.getAnalyzeRuleIds().isEmpty()) {
            cols.removeIf(v -> !this.paramModel.getAnalyzeRuleIds().contains(v.getPkValue()));
        }
        boolean hasInit = Boolean.FALSE;
        boolean hasStart = Boolean.FALSE;
        boolean hasClose = Boolean.FALSE;
        boolean hasDebit = Boolean.FALSE;
        boolean hasCredit = Boolean.FALSE;
        for (DynamicObject entry : cols) {
            if (BizDataTypeEnum.Init.getValue() == entry.getInt("datatype")) {
                hasInit = Boolean.TRUE;
                continue;
            }
            if (BizDataTypeEnum.PeriodStart.getValue() == entry.getInt("datatype")) {
                hasStart = Boolean.TRUE;
                continue;
            }
            if (BizDataTypeEnum.Close.getValue() == entry.getInt("datatype")) {
                hasClose = Boolean.TRUE;
                continue;
            }
            if (BizDataTypeEnum.Debit.getValue() == entry.getInt("datatype")) {
                hasDebit = Boolean.TRUE;
                continue;
            }
            if (BizDataTypeEnum.Credit.getValue() != entry.getInt("datatype")) continue;
            hasCredit = Boolean.TRUE;
        }
        this.paramModel.setHasInit(hasInit);
        this.paramModel.setHasStart(hasStart);
        this.paramModel.setHasClose(hasClose);
        this.paramModel.setHasDebit(hasDebit);
        this.paramModel.setHasCredit(hasCredit);
        this.paramModel.setLocalCurrency(true);
        if (this.planModel.getDetail().size() == 0) {
            taskInfo.setPercent(Integer.valueOf(100));
            taskInfo.setStatus("1");
            taskInfo.setCode(ReconcilationResultEnum.Pass);
            logger.info("\u5bf9\u8d26\u4efb\u52a1\u7ed3\u675f{}\uff0c\u65b9\u6848\u5206\u5f55\u884c\u4e3a\u7a7a;\u8fd4\u56de\u72b6\u6001={}", (Object)taskInfo.getId(), (Object)taskInfo.getCode());
            return false;
        }
        taskInfo.setStatus("2");
        TaskDao.updateTaskReconPlan((Long)taskInfo.getId(), (long)this.planModel.getId(), (long)(this.dataRule == null ? 0L : this.dataRule.getLong("id")), (Long)taskInfo.getGlAppCfgId());
        CustomParamUtil.setCustomParam(this.paramModel, this.dataRule);
        ReconciliationUtil.initSysParam((ReconciliationParamModel)this.paramModel, (String)appMap.get(this.planModel.getAppId()));
        this.enablePlatformThreadPool = FaBillParamUtils.getBooleanValue((Long)0L, (String)"frm_enable_platform_threadpool");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerExecute() {
        TaskInfo taskInfo = this.paramModel.getTaskInfo();
        Long orgId = taskInfo.getOrgId();
        String appId = this.paramModel.getAppIds().toArray(new String[0])[0];
        try {
            int bizRuleRows = TaskDao.updateTask((long)taskInfo.getId(), (long)orgId, (BizReconPlanModel)this.planModel, (ReconciliationParamModel)this.paramModel, (DynamicObject)this.dataRule);
            logger.info("\u4efb\u52a1\u5206\u5f55\u6784\u5efa\u5b8c\u6210, \u5f85\u6267\u884c\u6570={}", (Object)bizRuleRows);
            taskInfo.setTotalStep(Integer.valueOf(bizRuleRows));
            taskInfo.setExedStep(Integer.valueOf(0));
            taskInfo.setPercent(Integer.valueOf(0));
            taskInfo.setCode(ReconcilationResultEnum.Pass);
            AppCacheHelper.putTaskCache((String)taskInfo.getBatchNo(), (String)taskInfo.getId().toString(), (String)SerializationUtils.serializeToBase64((Object)taskInfo));
            if (this.paramModel.isEnableMq()) {
                return;
            }
            this.executeDetail(this.planModel, orgId, appId, this.dataRule, taskInfo);
            AppCacheHelper.updateTaskStatusWithDB((String)taskInfo.getBatchNo(), (String)String.valueOf(taskInfo.getId()), null, null, (TaskStatusEnum)TaskStatusEnum.FINISHED, null, null);
        }
        catch (Throwable e) {
            logger.error("\u5bf9\u8d26\u62a5\u9519:\u5e94\u7528Id:" + appId + ",\u9519\u8bef\u4fe1\u606f:" + ThrowableHelper.toString((Throwable)e));
            taskInfo.setCode(ReconcilationResultEnum.error);
            taskInfo.addError(e.getMessage(), ThrowableHelper.toString((Throwable)e));
            taskInfo.setStatus("3");
            taskInfo.setPercent(Integer.valueOf(100));
            taskInfo.setTaskStatus(TaskStatusEnum.ERROR);
            String errorMsg = ThrowableHelper.toString((Throwable)e);
            String[] errorInfo = new String[]{errorMsg, errorMsg};
            AppCacheHelper.updateTaskStatusWithDB((String)taskInfo.getBatchNo(), (String)taskInfo.getId().toString(), (ReconcilationResultEnum)taskInfo.getCode(), (String)"3", (TaskStatusEnum)TaskStatusEnum.ERROR, null, (String[])errorInfo);
        }
        finally {
            Tracer.addTag((String)"finishExec", (String)("orgId:" + orgId + ",appId:" + appId), (boolean)true);
            logger.info("finishExec:finish:" + Tracer.getCurrentSpan().getCost());
        }
    }

    private void executeDetail(BizReconPlanModel planModel, Long orgId, String appId, DynamicObject dataRule, TaskInfo taskInfo) {
        List details = planModel.getDetail();
        if (details.size() == 0) {
            return;
        }
        Map<Long, Integer> dcMap = ReconServiceHelper.getDCMap(details);
        this.paramModel.getFrmLogger().setParentThread(Thread.currentThread().getId() + "");
        ArrayList tasks = new ArrayList();
        details.forEach(planDetailModel -> tasks.add(new Callable((BizReconPlanDetailModel)planDetailModel, dcMap, planModel, orgId, appId, dataRule){
            final /* synthetic */ BizReconPlanDetailModel val$planDetailModel;
            final /* synthetic */ Map val$dcMap;
            final /* synthetic */ BizReconPlanModel val$planModel;
            final /* synthetic */ Long val$orgId;
            final /* synthetic */ String val$appId;
            final /* synthetic */ DynamicObject val$dataRule;
            {
                this.val$planDetailModel = bizReconPlanDetailModel;
                this.val$dcMap = map;
                this.val$planModel = bizReconPlanModel;
                this.val$orgId = l;
                this.val$appId = string;
                this.val$dataRule = dynamicObject;
            }

            public Object call() throws Exception {
                boolean isAccountEmpty;
                TaskInfo taskInfo = AbstractReconciliationService.this.paramModel.getTaskInfo();
                if (TaskDao.isTaskOver((TaskInfo)taskInfo)) {
                    return null;
                }
                boolean isAssist = AssistTypeEnum.Assist == this.val$planDetailModel.getAssistType();
                boolean bl = isAccountEmpty = this.val$planDetailModel.getAccountIds().size() == 0;
                if (isAccountEmpty && !isAssist) {
                    return null;
                }
                ReconServiceHelper.setDc(this.val$planDetailModel, this.val$dcMap);
                TaskDao.startExecutePlanEntry((Long)AbstractReconciliationService.this.paramModel.getTaskInfo().getId(), (Long)this.val$planDetailModel.getId());
                if (AbstractReconciliationService.this.paramModel.isEnableMq()) {
                    return null;
                }
                try {
                    AbstractReconTabService reconTabService = ReconTabServiceExecutor.serviceBuilder(this.val$planDetailModel.getAssistType()).planModel(this.val$planModel).paramModel(AbstractReconciliationService.this.paramModel).detailModel(this.val$planDetailModel).build();
                    reconTabService.execute(this.val$planModel, this.val$orgId, this.val$appId, this.val$dataRule, taskInfo, AbstractReconciliationService.this.enablePlatformThreadPool);
                    ReconcilationResultEnum reconCode = reconTabService.getReconCode();
                    TaskDao.finishExecutePlanEntry((Long)AbstractReconciliationService.this.paramModel.getTaskInfo().getId(), (Long)this.val$planDetailModel.getId(), (ReconcilationResultEnum)reconCode);
                }
                catch (Throwable e) {
                    logger.error("\u65b9\u6848\u5206\u5f55\u53d6\u6570\u5f02\u5e38", e);
                    TaskDao.failExecutePlanEntry((Long)AbstractReconciliationService.this.paramModel.getTaskInfo().getId(), (Long)this.val$planDetailModel.getId(), (String)ThrowableHelper.toString((Throwable)e));
                    AppCacheHelper.updateTaskStatusWithDB((String)AbstractReconciliationService.this.paramModel.getTaskInfo().getBatchNo(), (String)String.valueOf(AbstractReconciliationService.this.paramModel.getTaskInfo().getId()), (ReconcilationResultEnum)ReconcilationResultEnum.error, null, (TaskStatusEnum)TaskStatusEnum.ERROR, null, (String[])new String[]{e.getMessage(), ThrowableHelper.toString((Throwable)e)});
                }
                return null;
            }
        }));
        List futures = this.enablePlatformThreadPool ? tasks.stream().map(f -> ThreadService.submit((Callable)f, (TaskType)TaskType.FRM_PLAN_ENTRY_TASK, (RequestContext)RequestContext.get())).collect(Collectors.toList()) : tasks.stream().map(f -> SUB_BIZ_THREAD_POOL.submit(f, RequestContext.get())).collect(Collectors.toList());
        for (Future x : futures) {
            try {
                x.get(AbstractReconciliationService.getMAX_THREDTOMEOUT().intValue(), TimeUnit.SECONDS);
            }
            catch (Throwable e) {
                throw new KDException(e, new ErrorCode("THREAD_POOL_EXECUTION", String.format(ResManager.loadKDString((String)"\u7ebf\u7a0b\u5f02\u5e38\u4e2d\u65ad: %s", (String)"ReconService4Assist_6", (String)"fi-ai-mservice", (Object[])new Object[0]), e.getMessage())), new Object[0]);
            }
        }
    }

    protected void initFunctionPk(Long orgId, Map<Object, DynamicObject> commonFilterMap) {
        String periodConfig = SystemParamHelper.getStringSysParam((String)"periodcombo", (long)orgId, null);
        if (periodConfig != null) {
            List details = this.planModel.getDetail();
            HashSet amountTypeSet = new HashSet(16);
            for (BizReconPlanDetailModel detail : details) {
                List amountTypeList = detail.getAmountTypeList();
                if (!CollectionUtils.isNotEmpty((Collection)amountTypeList)) continue;
                amountTypeSet.addAll(amountTypeList);
            }
            DynamicObjectCollection entryEntity = this.dataRule.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection collection = new DynamicObjectCollection();
            for (DynamicObject row : entryEntity) {
                if (!amountTypeSet.contains(row.getDynamicObject("amttype").getLong("id")) || row.getBoolean("disable")) continue;
                collection.add((Object)row);
            }
            CommonFilterAnalyseUtil.handleRuleFunction(this.paramModel, collection, commonFilterMap, periodConfig);
        }
    }
}

