/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.impl;

import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.frm.common.enums.AssistTypeEnum;
import kd.fi.frm.common.model.BaseGlDataParam;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanDetailModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanModel;
import kd.fi.frm.common.model.gldata.GLAccountConfig;
import kd.fi.frm.common.model.gldata.GLDataParam;
import kd.fi.frm.mservice.gldata.GLDataService;
import kd.fi.frm.mservice.impl.AbstractReconTabService;
import kd.fi.frm.mservice.rpt.RptBizAppConfigServiceHelper;
import kd.fi.frm.mservice.rpt.invoke.RptGlDataQueryService;

public class ReconService4Account
extends AbstractReconTabService {
    public ReconService4Account(ReconciliationParamModel paramModel, BizReconPlanModel planModel, BizReconPlanDetailModel planDetailModel) {
        super(paramModel, planModel, planDetailModel);
    }

    @Override
    protected int getReconTabIndex() {
        return AssistTypeEnum.Acct.getValue();
    }

    @Override
    public DataSet getGlAmount() {
        DataSet dataSet;
        GLDataParam glparam = new GLDataParam();
        glparam.setAcctOrgID(this.planModel.getOrgId().longValue());
        glparam.setAccountTableID(this.planModel.getAccoutTableId().longValue());
        glparam.setInit(this.paramModel.isInit());
        glparam.setPeriodid(this.paramModel.getPeriodId().longValue());
        glparam.setLocalCurrency(this.paramModel.isLocalCurrency());
        glparam.setBalanceDc(this.planDetailModel.getBalanceDc());
        glparam.setDc(this.planDetailModel.getDc());
        HashSet<Long> allCurrencyIds = new HashSet<Long>();
        if (this.paramModel.isLocalCurrency()) {
            allCurrencyIds.add(this.paramModel.getCurrency());
        } else {
            Set planCurrencyIds = this.planDetailModel.getCurrencyIds();
            if (planCurrencyIds.size() == 0) {
                allCurrencyIds.add(this.paramModel.getCurrency());
            } else {
                glparam.setSpecialCurrency(true);
                allCurrencyIds.addAll(planCurrencyIds);
            }
        }
        glparam.setCurrencyIds(allCurrencyIds);
        glparam.setAcctBookTypeID(this.paramModel.getBookTypeId().longValue());
        glparam.setReconAmountType(this.planModel.getReconAmountType());
        glparam.setBalanceBasis(this.planDetailModel.getBalanceBasis());
        GLAccountConfig glconfig = new GLAccountConfig();
        glconfig.setAccountIds(this.planDetailModel.getAccountIds());
        glparam.setAccountConfig(glconfig);
        DynamicObject bizAppRefGlConfig = RptBizAppConfigServiceHelper.getBizAppRefGlConfig(this.planModel.getAppId());
        if (bizAppRefGlConfig == null) {
            GLDataService glService = new GLDataService(glparam, this.paramModel);
            dataSet = glService.execute();
        } else {
            RptGlDataQueryService glService = new RptGlDataQueryService(bizAppRefGlConfig, (BaseGlDataParam)glparam);
            dataSet = glService.execute();
        }
        return dataSet;
    }
}

