/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.impl;

import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.frm.common.enums.AssistTypeEnum;
import kd.fi.frm.common.model.BaseGlDataParam;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanDetailModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanModel;
import kd.fi.frm.common.model2.GLAccountConfig2;
import kd.fi.frm.common.model2.GLDataParam2;
import kd.fi.frm.mservice.gldata.GLDataService2;
import kd.fi.frm.mservice.impl.AbstractReconTabService;
import kd.fi.frm.mservice.rpt.RptBizAppConfigServiceHelper;
import kd.fi.frm.mservice.rpt.invoke.RptGlDataQueryService;

public class ReconService4AccountAssist
extends AbstractReconTabService {
    private static final Log logger = LogFactory.getLog(ReconService4AccountAssist.class);

    public ReconService4AccountAssist(ReconciliationParamModel paramModel, BizReconPlanModel planModel, BizReconPlanDetailModel planDetailModel) {
        super(paramModel, planModel, planDetailModel);
    }

    @Override
    protected int getReconTabIndex() {
        return AssistTypeEnum.Asstact.getValue();
    }

    @Override
    public DataSet getGlAmount() {
        GLDataParam2 glparam = new GLDataParam2();
        glparam.setAcctOrgID(this.planModel.getOrgId().longValue());
        glparam.setAccountTableID(this.planModel.getAccoutTableId().longValue());
        glparam.setPeriodid(this.paramModel.getPeriodId().longValue());
        glparam.setAcctBookTypeID(this.paramModel.getBookTypeId().longValue());
        glparam.setInit(this.paramModel.isInit());
        glparam.setLocalCurrency(this.paramModel.isLocalCurrency());
        glparam.setCurrencyId(this.paramModel.getCurrency().longValue());
        glparam.setType(AssistTypeEnum.Asstact);
        glparam.setReconAmountType(this.planModel.getReconAmountType());
        glparam.setBalanceBasis(this.planDetailModel.getBalanceBasis());
        glparam.setNeedQueryGl(this.planDetailModel.isNeedQueryGl());
        GLAccountConfig2 glconfig = new GLAccountConfig2();
        glconfig.setAccountIds(this.planDetailModel.getAccountIds());
        glconfig.setFlexfields(this.planDetailModel.getAssistAcctTypeList().stream().collect(Collectors.toSet()));
        glconfig.setAsstTypeflexIds(this.planDetailModel.getAssistFlexIdList().stream().collect(Collectors.toSet()));
        glconfig.setIgnoreEmpty(this.planDetailModel.isIgnoreEmpty());
        glconfig.setAssistValueRange(this.planDetailModel.getAssistValueRange());
        glparam.setAccountConfig(glconfig);
        glparam.setAssistIndexMap(this.planDetailModel.getGlAssistIndexMap());
        glparam.setBalanceDc(this.planDetailModel.getBalanceDc());
        glparam.setDc(this.planDetailModel.getDc());
        DataSet dataSet = null;
        DynamicObject bizAppRefGlConfig = RptBizAppConfigServiceHelper.getBizAppRefGlConfig(this.planModel.getAppId());
        if (bizAppRefGlConfig == null) {
            GLDataService2 glService = new GLDataService2(glparam, this.paramModel);
            dataSet = glService.execute();
        } else {
            RptGlDataQueryService glService = new RptGlDataQueryService(bizAppRefGlConfig, (BaseGlDataParam)glparam);
            dataSet = glService.execute();
        }
        return dataSet;
    }
}

