/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.impl;

import java.util.HashSet;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.frm.common.enums.AssistTypeEnum;
import kd.fi.frm.common.model.BaseGlDataParam;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanDetailModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanModel;
import kd.fi.frm.common.model2.GLAccountConfig2;
import kd.fi.frm.common.model2.GLDataParam2;
import kd.fi.frm.common.util.FaBillParamUtils;
import kd.fi.frm.mservice.gldata.GLDataService2;
import kd.fi.frm.mservice.impl.AbstractReconTabService;
import kd.fi.frm.mservice.impl.ReconServiceHelper;
import kd.fi.frm.mservice.rpt.RptBizAppConfigServiceHelper;
import kd.fi.frm.mservice.rpt.invoke.RptGlDataQueryService;

public class ReconService4Assist
extends AbstractReconTabService {
    public ReconService4Assist(ReconciliationParamModel paramModel, BizReconPlanModel planModel, BizReconPlanDetailModel planDetailModel) {
        super(paramModel, planModel, planDetailModel);
    }

    @Override
    protected int getReconTabIndex() {
        return AssistTypeEnum.Assist.getValue();
    }

    @Override
    public DataSet getGlAmount() {
        if (!this.planDetailModel.getHasAccount().booleanValue()) {
            boolean getAcctByAssistIdEnable = FaBillParamUtils.getBooleanValue((Long)0L, (String)"frm_acct_assistid_enable");
            if (getAcctByAssistIdEnable) {
                this.planDetailModel.setAccountIds(ReconServiceHelper.getAcctIdsByAssistConfig(this.planDetailModel.getAsstTypeCondList(), this.planModel.getAccoutTableId(), this.planModel.getOrgId(), this.paramModel.getPeriodId()));
            } else {
                this.planDetailModel.setAccountIds(ReconServiceHelper.getAcctIds(this.planDetailModel.getAssistAcctTypeList(), this.planModel.getAccoutTableId(), this.planModel.getOrgId(), this.paramModel.getPeriodId()));
            }
        }
        HashSet assistSet = new HashSet();
        HashSet acctIds = new HashSet();
        assistSet.addAll(this.planDetailModel.getAssistAcctTypeList());
        acctIds.addAll(this.planDetailModel.getAccountIds());
        GLDataParam2 glparam = new GLDataParam2();
        glparam.setAcctOrgID(this.planModel.getOrgId().longValue());
        glparam.setAccountTableID(this.planModel.getAccoutTableId().longValue());
        glparam.setPeriodid(this.paramModel.getPeriodId().longValue());
        glparam.setAcctBookTypeID(this.paramModel.getBookTypeId().longValue());
        glparam.setInit(this.paramModel.isInit());
        glparam.setLocalCurrency(this.paramModel.isLocalCurrency());
        glparam.setCurrencyId(this.paramModel.getCurrency().longValue());
        glparam.setType(AssistTypeEnum.Assist);
        glparam.setReconAmountType(this.planModel.getReconAmountType());
        glparam.setBalanceBasis(this.planDetailModel.getBalanceBasis());
        GLAccountConfig2 glconfig = new GLAccountConfig2();
        glconfig.setAccountIds(acctIds);
        glconfig.setFlexfields(assistSet);
        glconfig.setIgnoreEmpty(this.planDetailModel.isIgnoreEmpty());
        if (this.planDetailModel != null) {
            glconfig.setAsstTypeflexIds(this.planDetailModel.getAssistFlexIdList().stream().collect(Collectors.toSet()));
        }
        glconfig.setAssistValueRange(this.planDetailModel.getAssistValueRange());
        glparam.setAssistIndexMap(this.planDetailModel.getGlAssistIndexMap());
        glparam.setAccountConfig(glconfig);
        glparam.setBalanceDc(this.planDetailModel.getBalanceDc());
        glparam.setDc(this.planDetailModel.getDc());
        DataSet dataSet = null;
        DynamicObject bizAppRefGlConfig = RptBizAppConfigServiceHelper.getBizAppRefGlConfig(this.planModel.getAppId());
        if (bizAppRefGlConfig == null) {
            GLDataService2 glService = new GLDataService2(glparam, this.paramModel);
            dataSet = glService.execute();
        } else {
            RptGlDataQueryService glService = new RptGlDataQueryService(bizAppRefGlConfig, (BaseGlDataParam)glparam);
            dataSet = glService.execute();
        }
        return dataSet;
    }
}

