/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ConfigurationUtil;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.constant.ReconciliationFormConstant;
import kd.fi.frm.common.enums.AssistDataType;
import kd.fi.frm.common.enums.BalanceBasisEnum;
import kd.fi.frm.common.enums.BalanceDcEnum;
import kd.fi.frm.common.enums.DataTypeEnum;
import kd.fi.frm.common.enums.ReconcilationResultEnum;
import kd.fi.frm.common.model.FRMDataSetModel;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.bizdata.BizDataParam;
import kd.fi.frm.common.model.bizdata.BizDataResult;
import kd.fi.frm.common.model.bizdata.BizReconPlanDetailModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanModel;
import kd.fi.frm.common.model.mulassist.MulassistConfigModel;
import kd.fi.frm.common.task.TaskInfo;
import kd.fi.frm.common.task.TaskStatusEnum;
import kd.fi.frm.common.util.ReconciliationAmountTypeUtil;
import kd.fi.frm.common.util.ReconciliationUtil;
import kd.fi.frm.common.util.ThrowableHelper;
import kd.fi.frm.mservice.algo.DistinctConcatAggFunction;
import kd.fi.frm.mservice.bizdata.BizDataService;
import kd.fi.frm.mservice.bizdata.ext.custom.AbstractCustomParamService;

public class ReconServiceHelper
implements ReconciliationFormConstant {
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"kd.fi.frm.service.BizDataServicePool", (int)3);
    protected static Log logger = LogFactory.getLog(ReconServiceHelper.class);
    private static final String[] debit_updateStart = new String[]{"openingbalance_app", "closingbalance_app + creditamount_app - debitamount_app"};
    private static final String[] debit_updateEnd = new String[]{"closingbalance_app", "openingbalance_app + debitamount_app - creditamount_app"};
    private static final String[] credit_updateStart = new String[]{"openingbalance_app", "closingbalance_app - creditamount_app + debitamount_app"};
    private static final String[] credit_updateEnd = new String[]{"closingbalance_app", "openingbalance_app - debitamount_app + creditamount_app"};
    protected static final String[] initAmountExp = new String[]{"case when openingbalance_app is null then 0 else openingbalance_app end", "case when debitamount_app is null then 0 else debitamount_app end", "case when creditamount_app is null then 0 else creditamount_app end", "case when closingbalance_app is null then 0 else closingbalance_app end", "case when openingbalance_gl is null then 0 else openingbalance_gl end", "case when debitamount_gl is null then 0 else debitamount_gl end", "case when creditamount_gl is null then 0 else creditamount_gl end", "case when closingbalance_gl is null then 0 else closingbalance_gl end"};
    protected static final String[] amountFields = new String[]{"openingbalance_app", "debitamount_app", "creditamount_app", "closingbalance_app", "openingbalance_gl", "debitamount_gl", "creditamount_gl", "closingbalance_gl"};
    protected static final String[] BIZ_ASSIST_FIELDS = new String[]{"assist1_app", "assist2_app", "assist3_app", "assist4_app", "assist5_app", "assist6_app", "assist7_app", "assist8_app"};
    protected static final String[] BIZ_ASSIST_FIELDS_EXP = new String[]{"case when assist1_app is null then 0L else assist1_app end", "case when assist2_app is null then 0L else assist2_app end", "case when assist3_app is null then 0L else assist3_app end", "case when assist4_app is null then 0L else assist4_app end", "case when assist5_app is null then 0L else assist5_app end", "case when assist6_app is null then 0L else assist6_app end", "case when assist7_app is null then 0L else assist7_app end", "case when assist8_app is null then 0L else assist8_app end"};
    protected static final String[] GL_ASSIST_FIELDS = new String[]{"assist1_gl", "assist2_gl", "assist3_gl", "assist4_gl", "assist5_gl", "assist6_gl", "assist7_gl", "assist8_gl"};
    protected static final String[] GL_ASSIST_FIELDS_EXP = new String[]{"case when assist1_gl is null or assist1_gl = 0L then assist1_app else assist1_gl end", "case when assist2_gl is null or assist2_gl = 0L then assist2_app else assist2_gl end", "case when assist3_gl is null or assist3_gl = 0L then assist3_app else assist3_gl end", "case when assist4_gl is null or assist4_gl = 0L then assist4_app else assist4_gl end", "case when assist5_gl is null or assist5_gl = 0L then assist5_app else assist5_gl end", "case when assist6_gl is null or assist6_gl = 0L then assist6_app else assist6_gl end", "case when assist7_gl is null or assist7_gl = 0L then assist7_app else assist7_gl end", "case when assist8_gl is null or assist8_gl = 0L then assist8_app else assist8_gl end"};
    private static final String[] bizFieldArr = new String[]{"currency", "rules", "assist1_app", "assist2_app", "assist3_app", "assist4_app", "assist5_app", "assist6_app", "assist7_app", "assist8_app", "app_show_assist1", "app_show_assist2", "app_show_assist3", "app_show_assist4", "app_show_assist5", "app_show_assist6", "app_show_assist7", "app_show_assist8", "openingbalance_app", "debitamount_app", "creditamount_app", "closingbalance_app"};
    private static final String[] accountFieldArr = new String[]{"case when currency is null then currency_gl else currency end currency", "rules", "assist1_app", "assist2_app", "assist3_app", "assist4_app", "assist5_app", "assist6_app", "assist7_app", "assist8_app", "app_show_assist1", "app_show_assist2", "app_show_assist3", "app_show_assist4", "app_show_assist5", "app_show_assist6", "app_show_assist7", "app_show_assist8", "openingbalance_app", "debitamount_app", "creditamount_app", "closingbalance_app", "openingbalance_gl", "debitamount_gl", "creditamount_gl", "closingbalance_gl"};
    private static final String[] allFieldArr = new String[]{"currency", "rules", "assist1_app", "assist2_app", "assist3_app", "assist4_app", "assist5_app", "assist6_app", "assist7_app", "assist8_app", "assist1_gl", "assist2_gl", "assist3_gl", "assist4_gl", "assist5_gl", "assist6_gl", "assist7_gl", "assist8_gl", "app_show_assist1", "app_show_assist2", "app_show_assist3", "app_show_assist4", "app_show_assist5", "app_show_assist6", "app_show_assist7", "app_show_assist8", "openingbalance_app", "debitamount_app", "creditamount_app", "closingbalance_app", "openingbalance_gl", "debitamount_gl", "creditamount_gl", "closingbalance_gl", "openingbalance_app - openingbalance_gl openingbalance_diff", "debitamount_app - debitamount_gl debitamount_diff", "creditamount_app - creditamount_gl creditamount_diff", "closingbalance_app - closingbalance_gl closingbalance_diff", "glassgrps", "account"};
    private static final String[] initAllFieldArr = new String[]{"currency", "assist1_app", "assist2_app", "assist3_app", "assist4_app", "assist5_app", "assist6_app", "assist7_app", "assist8_app", "assist1_gl", "assist2_gl", "assist3_gl", "assist4_gl", "assist5_gl", "assist6_gl", "assist7_gl", "assist8_gl", "app_show_assist1", "app_show_assist2", "app_show_assist3", "app_show_assist4", "app_show_assist5", "app_show_assist6", "app_show_assist7", "app_show_assist8", "openingbalance_app init_app", "openingbalance_gl init_gl", "openingbalance_app - openingbalance_gl init_diff", "glassgrps", "account"};

    public static Set<Long> getAcctIds(List<String> acctTypeList, Long acctTableId, Long orgId, Long periodId) {
        ArrayList<String> assistTypes = new ArrayList<String>(acctTypeList.size());
        for (String acctTypeWithIndex : acctTypeList) {
            assistTypes.add(acctTypeWithIndex.split("\\.")[1]);
        }
        QFilter baseDataFilter = new QFilter("valuesource.number", "in", assistTypes);
        DynamicObjectCollection types = QueryServiceHelper.query((String)"bos_flex_property", (String)"id", (QFilter[])new QFilter[]{baseDataFilter});
        HashSet<Long> flexIds = new HashSet<Long>();
        for (DynamicObject flex : types) {
            flexIds.add((Long)flex.get("id"));
        }
        return ReconServiceHelper.getAcctIdsByFlexIds(flexIds, acctTableId, orgId, periodId);
    }

    public static Set<Long> getAcctIdsByAssistConfig(List<MulassistConfigModel> asstTypeCondList, Long acctTableId, Long orgId, Long periodId) {
        if (CollectionUtils.isEmpty(asstTypeCondList)) {
            return new HashSet<Long>(0);
        }
        HashSet<Long> flexIds = new HashSet<Long>(8);
        for (MulassistConfigModel mulassistConfigModel : asstTypeCondList) {
            flexIds.add(Long.parseLong(mulassistConfigModel.getAssistId()));
        }
        return ReconServiceHelper.getAcctIdsByFlexIds(flexIds, acctTableId, orgId, periodId);
    }

    public static Set<Long> getAcctIdsByFlexIds(Set<Long> flexIds, Long acctTableId, Long orgId, Long periodId) {
        QFilter periodIdFilter = new QFilter("id", "=", (Object)periodId);
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"enddate", (QFilter[])new QFilter[]{periodIdFilter});
        Date endDate = period.getDate("enddate");
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)endDate).and(new QFilter("enddate", ">", (Object)endDate));
        QFilter tableFilter = new QFilter("accounttable", "=", (Object)acctTableId);
        QFilter leafFilter = new QFilter("isleaf", "=", (Object)"1");
        QFilter assistFilter = new QFilter("checkitementry.asstactitem", "in", flexIds);
        QFilter accountViewFilter = tableFilter.and(leafFilter).and(assistFilter).and(dateFilter);
        DynamicObjectCollection collection = BaseDataServiceHelper.queryBaseData((String)"bd_accountview", (Long)orgId, (QFilter)accountViewFilter, (String)"id");
        HashSet<Long> acctIds = new HashSet<Long>();
        for (DynamicObject accountView : collection) {
            acctIds.add(accountView.getLong("id"));
        }
        return acctIds;
    }

    public static Map<Long, Integer> getDCMap(List<BizReconPlanDetailModel> details) {
        HashMap amountTypeMap = new HashMap(details.size());
        HashSet accts = new HashSet(details.size());
        HashSet amountTypeList = null;
        for (BizReconPlanDetailModel detail : details) {
            accts.addAll(detail.getAccountIds());
            amountTypeList = (HashSet)amountTypeMap.get(detail.getId());
            if (amountTypeList == null) {
                amountTypeList = new HashSet();
                amountTypeMap.put(detail.getId(), amountTypeList);
            }
            amountTypeList.addAll(detail.getAmountTypeList());
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)ReconServiceHelper.class.getName(), (String)"bd_accountview", (String)"id,dc", (QFilter[])new QFilter[]{new QFilter("id", "in", accts)}, null);
        Map<Long, Integer> dcMap = Collections.synchronizedMap(new HashMap(16));
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            dcMap.put(row.getLong("id"), row.getInteger("dc"));
        }
        return dcMap;
    }

    private static DataSet buildEmptyBizDataSet(ReconciliationParamModel paramModel) {
        DataSetBuilder builder = Algo.create((String)"FrmReconServiceHelper.sumDataSet").createDataSetBuilder(FRMDataSetModel.getBizRowMeta((DataTypeEnum)paramModel.getDataType()));
        DataSet sumDataSet = builder.build();
        sumDataSet = sumDataSet.groupBy(new String[]{"currency", "assist1_app", "assist2_app", "assist3_app", "assist4_app", "assist5_app", "assist6_app", "assist7_app", "assist8_app"}).agg((CustomAggFunction)new DistinctConcatAggFunction("distinctGroupConcat", (DataType)DataType.StringType), "rule", "rules").sum("openingbalance_app").sum("debitamount_app").sum("creditamount_app").sum("closingbalance_app").finish();
        return sumDataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DataSet getBizData(ReconciliationParamModel paramModel, List<BizDataParam> params, Long orgId, String appId, TaskInfo taskInfo, BizReconPlanDetailModel planDetailModel, AbstractCustomParamService customParamService, Boolean enablePlatformThreadPool) {
        if (CollectionUtils.isEmpty(params) || !planDetailModel.isNeedQueryBiz()) {
            logger.info("\u6ca1\u6709\u53d6\u6570\u89c4\u5219\u884c\u6216\u8005\u4e1a\u52a1\u8fc7\u6ee4\u67e5\u4e0d\u5230\u6570\u636e\uff0c\u4e0d\u67e5\u4e1a\u52a1\u6570\u636e\u76f4\u63a5\u8fd4\u56de\u3002");
            return ReconServiceHelper.buildEmptyBizDataSet(paramModel);
        }
        ArrayList bizServiceInstances = new ArrayList(10);
        params.forEach(param -> {
            param.setAcctOrgID(orgId.longValue());
            param.setAppId(appId);
            param.setAssistIndexMap(planDetailModel.getBizAssistIndexMap());
            param.setAssistType(planDetailModel.getAssistType());
            BizDataService service = new BizDataService((BizDataParam)param, paramModel);
            service.setCustomParamService(customParamService);
            bizServiceInstances.add(service);
        });
        AtomicInteger finishThreadCount = new AtomicInteger(0);
        CopyOnWriteArrayList<BizDataResult> resultList = new CopyOnWriteArrayList<BizDataResult>();
        int listsize = bizServiceInstances.size();
        Object o = new Object();
        ArrayBlockingQueue<BizDataServiceThread> queue = new ArrayBlockingQueue<BizDataServiceThread>(6);
        try {
            Object object = o;
            synchronized (object) {
                Iterator ite = bizServiceInstances.iterator();
                while (ite.hasNext()) {
                    BizDataServiceThread t = new BizDataServiceThread((BizDataService)ite.next(), resultList, o, listsize, finishThreadCount, queue, paramModel);
                    try {
                        queue.put(t);
                        if (enablePlatformThreadPool.booleanValue()) {
                            ThreadService.execute((Runnable)t, (TaskType)TaskType.FRM_SUMMARY_BIZ);
                            continue;
                        }
                        threadPool.executeIncludeRequestContext((Runnable)t);
                    }
                    catch (InterruptedException e) {
                        logger.error(ThrowableHelper.toString((Exception)e));
                        String errorMsgTag = ThrowableHelper.toString((Exception)e);
                        AppCacheHelper.updateTaskStatusWithDB((String)taskInfo.getBatchNo(), (String)String.valueOf(taskInfo.getId()), (ReconcilationResultEnum)ReconcilationResultEnum.error, null, (TaskStatusEnum)TaskStatusEnum.ERROR, null, (String[])new String[]{errorMsgTag, errorMsgTag});
                    }
                }
                while (listsize > 0) {
                    o.wait();
                    listsize = -1;
                }
            }
        }
        catch (Throwable e) {
            logger.error(ThrowableHelper.toString((Throwable)e));
            String errorMsgTag = ThrowableHelper.toString((Throwable)e);
            AppCacheHelper.updateTaskStatusWithDB((String)taskInfo.getBatchNo(), (String)String.valueOf(taskInfo.getId()), (ReconcilationResultEnum)ReconcilationResultEnum.error, null, (TaskStatusEnum)TaskStatusEnum.ERROR, null, (String[])new String[]{errorMsgTag, errorMsgTag});
        }
        Map needQueryBasedataIndex = planDetailModel.getBizAssistIndexMap();
        Algo algo = Algo.create((String)"BizDataService");
        if (resultList.isEmpty()) {
            return ReconServiceHelper.sumDataSet(null, paramModel, planDetailModel.getBalanceDc(), null, needQueryBasedataIndex);
        }
        HashMap<String, Set<Long>> needQueryBasedata = new HashMap<String, Set<Long>>(10);
        DataSet dataSet = null;
        for (BizDataResult dataResult : resultList) {
            CachedDataSet cacheDataSet;
            Map splitQueryBasedata = dataResult.getNeedQueryBasedata();
            ReconciliationUtil.mergeAssistMap((Map)splitQueryBasedata, needQueryBasedata, (Object)0L);
            String cacheId = dataResult.getResultCacheId();
            if (StringUtils.isEmpty((Object)cacheId) || (cacheDataSet = Algo.getCacheDataSet((String)cacheId)).getRowCount() == 0) continue;
            DataSet ruleDataSet = cacheDataSet.toDataSet(algo, true);
            if (dataSet == null) {
                dataSet = ruleDataSet;
                continue;
            }
            dataSet = dataSet.union(ruleDataSet);
        }
        return ReconServiceHelper.sumDataSet(dataSet, paramModel, planDetailModel.getBalanceDc(), needQueryBasedata, needQueryBasedataIndex);
    }

    public static DataSet sumDataSet(DataSet dataSet, ReconciliationParamModel paramModel, BalanceDcEnum balanceDc, Map<String, Set<Long>> needQueryBasedata, Map<String, Integer> needQueryBasedataIndex) {
        if (dataSet == null) {
            return ReconServiceHelper.buildEmptyBizDataSet(paramModel);
        }
        DataSet sumDataSet = dataSet.groupBy(new String[]{"currency", "assist1_app", "assist2_app", "assist3_app", "assist4_app", "assist5_app", "assist6_app", "assist7_app", "assist8_app"}).agg((CustomAggFunction)new DistinctConcatAggFunction("distinctGroupConcat", (DataType)DataType.StringType), "rule", "rules").sum("openingbalance_app").sum("debitamount_app").sum("creditamount_app").sum("closingbalance_app").finish();
        HashSet<String> groupByFields = new HashSet<String>(needQueryBasedata.size());
        List<String> collectField = Arrays.stream(sumDataSet.getRowMeta().getFields()).map(Field::getName).collect(Collectors.toList());
        for (Map.Entry<String, Set<Long>> entries : needQueryBasedata.entrySet()) {
            Set<Long> idSet = entries.getValue();
            if (idSet.isEmpty()) continue;
            String key = entries.getKey();
            String[] keySplit = key.split("\\.");
            idSet.remove(0L);
            DataSet baseDataAssistDataSet = null;
            int assistIndex = needQueryBasedataIndex.get(key);
            String replaceField = "assist" + assistIndex + "_app";
            collectField.remove(replaceField);
            collectField.add("basedatamid " + replaceField);
            QFilter idFilter = new QFilter("id", "in", idSet);
            baseDataAssistDataSet = AssistDataType.isBaseDataType((String)keySplit[0]) ? QueryServiceHelper.queryDataSet((String)"ALGO_GETMASTERID", (String)keySplit[1], (String)"id basdataid,masterid basedatamid", (QFilter[])new QFilter[]{idFilter}, null) : QueryServiceHelper.queryDataSet((String)ReconciliationUtil.class.getName(), (String)"bos_assistantdata_detail", (String)"id basdataid,masterid basedatamid", (QFilter[])new QFilter[]{idFilter}, null);
            sumDataSet = sumDataSet.leftJoin(baseDataAssistDataSet).on(replaceField, "basdataid").select(collectField.toArray(new String[0])).finish();
            collectField.remove("basedatamid " + replaceField);
            collectField.add(replaceField);
        }
        groupByFields.add("currency");
        groupByFields.addAll(Arrays.asList(BIZ_ASSIST_FIELDS));
        sumDataSet = sumDataSet.updateFields(BIZ_ASSIST_FIELDS, BIZ_ASSIST_FIELDS_EXP);
        sumDataSet = sumDataSet.groupBy(groupByFields.toArray(new String[0])).agg((CustomAggFunction)new DistinctConcatAggFunction("distinctGroupConcat", (DataType)DataType.StringType), "rules", "rules").sum("openingbalance_app").sum("debitamount_app").sum("creditamount_app").sum("closingbalance_app").finish();
        if (!paramModel.isInit()) {
            sumDataSet = ReconServiceHelper.caclBalance(sumDataSet, balanceDc, paramModel.isHasStart(), paramModel.isHasClose());
        }
        return sumDataSet;
    }

    protected static DataSet caclBalance(DataSet dataSet, BalanceDcEnum balanceDc, boolean hasStart, boolean hasEnd) {
        String[] updateExpr = null;
        if (BalanceDcEnum.DEBIT == balanceDc) {
            if (hasStart) {
                updateExpr = debit_updateEnd;
            } else if (hasEnd) {
                updateExpr = debit_updateStart;
            }
        } else if (hasStart) {
            updateExpr = credit_updateEnd;
        } else if (hasEnd) {
            updateExpr = credit_updateStart;
        }
        if (updateExpr != null) {
            return dataSet.updateField(updateExpr[0], updateExpr[1]);
        }
        return dataSet;
    }

    public static String transferToCache(DataSet ds, Long taskId, Long planDetailID) {
        long cacheStart = System.currentTimeMillis();
        CacheHint cacheHint = new CacheHint();
        cacheHint.setPageSize(ConfigurationUtil.getInteger((String)"bos.billlist.pagesize", (Integer)100000).intValue());
        int timeout = 7200;
        cacheHint.setTimeout((long)timeout, TimeUnit.SECONDS);
        String cacheId = ds.cache(cacheHint).getCacheId();
        cacheStart = System.currentTimeMillis() - cacheStart;
        logger.info(String.format("taikId:%s,planDetailId:%s,CacheDataSet\u8017\u65f6\uff1a%s", taskId, planDetailID, cacheStart));
        return cacheId;
    }

    public static boolean joinDataSet(ReconciliationParamModel paramModel, BizReconPlanModel planModel, BizReconPlanDetailModel detailModel, DataSet bizDataSet, DataSet glDataSet, int reconTab) {
        String cacheId = null;
        RowMeta bizRowMeta = bizDataSet.getRowMeta();
        List<String> bizFieldNames = Arrays.asList(bizRowMeta.getFieldNames());
        RowMeta glRowMeta = glDataSet.getRowMeta();
        List<String> glFieldNames = Arrays.asList(glRowMeta.getFieldNames());
        for (int i = 1; i <= 8; ++i) {
            String assistGl;
            String assistApp = "assist" + i + "_app";
            if (bizFieldNames.contains(assistApp)) {
                String expr = "case when " + assistApp + " is null then 0L else " + assistApp + " end";
                bizDataSet = bizDataSet.updateField(assistApp, expr);
            }
            if (!glFieldNames.contains(assistGl = "assist" + i + "_gl")) continue;
            String expr = "case when " + assistGl + " is null then 0L else " + assistGl + " end";
            glDataSet = glDataSet.updateField(assistGl, expr);
        }
        JoinDataSet dataSet = bizDataSet.fullJoin(glDataSet).on("currency", "currency_gl");
        DataSet joinDataSet = null;
        if (reconTab != 1) {
            dataSet = dataSet.on("assist1_app", "assist1_gl").on("assist2_app", "assist2_gl").on("assist3_app", "assist3_gl").on("assist4_app", "assist4_gl").on("assist5_app", "assist5_gl").on("assist6_app", "assist6_gl").on("assist7_app", "assist7_gl").on("assist8_app", "assist8_gl");
            joinDataSet = dataSet.select(bizFieldArr, new String[]{"currency_gl", "assist1_gl", "assist2_gl", "assist3_gl", "assist4_gl", "assist5_gl", "assist6_gl", "assist7_gl", "assist8_gl", "openingbalance_gl", "debitamount_gl", "creditamount_gl", "closingbalance_gl", "glassgrps", "account"}).finish();
            joinDataSet = joinDataSet.updateField("currency", "case when currency is null then currency_gl else currency end");
        } else {
            joinDataSet = dataSet.select(accountFieldArr).finish();
            joinDataSet = joinDataSet.addNullField(new String[]{"assist1_gl", "assist2_gl", "assist3_gl", "assist4_gl", "assist5_gl", "assist6_gl", "assist7_gl", "assist8_gl", "glassgrps", "account"});
        }
        joinDataSet = joinDataSet.updateFields(amountFields, initAmountExp);
        joinDataSet = joinDataSet.updateFields(BIZ_ASSIST_FIELDS, BIZ_ASSIST_FIELDS_EXP);
        joinDataSet = joinDataSet.updateFields(GL_ASSIST_FIELDS, GL_ASSIST_FIELDS_EXP);
        String[] allFields = null;
        boolean init = paramModel.isInit();
        allFields = init ? initAllFieldArr : allFieldArr;
        joinDataSet = joinDataSet.select(allFields);
        joinDataSet = joinDataSet.addNullField("status");
        joinDataSet = init ? joinDataSet.updateField("status", "case when init_diff <> 0 then 0 else 1 end") : joinDataSet.updateField("status", ReconciliationAmountTypeUtil.getBalanceExpr((BalanceBasisEnum)detailModel.getBalanceBasis()));
        boolean api = paramModel.isApi();
        boolean reconEqual = true;
        if (DataTypeEnum.OnlyStatus == paramModel.getDataType()) {
            DataSet resultDataSet;
            if (joinDataSet.hasNext() && (resultDataSet = joinDataSet.executeSql("select status where status = 0 limit 1")).hasNext()) {
                reconEqual = false;
                if (!init) {
                    reconEqual = api && ReconServiceHelper.isEqual(false, detailModel.isCloseParam());
                }
                ReconcilationResultEnum reconcilationResult = reconEqual ? ReconcilationResultEnum.Pass : ReconcilationResultEnum.fail;
                joinDataSet.close();
                AppCacheHelper.updateTaskStatusWithDB((String)paramModel.getTaskInfo().getBatchNo(), (String)(paramModel.getTaskInfo().getId() + ""), (ReconcilationResultEnum)reconcilationResult, null, (TaskStatusEnum)TaskStatusEnum.FINISHED, null, null);
            }
        } else if (DataTypeEnum.NotDetail == paramModel.getDataType()) {
            if (!joinDataSet.hasNext()) {
                AppCacheHelper.updateTaskStatusWithDB((String)paramModel.getTaskInfo().getBatchNo(), (String)(paramModel.getTaskInfo().getId() + ""), (ReconcilationResultEnum)ReconcilationResultEnum.Pass, null, null, null, null);
                return true;
            }
            DataSet resultDataSet = joinDataSet.copy().executeSql("select status where status = 0 limit 1");
            if (resultDataSet.hasNext()) {
                reconEqual = false;
                if (!init) {
                    reconEqual = api && ReconServiceHelper.isEqual(false, detailModel.isCloseParam());
                }
                ReconcilationResultEnum reconcilationResult = reconEqual ? ReconcilationResultEnum.Pass : ReconcilationResultEnum.fail;
                AppCacheHelper.updateTaskStatusWithDB((String)paramModel.getTaskInfo().getBatchNo(), (String)(paramModel.getTaskInfo().getId() + ""), (ReconcilationResultEnum)reconcilationResult, null, null, null, null);
            } else {
                AppCacheHelper.updateTaskStatusWithDB((String)paramModel.getTaskInfo().getBatchNo(), (String)(paramModel.getTaskInfo().getId() + ""), (ReconcilationResultEnum)ReconcilationResultEnum.Pass, null, null, null, null);
            }
            joinDataSet = joinDataSet.addFields(new String[]{reconTab + "", detailModel.getId() + ""}, new String[]{"assisttype", "plandetailid"});
            cacheId = ReconServiceHelper.transferToCache(joinDataSet, paramModel.getTaskInfo().getId(), detailModel.getId());
            AppCacheHelper.putTaskCache((String)(paramModel.getTaskInfo().getId() + ""), (String)(detailModel.getId() + ""), (String)cacheId);
        }
        return reconEqual;
    }

    private static boolean isEqual(boolean reconEqual, boolean closeParam) {
        if (!reconEqual && !closeParam) {
            reconEqual = true;
        }
        return reconEqual;
    }

    public static void setDc(BizReconPlanDetailModel planDetailModel, Map<Long, Integer> dcMap) {
        BalanceDcEnum balanceDc = planDetailModel.getBalanceDc();
        Set accountIds = planDetailModel.getAccountIds();
        BigDecimal dcBigDecimal = BigDecimal.ONE;
        int dc = 0;
        if (BalanceDcEnum.EMPTY == balanceDc && accountIds.size() > 0) {
            Long accountId = (Long)accountIds.iterator().next();
            dc = dcMap.get(accountId) == null ? 1 : dcMap.get(accountId);
            dcBigDecimal = new BigDecimal(dc);
            balanceDc = BalanceDcEnum.getEnum((String)String.valueOf(dcBigDecimal));
            planDetailModel.setBalanceDc(balanceDc);
            if (-1 == dc) {
                planDetailModel.setBalanceDc(BalanceDcEnum.CREDIT);
            } else if (1 == dc) {
                planDetailModel.setBalanceDc(BalanceDcEnum.DEBIT);
            }
        } else if (BalanceDcEnum.EMPTY != balanceDc) {
            dcBigDecimal = ReconciliationUtil.getBalanceDc((BalanceDcEnum)balanceDc);
        }
        planDetailModel.setDc(dcBigDecimal);
    }

    static class BizDataServiceThread
    implements Runnable {
        private final ArrayBlockingQueue<BizDataServiceThread> queue;
        private BizDataService bizDataService;
        private List<BizDataResult> resultList;
        private final Object lock;
        private final int listsize;
        private AtomicInteger finishThreadCount;
        private ReconciliationParamModel paramModel;

        BizDataServiceThread(BizDataService bizDataService, List<BizDataResult> resultList, Object lock, int listsize, AtomicInteger finishThreadCount, ArrayBlockingQueue<BizDataServiceThread> queue, ReconciliationParamModel paramModel) {
            this.bizDataService = bizDataService;
            this.resultList = resultList;
            this.lock = lock;
            this.listsize = listsize;
            this.finishThreadCount = finishThreadCount;
            this.queue = queue;
            this.paramModel = paramModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block27: {
                TaskInfo taskInfo = this.paramModel.getTaskInfo();
                String batchNo = taskInfo.getBatchNo();
                Long taskId = taskInfo.getId();
                this.bizDataService.execute();
                this.finishThreadCount.getAndIncrement();
                if (!this.queue.remove(this)) {
                    // empty if block
                }
                try {
                    if (this.bizDataService.hasResult()) {
                        BizDataResult dataResult = this.bizDataService.getDataResult();
                        this.resultList.add(dataResult);
                    }
                }
                catch (Throwable e) {
                    logger.error(ThrowableHelper.toString((Throwable)e));
                    String errorMsgTag = ThrowableHelper.toString((Throwable)e);
                    AppCacheHelper.updateTaskStatusWithDB((String)batchNo, (String)String.valueOf(taskId), (ReconcilationResultEnum)ReconcilationResultEnum.error, null, (TaskStatusEnum)TaskStatusEnum.ERROR, null, (String[])new String[]{errorMsgTag, errorMsgTag});
                }
                if (this.listsize == this.finishThreadCount.get()) {
                    Object e = this.lock;
                    synchronized (e) {
                        this.lock.notifyAll();
                    }
                }
                break block27;
                catch (Throwable e4) {
                    String errorMsgTag;
                    try {
                        logger.error(e4);
                        errorMsgTag = ThrowableHelper.toString((Throwable)e4);
                        AppCacheHelper.updateTaskStatusWithDB((String)batchNo, (String)String.valueOf(taskId), (ReconcilationResultEnum)ReconcilationResultEnum.error, null, (TaskStatusEnum)TaskStatusEnum.ERROR, null, (String[])new String[]{errorMsgTag, errorMsgTag});
                        this.finishThreadCount.getAndIncrement();
                    }
                    catch (Throwable throwable) {
                        this.finishThreadCount.getAndIncrement();
                        if (!this.queue.remove(this)) {
                            // empty if block
                        }
                        try {
                            if (this.bizDataService.hasResult()) {
                                BizDataResult dataResult = this.bizDataService.getDataResult();
                                this.resultList.add(dataResult);
                            }
                        }
                        catch (Throwable e2) {
                            logger.error(ThrowableHelper.toString((Throwable)e2));
                            String errorMsgTag2 = ThrowableHelper.toString((Throwable)e2);
                            AppCacheHelper.updateTaskStatusWithDB((String)batchNo, (String)String.valueOf(taskId), (ReconcilationResultEnum)ReconcilationResultEnum.error, null, (TaskStatusEnum)TaskStatusEnum.ERROR, null, (String[])new String[]{errorMsgTag2, errorMsgTag2});
                        }
                        if (this.listsize == this.finishThreadCount.get()) {
                            Object object = this.lock;
                            synchronized (object) {
                                this.lock.notifyAll();
                            }
                        }
                        throw throwable;
                    }
                    if (!this.queue.remove(this)) {
                        // empty if block
                    }
                    try {
                        if (this.bizDataService.hasResult()) {
                            BizDataResult dataResult = this.bizDataService.getDataResult();
                            this.resultList.add(dataResult);
                        }
                    }
                    catch (Throwable e3) {
                        logger.error(ThrowableHelper.toString((Throwable)e3));
                        errorMsgTag = ThrowableHelper.toString((Throwable)e3);
                        AppCacheHelper.updateTaskStatusWithDB((String)batchNo, (String)String.valueOf(taskId), (ReconcilationResultEnum)ReconcilationResultEnum.error, null, (TaskStatusEnum)TaskStatusEnum.ERROR, null, (String[])new String[]{errorMsgTag, errorMsgTag});
                    }
                    if (this.listsize != this.finishThreadCount.get()) break block27;
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.notifyAll();
                    }
                }
            }
        }
    }
}

