/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.impl.detail;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.algo.util.bitset.LongBitSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.xdb.util.ConcurrentHashSet;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.enums.AssistDataType;
import kd.fi.frm.common.enums.AssistTypeEnum;
import kd.fi.frm.common.enums.DataTypeEnum;
import kd.fi.frm.common.enums.DetailDataTypeEnum;
import kd.fi.frm.common.enums.DetailDcEnum;
import kd.fi.frm.common.enums.DetailTypeEnum;
import kd.fi.frm.common.enums.ReconAmountTypeEnum;
import kd.fi.frm.common.enums.ReconcilationResultEnum;
import kd.fi.frm.common.model.FRMDataSetModel;
import kd.fi.frm.common.model.FrmLogger;
import kd.fi.frm.common.model.ReconDiffSummeryModel;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.bizdata.BizDataParam;
import kd.fi.frm.common.model.bizdata.BizDataSourceConfig;
import kd.fi.frm.common.model.bizdata.BizDataTypeEnum;
import kd.fi.frm.common.model.bizdata.BizReconPlanDetailModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanModel;
import kd.fi.frm.common.model2.RelationDataParam3;
import kd.fi.frm.common.relation.RelationParam;
import kd.fi.frm.common.relation.RelationServiceAdaptor;
import kd.fi.frm.common.relation.RelationTypeEnum;
import kd.fi.frm.common.task.TaskDao;
import kd.fi.frm.common.task.TaskInfo;
import kd.fi.frm.common.task.TaskStatusEnum;
import kd.fi.frm.common.util.FaBillParamUtils;
import kd.fi.frm.common.util.FrmRowUtil;
import kd.fi.frm.common.util.MapUtil;
import kd.fi.frm.common.util.ReconciliationParmUtil;
import kd.fi.frm.common.util.ReconciliationUtil;
import kd.fi.frm.common.util.ThrowableHelper;
import kd.fi.frm.mservice.AssistMappingUtil;
import kd.fi.frm.mservice.bizdata.BizDataService;
import kd.fi.frm.mservice.bizdata.ext.custom.AbstractCustomParamService;
import kd.fi.frm.mservice.bizdata.ext.custom.CustomParamUtil;
import kd.fi.frm.mservice.gldata.DetailDataFormat;
import kd.fi.frm.mservice.gldata.ReconDetailRelationRepair;
import kd.fi.frm.mservice.impl.AbstractReconciliationService;
import kd.fi.frm.mservice.impl.ReconServiceHelper;
import kd.fi.frm.mservice.rpt.RptBizAppConfigServiceHelper;
import kd.fi.frm.mservice.rpt.invoke.RptBizDataQueryService;

class AbstractDetailService
extends AbstractReconciliationService {
    protected static final Log logger = LogFactory.getLog(AbstractDetailService.class);
    public static final ThreadPool DETAIL_THREAD_POOL = ThreadPools.newFixedThreadPool((String)"frm-abstractdetailservice", (int)3);
    protected static final int DETAIL_LIMIT = Integer.parseInt(System.getProperty("prop.fi.ai.recon.detaillimit", "1000"));
    public static final String MUL_TO_MUL_CACHE_KEY_SUFFIX = "mul2mul";
    private static Object[] noBillArray = new Object[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, "", 0L, "", -1, BigDecimal.ZERO};
    private static Object[] noVchArray = new Object[]{0L, "", -1, BigDecimal.ZERO};
    protected RelationDataParam3 param;
    protected final List<BizDataParam> ruleParams = new ArrayList<BizDataParam>();
    protected List<QFilter> comDapFilters = new ArrayList<QFilter>();
    protected List<QFilter> reverseVchFilters = new ArrayList<QFilter>();
    Set<Long> reverseRelationVchIds = new HashSet<Long>();
    protected Set<Long> acctIdSet = new HashSet<Long>();
    protected Map<String, List<BizDataParam>> group = new HashMap<String, List<BizDataParam>>();
    protected String selector = "";
    protected QFilter handVchDcFilter = null;
    protected String orgName = "";
    protected QFilter periodFilter = null;
    protected int progressStep = 0;
    protected FrmLogger frmLogger;
    protected BizReconPlanDetailModel detailModel;
    protected Set<Long> allRelateVchIds = new HashSet<Long>(16);
    protected boolean prepared = false;
    private AbstractCustomParamService customParamService;
    protected DynamicObject bizAppRefGlConfig;
    protected boolean isVchIdStr;
    protected DynamicObject bizAppConfig;
    protected Map<Long, Object> indexVchMap = new HashMap<Long, Object>();
    protected Map<Object, Long> vchIndexMap = new HashMap<Object, Long>();
    private RowMeta detailRowMeta;

    public Set<Long> getAllRelateVchIds() {
        return this.allRelateVchIds;
    }

    public AbstractDetailService(RelationDataParam3 param, ReconciliationParamModel paramModel) {
        param.setCurrency(paramModel.getCurrency());
        this.param = param;
        this.buildParam(paramModel);
        ReconciliationUtil.initFrmLoggerCache((FrmLogger)paramModel.getFrmLogger());
    }

    @Override
    public void execute() {
        try {
            this.prepared = this.prepare();
        }
        catch (Throwable tx) {
            logger.error("\u660e\u7ec6\u5bf9\u8d26prepare", tx);
            String errorMsgTag = ThrowableHelper.toString((Throwable)tx);
            AppCacheHelper.updateTaskStatusWithDB((String)this.paramModel.getTaskInfo().getBatchNo(), (String)String.valueOf(this.paramModel.getTaskInfo().getId()), (ReconcilationResultEnum)ReconcilationResultEnum.error, null, (TaskStatusEnum)TaskStatusEnum.ERROR, null, (String[])new String[]{errorMsgTag, errorMsgTag});
        }
        if (!this.prepared) {
            TaskInfo taskInfo = this.paramModel.getTaskInfo();
            taskInfo.setTaskStatus(TaskStatusEnum.FINISHED);
            AppCacheHelper.putTaskCache((String)taskInfo.getBatchNo(), (String)taskInfo.getId().toString(), (String)SerializationUtils.serializeToBase64((Object)taskInfo));
            if (this.planModel != null) {
                TaskDao.updateTaskReconPlan((Long)taskInfo.getId(), (long)this.planModel.getId(), (long)(this.dataRule == null ? 0L : this.dataRule.getLong("id")), (Long)taskInfo.getGlAppCfgId());
            }
            TaskDao.finishTask((long)taskInfo.getId(), (ReconcilationResultEnum)taskInfo.getCode());
        }
    }

    protected void calcProgress(int count, TaskInfo taskInfo) {
        AppCacheHelper.updateTaskStatusWithDB((String)taskInfo.getBatchNo(), (String)String.valueOf(taskInfo.getId()), null, null, null, (Integer)count, null);
    }

    private void buildParam(ReconciliationParamModel paramModel2) {
        this.paramModel = new ReconciliationParamModel();
        this.paramModel.setAccountIds(this.param.getAccountIds());
        this.paramModel.setDataType(DataTypeEnum.Detail);
        this.paramModel.setInit(false);
        this.paramModel.setPeriodId(Long.valueOf(this.param.getPeriodid()));
        this.paramModel.setBookTypeId(Long.valueOf(this.param.getAcctBookTypeID()));
        this.paramModel.setLocalCurrency(paramModel2.isLocalCurrency());
        this.paramModel.getOrgIds().add(this.param.getAcctOrgID());
        this.paramModel.setCurrency(this.param.getCurrency());
        this.paramModel.setAccountTable(this.param.getAccountTableId());
        if (paramModel2.isAnalyzeMode()) {
            this.paramModel.setAnalyzeBillId(paramModel2.getAnalyzeBillId());
            this.paramModel.setAnalyzeVoucherId(paramModel2.getAnalyzeVoucherId());
            this.paramModel.setAnalyzeRuleIds(paramModel2.getAnalyzeRuleIds());
            this.paramModel.setPrintDataSet(paramModel2.getPrintDataSet());
            this.paramModel.setAnalyzeMode();
        }
        this.paramModel.setTaskInfo(paramModel2.getTaskInfo());
        this.paramModel.setDetailTypeEnum(paramModel2.getDetailTypeEnum());
        this.paramModel.setBizOrgIds(paramModel2.getBizOrgIds());
        this.paramModel.setPlanDetailId(paramModel2.getPlanDetailId());
        this.paramModel.setBizAssistTable(paramModel2.getBizAssistTable());
        this.paramModel.setAssist(paramModel2.getAssist());
        this.paramModel.setCustomParam(paramModel2.getCustomParam());
        this.paramModel.setAssistTypeEnum(paramModel2.getAssistTypeEnum());
        this.frmLogger = paramModel2.getFrmLogger();
    }

    protected void getAllLeafAccts(Set<Long> acctIdSet, Set<Long> acctMasterSet) {
        Set<Object> accountIds = new HashSet(10);
        if (this.param.getAccountIds() == null || this.param.getAccountIds().isEmpty()) {
            boolean getAcctByAssistIdEnable = FaBillParamUtils.getBooleanValue((Long)0L, (String)"frm_acct_assistid_enable");
            if (getAcctByAssistIdEnable) {
                accountIds = ReconServiceHelper.getAcctIdsByAssistConfig(this.detailModel.getAsstTypeCondList(), this.planModel.getAccoutTableId(), this.planModel.getOrgId(), this.paramModel.getPeriodId());
            } else {
                ArrayList<String> assistTypeList = new ArrayList<String>(10);
                if (this.param.getAssistMap() != null && this.param.getAssistMap().size() > 0) {
                    assistTypeList.addAll(this.param.getAssistMap().keySet());
                } else {
                    assistTypeList.addAll(this.detailModel.getAssistAcctTypeList());
                }
                accountIds = ReconServiceHelper.getAcctIds(assistTypeList, this.param.getAccountTableId(), this.param.getAcctOrgID(), this.param.getPeriodid());
            }
        } else {
            accountIds.addAll(this.param.getAccountIds());
        }
        ReconciliationUtil.getDetailAccountId((Long)this.param.getAcctOrgID(), (Long)this.param.getAccountTableId(), (Long)this.param.getPeriodid(), accountIds, acctIdSet, acctMasterSet);
    }

    protected void getDataRule() {
        this.planModel = ReconciliationUtil.getPlanModel((Long)this.param.getAcctBookTypeID(), (Long)this.param.getAcctOrgID(), (String)this.param.getAppId(), (Long)this.param.getPeriodid(), (Long)this.paramModel.getPlanDetailId());
        if (this.planModel == null) {
            throw new KDBizException(ReconcilationResultEnum.noExecPlan.getName());
        }
        this.dataRule = ReconciliationUtil.getDataRule((Long)this.planModel.getRuleId(), (ReconAmountTypeEnum)this.planModel.getReconAmountType());
        CustomParamUtil.setCustomParam(this.paramModel, this.dataRule);
        Map commonFilterMap = ReconciliationParmUtil.getAllCommonFilter();
        this.initFunctionPk(this.param.getAcctOrgID(), commonFilterMap);
        this.detailModel = ReconciliationUtil.getDetailModel((BizReconPlanModel)this.planModel, (Long)this.param.getId());
        ReconciliationUtil.planDetailAssist((BizReconPlanDetailModel)this.detailModel, (Long)this.param.getAcctOrgID());
        this.customParamService = CustomParamUtil.paramConversion(this.paramModel, this.detailModel, this.param);
        this.param.setAssistValueRange(this.detailModel.getAssistValueRange());
        List params = ReconciliationParmUtil.getDataRuleParam((BizReconPlanDetailModel)this.detailModel, (DynamicObject)this.dataRule, (List)this.detailModel.getAmountTypeList(), (ReconciliationParamModel)this.paramModel, (Long)this.param.getAcctOrgID(), (ReconAmountTypeEnum)this.planModel.getReconAmountType());
        boolean needQuery = true;
        String bizAssistTable = this.paramModel.getBizAssistTable();
        List<Object> bizAssistIdSetMapList = new ArrayList(8);
        AssistTypeEnum assistType = this.detailModel.getAssistType();
        if (AssistTypeEnum.Acct == assistType) {
            Map bizAssistMap = new HashMap(8);
            if (!StringUtils.isEmpty((Object)bizAssistTable)) {
                bizAssistMap = ReconciliationUtil.getBizAssistMap((String)bizAssistTable);
            }
            if (!CollectionUtils.isEmpty(bizAssistMap)) {
                bizAssistIdSetMapList.add(bizAssistMap);
            } else {
                bizAssistIdSetMapList = AssistMappingUtil.acctBizFilterToBizAssistMap(this.detailModel.getBizFilterAssistMapList());
            }
        } else {
            HashMap assistQueryMap = new HashMap(8);
            ArrayList<Map<String, Set<Long>>> tmpBizAssistMapList = params.size() == 0 ? new ArrayList(0) : ((BizDataParam)params.get(0)).getBizAssistIdSetMapList();
            needQuery = AssistMappingUtil.getAssistQueryMap(this.paramModel.getTaskInfo().getOrgId(), this.detailModel.getAssistDataMapping(), bizAssistTable, this.paramModel.getAssist(), tmpBizAssistMapList, assistQueryMap);
            bizAssistIdSetMapList.add(assistQueryMap);
        }
        for (BizDataParam bizParam : params) {
            bizParam.setNeedQueryBiz(needQuery);
            bizParam.setBizAssistIdSetMapList(bizAssistIdSetMapList);
            boolean contains = false;
            BizDataSourceConfig config = bizParam.getSourceConfig();
            if (config.getDimPropMap().keySet().containsAll(this.param.getBizAssistMap().keySet())) {
                contains = true;
            }
            if (!contains) continue;
            bizParam.setSourceConfig(config);
            this.ruleParams.add(bizParam);
        }
        this.group = this.ruleParams.stream().collect(Collectors.groupingBy(BizDataParam::getEntityKey));
        if (this.ruleParams.size() > 0) {
            TaskInfo taskInfo = this.paramModel.getTaskInfo();
            String taskId = String.valueOf(taskInfo.getId());
            String batchNo = taskInfo.getBatchNo();
            String taskCache = AppCacheHelper.getTaskCache((String)batchNo, (String)taskId);
            TaskInfo taskCacheInfo = (TaskInfo)SerializationUtils.deSerializeFromBase64((String)taskCache);
            taskCacheInfo.setExedStep(Integer.valueOf(0));
            taskCacheInfo.setPercent(Integer.valueOf(0));
            taskCacheInfo.setTotalStep(Integer.valueOf(this.ruleParams.size()));
            AppCacheHelper.putTaskCache((String)taskInfo.getBatchNo(), (String)taskInfo.getId().toString(), (String)SerializationUtils.serializeToBase64((Object)taskCacheInfo));
        }
    }

    @Override
    protected boolean prepare() throws Exception {
        Map bizAssistMap;
        Map assistMap;
        boolean reverse;
        HashSet<Long> acctMasterSet = new HashSet<Long>(16);
        this.getDataRule();
        this.getAllLeafAccts(this.acctIdSet, acctMasterSet);
        this.initComDapFilters();
        this.bizAppConfig = RptBizAppConfigServiceHelper.getBizAppConfig(this.planModel.getAppId());
        boolean bl = reverse = this.bizAppConfig != null && this.bizAppConfig.getBoolean("reverse");
        if (!reverse) {
            this.reverseRelationVchIds = RelationServiceAdaptor.getReverRelation((FrmLogger)this.frmLogger, this.reverseVchFilters);
        }
        if (!CollectionUtils.isEmpty((Map)(assistMap = this.param.getAssistMap())) && (bizAssistMap = this.param.getBizAssistMap()) != null && bizAssistMap.size() > 0) {
            ReconciliationUtil.mergeAssistMap((Map)bizAssistMap, (Map)assistMap, (Object)0L);
        }
        this.getSelectField();
        Map<Long, String> orgNameMap = DetailDataFormat.getAllOrgName(this.paramModel);
        this.orgName = orgNameMap.entrySet().iterator().next().getValue();
        this.progressStep = (int)Math.floor(80.0 / (double)this.ruleParams.size());
        ReconciliationUtil.initSysParam((ReconciliationParamModel)this.paramModel, null);
        if (this.param.isExport()) {
            String taskId = String.valueOf(this.paramModel.getTaskInfo().getId());
            AppCacheHelper.putResultCache((String)("DETAIL_NOT_ALL:" + taskId), (Object)Boolean.FALSE);
        }
        this.bizAppRefGlConfig = RptBizAppConfigServiceHelper.getBizAppRefGlConfig(this.planModel.getAppId());
        TaskInfo taskInfo = this.paramModel.getTaskInfo();
        if (this.bizAppRefGlConfig != null) {
            taskInfo.setGlAppCfgId(Long.valueOf(this.bizAppRefGlConfig.getLong("id")));
            this.isVchIdStr = "2".equals(this.bizAppRefGlConfig.getString("vchidtype"));
        }
        this.detailRowMeta = FRMDataSetModel.getDetailRelateRowMeta();
        TaskDao.updateTaskReconPlan((Long)taskInfo.getId(), (long)this.planModel.getId(), (long)(this.dataRule == null ? 0L : this.dataRule.getLong("id")), (Long)taskInfo.getGlAppCfgId());
        this.enablePlatformThreadPool = FaBillParamUtils.getBooleanValue((Long)0L, (String)"frm_enable_platform_threadpool");
        return true;
    }

    protected void initComDapFilters() {
        QFilter orgFilter = new QFilter("entries.eorg", "=", (Object)this.param.getAcctOrgID());
        QFilter vchOrgFilter = new QFilter("org", "=", (Object)this.param.getAcctOrgID());
        this.comDapFilters.add(orgFilter);
        this.comDapFilters.add(vchOrgFilter);
        this.reverseVchFilters.add(orgFilter);
        QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)this.param.getAcctBookTypeID());
        this.comDapFilters.add(bookTypeFilter);
        QFilter acctFilter = new QFilter("entries.account.id", "in", this.acctIdSet);
        this.comDapFilters.add(acctFilter);
        this.reverseVchFilters.add(acctFilter);
        boolean hasVoucher = this.param.getAssgrpSet().size() > 0;
        QFilter assFilter = null;
        if (hasVoucher) {
            assFilter = new QFilter("entries.assgrp", "in", (Object)this.param.getAssgrpSet());
            this.comDapFilters.add(assFilter);
            this.reverseVchFilters.add(assFilter);
        }
        if (!this.paramModel.isLocalCurrency()) {
            QFilter currencyFilter = new QFilter("entries.currency", "=", (Object)this.param.getCurrency());
            this.comDapFilters.add(currencyFilter);
        }
        this.periodFilter = new QFilter("entries.eperiod", "=", (Object)this.param.getPeriodid());
        QFilter vchPeriodFilter = new QFilter("period", "=", (Object)this.param.getPeriodid());
        this.comDapFilters.add(this.periodFilter);
        this.comDapFilters.add(vchPeriodFilter);
        this.reverseVchFilters.add(this.periodFilter);
        if (this.paramModel.isAnalyzeMode() && this.paramModel.getAnalyzeVoucherId() > 0L) {
            QFilter idFilter = new QFilter("id", "=", (Object)this.paramModel.getAnalyzeVoucherId());
            this.comDapFilters.add(idFilter);
            this.reverseVchFilters.add(idFilter);
        }
    }

    protected RelationParam initRelationParam() {
        RelationParam relationParam = new RelationParam();
        relationParam.setTargetEntity("gl_voucher");
        relationParam.setPeriodId(Long.valueOf(this.param.getPeriodid()));
        relationParam.setAcctOrgId(Long.valueOf(this.param.getAcctOrgID()));
        relationParam.setBizOrgIds(this.paramModel.getBizOrgIds());
        return relationParam;
    }

    protected void innerExecute(Map<String, List<BizDataParam>> group, TaskInfo taskInfo) {
        RelationParam relationParam = this.initRelationParam();
        relationParam.setRelationType(RelationTypeEnum.DAP);
        int index = 0;
        this.paramModel.log("group.size(): " + group.size());
        for (Map.Entry<String, List<BizDataParam>> mapEntry : group.entrySet()) {
            this.paramModel.log("loop group, index: " + index);
            String entityKey = mapEntry.getKey();
            List<BizDataParam> bizDataParamLst = mapEntry.getValue();
            relationParam.setSourceEntity(entityKey);
            ConcurrentHashSet<Long> tmpRelateVchIds = this.innerExecute4Relation(bizDataParamLst, relationParam);
            if (!CollectionUtils.isEmpty(tmpRelateVchIds)) {
                this.allRelateVchIds.addAll((Collection<Long>)tmpRelateVchIds);
            }
            ++index;
            this.calcProgress(bizDataParamLst.size(), taskInfo);
        }
    }

    protected Map<String, Set<Long>> getBizAssistLeaf(Map<String, Set<Long>> bizAssistMasterIdMap) {
        HashMap<String, Set<Long>> newBizAssistMap = new HashMap<String, Set<Long>>(bizAssistMasterIdMap.size());
        for (Map.Entry<String, Set<Long>> entry : bizAssistMasterIdMap.entrySet()) {
            String entity = entry.getKey();
            Set<Long> ids = entry.getValue();
            ids.remove(0L);
            if (ids.size() == 0) continue;
            Set leafIds = ReconciliationUtil.getAllByMasterId((String)entry.getKey(), entry.getValue());
            ids.addAll(leafIds);
            newBizAssistMap.put(entity, ids);
        }
        return newBizAssistMap;
    }

    protected ConcurrentHashSet<Long> innerExecute4Relation(List<BizDataParam> bizDataParamLst, RelationParam relationParam) {
        TaskInfo taskInfo = this.paramModel.getTaskInfo();
        Map bizAssistMasterIdMap = this.param.getBizAssistMap();
        Map<String, Set<Long>> bizAssistIdMap = this.getBizAssistLeaf(bizAssistMasterIdMap);
        String bizAssistTableStr = this.paramModel.getBizAssistTable();
        DataSet assistMasterDataSet = null;
        boolean needJoinAssistGroup = false;
        if (!StringUtils.isEmpty((Object)bizAssistTableStr)) {
            List bizAssistTable = (List)SerializationUtils.fromJsonString((String)bizAssistTableStr, List.class);
            List head = (List)bizAssistTable.get(0);
            boolean bl = needJoinAssistGroup = bizAssistTable.size() > 2 && head.size() > 1;
            if (needJoinAssistGroup) {
                ArrayList<Field> rowMetaField = new ArrayList<Field>(head.size());
                ArrayList<String> orgSelectFields = new ArrayList<String>(10);
                for (Object dimKey : head) {
                    String fieldkey = "f" + dimKey.toString().replace(".", "_") + "_mid";
                    rowMetaField.add(new Field(fieldkey, (DataType)DataType.LongType));
                    orgSelectFields.add(fieldkey);
                }
                RowMeta rowMeta = new RowMeta(rowMetaField.toArray(new Field[0]));
                DataSetBuilder builder = Algo.create((String)"frm_preview_assistgroup").createDataSetBuilder(rowMeta);
                for (int i = 1; i < bizAssistTable.size(); ++i) {
                    List bodyRow = (List)bizAssistTable.get(i);
                    Object[] valArray = bodyRow.stream().map(id -> Long.valueOf(id.toString())).toArray();
                    builder.append(valArray);
                }
                assistMasterDataSet = builder.build();
                for (Object dimKey : head) {
                    String fieldkey = "f" + dimKey.toString().replace(".", "_");
                    String[] entitySplit = dimKey.toString().split("\\.");
                    String entityId = "";
                    entityId = AssistDataType.isBaseDataType((String)entitySplit[0]) ? entitySplit[1] : "bos_assistantdata_detail";
                    DataSet dataSet = QueryServiceHelper.queryDataSet((String)"frm_preview_assistgroup", (String)entityId, (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("masterid", "in", bizAssistMasterIdMap.get(dimKey.toString()))}, (String)"");
                    assistMasterDataSet = assistMasterDataSet.join(dataSet).on(fieldkey + "_mid", "masterid").select(orgSelectFields.toArray(new String[0]), new String[]{"id " + fieldkey + "_id"}).finish();
                    orgSelectFields.add(fieldkey + "_id");
                }
            }
        }
        FrmLogger frmLogger = this.paramModel.getFrmLogger();
        HashSet<Long> vchIdSet = new HashSet<Long>(1);
        if (this.paramModel.isAnalyzeMode() && this.paramModel.getAnalyzeVoucherId() > 0L) {
            vchIdSet.add(this.paramModel.getAnalyzeVoucherId());
        }
        long bizStart = System.currentTimeMillis();
        CountDownLatch countDownLatch = new CountDownLatch(bizDataParamLst.size());
        ConcurrentHashSet curRelateVchIds = new ConcurrentHashSet();
        for (BizDataParam bizDataParam : bizDataParamLst) {
            DataSet finalAssistMasterDataSet = assistMasterDataSet == null ? null : assistMasterDataSet.copy();
            boolean _needJoinAssistGroup = needJoinAssistGroup;
            DetailTask detailTask = new DetailTask(taskInfo, bizAssistIdMap, bizDataParam, _needJoinAssistGroup, finalAssistMasterDataSet, relationParam, vchIdSet, (ConcurrentHashSet<Long>)curRelateVchIds, countDownLatch);
            if (this.enablePlatformThreadPool) {
                ThreadService.execute((Runnable)detailTask, (TaskType)TaskType.FRM_DETAIL_TASK, (RequestContext)RequestContext.get());
                continue;
            }
            DETAIL_THREAD_POOL.execute((Runnable)detailTask, RequestContext.get());
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage());
            throw new KDBizException((Throwable)e, new ErrorCode("UNKNOWN_ERR", "%s"), new Object[]{ThrowableHelper.toString((Exception)e)});
        }
        bizStart = System.currentTimeMillis() - bizStart;
        logger.info("taikId:{},entity:{},\u660e\u7ec6\u8868\u5bf9\u8d26\u8017\u65f6\uff1a{}", new Object[]{taskInfo.getId(), relationParam.getSourceEntity(), bizStart});
        return curRelateVchIds;
    }

    private MapFunction handleStrVchId() {
        final RowMeta dapRowMeta = FRMDataSetModel.getDapRelationRowMeta();
        return new MapFunction(){
            private static final long serialVersionUID = 5931480419734199762L;
            long index = -1L;

            public Object[] map(Row row) {
                Object[] values = new Object[dapRowMeta.getFields().length];
                String vchIdStr = row.getString("voucherid");
                values[0] = row.get("entity");
                values[2] = row.get("sourcebillid");
                values[1] = AbstractDetailService.this.vchIndexMap.containsKey(vchIdStr) ? AbstractDetailService.this.vchIndexMap.get(vchIdStr) : Long.valueOf(this.index--);
                return values;
            }

            public RowMeta getResultRowMeta() {
                return dapRowMeta;
            }
        };
    }

    private Map<Long, Set<Long>> getOne2MulRelation(DataSet relationDataSet) {
        HashMap<Long, Set<Long>> bill2nVchMap = new HashMap<Long, Set<Long>>(16);
        relationDataSet = relationDataSet.groupBy(new String[]{"sourcebillid"}).groupConcat("voucherid", "vchids").finish();
        for (Row row : relationDataSet) {
            String vchIds = row.getString("vchids");
            Long billId = row.getLong("sourcebillid");
            if (!vchIds.contains(",")) continue;
            HashSet<Long> tmpVchIds = new HashSet<Long>(8);
            for (String vchIdStr : vchIds.split(",")) {
                tmpVchIds.add(Long.parseLong(vchIdStr));
            }
            bill2nVchMap.put(billId, tmpVchIds);
        }
        return bill2nVchMap;
    }

    private int handleRelation1ToMul(Set<Long> curRelateVchIds, List<Row> onlyBillRows, List<Row> equalRows, List<Row> unEqualRows, Map<Long, Set<Long>> bill2nVchMap, List<Row> oneBillRows, List<Row> mulVchRows, ReconDiffSummeryModel summeryModel, Map<Long, Set<Long>> vchAccountMap, int detailRestCount) {
        if (bill2nVchMap == null || bill2nVchMap.size() == 0) {
            return detailRestCount;
        }
        HashMap<Long, Row> billMap = new HashMap<Long, Row>(16);
        for (Row row : oneBillRows) {
            billMap.put(row.getLong("billid"), row);
        }
        if (billMap.size() == 0) {
            return detailRestCount;
        }
        HashMap<Long, Row> vchMap = new HashMap<Long, Row>(16);
        for (Row row : mulVchRows) {
            vchMap.put(row.getLong("id"), row);
        }
        for (Map.Entry<Long, Set<Long>> bill2VchEntry : bill2nVchMap.entrySet()) {
            Long l = bill2VchEntry.getKey();
            Row bill = (Row)billMap.get(l);
            if (bill == null) continue;
            BigDecimal totalBillAmount = bill.getBigDecimal("billamount");
            BigDecimal totalVchAmount = BigDecimal.ZERO;
            HashSet<Long> accountIds = new HashSet<Long>(16);
            ArrayList<Row> vchList = new ArrayList<Row>(16);
            Set<Long> tmpVchIds = bill2VchEntry.getValue();
            HashSet<Long> tmpRelateVchIds = new HashSet<Long>(16);
            List<Object> rows = new ArrayList(16);
            for (Long tmpVchId : tmpVchIds) {
                Set<Long> tmpAccountIds;
                Row row = (Row)vchMap.get(tmpVchId);
                if (row != null) {
                    vchList.add(row);
                    tmpRelateVchIds.add(tmpVchId);
                    BigDecimal debit = FrmRowUtil.getBigDecimal((Row)row, (String)"debit", (BigDecimal)BigDecimal.ZERO);
                    BigDecimal credit = FrmRowUtil.getBigDecimal((Row)row, (String)"credit", (BigDecimal)BigDecimal.ZERO);
                    BigDecimal vchAmount = BigDecimal.ZERO.compareTo(debit) != 0 ? debit : credit;
                    totalVchAmount = totalVchAmount.add(vchAmount);
                }
                if ((tmpAccountIds = vchAccountMap.get(tmpVchId)) == null || tmpAccountIds.size() <= 0) continue;
                accountIds.addAll(tmpAccountIds);
            }
            DetailDataTypeEnum detailDataType = DetailDataTypeEnum.EQUAL;
            if (vchList.size() == 0) {
                if (detailRestCount > 1) {
                    Row onlyBillRow = this.createOnlyBillRow(bill, accountIds);
                    onlyBillRows.add(onlyBillRow);
                    int n = FrmRowUtil.getIntVal((Row)onlyBillRow, (String)"bizdc", (int)-1);
                    BigDecimal incrAmt = FrmRowUtil.getBigDecimal((Row)onlyBillRow, (String)"billamount", (BigDecimal)BigDecimal.ZERO);
                    summeryModel.incrAmount(n, false, true, incrAmt);
                    --detailRestCount;
                }
            } else {
                curRelateVchIds.addAll(tmpRelateVchIds);
                if (totalBillAmount.compareTo(totalVchAmount) == 0) {
                    if (this.param.isExport()) {
                        rows = this.create1ToMulRow(bill, vchList, accountIds, totalVchAmount, detailRestCount);
                        equalRows.addAll(rows);
                        detailDataType = DetailDataTypeEnum.EQUAL;
                        detailRestCount -= rows.size();
                    } else {
                        int dc = FrmRowUtil.getIntVal((Row)bill, (String)"bizdc", (int)-1);
                        summeryModel.incrAmount(dc, true, false, totalBillAmount);
                    }
                } else {
                    rows = this.create1ToMulRow(bill, vchList, accountIds, totalVchAmount, detailRestCount);
                    unEqualRows.addAll(rows);
                    detailDataType = DetailDataTypeEnum.NOT_EQUAL;
                    detailRestCount -= rows.size();
                }
            }
            for (Row row : rows) {
                int dc;
                int pid = FrmRowUtil.getIntVal((Row)row, (String)"pid", (int)-1);
                if (pid != 0) continue;
                if (DetailDataTypeEnum.NOT_EQUAL == detailDataType) {
                    dc = FrmRowUtil.getIntVal((Row)row, (String)"bizdc", (int)-1);
                    BigDecimal bizamt = FrmRowUtil.getBigDecimal((Row)row, (String)"bizamt", (BigDecimal)BigDecimal.ZERO);
                    summeryModel.incrAmount(dc, false, true, bizamt);
                    BigDecimal glamt = FrmRowUtil.getBigDecimal((Row)row, (String)"glamt", (BigDecimal)BigDecimal.ZERO);
                    summeryModel.incrAmount(dc, false, false, glamt);
                    continue;
                }
                dc = FrmRowUtil.getIntVal((Row)row, (String)"bizdc", (int)-1);
                BigDecimal incrAmt = FrmRowUtil.getBigDecimal((Row)row, (String)"bizamt", (BigDecimal)BigDecimal.ZERO);
                summeryModel.incrAmount(dc, true, false, incrAmt);
            }
        }
        return detailRestCount;
    }

    private int getDetailRestCount(String taskId) {
        if (this.param.isExport() || this.param.isShowAll()) {
            return Integer.MAX_VALUE;
        }
        return AppCacheHelper.getDetailRestCount((String)taskId, (int)DETAIL_LIMIT);
    }

    private void updateDetailRestCount(String taskId, int detailRestCount) {
        if (this.param.isExport()) {
            return;
        }
        AppCacheHelper.updateDetailRestCount((String)taskId, (int)DETAIL_LIMIT, (int)detailRestCount);
    }

    private void dealOnlyHandBill(Iterator<Row> billIterator, int detailRestCount, List<Row> onlyBillRows, ReconDiffSummeryModel summeryModel, String taskId) {
        while (billIterator.hasNext() && detailRestCount > 0) {
            detailRestCount = this.checkAndCreateOnlyBillRow(billIterator.next(), onlyBillRows, summeryModel, detailRestCount);
        }
        this.updateDetailRestCount(taskId, detailRestCount);
    }

    private void handleRelationMulTo1(DataSet billDs, DataSet relationDs, DataSet vchDs, ConcurrentHashSet<Long> curRelateVchIds, Map<Long, Set<Long>> vchAccountMap, Map<Long, Set<Long>> bill2nVchMap) {
        String taskId = String.valueOf(this.paramModel.getTaskInfo().getId());
        int detailRestCount = this.getDetailRestCount(taskId);
        ReconDiffSummeryModel summeryModel = new ReconDiffSummeryModel();
        ArrayList<Row> onlyBillRows = new ArrayList<Row>(100);
        if (vchDs == null) {
            this.dealOnlyHandBill(billDs.iterator(), detailRestCount, onlyBillRows, summeryModel, taskId);
            this.storeIntoCache(this.detailRowMeta, onlyBillRows, DetailDataTypeEnum.HAND_BILL);
            AppCacheHelper.addList((String)(this.paramModel.getTaskInfo().getId() + ".detail.summery"), (String)SerializationUtils.toJsonString((Object)summeryModel));
            return;
        }
        this.frmLogger.logDataSet("detail bizDataSet : ", billDs);
        this.frmLogger.logDataSet("detail relationDataSet : ", relationDs);
        this.frmLogger.logDataSet("detail vchDataSet : ", vchDs);
        String[] leftFields = billDs.getRowMeta().getFieldNames();
        DataSet leftDs = billDs.leftJoin(relationDs).on("billid", "sourcebillid").select(leftFields, new String[]{"voucherid vchid"}).finish();
        leftDs = leftDs.updateField("vchid", "case when vchid is null then 0L else vchid end");
        leftDs = leftDs.orderBy(new String[]{"vchid asc"});
        vchDs = vchDs.orderBy(new String[]{"id asc"});
        this.frmLogger.logDataSet("detail leftDs : ", leftDs);
        this.frmLogger.logDataSet("detail rightDs : ", vchDs);
        ArrayList<Row> equalRows = new ArrayList<Row>(100);
        ArrayList<Row> unEqualRows = new ArrayList<Row>(100);
        ArrayList<Row> oneBillRows = new ArrayList<Row>(100);
        ArrayList<Row> mulVchRows = new ArrayList<Row>(400);
        boolean allHandBill = false;
        Set<Long> oneBillIds = bill2nVchMap.keySet();
        HashSet<Long> mulVchIds = new HashSet<Long>(16);
        for (Set<Long> vchIdSet : bill2nVchMap.values()) {
            if (vchIdSet == null || vchIdSet.size() <= 0) continue;
            mulVchIds.addAll(vchIdSet);
        }
        Iterator leftCursor = leftDs.iterator();
        Iterator rightCursor = vchDs.iterator();
        if (!leftCursor.hasNext()) {
            return;
        }
        if (!rightCursor.hasNext()) {
            allHandBill = true;
            ArrayList<Row> singleHandBills = new ArrayList<Row>(100);
            while (leftCursor.hasNext()) {
                Row next = (Row)leftCursor.next();
                if (detailRestCount <= 0) break;
                if (oneBillIds.contains(next.getLong("billid"))) {
                    oneBillRows.add(next);
                    continue;
                }
                singleHandBills.add(next);
            }
            if (singleHandBills.size() > 0) {
                this.dealOnlyHandBill(singleHandBills.iterator(), detailRestCount, onlyBillRows, summeryModel, taskId);
            }
        }
        ArrayList<Row> leftBuff = new ArrayList<Row>(10);
        boolean loopLeft = true;
        while (rightCursor.hasNext()) {
            BigDecimal totalAmount;
            Row curRightRow = (Row)rightCursor.next();
            Long curRightVchId = curRightRow.getLong("id");
            if (mulVchIds.contains(curRightVchId)) {
                mulVchRows.add(curRightRow);
                continue;
            }
            Set<Long> accountIds = vchAccountMap.get(curRightVchId);
            if (leftBuff.size() > 0) {
                Row bufLeftRow = (Row)leftBuff.get(0);
                if (curRightRow.getLong("id").compareTo(bufLeftRow.getLong("vchid")) < 0) continue;
                if (bufLeftRow.getLong("vchid").compareTo(curRightRow.getLong("id")) < 0) {
                    detailRestCount = this.checkAndCreateOnlyBillRow(bufLeftRow, onlyBillRows, summeryModel, detailRestCount);
                    leftBuff.clear();
                    loopLeft = true;
                } else {
                    if (!leftCursor.hasNext()) {
                        if (bufLeftRow.getLong("vchid").compareTo(curRightVchId) == 0) {
                            totalAmount = BigDecimal.ZERO;
                            for (Row buf : leftBuff) {
                                totalAmount = totalAmount.add(buf.getBigDecimal("billamount"));
                            }
                            if (totalAmount.compareTo(this.getVchAmountFromRow(curRightRow)) == 0) {
                                if (this.param.isExport()) {
                                    detailRestCount = this.checkAndCreateMulTo1Row(leftBuff, curRightRow, totalAmount, accountIds, equalRows, DetailDataTypeEnum.EQUAL, summeryModel, detailRestCount);
                                } else {
                                    int dc = FrmRowUtil.getIntVal((Row)((Row)leftBuff.get(0)), (String)"bizdc", (int)-1);
                                    summeryModel.incrAmount(dc, true, false, totalAmount);
                                }
                            } else {
                                detailRestCount = this.checkAndCreateMulTo1Row(leftBuff, curRightRow, totalAmount, accountIds, unEqualRows, DetailDataTypeEnum.NOT_EQUAL, summeryModel, detailRestCount);
                            }
                            curRelateVchIds.add((Object)curRightVchId);
                        } else {
                            detailRestCount = this.checkAndCreateMulTo1Row(leftBuff, null, BigDecimal.ZERO, accountIds, onlyBillRows, DetailDataTypeEnum.HAND_BILL, summeryModel, detailRestCount);
                        }
                        leftBuff.clear();
                        break;
                    }
                    loopLeft = true;
                }
            }
            boolean usedRightRow = false;
            while (loopLeft && leftCursor.hasNext()) {
                Row curLeftRow = (Row)leftCursor.next();
                Long curLeftVchId = curLeftRow.getLong("vchid");
                Long curLeftBillId = curLeftRow.getLong("billid");
                if (oneBillIds.contains(curLeftBillId)) {
                    oneBillRows.add(curLeftRow);
                    continue;
                }
                if (curLeftVchId == null || curLeftVchId == 0L) {
                    detailRestCount = this.checkAndCreateOnlyBillRow(curLeftRow, onlyBillRows, summeryModel, detailRestCount);
                    continue;
                }
                if (curLeftVchId.compareTo(curRightVchId) < 0) {
                    detailRestCount = this.checkAndCreateOnlyBillRow(curLeftRow, onlyBillRows, summeryModel, detailRestCount);
                    if (leftBuff.size() <= 0) continue;
                    detailRestCount = this.checkAndCreateMulTo1Row(leftBuff, null, BigDecimal.ZERO, null, onlyBillRows, DetailDataTypeEnum.HAND_BILL, summeryModel, detailRestCount);
                    leftBuff.clear();
                    continue;
                }
                if (curLeftVchId.compareTo(curRightVchId) == 0) {
                    leftBuff.add(curLeftRow);
                    continue;
                }
                if (leftBuff.size() == 0 && curLeftVchId.compareTo(curRightVchId) > 0) {
                    leftBuff.add(curLeftRow);
                    usedRightRow = true;
                    break;
                }
                if (leftBuff.size() <= 0) continue;
                BigDecimal totalAmount2 = BigDecimal.ZERO;
                for (Row buf : leftBuff) {
                    totalAmount2 = totalAmount2.add(buf.getBigDecimal("billamount"));
                }
                if (totalAmount2.compareTo(this.getVchAmountFromRow(curRightRow)) == 0) {
                    if (this.param.isExport()) {
                        detailRestCount = this.checkAndCreateMulTo1Row(leftBuff, curRightRow, totalAmount2, accountIds, equalRows, DetailDataTypeEnum.EQUAL, summeryModel, detailRestCount);
                    } else {
                        int dc = FrmRowUtil.getIntVal((Row)((Row)leftBuff.get(0)), (String)"bizdc", (int)-1);
                        summeryModel.incrAmount(dc, true, false, totalAmount2);
                    }
                } else {
                    detailRestCount = this.checkAndCreateMulTo1Row(leftBuff, curRightRow, totalAmount2, accountIds, unEqualRows, DetailDataTypeEnum.NOT_EQUAL, summeryModel, detailRestCount);
                }
                curRelateVchIds.add((Object)curRightVchId);
                leftBuff.clear();
                leftBuff.add(curLeftRow);
                loopLeft = false;
                usedRightRow = true;
                break;
            }
            if (leftCursor.hasNext() || usedRightRow || leftBuff.isEmpty()) continue;
            totalAmount = BigDecimal.ZERO;
            for (Row buf : leftBuff) {
                totalAmount = totalAmount.add(buf.getBigDecimal("billamount"));
            }
            if (totalAmount.compareTo(this.getVchAmountFromRow(curRightRow)) == 0) {
                if (this.param.isExport()) {
                    detailRestCount = this.checkAndCreateMulTo1Row(leftBuff, curRightRow, totalAmount, accountIds, equalRows, DetailDataTypeEnum.EQUAL, summeryModel, detailRestCount);
                } else {
                    int dc = FrmRowUtil.getIntVal((Row)((Row)leftBuff.get(0)), (String)"bizdc", (int)-1);
                    summeryModel.incrAmount(dc, true, false, totalAmount);
                }
            } else {
                detailRestCount = this.checkAndCreateMulTo1Row(leftBuff, curRightRow, totalAmount, accountIds, unEqualRows, DetailDataTypeEnum.NOT_EQUAL, summeryModel, detailRestCount);
            }
            curRelateVchIds.add((Object)curRightVchId);
            leftBuff.clear();
        }
        if (!leftBuff.isEmpty()) {
            detailRestCount = this.checkAndCreateMulTo1Row(leftBuff, null, BigDecimal.ZERO, null, onlyBillRows, DetailDataTypeEnum.HAND_BILL, summeryModel, detailRestCount);
        }
        if (!allHandBill) {
            while (leftCursor.hasNext()) {
                Row nextBill = (Row)leftCursor.next();
                Long curLeftBillId = nextBill.getLong("billid");
                if (oneBillIds.contains(curLeftBillId)) {
                    oneBillRows.add(nextBill);
                    continue;
                }
                if (detailRestCount <= 0) break;
                detailRestCount = this.checkAndCreateOnlyBillRow(nextBill, onlyBillRows, summeryModel, detailRestCount);
            }
        }
        detailRestCount = this.handleRelation1ToMul((Set<Long>)curRelateVchIds, (List<Row>)onlyBillRows, (List<Row>)equalRows, (List<Row>)unEqualRows, bill2nVchMap, (List<Row>)oneBillRows, (List<Row>)mulVchRows, summeryModel, vchAccountMap, detailRestCount);
        this.updateDetailRestCount(taskId, detailRestCount);
        this.storeIntoCache(this.detailRowMeta, onlyBillRows, DetailDataTypeEnum.HAND_BILL);
        this.storeIntoCache(this.detailRowMeta, equalRows, DetailDataTypeEnum.EQUAL);
        this.storeIntoCache(this.detailRowMeta, unEqualRows, DetailDataTypeEnum.NOT_EQUAL);
        AppCacheHelper.addList((String)(this.paramModel.getTaskInfo().getId() + ".detail.summery"), (String)SerializationUtils.toJsonString((Object)summeryModel));
    }

    private int checkAndCreateMulTo1Row(List<Row> bills, Row vch, BigDecimal totalAmount, Set<Long> accountIds, List<Row> collector, DetailDataTypeEnum detailDataType, ReconDiffSummeryModel summeryModel, int detailRestCount) {
        if (detailRestCount <= 0) {
            return detailRestCount;
        }
        if (bills.size() > detailRestCount) {
            bills = bills.subList(0, detailRestCount);
        }
        List<Row> rows = this.createMulto1Row(bills, vch, totalAmount, accountIds);
        collector.addAll(rows);
        for (Row row : rows) {
            BigDecimal incrAmt;
            int dc;
            int pid = FrmRowUtil.getIntVal((Row)row, (String)"pid", (int)-1);
            if (pid != 0) continue;
            if (DetailDataTypeEnum.HAND_BILL == detailDataType) {
                dc = FrmRowUtil.getIntVal((Row)row, (String)"bizdc", (int)-1);
                incrAmt = FrmRowUtil.getBigDecimal((Row)row, (String)"billamount", (BigDecimal)BigDecimal.ZERO);
                summeryModel.incrAmount(dc, false, true, incrAmt);
                continue;
            }
            if (DetailDataTypeEnum.NOT_EQUAL == detailDataType) {
                dc = FrmRowUtil.getIntVal((Row)row, (String)"bizdc", (int)-1);
                BigDecimal bizamt = FrmRowUtil.getBigDecimal((Row)row, (String)"bizamt", (BigDecimal)BigDecimal.ZERO);
                summeryModel.incrAmount(dc, false, true, bizamt);
                BigDecimal glamt = FrmRowUtil.getBigDecimal((Row)row, (String)"glamt", (BigDecimal)BigDecimal.ZERO);
                summeryModel.incrAmount(dc, false, false, glamt);
                continue;
            }
            dc = FrmRowUtil.getIntVal((Row)row, (String)"bizdc", (int)-1);
            incrAmt = FrmRowUtil.getBigDecimal((Row)row, (String)"bizamt", (BigDecimal)BigDecimal.ZERO);
            summeryModel.incrAmount(dc, true, false, incrAmt);
        }
        return detailRestCount -= rows.size();
    }

    private int checkAndCreateOnlyBillRow(Row bill, List<Row> collector, ReconDiffSummeryModel summeryModel, int detailRestCount) {
        if (detailRestCount <= 0) {
            return detailRestCount;
        }
        Row onlyBillRow = this.createOnlyBillRow(bill, null);
        collector.add(onlyBillRow);
        int dc = FrmRowUtil.getIntVal((Row)onlyBillRow, (String)"bizdc", (int)-1);
        BigDecimal incrAmt = FrmRowUtil.getBigDecimal((Row)onlyBillRow, (String)"billamount", (BigDecimal)BigDecimal.ZERO);
        summeryModel.incrAmount(dc, false, true, incrAmt);
        return --detailRestCount;
    }

    private Row createOnlyBillRow(Row bill, Set<Long> accountIds) {
        RowMeta relateRowMeta = this.detailRowMeta;
        Object[] values = new Object[relateRowMeta.getFields().length];
        this.fillBillValues(bill, values);
        this.fillVchValues(null, values, -1, accountIds);
        values[19] = values[14];
        values[20] = BigDecimal.ZERO;
        values[21] = values[14];
        values[22] = 0L;
        values[23] = this.genGlobalLongId();
        values[24] = 1;
        return RowFactory.createRow((RowMeta)relateRowMeta, (Object[])values);
    }

    private Row createOnlyVchRow(Row vch, Set<Long> accountIds) {
        RowMeta relateRowMeta = this.detailRowMeta;
        Object[] values = new Object[relateRowMeta.getFields().length];
        this.fillBillValues(null, values);
        this.fillVchValues(vch, values, -1, accountIds);
        values[19] = BigDecimal.ZERO;
        values[20] = values[18];
        values[21] = BigDecimal.ZERO.subtract((BigDecimal)values[20]);
        values[22] = 0L;
        values[23] = this.genGlobalLongId();
        values[24] = 1;
        return RowFactory.createRow((RowMeta)relateRowMeta, (Object[])values);
    }

    private Row create1to1Row(Row bill, Row vch, Set<Long> accountIds) {
        RowMeta relateRowMeta = this.detailRowMeta;
        Object[] values = new Object[relateRowMeta.getFields().length];
        this.fillBillValues(bill, values);
        this.fillVchValues(vch, values, -1, accountIds);
        values[19] = values[14];
        values[20] = values[18];
        values[21] = ((BigDecimal)values[19]).subtract((BigDecimal)values[20]);
        values[22] = 0L;
        values[23] = this.genGlobalLongId();
        values[24] = 1;
        return RowFactory.createRow((RowMeta)relateRowMeta, (Object[])values);
    }

    private List<Row> createMulto1Row(List<Row> bills, Row vch, BigDecimal totalBillAmount, Set<Long> accountIds) {
        ArrayList<Row> resultRows;
        block6: {
            RowMeta relateRowMeta;
            block5: {
                relateRowMeta = this.detailRowMeta;
                resultRows = new ArrayList<Row>(bills == null ? 1 : bills.size());
                if (bills == null && vch == null) {
                    return Collections.emptyList();
                }
                if (vch != null || bills.size() != 1) break block5;
                for (Row bill : bills) {
                    resultRows.add(this.createOnlyBillRow(bill, accountIds));
                }
                break block6;
            }
            if (bills == null || bills.size() == 0) break block6;
            if (bills.size() == 1) {
                Row row = this.create1to1Row(bills.get(0), vch, accountIds);
                resultRows.add(row);
            } else {
                long pid = this.genGlobalLongId();
                Object[] virtualRow = this.createVirtualRow(1, bills.size(), pid, bills.get(0), vch, totalBillAmount, accountIds);
                resultRows.add(RowFactory.createRow((RowMeta)relateRowMeta, (Object[])virtualRow));
                for (Row bill : bills) {
                    Object[] values = new Object[relateRowMeta.getFields().length];
                    this.fillBillValues(bill, values);
                    this.fillVchValues(null, values, FrmRowUtil.getIntVal((Row)bill, (String)"bizdc", (int)-1), accountIds);
                    values[19] = BigDecimal.ZERO;
                    values[20] = BigDecimal.ZERO;
                    values[21] = BigDecimal.ZERO;
                    values[22] = pid;
                    values[23] = this.genGlobalLongId();
                    values[24] = 1;
                    resultRows.add(RowFactory.createRow((RowMeta)relateRowMeta, (Object[])values));
                }
            }
        }
        return resultRows;
    }

    private List<Row> create1ToMulRow(Row bill, List<Row> vchList, Set<Long> accountIds, BigDecimal totalVchAmount, int detailRestCount) {
        if (bill == null || CollectionUtils.isEmpty(vchList)) {
            return Collections.emptyList();
        }
        if (detailRestCount <= 0) {
            return Collections.emptyList();
        }
        RowMeta relateRowMeta = this.detailRowMeta;
        ArrayList<Row> resultRows = new ArrayList<Row>(vchList.size());
        if (vchList.size() == 1 && detailRestCount > 1) {
            resultRows.add(this.create1to1Row(bill, vchList.get(0), accountIds));
            return resultRows;
        }
        long pid = this.genGlobalLongId();
        Object[] virtualRow = this.createVirtualRow(2, vchList.size(), pid, bill, vchList.get(0), totalVchAmount, accountIds);
        resultRows.add(RowFactory.createRow((RowMeta)relateRowMeta, (Object[])virtualRow));
        if (vchList.size() > detailRestCount) {
            vchList = vchList.subList(0, detailRestCount);
        }
        for (Row vch : vchList) {
            Object[] values = new Object[relateRowMeta.getFields().length];
            this.fillBillValues(null, values);
            this.fillVchValues(vch, values, FrmRowUtil.getIntVal((Row)bill, (String)"bizdc", (int)-1), accountIds);
            values[19] = BigDecimal.ZERO;
            values[20] = values[18];
            values[21] = BigDecimal.ZERO;
            values[22] = pid;
            values[23] = this.genGlobalLongId();
            values[24] = 1;
            resultRows.add(RowFactory.createRow((RowMeta)relateRowMeta, (Object[])values));
        }
        return resultRows;
    }

    private Object[] createVirtualRow(int type, int sumSize, long rowId, Row bill, Row vch, BigDecimal totalAmount, Set<Long> accountIds) {
        RowMeta relateRowMeta = this.detailRowMeta;
        Object[] virtualRow = new Object[relateRowMeta.getFields().length];
        if (type == 1) {
            this.fillBillValues(bill, virtualRow, true);
            virtualRow[13] = bill.get("bizdc");
            virtualRow[14] = totalAmount;
            this.fillVchValues(vch, virtualRow, -1, accountIds);
            virtualRow[19] = totalAmount;
            virtualRow[20] = virtualRow[18];
        } else {
            this.fillBillValues(bill, virtualRow);
            this.fillVchValues(vch, virtualRow, -1, true, accountIds);
            virtualRow[18] = BigDecimal.ZERO;
            virtualRow[19] = virtualRow[14];
            virtualRow[20] = totalAmount;
        }
        virtualRow[21] = ((BigDecimal)virtualRow[19]).subtract((BigDecimal)virtualRow[20]);
        virtualRow[22] = 0;
        virtualRow[23] = rowId;
        virtualRow[24] = sumSize;
        return virtualRow;
    }

    private void fillVchValues(Row vch, Object[] values, int billDc, Set<Long> accountIds) {
        if (vch == null) {
            System.arraycopy(noVchArray, 0, values, 15, 4);
            return;
        }
        this.fillVchValues(vch, values, billDc, false, accountIds);
    }

    private void fillVchValues(Row vch, Object[] values, int billDc, boolean virtualRow, Set<Long> accountIds) {
        BigDecimal debit = FrmRowUtil.getBigDecimal((Row)vch, (String)"debit", (BigDecimal)BigDecimal.ZERO);
        BigDecimal glAmount = BigDecimal.ZERO;
        int vchDc = -1;
        if (BigDecimal.ZERO.compareTo(debit) != 0) {
            glAmount = debit;
            vchDc = DetailDcEnum.DEBIT.getValue();
        } else {
            glAmount = FrmRowUtil.getBigDecimal((Row)vch, (String)"credit", (BigDecimal)BigDecimal.ZERO);
            vchDc = DetailDcEnum.CREDIT.getValue();
        }
        values[15] = accountIds != null && accountIds.size() == 1 ? accountIds.toArray(new Long[0])[0] : 0L;
        values[16] = !virtualRow ? vch.getString("id") : Long.valueOf(0L);
        values[17] = billDc != -1 ? billDc : vchDc;
        values[18] = glAmount;
        values[25] = vch.getString("rptvchid");
        values[26] = vch.getString("rptvchno");
    }

    private void fillBillValues(Row bill, Object[] values) {
        if (bill == null) {
            System.arraycopy(noBillArray, 0, values, 0, 14);
            return;
        }
        this.fillBillValues(bill, values, false);
    }

    private void fillBillValues(Row bill, Object[] values, boolean virtualRow) {
        values[0] = bill.get("currency");
        values[1] = bill.get("billorg");
        if (!virtualRow) {
            values[2] = bill.get("assist1_app");
            values[3] = bill.get("assist2_app");
            values[4] = bill.get("assist3_app");
            values[5] = bill.get("assist4_app");
            values[6] = bill.get("assist5_app");
            values[7] = bill.get("assist6_app");
            values[8] = bill.get("assist7_app");
            values[9] = bill.get("assist8_app");
            values[11] = bill.get("billid");
            values[12] = bill.get("billno");
        } else {
            values[2] = 0L;
            values[3] = 0L;
            values[4] = 0L;
            values[5] = 0L;
            values[6] = 0L;
            values[7] = 0L;
            values[8] = 0L;
            values[9] = 0L;
            values[11] = 0L;
            values[12] = "";
        }
        values[10] = bill.get("billentity");
        values[13] = bill.get("bizdc");
        BigDecimal billAmount = FrmRowUtil.getBigDecimal((Row)bill, (String)"billamount", (BigDecimal)BigDecimal.ZERO);
        values[14] = billAmount;
    }

    private BigDecimal getVchAmountFromRow(Row vch) {
        if (vch == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal debit = vch.getBigDecimal("debit");
        if (BigDecimal.ZERO.compareTo(debit) == 0) {
            return vch.getBigDecimal("credit");
        }
        return debit;
    }

    private void storeIntoCache(RowMeta rowMeta, List<Row> rows, DetailDataTypeEnum detailDataType) {
        if (rows == null || rows.size() == 0) {
            return;
        }
        DataSetBuilder builder = Algo.create((String)"AbstractDetailService").createDataSetBuilder(rowMeta);
        for (Row row : rows) {
            builder.append(row);
        }
        if (this.param.isShowAll() && !this.param.isExport()) {
            return;
        }
        if (this.param.isExport() || !this.param.isExport() && DetailDataTypeEnum.EQUAL != detailDataType) {
            DataSet dataSet = builder.build();
            String batchNo = this.paramModel.getTaskInfo().getId() + detailDataType.getValue();
            String cacheTaskId = AppCacheHelper.getCacheTaskId();
            String dataSetCacheId = ReconServiceHelper.transferToCache(dataSet, this.paramModel.getTaskInfo().getId(), this.detailModel.getId());
            AppCacheHelper.putTaskCache((String)batchNo, (String)cacheTaskId, (String)dataSetCacheId);
        }
    }

    protected void getSelectField() {
        ReconAmountTypeEnum reconAmountType = this.planModel.getReconAmountType();
        DetailTypeEnum detailTypeEnum = this.paramModel.getDetailTypeEnum();
        block0 : switch (detailTypeEnum) {
            case DEBIT_DIFF: {
                if (this.paramModel.isLocalCurrency()) {
                    this.handVchDcFilter = new QFilter("entries.debitlocal", "!=", (Object)0);
                    this.selector = "id,entries.debitlocal debit,entries.creditlocal credit,entries.account account,sourcebilltype srcentity";
                } else {
                    this.selector = "id,entries.debitori debit,entries.creditori credit,entries.account account,sourcebilltype srcentity";
                    this.handVchDcFilter = new QFilter("entries.debitori", "!=", (Object)0);
                }
                this.comDapFilters.add(new QFilter("entries.entrydc", "=", (Object)"1"));
                break;
            }
            case CREDIT_DIFF: {
                if (this.paramModel.isLocalCurrency()) {
                    this.selector = "id,entries.debitlocal debit,entries.creditlocal credit,entries.account account,sourcebilltype srcentity";
                    this.handVchDcFilter = new QFilter("entries.creditlocal", "!=", (Object)0);
                } else {
                    this.selector = "id,entries.debitori debit,entries.creditori credit,entries.account account,sourcebilltype srcentity";
                    this.handVchDcFilter = new QFilter("entries.creditori", "!=", (Object)0);
                }
                this.comDapFilters.add(new QFilter("entries.entrydc", "=", (Object)"-1"));
                break;
            }
            case STATUS: {
                if (this.paramModel.isLocalCurrency()) {
                    switch (reconAmountType) {
                        case DEBIT: {
                            this.selector = "id,entries.debitlocal debit,entries.creditlocal credit,entries.account account,sourcebilltype srcentity";
                            this.handVchDcFilter = new QFilter("entries.debitlocal", "!=", (Object)0);
                            this.comDapFilters.add(new QFilter("entries.entrydc", "=", (Object)"1"));
                            break block0;
                        }
                        case CREDIT: {
                            this.selector = "id,entries.debitlocal debit,entries.creditlocal credit,entries.account account,sourcebilltype srcentity";
                            this.handVchDcFilter = new QFilter("entries.creditlocal", "!=", (Object)0);
                            this.comDapFilters.add(new QFilter("entries.entrydc", "=", (Object)"-1"));
                            break block0;
                        }
                    }
                    this.selector = "id,entries.debitlocal debit,entries.creditlocal credit,entries.account account,sourcebilltype srcentity";
                    break;
                }
                switch (reconAmountType) {
                    case DEBIT: {
                        this.selector = "id,entries.debitori debit,entries.creditori credit,entries.account account,sourcebilltype srcentity";
                        this.handVchDcFilter = new QFilter("entries.debitori", "!=", (Object)0);
                        this.comDapFilters.add(new QFilter("entries.entrydc", "=", (Object)"1"));
                        break block0;
                    }
                    case CREDIT: {
                        this.selector = "id,entries.debitori debit,entries.creditori credit,entries.account account,sourcebilltype srcentity";
                        this.handVchDcFilter = new QFilter("entries.creditori", "!=", (Object)0);
                        this.comDapFilters.add(new QFilter("entries.entrydc", "=", (Object)"-1"));
                        break block0;
                    }
                }
                this.selector = "id,entries.debitori debit,entries.creditori credit,entries.account account,sourcebilltype srcentity";
                break;
            }
        }
        this.selector = this.selector + ",billstatus";
    }

    protected Map<String, List<BizDataParam>> getCasBizDataParam(Map<String, List<BizDataParam>> group) {
        HashMap<String, List<BizDataParam>> casBizDataParam = new HashMap<String, List<BizDataParam>>(8);
        Set<Map.Entry<String, List<BizDataParam>>> entries = group.entrySet();
        Iterator<Map.Entry<String, List<BizDataParam>>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<BizDataParam>> next = iterator.next();
            if (!RelationServiceAdaptor.isCAS((String)next.getKey())) continue;
            casBizDataParam.computeIfAbsent(next.getKey(), p -> new ArrayList()).addAll((Collection)next.getValue());
            iterator.remove();
        }
        return casBizDataParam;
    }

    protected void dealOnlyHandVch(String vchCacheDataSetId) {
        if (vchCacheDataSetId == null) {
            return;
        }
        CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)this.param.getVchCacheDataSetId());
        DataSet allVchDataSet = cacheDataSet.toDataSet(Algo.create((String)"frm"), false);
        if (allVchDataSet == null) {
            return;
        }
        allVchDataSet = allVchDataSet.groupBy(new String[]{"id", "account", "rptvchid", "rptvchno"}).sum("debit").sum("credit").finish();
        Long taskId = this.paramModel.getTaskInfo().getId();
        int detailRestCount = this.getDetailRestCount(String.valueOf(taskId));
        ReconDiffSummeryModel reconDiffSummeryModel = new ReconDiffSummeryModel();
        ArrayList<Row> handVchList = new ArrayList<Row>(16);
        for (Row vch : allVchDataSet) {
            if (detailRestCount == 0) break;
            HashSet<Long> accountIds = new HashSet<Long>(1);
            accountIds.add(vch.getLong("account"));
            Row onlyVchRow = this.createOnlyVchRow(vch, accountIds);
            handVchList.add(onlyVchRow);
            --detailRestCount;
            int dc = FrmRowUtil.getIntVal((Row)onlyVchRow, (String)"vchdc", (int)-1);
            BigDecimal incrAmt = FrmRowUtil.getBigDecimal((Row)onlyVchRow, (String)"glamount", (BigDecimal)BigDecimal.ZERO);
            reconDiffSummeryModel.incrAmount(dc, false, false, incrAmt);
        }
        this.storeIntoCache(this.detailRowMeta, handVchList, DetailDataTypeEnum.HAND_VCH);
        AppCacheHelper.addList((String)(taskId + ".detail.summery"), (String)SerializationUtils.toJsonString((Object)reconDiffSummeryModel));
        this.updateDetailRestCount(String.valueOf(taskId), detailRestCount);
    }

    protected void relation(String taskId, Long planDetailId) {
        List<Row> handVch = DetailDataFormat.getRowByType(taskId, DetailDataTypeEnum.HAND_VCH);
        List<Row> handBill = DetailDataFormat.getRowByType(taskId, DetailDataTypeEnum.HAND_BILL);
        Set<Long> ignoreIdSet = this.getIgnoreId(handVch, handBill);
        this.ignoreRow(taskId, handVch, ignoreIdSet, DetailDataTypeEnum.HAND_VCH, planDetailId);
        this.ignoreRow(taskId, handBill, ignoreIdSet, DetailDataTypeEnum.HAND_BILL, planDetailId);
    }

    private Set<Long> getIgnoreId(List<Row> handVch, List<Row> handBill) {
        ArrayList<Row> diffList = new ArrayList<Row>(1000);
        if (handVch.size() > 0) {
            diffList.addAll(handVch);
        }
        if (handBill.size() > 0) {
            diffList.addAll(handBill);
        }
        Set<Long> ignoreIdSet = new HashSet<Long>(diffList.size());
        if (diffList.size() == 0) {
            return ignoreIdSet;
        }
        ignoreIdSet = ReconDetailRelationRepair.execute(diffList);
        return ignoreIdSet;
    }

    private void ignoreRow(String taskId, List<Row> cacheRows, Set<Long> ignoreIdSet, DetailDataTypeEnum detailDataType, Long planDetailId) {
        if (cacheRows.size() == 0 || ignoreIdSet.size() == 0) {
            return;
        }
        cacheRows.removeIf(it -> ignoreIdSet.contains(it.getLong("billid")) || ignoreIdSet.contains(it.getLong("vchid")));
        AppCacheHelper.removeAll((String)(taskId + detailDataType.getValue()));
        DataSetBuilder builder = Algo.create((String)("updateDetailCache" + detailDataType.getValue())).createDataSetBuilder(this.detailRowMeta);
        for (Row row : cacheRows) {
            builder.append(row);
        }
        DataSet dataSet = builder.build();
        String batchNo = taskId + detailDataType.getValue();
        String cacheTaskId = AppCacheHelper.getCacheTaskId();
        String dataSetCacheId = ReconServiceHelper.transferToCache(dataSet, Long.parseLong(taskId), planDetailId);
        AppCacheHelper.putTaskCache((String)batchNo, (String)cacheTaskId, (String)dataSetCacheId);
    }

    private long genGlobalLongId() {
        return DB.genGlobalLongId();
    }

    private DataSet filterDataSet(DataSet dataSet, final String field, final LongBitSet longBitSet) {
        if (dataSet == null) {
            return null;
        }
        if (longBitSet.cardinality() == 0L) {
            return dataSet;
        }
        dataSet = dataSet.filter(new FilterFunction(){

            public boolean test(Row row) {
                Long value = row.getLong(field);
                return !longBitSet.get(value.longValue());
            }
        });
        return dataSet;
    }

    class DetailTask
    implements Runnable {
        private final TaskInfo taskInfo;
        private final Map<String, Set<Long>> bizAssistIdMap;
        private final BizDataParam bizDataParam;
        private final Boolean _needJoinAssistGroup;
        private final DataSet finalAssistMasterDataSet;
        private final RelationParam relationParam;
        private final Set<Long> vchIdSet;
        private final ConcurrentHashSet<Long> curRelateVchIds;
        private final CountDownLatch countDownLatch;

        public DetailTask(TaskInfo taskInfo, Map<String, Set<Long>> bizAssistIdMap, BizDataParam bizDataParam, Boolean _needJoinAssistGroup, DataSet finalAssistMasterDataSet, RelationParam relationParam, Set<Long> vchIdSet, ConcurrentHashSet<Long> curRelateVchIds, CountDownLatch countDownLatch) {
            this.taskInfo = taskInfo;
            this.bizAssistIdMap = bizAssistIdMap;
            this.bizDataParam = bizDataParam;
            this._needJoinAssistGroup = _needJoinAssistGroup;
            this.finalAssistMasterDataSet = finalAssistMasterDataSet;
            this.relationParam = relationParam;
            this.vchIdSet = vchIdSet;
            this.curRelateVchIds = curRelateVchIds;
            this.countDownLatch = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long ruleStart = System.currentTimeMillis();
                if (TaskDao.isTaskOver((TaskInfo)this.taskInfo)) {
                    return;
                }
                ArrayList<Map<String, Set<Long>>> list = new ArrayList<Map<String, Set<Long>>>(1);
                list.add(this.bizAssistIdMap);
                this.bizDataParam.setAssIdSetMapList(list);
                this.bizDataParam.setAcctOrgID(AbstractDetailService.this.paramModel.getOrgIds().toArray(new Long[0])[0].longValue());
                this.bizDataParam.setDataType(DataTypeEnum.Detail);
                this.bizDataParam.setAssistIndexMap(AbstractDetailService.this.detailModel.getBizAssistIndexMap());
                this.bizDataParam.setAssistType(AbstractDetailService.this.detailModel.getAssistType());
                BizDataService service = new BizDataService(this.bizDataParam, AbstractDetailService.this.paramModel);
                service.setCustomParamService(AbstractDetailService.this.customParamService);
                if (this._needJoinAssistGroup.booleanValue()) {
                    service.registerFilterByAssistGroup(this.finalAssistMasterDataSet);
                }
                service.execute();
                LongBitSet billIdBitSet = service.getDataResult().getBillIdBitSet();
                DataSet bizDataSet = service.getBizDataSet();
                if (!service.hasResult()) {
                    return;
                }
                if (TaskDao.isTaskOver((TaskInfo)AbstractDetailService.this.paramModel.getTaskInfo())) {
                    return;
                }
                DataSet finalCurVchDataSet = null;
                if (AbstractDetailService.this.param.getVchCacheDataSetId() != null) {
                    CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)AbstractDetailService.this.param.getVchCacheDataSetId());
                    finalCurVchDataSet = cacheDataSet.toDataSet(Algo.create((String)"frm"), false);
                }
                HashMap<Long, Set> vchAccountMap = new HashMap<Long, Set>(64);
                Map bill2nVchMap = new HashMap(64);
                DataSet vchDataSet = null;
                DataSet relationDataSet = null;
                if (finalCurVchDataSet != null) {
                    DynamicObject pluginCfg = RptBizAppConfigServiceHelper.getBizAppConfigForDap(AbstractDetailService.this.planModel.getAppId());
                    if (pluginCfg != null) {
                        DynamicObject bizAppRefGlConfig = RptBizAppConfigServiceHelper.getBizAppRefGlConfig(AbstractDetailService.this.planModel.getAppId());
                        RptBizDataQueryService dapQueryService = new RptBizDataQueryService(pluginCfg, bizAppRefGlConfig);
                        relationDataSet = dapQueryService.queryRelation(this.relationParam, null, MapUtil.bitSetMap2Set((LongBitSet)billIdBitSet));
                        if (relationDataSet == null) {
                            relationDataSet = RelationServiceAdaptor.getRelation((RelationParam)this.relationParam, (FrmLogger)AbstractDetailService.this.frmLogger, (LongBitSet)billIdBitSet, this.vchIdSet);
                        }
                        if (AbstractDetailService.this.isVchIdStr) {
                            relationDataSet = relationDataSet.map(AbstractDetailService.this.handleStrVchId());
                        }
                    } else {
                        relationDataSet = RelationServiceAdaptor.getRelation((RelationParam)this.relationParam, (FrmLogger)AbstractDetailService.this.frmLogger, (LongBitSet)billIdBitSet, Collections.emptySet());
                    }
                    String dcFilter = "";
                    BizDataTypeEnum dcType = this.bizDataParam.getSourceConfig().getType();
                    dcFilter = BizDataTypeEnum.Debit == dcType ? "debit != 0" : "credit != 0";
                    vchDataSet = finalCurVchDataSet.copy().filter(dcFilter);
                    for (Row row : vchDataSet.copy()) {
                        vchAccountMap.computeIfAbsent(row.getLong("id"), p -> new HashSet(10)).add(row.getLong("account"));
                    }
                    vchDataSet = vchDataSet.groupBy(new String[]{"id", "rptvchid", "rptvchno"}).sum("debit").sum("credit").finish();
                    bill2nVchMap = AbstractDetailService.this.getOne2MulRelation(relationDataSet.copy());
                }
                if (TaskDao.isTaskOver((TaskInfo)AbstractDetailService.this.paramModel.getTaskInfo())) {
                    return;
                }
                AbstractDetailService.this.handleRelationMulTo1(bizDataSet, relationDataSet, vchDataSet, (ConcurrentHashSet<Long>)this.curRelateVchIds, vchAccountMap, bill2nVchMap);
                ruleStart = System.currentTimeMillis() - ruleStart;
                logger.info("taikId:{},entity:{},ruleentryid:{},\u660e\u7ec6\u8868\u5bf9\u8d26\u8017\u65f6\uff1a{}", new Object[]{this.taskInfo.getId(), this.relationParam.getSourceEntity(), this.bizDataParam.getSourceConfig().getRuleEntryId(), ruleStart});
            }
            catch (Throwable e) {
                String errorMsg = ThrowableHelper.toString((Throwable)e);
                String[] errorInfo = new String[]{errorMsg, errorMsg};
                AppCacheHelper.updateTaskStatusWithDB((String)this.taskInfo.getBatchNo(), (String)this.taskInfo.getId().toString(), (ReconcilationResultEnum)ReconcilationResultEnum.error, (String)"3", (TaskStatusEnum)TaskStatusEnum.ERROR, null, (String[])errorInfo);
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }
}

