/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.impl.detail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.enums.AssistTypeEnum;
import kd.fi.frm.common.enums.DataTypeEnum;
import kd.fi.frm.common.enums.ReconAmountTypeEnum;
import kd.fi.frm.common.enums.ReconcilationResultEnum;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.bizdata.BizDataParam;
import kd.fi.frm.common.model.bizdata.BizDataSourceConfig;
import kd.fi.frm.common.model.bizdata.BizReconPlanDetailModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanModel;
import kd.fi.frm.common.model2.RelationDataParam3;
import kd.fi.frm.common.task.TaskDao;
import kd.fi.frm.common.task.TaskInfo;
import kd.fi.frm.common.util.FaBillParamUtils;
import kd.fi.frm.common.util.ReconciliationParmUtil;
import kd.fi.frm.common.util.ReconciliationUtil;
import kd.fi.frm.mservice.AssistMappingUtil;
import kd.fi.frm.mservice.bizdata.ext.custom.AbstractCustomParamService;
import kd.fi.frm.mservice.bizdata.ext.custom.CustomParamUtil;
import kd.fi.frm.mservice.impl.AbstractReconciliationService;
import kd.fi.frm.mservice.impl.ReconServiceHelper;

public abstract class AbstractReconDetailService
extends AbstractReconciliationService {
    private static final Log logger = LogFactory.getLog(AbstractReconDetailService.class);
    public static final ThreadPool BIZ_ASSIST_ID_THREAD_POOL = ThreadPools.newFixedThreadPool((String)"frm-selectassistidfrombizobj", (int)4);
    public static final ThreadPool BIZ_ASSIST_INFO_THREAD_POOL = ThreadPools.newFixedThreadPool((String)"frm-selectassistinfo", (int)4);
    protected RelationDataParam3 param;
    protected BizReconPlanDetailModel detailModel;
    protected AbstractCustomParamService customParamService;
    protected Map<String, List<BizDataParam>> billTypeGroup = new HashMap<String, List<BizDataParam>>();
    protected final List<BizDataParam> ruleParams = new ArrayList<BizDataParam>();
    protected Set<Long> acctIdSet = new HashSet<Long>();
    protected Map<String, String> appMap = new HashMap<String, String>();

    @Override
    protected boolean prepare() throws Exception {
        Map bizAssistMap;
        Map assistMap;
        this.getDataRule();
        this.getAllLeafAccts(this.acctIdSet);
        String appId = this.paramModel.getAppIds().toArray(new String[0])[0];
        if (this.appMap.get(appId) == null) {
            QFilter idFilter = new QFilter("id", "in", (Object)this.paramModel.getAppIds());
            DynamicObjectCollection apps = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id,number", (QFilter[])new QFilter[]{idFilter}, null);
            for (DynamicObject app : apps) {
                this.appMap.put(app.getString("id"), app.getString("number"));
            }
        }
        if (!CollectionUtils.isEmpty((Map)(assistMap = this.param.getAssistMap())) && (bizAssistMap = this.param.getBizAssistMap()) != null && bizAssistMap.size() > 0) {
            ReconciliationUtil.mergeAssistMap((Map)bizAssistMap, (Map)assistMap, (Object)0L);
        }
        ReconciliationUtil.initSysParam((ReconciliationParamModel)this.paramModel, null);
        if (this.param.isExport()) {
            String taskId = String.valueOf(this.paramModel.getTaskInfo().getId());
            AppCacheHelper.putResultCache((String)("DETAIL_NOT_ALL:" + taskId), (Object)Boolean.FALSE);
        }
        TaskInfo taskInfo = this.paramModel.getTaskInfo();
        TaskDao.updateTaskReconPlan((Long)taskInfo.getId(), (long)this.planModel.getId(), (long)(this.dataRule == null ? 0L : this.dataRule.getLong("id")), (Long)taskInfo.getGlAppCfgId());
        this.enablePlatformThreadPool = FaBillParamUtils.getBooleanValue((Long)0L, (String)"frm_enable_platform_threadpool");
        return true;
    }

    protected void getDataRule() {
        this.planModel = ReconciliationUtil.getPlanModel((Long)this.param.getAcctBookTypeID(), (Long)this.param.getAcctOrgID(), (String)this.param.getAppId(), (Long)this.param.getPeriodid(), (Long)this.paramModel.getPlanDetailId());
        if (this.planModel == null) {
            throw new KDBizException(ReconcilationResultEnum.noExecPlan.getName());
        }
        this.dataRule = ReconciliationUtil.getDataRule((Long)this.planModel.getRuleId(), (ReconAmountTypeEnum)this.planModel.getReconAmountType());
        CustomParamUtil.setCustomParam(this.paramModel, this.dataRule);
        this.detailModel = ReconciliationUtil.getDetailModel((BizReconPlanModel)this.planModel, (Long)this.param.getId());
        ReconciliationUtil.planDetailAssist((BizReconPlanDetailModel)this.detailModel, (Long)this.param.getAcctOrgID());
        this.customParamService = CustomParamUtil.paramConversion(this.paramModel, this.detailModel, this.param);
        this.param.setAssistValueRange(this.detailModel.getAssistValueRange());
        List params = ReconciliationParmUtil.getDataRuleParam((BizReconPlanDetailModel)this.detailModel, (DynamicObject)this.dataRule, (List)this.detailModel.getAmountTypeList(), (ReconciliationParamModel)this.paramModel, (Long)this.param.getAcctOrgID(), (ReconAmountTypeEnum)this.planModel.getReconAmountType());
        boolean needQuery = true;
        String bizAssistTable = this.paramModel.getBizAssistTable();
        List<Object> bizAssistIdSetMapList = new ArrayList(8);
        AssistTypeEnum assistType = this.detailModel.getAssistType();
        if (AssistTypeEnum.Acct == assistType) {
            Map bizAssistMap = new HashMap(8);
            if (!StringUtils.isEmpty((Object)bizAssistTable)) {
                bizAssistMap = ReconciliationUtil.getBizAssistMap((String)bizAssistTable);
            }
            if (!CollectionUtils.isEmpty(bizAssistMap)) {
                bizAssistIdSetMapList.add(bizAssistMap);
            } else {
                bizAssistIdSetMapList = AssistMappingUtil.acctBizFilterToBizAssistMap(this.detailModel.getBizFilterAssistMapList());
            }
        } else {
            HashMap assistQueryMap = new HashMap(8);
            ArrayList<Map<String, Set<Long>>> tmpBizAssistMapList = params.size() == 0 ? new ArrayList(0) : ((BizDataParam)params.get(0)).getBizAssistIdSetMapList();
            needQuery = AssistMappingUtil.getAssistQueryMap(this.paramModel.getTaskInfo().getOrgId(), this.detailModel.getAssistDataMapping(), bizAssistTable, this.paramModel.getAssist(), tmpBizAssistMapList, assistQueryMap);
            bizAssistIdSetMapList.add(assistQueryMap);
        }
        for (BizDataParam bizParam : params) {
            bizParam.setNeedQueryBiz(needQuery);
            bizParam.setBizAssistIdSetMapList(bizAssistIdSetMapList);
            boolean contains = false;
            BizDataSourceConfig config = bizParam.getSourceConfig();
            if (config.getDimPropMap().keySet().containsAll(this.param.getBizAssistMap().keySet())) {
                contains = true;
            }
            if (!contains) continue;
            bizParam.setSourceConfig(config);
            this.ruleParams.add(bizParam);
        }
        this.billTypeGroup = this.ruleParams.stream().collect(Collectors.groupingBy(BizDataParam::getEntityKey));
        if (this.ruleParams.size() > 0) {
            TaskInfo taskInfo = this.paramModel.getTaskInfo();
            String taskId = String.valueOf(taskInfo.getId());
            String batchNo = taskInfo.getBatchNo();
            String taskCache = AppCacheHelper.getTaskCache((String)batchNo, (String)taskId);
            TaskInfo taskCacheInfo = (TaskInfo)SerializationUtils.deSerializeFromBase64((String)taskCache);
            taskCacheInfo.setExedStep(Integer.valueOf(0));
            taskCacheInfo.setPercent(Integer.valueOf(0));
            taskCacheInfo.setTotalStep(Integer.valueOf(100));
            AppCacheHelper.putTaskCache((String)taskInfo.getBatchNo(), (String)taskInfo.getId().toString(), (String)SerializationUtils.serializeToBase64((Object)taskCacheInfo));
        }
    }

    protected void getAllLeafAccts(Set<Long> acctIdSet) {
        Set<Object> accountIds = new HashSet(10);
        HashSet acctMasterSet = new HashSet(10);
        if (this.param.getAccountIds() == null || this.param.getAccountIds().isEmpty()) {
            boolean getAcctByAssistIdEnable = FaBillParamUtils.getBooleanValue((Long)0L, (String)"frm_acct_assistid_enable");
            if (getAcctByAssistIdEnable) {
                accountIds = ReconServiceHelper.getAcctIdsByAssistConfig(this.detailModel.getAsstTypeCondList(), this.planModel.getAccoutTableId(), this.planModel.getOrgId(), this.paramModel.getPeriodId());
            } else {
                ArrayList<String> assistTypeList = new ArrayList<String>(10);
                if (this.param.getAssistMap() != null && this.param.getAssistMap().size() > 0) {
                    assistTypeList.addAll(this.param.getAssistMap().keySet());
                } else {
                    assistTypeList.addAll(this.detailModel.getAssistAcctTypeList());
                }
                accountIds = ReconServiceHelper.getAcctIds(assistTypeList, this.param.getAccountTableId(), this.param.getAcctOrgID(), this.param.getPeriodid());
            }
        } else {
            accountIds.addAll(this.param.getAccountIds());
        }
        ReconciliationUtil.getDetailAccountId((Long)this.param.getAcctOrgID(), (Long)this.param.getAccountTableId(), (Long)this.param.getPeriodid(), accountIds, acctIdSet, acctMasterSet);
    }

    protected Map<String, Set<Long>> getBizAssistLeaf(Map<String, Set<Long>> bizAssistMasterIdMap) {
        HashMap<String, Set<Long>> newBizAssistMap = new HashMap<String, Set<Long>>(bizAssistMasterIdMap.size());
        for (Map.Entry<String, Set<Long>> entry : bizAssistMasterIdMap.entrySet()) {
            String entity = entry.getKey();
            Set<Long> ids = entry.getValue();
            ids.remove(0L);
            if (ids.size() == 0) continue;
            Set leafIds = ReconciliationUtil.getAllByMasterId((String)entry.getKey(), entry.getValue());
            ids.addAll(leafIds);
            newBizAssistMap.put(entity, ids);
        }
        return newBizAssistMap;
    }

    protected void buildParam() {
        this.paramModel.setAccountIds(this.param.getAccountIds());
        this.paramModel.setDataType(DataTypeEnum.Detail);
        this.paramModel.setInit(false);
        this.paramModel.setPeriodId(Long.valueOf(this.param.getPeriodid()));
        this.paramModel.setBookTypeId(Long.valueOf(this.param.getAcctBookTypeID()));
        this.paramModel.getOrgIds().add(this.param.getAcctOrgID());
        this.paramModel.setCurrency(this.param.getCurrency());
        this.paramModel.setAccountTable(this.param.getAccountTableId());
    }

    protected DataSet genLeftDataSet(DataSet billDataSet, DataSet billGroupDataSet) {
        if (billDataSet == null) {
            return null;
        }
        if (billGroupDataSet == null) {
            return billDataSet.addNullField("groupIdx");
        }
        DataSet leftDataSet = billDataSet.leftJoin(billGroupDataSet).on("billentity", "entity").on("billid", "billid").select(billDataSet.getRowMeta().getFieldNames(), new String[]{"groupIdx"}).finish();
        return leftDataSet;
    }

    protected DataSet genRightDataSet(DataSet vchDataSet, DataSet vchGroupDataSet) {
        if (vchDataSet == null) {
            return null;
        }
        if (vchGroupDataSet == null) {
            return vchDataSet.addNullField("groupIdx");
        }
        DataSet rightDataSet = vchDataSet.leftJoin(vchGroupDataSet).on("id", "vchid").select(vchDataSet.getRowMeta().getFieldNames(), new String[]{"groupIdx"}).finish();
        return rightDataSet;
    }
}

