/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.impl.detail;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.frm.common.enums.DetailDcEnum;
import kd.fi.frm.common.model.FRMDataSetModel;
import kd.fi.frm.common.util.FrmRowUtil;
import kd.fi.frm.mservice.detailstore.IDataRowCollector;

public class DetailRowCreateUtil {
    private static Object[] noBillArray = new Object[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, "", 0L, "", -1, BigDecimal.ZERO};
    private static Object[] noVchArray = new Object[]{0L, "", -1, BigDecimal.ZERO};

    public static boolean createAndCollectRow(DetailDcEnum dcEnum, List<Row> leftRows, List<Row> rightRows, IDataRowCollector collector) {
        Row newRow;
        Object[] values;
        BigDecimal leftSumAmt = BigDecimal.ZERO;
        for (Row bill : leftRows) {
            BigDecimal billAmount = FrmRowUtil.getBigDecimal((Row)bill, (String)"billamount", (BigDecimal)BigDecimal.ZERO);
            leftSumAmt = leftSumAmt.add(billAmount);
        }
        HashSet<Long> accountIds = new HashSet<Long>(10);
        BigDecimal rightSumAmt = BigDecimal.ZERO;
        for (Row row : rightRows) {
            String accounts = row.getString("account");
            if (!accounts.contains(",")) {
                accountIds.add(Long.parseLong(accounts));
            }
            BigDecimal debit = FrmRowUtil.getBigDecimal((Row)row, (String)"debit", (BigDecimal)BigDecimal.ZERO);
            BigDecimal glAmount = BigDecimal.ZERO.compareTo(debit) != 0 ? debit : FrmRowUtil.getBigDecimal((Row)row, (String)"credit", (BigDecimal)BigDecimal.ZERO);
            rightSumAmt = rightSumAmt.add(glAmount);
        }
        if (!collector.collectEqualRow() && CollectionUtils.isNotEmpty(leftRows) && CollectionUtils.isNotEmpty(rightRows) && leftSumAmt.compareTo(rightSumAmt) == 0) {
            collector.calcEqualsAmount(dcEnum, leftSumAmt);
            return true;
        }
        RowMeta relateRowMeta = FRMDataSetModel.getDetailRelateRowMeta();
        if (CollectionUtils.isEmpty(leftRows)) {
            for (Row rightRow : rightRows) {
                values = DetailRowCreateUtil.mergeNewRow(null, rightRow, accountIds);
                values[22] = 0;
                values[23] = DBServiceHelper.genGlobalLongId();
                values[24] = 1;
                newRow = RowFactory.createRow((RowMeta)relateRowMeta, (Object[])values);
                collector.collect(newRow, BigDecimal.ZERO, (BigDecimal)values[18]);
            }
        } else if (CollectionUtils.isEmpty(rightRows)) {
            for (Row leftRow : leftRows) {
                values = DetailRowCreateUtil.mergeNewRow(leftRow, null, accountIds);
                values[22] = 0;
                values[23] = DBServiceHelper.genGlobalLongId();
                values[24] = 1;
                newRow = RowFactory.createRow((RowMeta)relateRowMeta, (Object[])values);
                collector.collect(newRow, (BigDecimal)values[19], BigDecimal.ZERO);
            }
        } else if (leftRows.size() == 1 && rightRows.size() == 1) {
            Row rightRow;
            Row row = leftRows.get(0);
            rightRow = rightRows.get(0);
            values = DetailRowCreateUtil.mergeNewRow(row, rightRow, accountIds);
            values[22] = 0;
            values[23] = DBServiceHelper.genGlobalLongId();
            values[24] = 1;
            newRow = RowFactory.createRow((RowMeta)relateRowMeta, (Object[])values);
            collector.collect(newRow, (BigDecimal)values[14], (BigDecimal)values[18]);
        } else {
            int n = Math.max(leftRows.size(), rightRows.size());
            int type = rightRows.size() == 1 ? 1 : (leftRows.size() == 1 ? 2 : 3);
            long pid = DBServiceHelper.genGlobalLongId();
            ArrayList<Row> groupRows = new ArrayList<Row>(n);
            for (int i = 0; i < n; ++i) {
                Row leftRow = null;
                if (i < leftRows.size()) {
                    leftRow = leftRows.get(i);
                }
                Row rightRow = null;
                if (i < rightRows.size()) {
                    rightRow = rightRows.get(i);
                }
                Object[] values2 = DetailRowCreateUtil.mergeNewRow(type == 2 ? null : leftRow, type == 1 ? null : rightRow, accountIds);
                values2[19] = BigDecimal.ZERO;
                values2[20] = BigDecimal.ZERO;
                values2[21] = BigDecimal.ZERO;
                values2[22] = pid;
                values2[23] = DBServiceHelper.genGlobalLongId();
                values2[24] = 1;
                Row newRow2 = RowFactory.createRow((RowMeta)relateRowMeta, (Object[])values2);
                groupRows.add(newRow2);
            }
            Object[] virtualValues = DetailRowCreateUtil.createVirtualRow(type, leftRows.get(0), leftSumAmt, rightRows.get(0), rightSumAmt, accountIds);
            virtualValues[22] = 0;
            virtualValues[23] = pid;
            virtualValues[24] = n;
            Row virtualRow = RowFactory.createRow((RowMeta)relateRowMeta, (Object[])virtualValues);
            groupRows.add(0, virtualRow);
            collector.collect(groupRows, leftSumAmt, rightSumAmt);
        }
        return !collector.isStop();
    }

    private static Object[] createVirtualRow(int type, Row bill, BigDecimal billAmt, Row vch, BigDecimal vchAmt, Set<Long> accountIds) {
        RowMeta relateRowMeta = FRMDataSetModel.getDetailRelateRowMeta();
        Object[] virtualRow = new Object[relateRowMeta.getFields().length];
        if (type == 1) {
            DetailRowCreateUtil.fillBillValues(bill, virtualRow, true);
            DetailRowCreateUtil.fillVchValues(vch, virtualRow, -1, false, accountIds);
            virtualRow[13] = bill.get("bizdc");
            virtualRow[14] = billAmt;
            virtualRow[16] = FrmRowUtil.getVal((Row)vch, (String)"id", (Object)0L);
            virtualRow[19] = billAmt;
            virtualRow[20] = vchAmt;
        } else if (type == 2) {
            DetailRowCreateUtil.fillBillValues(bill, virtualRow);
            DetailRowCreateUtil.fillVchValues(vch, virtualRow, (Integer)virtualRow[13], true, accountIds);
            virtualRow[19] = virtualRow[14];
            virtualRow[20] = vchAmt;
        } else {
            DetailRowCreateUtil.fillBillValues(bill, virtualRow, true);
            DetailRowCreateUtil.fillVchValues(vch, virtualRow, -1, true, accountIds);
            virtualRow[13] = bill.get("bizdc");
            virtualRow[14] = BigDecimal.ZERO;
            virtualRow[19] = billAmt;
            virtualRow[20] = vchAmt;
        }
        virtualRow[21] = ((BigDecimal)virtualRow[19]).subtract((BigDecimal)virtualRow[20]);
        return virtualRow;
    }

    private static Object[] mergeNewRow(Row leftRow, Row rightRow, Set<Long> accountIds) {
        RowMeta relateRowMeta = FRMDataSetModel.getDetailRelateRowMeta();
        Object[] values = new Object[relateRowMeta.getFieldCount()];
        DetailRowCreateUtil.fillBillValues(leftRow, values);
        DetailRowCreateUtil.fillVchValues(rightRow, values, (Integer)values[13], accountIds);
        values[19] = leftRow != null ? values[14] : BigDecimal.ZERO;
        values[20] = values[18];
        values[21] = ((BigDecimal)values[19]).subtract((BigDecimal)values[20]);
        return values;
    }

    private static void fillBillValues(Row bill, Object[] values) {
        if (bill == null) {
            System.arraycopy(noBillArray, 0, values, 0, 15);
            return;
        }
        DetailRowCreateUtil.fillBillValues(bill, values, false);
    }

    private static void fillBillValues(Row bill, Object[] values, boolean virtualRow) {
        values[0] = bill.get("currency");
        values[1] = bill.get("billorg");
        if (!virtualRow) {
            values[2] = bill.get("assist1_app");
            values[3] = bill.get("assist2_app");
            values[4] = bill.get("assist3_app");
            values[5] = bill.get("assist4_app");
            values[6] = bill.get("assist5_app");
            values[7] = bill.get("assist6_app");
            values[8] = bill.get("assist7_app");
            values[9] = bill.get("assist8_app");
            values[10] = bill.get("billentity");
            values[11] = bill.get("billid");
            values[12] = bill.get("billno");
        } else {
            values[2] = 0L;
            values[3] = 0L;
            values[4] = 0L;
            values[5] = 0L;
            values[6] = 0L;
            values[7] = 0L;
            values[8] = 0L;
            values[9] = 0L;
            values[10] = "";
            values[11] = 0L;
            values[12] = "";
        }
        values[13] = bill.get("bizdc");
        BigDecimal billAmount = FrmRowUtil.getBigDecimal((Row)bill, (String)"billamount", (BigDecimal)BigDecimal.ZERO);
        values[14] = billAmount;
    }

    private static void fillVchValues(Row vch, Object[] values, int billDc, Set<Long> accountIds) {
        if (vch == null) {
            System.arraycopy(noVchArray, 0, values, 15, 4);
            return;
        }
        DetailRowCreateUtil.fillVchValues(vch, values, billDc, false, accountIds);
    }

    private static void fillVchValues(Row vch, Object[] values, int billDc, boolean virtualRow, Set<Long> accountIds) {
        BigDecimal debit = FrmRowUtil.getBigDecimal((Row)vch, (String)"debit", (BigDecimal)BigDecimal.ZERO);
        BigDecimal glAmount = BigDecimal.ZERO;
        int vchDc = -1;
        if (BigDecimal.ZERO.compareTo(debit) != 0) {
            glAmount = debit;
            vchDc = DetailDcEnum.DEBIT.getValue();
        } else {
            glAmount = FrmRowUtil.getBigDecimal((Row)vch, (String)"credit", (BigDecimal)BigDecimal.ZERO);
            vchDc = DetailDcEnum.CREDIT.getValue();
        }
        values[15] = accountIds != null && accountIds.size() == 1 ? accountIds.toArray(new Long[0])[0] : 0L;
        if (!virtualRow) {
            values[16] = vch.getString("id");
            values[25] = vch.getString("rptvchid");
            values[26] = vch.getString("rptvchno");
            values[18] = glAmount;
        } else {
            values[16] = 0L;
        }
        values[17] = billDc != -1 ? billDc : vchDc;
    }
}

