/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.impl.detail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.util.bitset.BitSetFactory;
import kd.bos.algo.util.bitset.LongBitSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.enums.AssistDataType;
import kd.fi.frm.common.enums.AssistTypeEnum;
import kd.fi.frm.common.enums.DataTypeEnum;
import kd.fi.frm.common.enums.DetailDcEnum;
import kd.fi.frm.common.enums.DetailTypeEnum;
import kd.fi.frm.common.enums.ReconAmountTypeEnum;
import kd.fi.frm.common.enums.ReconcilationResultEnum;
import kd.fi.frm.common.model.FRMDataSetModel;
import kd.fi.frm.common.model.FrmLogger;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.bizdata.BizDataParam;
import kd.fi.frm.common.model.bizdata.BizDataTypeEnum;
import kd.fi.frm.common.model2.RelationDataParam3;
import kd.fi.frm.common.relation.CASService;
import kd.fi.frm.common.relation.RelationParam;
import kd.fi.frm.common.relation.RelationServiceAdaptor;
import kd.fi.frm.common.relation.RelationTypeEnum;
import kd.fi.frm.common.task.TaskDao;
import kd.fi.frm.common.task.TaskInfo;
import kd.fi.frm.common.task.TaskStatusEnum;
import kd.fi.frm.common.util.FaBillParamUtils;
import kd.fi.frm.common.util.FrmQueryServiceHelper;
import kd.fi.frm.common.util.MapUtil;
import kd.fi.frm.common.util.ReconciliationUtil;
import kd.fi.frm.common.util.ThrowableHelper;
import kd.fi.frm.mservice.algo.NotInFilterFunction;
import kd.fi.frm.mservice.bizdata.BizDataService;
import kd.fi.frm.mservice.datamatch.CollectionCompGroupEngine;
import kd.fi.frm.mservice.datamatch.IGroupDataHandler;
import kd.fi.frm.mservice.detailstore.DataSetRowCollector;
import kd.fi.frm.mservice.detailstore.DataSumCollector;
import kd.fi.frm.mservice.detailstore.ExportExcelCollector;
import kd.fi.frm.mservice.detailstore.IDataRowCollector;
import kd.fi.frm.mservice.impl.detail.AbstractDetailService;
import kd.fi.frm.mservice.impl.detail.AbstractReconDetailService;
import kd.fi.frm.mservice.impl.detail.DetailBizQueryTask;
import kd.fi.frm.mservice.impl.detail.DetailRowCreateUtil;
import kd.fi.frm.mservice.rpt.RptBizAppConfigServiceHelper;
import kd.fi.frm.mservice.rpt.invoke.RptBizDataQueryService;
import kd.fi.frm.mservice.rpt.invoke.RptGlDataQueryService;

public class ReconDetailService
extends AbstractReconDetailService {
    private static final Log logger = LogFactory.getLog(ReconDetailService.class);
    private boolean isIdStrType = false;
    private DataSet assistMasterDataSet = null;
    protected boolean needJoinAssistGroup = false;
    private IDataRowCollector dataRowCollector;

    public ReconDetailService(ReconciliationParamModel model, RelationDataParam3 glParam) {
        this.paramModel = model;
        this.param = glParam;
        if (this.paramModel.isAnalyzeMode()) {
            this.paramModel.setAnalyzeMode();
        }
        this.buildParam();
    }

    @Override
    public void execute() {
        boolean prepared;
        try {
            int maxShowLimit;
            prepared = this.prepare();
            if (this.param.isExport()) {
                this.dataRowCollector = new ExportExcelCollector(this.paramModel, this.param.isShowAll() ? 2 : 1);
            } else if (!this.param.isExport() && this.param.isShowAll()) {
                maxShowLimit = Integer.parseInt(System.getProperty("prop.fi.ai.recon.detaillimit", "1000"));
                this.dataRowCollector = new DataSumCollector(this.paramModel, FRMDataSetModel.getDetailRelateRowMeta(), maxShowLimit);
            } else if (!this.param.isExport()) {
                maxShowLimit = Integer.parseInt(System.getProperty("prop.fi.ai.recon.detaillimit", "1000"));
                this.dataRowCollector = new DataSetRowCollector(this.paramModel, FRMDataSetModel.getDetailRelateRowMeta(), maxShowLimit);
            }
            this.dataRowCollector.prepare(this.detailModel, this.billTypeGroup.keySet());
        }
        catch (Exception e) {
            ErrorCode errCode = new ErrorCode("PREPARE METHOD", ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8d26\u51c6\u5907\u5de5\u4f5c\u51fa\u9519", (String)"AbstractReconciliationService_2", (String)"fi-frm-mservice", (Object[])new Object[0]));
            throw new KDException((Throwable)e, errCode, new Object[0]);
        }
        if (prepared) {
            String mulBillTypeApps;
            Set mulBillTypeAppSet;
            TaskInfo taskInfo = this.paramModel.getTaskInfo();
            AppCacheHelper.updateTaskStatusWithDB((String)taskInfo.getBatchNo(), (String)taskInfo.getId().toString(), null, null, null, (Integer)1, null);
            String taskId = String.valueOf(taskInfo.getId());
            this.dealAssistFilterInfo();
            if (this.param.isExport()) {
                this.setAssistInfo(this.ruleParams);
            }
            if ((mulBillTypeAppSet = Arrays.stream((mulBillTypeApps = FaBillParamUtils.getStringValue(null, (String)"frm_morebill_genvch", (boolean)false)) != null ? mulBillTypeApps.split(",") : new String[]{}).collect(Collectors.toSet())).contains(this.appMap.get(taskInfo.getAppId()))) {
                long t1 = System.currentTimeMillis();
                HashMap groupBillIdMap = MapUtil.newHashMap((int)this.billTypeGroup.size());
                DataSet[] billDataSet = this.executeForBizData(groupBillIdMap);
                AppCacheHelper.updateTaskStatusWithDB((String)taskInfo.getBatchNo(), (String)taskInfo.getId().toString(), null, null, null, (Integer)20, null);
                long t2 = System.currentTimeMillis();
                logger.info("\u4e1a\u52a1\u53d6\u6570\u8017\u65f6\uff1a{}", (Object)(t2 - t1));
                t1 = System.currentTimeMillis();
                DataSet[] vchDataSet = this.executeForGlData();
                AppCacheHelper.updateTaskStatusWithDB((String)taskInfo.getBatchNo(), (String)taskInfo.getId().toString(), null, null, null, (Integer)20, null);
                t2 = System.currentTimeMillis();
                logger.info("\u603b\u8d26\u53d6\u6570\u8017\u65f6\uff1a{}", (Object)(t2 - t1));
                ThreeTuple<DataSet, DataSet, Integer> dapInfoTup1 = null;
                ThreeTuple dapInfoTup2 = null;
                if (billDataSet[0] != null && vchDataSet[0] != null || billDataSet[1] != null && vchDataSet[1] != null) {
                    t1 = System.currentTimeMillis();
                    DataSet dapDataSet = null;
                    for (String billType : this.billTypeGroup.keySet()) {
                        LongBitSet billBitSet = (LongBitSet)groupBillIdMap.get(billType);
                        DataSet billDapDataSet = this.executeForDapData(billType, billBitSet);
                        billDapDataSet = billDapDataSet.select(new String[]{"entity", "sourcebillid", "voucherid"});
                        if (dapDataSet == null) {
                            dapDataSet = billDapDataSet;
                            continue;
                        }
                        dapDataSet = dapDataSet.union(billDapDataSet);
                    }
                    t2 = System.currentTimeMillis();
                    logger.info("\u83b7\u53d6dap\u5173\u7cfb\u8017\u65f6\uff1a{}", (Object)(t2 - t1));
                    if (dapDataSet != null) {
                        long t7 = System.currentTimeMillis();
                        dapInfoTup1 = this.analyseDap(dapDataSet.copy(), this.isIdStrType);
                        dapInfoTup2 = new ThreeTuple((Object)((DataSet)dapInfoTup1.item1).copy(), (Object)((DataSet)dapInfoTup1.item2).copy(), dapInfoTup1.item3);
                        long t8 = System.currentTimeMillis();
                        logger.info("\u5206\u6790dap\u5173\u7cfb\u8017\u65f6\uff1a{}", (Object)(t8 - t7));
                    }
                }
                AppCacheHelper.updateTaskStatusWithDB((String)taskInfo.getBatchNo(), (String)taskInfo.getId().toString(), null, null, null, (Integer)20, null);
                if (TaskDao.isTaskOver((TaskInfo)this.paramModel.getTaskInfo())) {
                    return;
                }
                t1 = System.currentTimeMillis();
                this.handleDCDataSet(false, DetailDcEnum.DEBIT, billDataSet[0], vchDataSet[0], dapInfoTup1);
                this.handleDCDataSet(false, DetailDcEnum.CREDIT, billDataSet[1], vchDataSet[1], dapInfoTup2);
                t2 = System.currentTimeMillis();
                logger.info("\u5904\u7406\u6570\u636e\u8017\u65f6{}", (Object)(t2 - t1));
            } else {
                LongBitSet billBitSet = BitSetFactory.createLong();
                long t1 = System.currentTimeMillis();
                DataSet[] vchDataSet = this.executeForGlData();
                long t2 = System.currentTimeMillis();
                logger.info("\u51ed\u8bc1\u53d6\u6570\u8017\u65f6{}", (Object)(t2 - t1));
                AppCacheHelper.updateTaskStatusWithDB((String)taskInfo.getBatchNo(), (String)taskInfo.getId().toString(), null, null, null, (Integer)20, null);
                if (this.billTypeGroup.size() > 0) {
                    for (Map.Entry billTypeEntry : this.billTypeGroup.entrySet()) {
                        t1 = System.currentTimeMillis();
                        DataSet[] billDataSet = this.executeForBizData("", (List)billTypeEntry.getValue(), billBitSet);
                        t2 = System.currentTimeMillis();
                        logger.info("\u5355\u636e{}\u4e1a\u52a1\u53d6\u6570\u8017\u65f6{}", billTypeEntry.getKey(), (Object)(t2 - t1));
                        if (TaskDao.isTaskOver((TaskInfo)this.paramModel.getTaskInfo())) {
                            return;
                        }
                        ThreeTuple<DataSet, DataSet, Integer> dapInfoTup1 = null;
                        ThreeTuple dapInfoTup2 = null;
                        if (billDataSet[0] != null && vchDataSet[0] != null || billDataSet[1] != null && vchDataSet[1] != null) {
                            t1 = System.currentTimeMillis();
                            DataSet billDapDataSet = this.executeForDapData((String)billTypeEntry.getKey(), billBitSet);
                            t2 = System.currentTimeMillis();
                            logger.info("\u5355\u636e{}DAP\u53d6\u6570\u8017\u65f6{}", billTypeEntry.getKey(), (Object)(t2 - t1));
                            t1 = System.currentTimeMillis();
                            dapInfoTup1 = this.analyseDap(billDapDataSet.copy(), this.isIdStrType);
                            dapInfoTup2 = new ThreeTuple((Object)((DataSet)dapInfoTup1.item1).copy(), (Object)((DataSet)dapInfoTup1.item2).copy(), dapInfoTup1.item3);
                            t2 = System.currentTimeMillis();
                            logger.info("\u5355\u636e{}DAP\u5206\u6790\u8017\u65f6{}", billTypeEntry.getKey(), (Object)(t2 - t1));
                        }
                        if (TaskDao.isTaskOver((TaskInfo)this.paramModel.getTaskInfo())) {
                            return;
                        }
                        t1 = System.currentTimeMillis();
                        Set<Object> debitUsedVchSet = this.handleDCDataSet(true, DetailDcEnum.DEBIT, billDataSet[0], vchDataSet[0] == null ? null : vchDataSet[0].copy(), dapInfoTup1);
                        if (vchDataSet[0] != null && !CollectionUtils.isEmpty(debitUsedVchSet)) {
                            vchDataSet[0] = vchDataSet[0].filter(new NotInFilterFunction<Object>(debitUsedVchSet, "id"));
                        }
                        Set<Object> creditUsedVchSet = this.handleDCDataSet(true, DetailDcEnum.CREDIT, billDataSet[1], vchDataSet[1] == null ? null : vchDataSet[1].copy(), dapInfoTup2);
                        if (vchDataSet[1] != null && !CollectionUtils.isEmpty(creditUsedVchSet)) {
                            vchDataSet[1] = vchDataSet[1].filter(new NotInFilterFunction<Object>(creditUsedVchSet, "id"));
                        }
                        t2 = System.currentTimeMillis();
                        logger.info("\u5355\u636e{}\u5904\u7406\u6570\u636e\u8017\u65f6{}", billTypeEntry.getKey(), (Object)(t2 - t1));
                        AppCacheHelper.updateTaskStatusWithDB((String)taskInfo.getBatchNo(), (String)taskInfo.getId().toString(), null, null, null, (Integer)(80 / this.billTypeGroup.size()), null);
                    }
                    if (vchDataSet[0] != null) {
                        this.handleDCDataSet(false, DetailDcEnum.DEBIT, null, vchDataSet[0], null);
                    }
                    if (vchDataSet[1] != null) {
                        this.handleDCDataSet(false, DetailDcEnum.CREDIT, null, vchDataSet[1], null);
                    }
                } else {
                    if (vchDataSet[0] != null) {
                        this.handleDCDataSet(false, DetailDcEnum.DEBIT, null, vchDataSet[0], null);
                    }
                    if (vchDataSet[1] != null) {
                        this.handleDCDataSet(false, DetailDcEnum.CREDIT, null, vchDataSet[1], null);
                    }
                }
            }
            Object result = this.dataRowCollector.finishWithResult(this.param);
            String batchNo = taskInfo.getBatchNo();
            if (this.paramModel.isAnalyzeMode()) {
                IAppCache cache = AppCache.get((String)"frm");
                cache.put("frmLogger" + taskInfo.getId(), (Object)this.paramModel.getFrmLogger().getLogs());
            }
            AppCacheHelper.updateTaskStatusWithDB((String)batchNo, (String)taskId, (ReconcilationResultEnum)ReconcilationResultEnum.fail, null, (TaskStatusEnum)TaskStatusEnum.FINISHED, (Integer)100, null);
        }
    }

    protected void setAssistInfo(List<BizDataParam> params) {
        HashMap<String, Set> assistIdMap = new HashMap<String, Set>(params.size());
        for (BizDataParam bizDataParam : params) {
            List bizAssistIdSetMapList = bizDataParam.getBizAssistIdSetMapList();
            for (Map bizAssistIdSetMap : bizAssistIdSetMapList) {
                for (Map.Entry bizAssistEntry : bizAssistIdSetMap.entrySet()) {
                    assistIdMap.computeIfAbsent((String)bizAssistEntry.getKey(), k -> new HashSet(2000)).addAll((Collection)bizAssistEntry.getValue());
                }
            }
        }
        if (assistIdMap.size() > 0) {
            long l1 = System.currentTimeMillis();
            logger.info("getBaseDataName begin");
            Map baseDataName = ReconciliationUtil.getBaseDataName(assistIdMap);
            logger.info("getBaseDataName end : {}", (Object)(System.currentTimeMillis() - l1));
            Map baseDataTypeName = ReconciliationUtil.queryAssistEntityName(assistIdMap.keySet());
            this.paramModel.setBaseDataName(baseDataName);
            this.paramModel.setBaseDataTypeName(baseDataTypeName);
        }
    }

    protected Set<Object> handleDCDataSet(final boolean skipVchNoMatch, final DetailDcEnum dcEnum, DataSet billDataSet, DataSet vchDataSet, ThreeTuple<DataSet, DataSet, Integer> dapInfoTup) {
        DataSet vchGroupDataSet = dapInfoTup == null ? null : (DataSet)dapInfoTup.item1;
        DataSet billGroupDataSet = dapInfoTup == null ? null : (DataSet)dapInfoTup.item2;
        Integer groupIndex = dapInfoTup == null ? null : (Integer)dapInfoTup.item3;
        DataSet leftDataSet = this.genLeftDataSet(billDataSet, billGroupDataSet);
        DataSet rightDataSet = this.genRightDataSet(vchDataSet, vchGroupDataSet);
        this.paramModel.getFrmLogger().logDataSet(dcEnum.name() + " leftDataSet", leftDataSet);
        this.paramModel.getFrmLogger().logDataSet(dcEnum.name() + " rightDataSet", rightDataSet);
        long t9 = System.currentTimeMillis();
        final HashSet<Object> usedVchSet = new HashSet<Object>();
        CollectionCompGroupEngine engine = CollectionCompGroupEngine.getRowService().data(leftDataSet, rightDataSet).compareField("groupIdx").maxGroupIndex(groupIndex).groupDataHandler(new IGroupDataHandler(){

            @Override
            public boolean handle(List<Row> leftRows, List<Row> rightRows) {
                if (skipVchNoMatch) {
                    if (CollectionUtils.isEmpty(leftRows)) {
                        return true;
                    }
                    for (Row rightRow : rightRows) {
                        usedVchSet.add(rightRow.get("id"));
                    }
                }
                return DetailRowCreateUtil.createAndCollectRow(dcEnum, leftRows, rightRows, ReconDetailService.this.dataRowCollector);
            }
        });
        engine.start();
        long t10 = System.currentTimeMillis();
        logger.info("\u6570\u636e\u5339\u914d\u8017\u65f6\uff1a{}", (Object)(t10 - t9));
        return usedVchSet;
    }

    protected void dealAssistFilterInfo() {
        if (this.billTypeGroup.size() == 0) {
            return;
        }
        Map bizAssistMasterIdMap = this.param.getBizAssistMap();
        Map<String, Set<Long>> bizAssistIdMap = this.getBizAssistLeaf(bizAssistMasterIdMap);
        String bizAssistTableStr = this.paramModel.getBizAssistTable();
        if (!StringUtils.isEmpty((Object)bizAssistTableStr)) {
            List bizAssistTable = (List)SerializationUtils.fromJsonString((String)bizAssistTableStr, List.class);
            List head = (List)bizAssistTable.get(0);
            boolean bl = this.needJoinAssistGroup = bizAssistTable.size() > 2 && head.size() > 1;
            if (this.needJoinAssistGroup) {
                ArrayList<Field> rowMetaField = new ArrayList<Field>(head.size());
                ArrayList<String> orgSelectFields = new ArrayList<String>(10);
                for (Object dimKey : head) {
                    String fieldkey = "f" + dimKey.toString().replace(".", "_") + "_mid";
                    rowMetaField.add(new Field(fieldkey, (DataType)DataType.LongType));
                    orgSelectFields.add(fieldkey);
                }
                RowMeta rowMeta = new RowMeta(rowMetaField.toArray(new Field[0]));
                DataSetBuilder builder = Algo.create((String)"frm_preview_assistgroup").createDataSetBuilder(rowMeta);
                for (int i = 1; i < bizAssistTable.size(); ++i) {
                    List bodyRow = (List)bizAssistTable.get(i);
                    Object[] valArray = bodyRow.stream().map(id -> Long.valueOf(id.toString())).toArray();
                    builder.append(valArray);
                }
                this.assistMasterDataSet = builder.build();
                for (Object dimKey : head) {
                    String fieldkey = "f" + dimKey.toString().replace(".", "_");
                    String[] entitySplit = dimKey.toString().split("\\.");
                    String entityId = "";
                    entityId = AssistDataType.isBaseDataType((String)entitySplit[0]) ? entitySplit[1] : "bos_assistantdata_detail";
                    DataSet dataSet = QueryServiceHelper.queryDataSet((String)"fi.frm.detail.executeForBizData", (String)entityId, (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("masterid", "in", bizAssistMasterIdMap.get(dimKey.toString()))}, (String)"");
                    this.assistMasterDataSet = this.join(this.assistMasterDataSet, dataSet, fieldkey, orgSelectFields);
                    orgSelectFields.add(fieldkey + "_id");
                }
            }
        }
        for (Map.Entry billTypeEntry : this.billTypeGroup.entrySet()) {
            for (BizDataParam bizDataParam : (List)billTypeEntry.getValue()) {
                bizDataParam.setAssIdSetMapList(Collections.singletonList(bizAssistIdMap));
                bizDataParam.setAcctOrgID(this.paramModel.getOrgIds().toArray(new Long[0])[0].longValue());
                bizDataParam.setDataType(DataTypeEnum.Detail);
                bizDataParam.setAssistIndexMap(this.detailModel.getBizAssistIndexMap());
                bizDataParam.setAssistType(this.detailModel.getAssistType());
            }
        }
    }

    protected DataSet join(DataSet assistMasterDataSet, DataSet dataSet, String fieldkey, List<String> orgSelectFields) {
        return assistMasterDataSet.join(dataSet).on(fieldkey + "_mid", "masterid").select(orgSelectFields.toArray(new String[0]), new String[]{"id " + fieldkey + "_id"}).finish();
    }

    protected String vchFiltersAndFields(List<QFilter> vchFilters, List<QFilter> revsVchFilters) {
        QFilter orgFilter = new QFilter("entries.eorg", "=", (Object)this.param.getAcctOrgID());
        vchFilters.add(orgFilter);
        revsVchFilters.add(orgFilter);
        QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)this.param.getAcctBookTypeID());
        vchFilters.add(bookTypeFilter);
        QFilter acctFilter = new QFilter("entries.account.id", "in", (Object)this.acctIdSet);
        vchFilters.add(acctFilter);
        revsVchFilters.add(acctFilter);
        boolean hasVoucher = this.param.getAssgrpSet().size() > 0;
        QFilter assFilter = null;
        if (hasVoucher) {
            assFilter = new QFilter("entries.assgrp", "in", (Object)this.param.getAssgrpSet());
            vchFilters.add(assFilter);
            revsVchFilters.add(assFilter);
        }
        if (!this.paramModel.isLocalCurrency()) {
            QFilter currencyFilter = new QFilter("entries.currency", "=", (Object)this.param.getCurrency());
            vchFilters.add(currencyFilter);
        }
        HashSet<String> status = new HashSet<String>(2);
        status.add("B");
        status.add("C");
        QFilter statusFilter = new QFilter("billstatus", "in", status);
        vchFilters.add(statusFilter);
        QFilter periodFilter = new QFilter("entries.eperiod", "=", (Object)this.param.getPeriodid());
        vchFilters.add(periodFilter);
        revsVchFilters.add(periodFilter);
        if (this.paramModel.isAnalyzeMode() && this.paramModel.getAnalyzeVoucherId() > 0L) {
            QFilter idFilter = new QFilter("id", "=", (Object)this.paramModel.getAnalyzeVoucherId());
            vchFilters.add(idFilter);
            revsVchFilters.add(idFilter);
        }
        String selector = this.vchSelectFields(vchFilters);
        if (this.param.isExport()) {
            selector = selector + ",billno rptvchno,vouchertype rptvchid";
        }
        return selector;
    }

    protected String vchSelectFields(List<QFilter> vchFilters) {
        String selector = "";
        ReconAmountTypeEnum reconAmountType = this.planModel.getReconAmountType();
        DetailTypeEnum detailTypeEnum = this.paramModel.getDetailTypeEnum();
        block0 : switch (detailTypeEnum) {
            case DEBIT_DIFF: {
                selector = this.paramModel.isLocalCurrency() ? "id,entries.debitlocal debit,entries.creditlocal credit,entries.account account,sourcebilltype srcentity" : "id,entries.debitori debit,entries.creditori credit,entries.account account,sourcebilltype srcentity";
                vchFilters.add(new QFilter("entries.entrydc", "=", (Object)"1"));
                break;
            }
            case CREDIT_DIFF: {
                selector = this.paramModel.isLocalCurrency() ? "id,entries.debitlocal debit,entries.creditlocal credit,entries.account account,sourcebilltype srcentity" : "id,entries.debitori debit,entries.creditori credit,entries.account account,sourcebilltype srcentity";
                vchFilters.add(new QFilter("entries.entrydc", "=", (Object)"-1"));
                break;
            }
            case STATUS: {
                if (this.paramModel.isLocalCurrency()) {
                    switch (reconAmountType) {
                        case DEBIT: {
                            selector = "id,entries.debitlocal debit,entries.creditlocal credit,entries.account account,sourcebilltype srcentity";
                            vchFilters.add(new QFilter("entries.entrydc", "=", (Object)"1"));
                            break block0;
                        }
                        case CREDIT: {
                            selector = "id,entries.debitlocal debit,entries.creditlocal credit,entries.account account,sourcebilltype srcentity";
                            vchFilters.add(new QFilter("entries.entrydc", "=", (Object)"-1"));
                            break block0;
                        }
                    }
                    selector = "id,entries.debitlocal debit,entries.creditlocal credit,entries.account account,sourcebilltype srcentity";
                    break;
                }
                switch (reconAmountType) {
                    case DEBIT: {
                        selector = "id,entries.debitori debit,entries.creditori credit,entries.account account,sourcebilltype srcentity";
                        vchFilters.add(new QFilter("entries.entrydc", "=", (Object)"1"));
                        break block0;
                    }
                    case CREDIT: {
                        selector = "id,entries.debitori debit,entries.creditori credit,entries.account account,sourcebilltype srcentity";
                        vchFilters.add(new QFilter("entries.entrydc", "=", (Object)"-1"));
                        break block0;
                    }
                }
                selector = "id,entries.debitori debit,entries.creditori credit,entries.account account,sourcebilltype srcentity";
                break;
            }
        }
        return selector;
    }

    protected DataSet[] executeForGlData() {
        DataSet allVchDataSet = null;
        DynamicObject bizAppRefGlConfig = RptBizAppConfigServiceHelper.getBizAppRefGlConfig(this.planModel.getAppId());
        if (bizAppRefGlConfig == null) {
            ArrayList<QFilter> vchFilterList = new ArrayList<QFilter>(10);
            ArrayList<QFilter> revsVchFilterList = new ArrayList<QFilter>(10);
            String selectFields = this.vchFiltersAndFields(vchFilterList, revsVchFilterList);
            if (AssistTypeEnum.Acct == this.paramModel.getAssistTypeEnum() || this.param.getAssgrpSet().size() > 0) {
                Set reverseRelationVchIds;
                boolean reverse;
                allVchDataSet = FrmQueryServiceHelper.queryDataSet((FrmLogger)this.paramModel.getFrmLogger(), (String)(this.getClass().getName() + System.currentTimeMillis()), (String)"gl_voucher", (String)selectFields, (QFilter[])vchFilterList.toArray(new QFilter[0]), null);
                DynamicObject bizAppConfig = RptBizAppConfigServiceHelper.getBizAppConfig(this.planModel.getAppId());
                boolean bl = reverse = bizAppConfig != null && bizAppConfig.getBoolean("reverse");
                if (!reverse && (reverseRelationVchIds = RelationServiceAdaptor.getReverRelation((FrmLogger)this.paramModel.getFrmLogger(), revsVchFilterList)).size() > 0) {
                    allVchDataSet = allVchDataSet.filter(new NotInFilterFunction(reverseRelationVchIds, "id"));
                }
                if (!this.param.isExport()) {
                    allVchDataSet = allVchDataSet.addNullField(new String[]{"rptvchid", "rptvchno"});
                }
            }
        } else {
            this.isIdStrType = "2".equals(bizAppRefGlConfig.getString("vchidtype"));
            RptGlDataQueryService glService = new RptGlDataQueryService(bizAppRefGlConfig, this.param, this.paramModel.getDetailTypeEnum());
            allVchDataSet = glService.executeForDetail(null, null);
        }
        if (allVchDataSet != null) {
            allVchDataSet = this.groupBySum(allVchDataSet);
            DataSet[] splitDataSet = allVchDataSet.splitByFilter(new String[]{"debit != 0"}, true);
            return splitDataSet;
        }
        return new DataSet[]{null, null};
    }

    protected DataSet groupBySum(DataSet allVchDataSet) {
        return allVchDataSet.groupBy(new String[]{"id", "account", "rptvchid", "rptvchno"}).sum("debit").sum("credit").finish();
    }

    protected DataSet executeForDapData(String billType, LongBitSet billBitSet) {
        DynamicObject pluginCfg;
        boolean casBill = RelationServiceAdaptor.isCAS((String)billType);
        RelationParam relationParam = new RelationParam();
        relationParam.setRelationType(RelationTypeEnum.DAP);
        relationParam.setSourceEntity(billType);
        relationParam.setPeriodId(this.paramModel.getPeriodId());
        relationParam.setBizOrgIds(this.paramModel.getBizOrgIds());
        relationParam.setAcctOrgId(Long.valueOf(this.param.getAcctOrgID()));
        relationParam.setTargetEntity("gl_voucher");
        if (casBill) {
            CASService casService = new CASService(this.paramModel.getFrmLogger(), relationParam);
            RelationTypeEnum relationType = casService.getRelationType(this.paramModel.getBizOrgIds());
            relationParam.setRelationType(relationType);
        }
        if ((pluginCfg = RptBizAppConfigServiceHelper.getBizAppConfigForDap(this.planModel.getAppId())) == null) {
            DataSet relation = RelationServiceAdaptor.getRelation((RelationParam)relationParam, (FrmLogger)this.paramModel.getFrmLogger(), (LongBitSet)billBitSet, Collections.emptySet());
            return relation;
        }
        DynamicObject bizAppRefGlConfig = RptBizAppConfigServiceHelper.getBizAppRefGlConfig(this.planModel.getAppId());
        RptBizDataQueryService dapQueryService = new RptBizDataQueryService(pluginCfg, bizAppRefGlConfig);
        DataSet relationDataSet = dapQueryService.queryRelation(relationParam, null, MapUtil.bitSetMap2Set((LongBitSet)billBitSet));
        if (relationDataSet == null) {
            return RelationServiceAdaptor.getRelation((RelationParam)relationParam, (FrmLogger)this.paramModel.getFrmLogger(), (LongBitSet)billBitSet, Collections.emptySet());
        }
        return relationDataSet;
    }

    protected DataSet[] executeForBizData(Map<String, LongBitSet> groupBillIdMap) {
        DataSet debitBizDataSet = null;
        DataSet creditBizDataSet = null;
        for (Map.Entry billTypeEntry : this.billTypeGroup.entrySet()) {
            LongBitSet billBitSet = BitSetFactory.createLong();
            groupBillIdMap.put((String)billTypeEntry.getKey(), billBitSet);
            DataSet[] bizDataSet = this.executeForBizData((String)billTypeEntry.getKey(), (List)billTypeEntry.getValue(), billBitSet);
            debitBizDataSet = debitBizDataSet == null ? bizDataSet[0] : debitBizDataSet.union(bizDataSet[0]);
            if (creditBizDataSet == null) {
                creditBizDataSet = bizDataSet[1];
                continue;
            }
            creditBizDataSet = creditBizDataSet.union(bizDataSet[1]);
        }
        return new DataSet[]{debitBizDataSet, creditBizDataSet};
    }

    protected DataSet[] executeForBizData(String billType, List<BizDataParam> bizParamList, LongBitSet billBitSet) {
        DataSet debitBizDataSet = null;
        DataSet creditBizDataSet = null;
        CountDownLatch countDownLatch = new CountDownLatch(bizParamList.size());
        ArrayList<BizDataService> serviceList = new ArrayList<BizDataService>(bizParamList.size());
        for (BizDataParam bizDataParam : bizParamList) {
            BizDataService service = new BizDataService(bizDataParam, this.paramModel);
            service.setCustomParamService(this.customParamService);
            if (this.needJoinAssistGroup) {
                service.registerFilterByAssistGroup(this.assistMasterDataSet);
            }
            service.setResultCache(true);
            DetailBizQueryTask detailTask = new DetailBizQueryTask(this.paramModel.getTaskInfo(), service, countDownLatch);
            serviceList.add(service);
            if (this.enablePlatformThreadPool) {
                ThreadService.execute((Runnable)detailTask, (TaskType)TaskType.FRM_DETAIL_TASK, (RequestContext)RequestContext.get());
                continue;
            }
            AbstractDetailService.DETAIL_THREAD_POOL.execute((Runnable)detailTask, RequestContext.get());
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage());
            throw new KDBizException((Throwable)e, new ErrorCode("UNKNOWN_ERR", "%s"), new Object[]{ThrowableHelper.toString((Exception)e)});
        }
        if (TaskDao.isTaskOver((TaskInfo)this.paramModel.getTaskInfo())) {
            return new DataSet[]{null, null};
        }
        Algo algo = Algo.create((String)"ReconDetailService");
        for (BizDataService service : serviceList) {
            CachedDataSet cacheDataSet;
            LongBitSet billIdBitSet = service.getDataResult().getBillIdBitSet();
            billBitSet.or(billIdBitSet);
            String cacheId = service.getDataResult().getResultCacheId();
            if (StringUtils.isEmpty((Object)cacheId) || (cacheDataSet = Algo.getCacheDataSet((String)cacheId)).getRowCount() == 0) continue;
            DataSet bizDataSet = cacheDataSet.toDataSet(algo, true);
            BizDataTypeEnum type = service.getParam().getSourceConfig().getType();
            if (BizDataTypeEnum.Debit == type) {
                if (debitBizDataSet == null) {
                    debitBizDataSet = bizDataSet;
                    continue;
                }
                debitBizDataSet = debitBizDataSet.union(bizDataSet);
                continue;
            }
            if (creditBizDataSet == null) {
                creditBizDataSet = bizDataSet;
                continue;
            }
            creditBizDataSet = creditBizDataSet.union(bizDataSet);
        }
        RowMeta rowMeta = FRMDataSetModel.getBizRowMeta((DataTypeEnum)this.paramModel.getDataType());
        if (debitBizDataSet == null) {
            debitBizDataSet = Algo.create((String)"fi.frm.ReconDetailService").createDataSetBuilder(rowMeta).build();
        }
        if (creditBizDataSet == null) {
            creditBizDataSet = Algo.create((String)"fi.frm.ReconDetailService").createDataSetBuilder(rowMeta).build();
        }
        return new DataSet[]{debitBizDataSet, creditBizDataSet};
    }

    protected ThreeTuple<DataSet, DataSet, Integer> analyseDap(DataSet dapRelationDataSet, boolean isIdStrType) {
        this.paramModel.getFrmLogger().logDataSet("analyseDap", dapRelationDataSet);
        long start = System.currentTimeMillis();
        logger.info("analyseDap begin : {}", (Object)start);
        HashMap billMap = MapUtil.newHashMap();
        HashMap vchMap = MapUtil.newHashMap();
        for (Row row : dapRelationDataSet) {
            String billType = row.getString("entity");
            Long l = row.getLong("sourcebillid");
            String billKey = (String)billType + "." + l;
            String vchId = row.getString("voucherid");
            if (l == null || StringUtils.isEmpty((Object)vchId)) continue;
            billMap.computeIfAbsent(billKey, p -> new HashSet(16)).add(vchId);
            vchMap.computeIfAbsent(vchId, p -> new HashSet(16)).add(billKey);
        }
        ArrayList vchIdxList = new ArrayList(200);
        HashSet usedVchIds = new HashSet(2000);
        for (Map.Entry entry : vchMap.entrySet()) {
            if (usedVchIds.contains(entry.getKey())) continue;
            Set billSet = (Set)entry.getValue();
            HashSet<String> usedBill = new HashSet<String>(billSet);
            LinkedList<String> billQueue = new LinkedList<String>();
            for (String string : billSet) {
                billQueue.offer(string);
            }
            HashSet matchedVchSet = new HashSet(2000);
            matchedVchSet.add(entry.getKey());
            usedVchIds.add(entry.getKey());
            while (!billQueue.isEmpty()) {
                Set set = (Set)billMap.get(billQueue.poll());
                set.removeAll(matchedVchSet);
                if (set.isEmpty()) continue;
                matchedVchSet.addAll(set);
                usedVchIds.addAll(set);
                for (String vchId : set) {
                    Set needFindBills = (Set)vchMap.get(vchId);
                    for (String billKey : needFindBills) {
                        if (usedBill.contains(billKey)) continue;
                        billQueue.offer(billKey);
                        usedBill.add(billKey);
                    }
                }
            }
            vchIdxList.add(matchedVchSet);
        }
        RowMeta rowMeta = new RowMeta(new String[]{"groupIdx", "vchid"}, new DataType[]{DataType.IntegerType, DataType.LongType});
        if (isIdStrType) {
            rowMeta = new RowMeta(new String[]{"groupIdx", "vchid"}, new DataType[]{DataType.IntegerType, DataType.StringType});
        }
        DataSetBuilder dataSetBuilder = Algo.create((String)"frm.detail.analyseDap.vchGroup").createDataSetBuilder(rowMeta);
        RowMeta billGroupRowMeta = new RowMeta(new String[]{"groupIdx", "entity", "billid"}, new DataType[]{DataType.IntegerType, DataType.StringType, DataType.LongType});
        DataSetBuilder billGroupBuilder = Algo.create((String)"frm.detail.analyseDap.billGroup").createDataSetBuilder(billGroupRowMeta);
        int grpIdx = 1;
        for (Set set : vchIdxList) {
            HashSet bills = new HashSet(200);
            for (String vchId : set) {
                dataSetBuilder.append(new Object[]{grpIdx, vchId});
                Set billKeys = (Set)vchMap.get(vchId);
                bills.addAll(billKeys);
            }
            for (String billKey : bills) {
                String[] split = billKey.split("\\.");
                billGroupBuilder.append(new Object[]{grpIdx, split[0], split[1]});
            }
            ++grpIdx;
        }
        logger.info("analyseDap end : {}", (Object)(System.currentTimeMillis() - start));
        return new ThreeTuple((Object)dataSetBuilder.build(), (Object)billGroupBuilder.build(), (Object)(grpIdx - 1));
    }
}

