/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.impl.detail;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.enums.AssistTypeEnum;
import kd.fi.frm.common.enums.ReconcilationResultEnum;
import kd.fi.frm.common.model.FrmLogger;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.bizdata.BizDataParam;
import kd.fi.frm.common.model2.RelationDataParam3;
import kd.fi.frm.common.task.TaskInfo;
import kd.fi.frm.common.task.TaskStatusEnum;
import kd.fi.frm.common.util.FrmQueryServiceHelper;
import kd.fi.frm.common.util.ThrowableHelper;
import kd.fi.frm.mservice.algo.NotInFilterFunction;
import kd.fi.frm.mservice.impl.ReconServiceHelper;
import kd.fi.frm.mservice.impl.detail.AbstractDetailService;
import kd.fi.frm.mservice.impl.detail.DetailService4DAP;
import kd.fi.frm.mservice.impl.detail.DetailService4NotDAP;
import kd.fi.frm.mservice.rpt.RptBizAppConfigServiceHelper;
import kd.fi.frm.mservice.rpt.invoke.RptGlDataQueryService;

public class ReconciliationDetailService
extends AbstractDetailService {
    private static Log logger = LogFactory.getLog(ReconciliationDetailService.class);

    public ReconciliationDetailService(ReconciliationParamModel paramModel, RelationDataParam3 glParam) {
        super(glParam, paramModel);
    }

    @Override
    public void execute() {
        super.execute();
        if (!this.prepared) {
            return;
        }
        TaskInfo taskInfo = this.paramModel.getTaskInfo();
        String taskId = String.valueOf(taskInfo.getId());
        try {
            DataSet allVchDataSet = null;
            DynamicObject bizAppRefGlConfig = RptBizAppConfigServiceHelper.getBizAppRefGlConfig(this.planModel.getAppId());
            if (bizAppRefGlConfig == null) {
                if (AssistTypeEnum.Acct == this.paramModel.getAssistTypeEnum() || this.param.getAssgrpSet().size() > 0) {
                    allVchDataSet = FrmQueryServiceHelper.queryDataSet((FrmLogger)this.paramModel.getFrmLogger(), (String)(this.getClass().getName() + System.currentTimeMillis()), (String)"gl_voucher", (String)this.selector, (QFilter[])this.comDapFilters.toArray(new QFilter[0]), null);
                    allVchDataSet = allVchDataSet.filter("billstatus in ('B','C')");
                    if (this.reverseRelationVchIds.size() > 0) {
                        allVchDataSet = allVchDataSet.filter(new NotInFilterFunction(this.reverseRelationVchIds, "id"));
                    }
                    allVchDataSet = allVchDataSet.addNullField(new String[]{"rptvchid", "rptvchno"});
                }
            } else {
                RptGlDataQueryService glService = new RptGlDataQueryService(bizAppRefGlConfig, this.param, this.paramModel.getDetailTypeEnum());
                allVchDataSet = glService.executeForDetail(this.indexVchMap, this.vchIndexMap);
            }
            String vchDataSetCacheId = null;
            if (allVchDataSet != null) {
                vchDataSetCacheId = ReconServiceHelper.transferToCache(allVchDataSet, this.paramModel.getTaskInfo().getId(), this.detailModel.getId());
                this.param.setVchCacheDataSetId(vchDataSetCacheId);
            }
            if (this.group.isEmpty()) {
                this.dealOnlyHandVch(vchDataSetCacheId);
            } else {
                Map<String, List<BizDataParam>> casBizDataParam = this.getCasBizDataParam(this.group);
                AbstractDetailService detailService = null;
                if (!this.group.isEmpty()) {
                    detailService = new DetailService4DAP(this.param, this.paramModel);
                    detailService.execute();
                    allVchDataSet = this.filterRelateVch(vchDataSetCacheId, detailService);
                    if (allVchDataSet != null) {
                        vchDataSetCacheId = ReconServiceHelper.transferToCache(allVchDataSet, this.paramModel.getTaskInfo().getId(), this.detailModel.getId());
                        this.param.setVchCacheDataSetId(vchDataSetCacheId);
                    }
                }
                if (casBizDataParam.size() > 0) {
                    detailService = new DetailService4NotDAP(this.param, this.paramModel, casBizDataParam);
                    detailService.execute();
                    allVchDataSet = this.filterRelateVch(vchDataSetCacheId, detailService);
                    if (allVchDataSet != null) {
                        vchDataSetCacheId = ReconServiceHelper.transferToCache(allVchDataSet, this.paramModel.getTaskInfo().getId(), this.detailModel.getId());
                        this.param.setVchCacheDataSetId(vchDataSetCacheId);
                    }
                }
                if (detailService != null) {
                    this.dealOnlyHandVch(vchDataSetCacheId);
                }
            }
            boolean relation = this.param.isRelation();
            if (relation) {
                this.relation(taskId, this.paramModel.getPlanDetailId());
            }
            String batchNo = taskInfo.getBatchNo();
            AppCacheHelper.updateTaskStatusWithDB((String)batchNo, (String)taskId, (ReconcilationResultEnum)ReconcilationResultEnum.fail, null, (TaskStatusEnum)TaskStatusEnum.FINISHED, null, null);
        }
        catch (Throwable e) {
            logger.error("\u660e\u7ec6\u8868\u5bf9\u8d26\u62a5\u9519:\u5e94\u7528Id:" + this.param.getAppId() + ",\u9519\u8bef\u4fe1\u606f:", e);
            throw new KDBizException(ThrowableHelper.toString((Throwable)e));
        }
        finally {
            if (this.paramModel.isAnalyzeMode()) {
                IAppCache cache = AppCache.get((String)"frm");
                cache.put("frmLogger" + taskInfo.getId(), (Object)this.paramModel.getFrmLogger().getLogs());
            }
        }
    }

    private DataSet filterRelateVch(String vchDataSetCacheId, AbstractDetailService detailService) {
        if (vchDataSetCacheId == null) {
            return null;
        }
        CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)vchDataSetCacheId);
        DataSet allVchDataSet = cacheDataSet.toDataSet(Algo.create((String)"frm"), false);
        if (allVchDataSet == null) {
            return null;
        }
        Set<Long> allRelateVchIds = detailService.getAllRelateVchIds();
        if (allRelateVchIds.size() > 0) {
            allVchDataSet = allVchDataSet.filter(new NotInFilterFunction<Long>(allRelateVchIds, "id"));
        }
        return allVchDataSet;
    }
}

