/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.rpt.invoke;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.frm.mservice.rpt.RptApplyType;
import kd.fi.frm.mservice.rpt.invoke.InvokeParam;
import kd.fi.frm.mservice.rpt.invoke.ResultTypeEnum;

public class InvokeUtil {
    private static final Log logger = LogFactory.getLog(InvokeUtil.class);

    public static List invoke(DynamicObjectCollection pluginEntry, RptApplyType applyType, Map<String, Object> paramMap) {
        InvokeParam invokeParam = InvokeUtil.buildInvokeParam(applyType, pluginEntry, paramMap);
        if (invokeParam == null) {
            return Collections.emptyList();
        }
        return (List)InvokeUtil.invoke(invokeParam);
    }

    public static <T> T invoke(InvokeParam invokeParam) {
        logger.info("\u5f00\u59cb\u8c03\u7528\u53d6\u6570\u5fae\u670d\u52a1\u63a5\u53e3, param = {}", (Object)invokeParam);
        long t1 = System.currentTimeMillis();
        Object result = null;
        result = "1".equals(invokeParam.getType()) ? DispatchServiceHelper.invokeBizService((String)invokeParam.getCloud(), (String)invokeParam.getApp(), (String)invokeParam.getServiceName(), (String)invokeParam.getMethodName(), (Object[])new Object[]{invokeParam.getParamMap()}) : DispatchServiceHelper.invokeService((String)invokeParam.getCloud(), (String)invokeParam.getApp(), (String)invokeParam.getServiceName(), (String)invokeParam.getMethodName(), (Object[])new Object[]{invokeParam.getParamMap()});
        long t2 = System.currentTimeMillis();
        logger.info("\u5b8c\u6210\u8c03\u7528\u53d6\u6570\u5fae\u670d\u52a1\u63a5\u53e3, cost = {}ms", (Object)(t2 - t1));
        return (T)result;
    }

    public static InvokeParam buildInvokeParam(RptApplyType applyType, DynamicObjectCollection pluginEntry, Map<String, Object> paramMap) {
        InvokeParam invokeParam = null;
        for (DynamicObject pluginCfg : pluginEntry) {
            String applytype;
            RptApplyType applyTypeEnum;
            if (pluginCfg.getBoolean("plugindisable") || applyType != (applyTypeEnum = RptApplyType.fromVal(applytype = pluginCfg.getString("applytype")))) continue;
            invokeParam = InvokeUtil.buildInvokeParam(pluginCfg, paramMap);
            break;
        }
        return invokeParam;
    }

    public static InvokeParam buildInvokeParam(DynamicObject pluginCfg, Map<String, Object> paramMap) {
        InvokeParam invokeParam = new InvokeParam();
        invokeParam.setType(pluginCfg.getString("servicettype"));
        invokeParam.setCloud(pluginCfg.getString("cloudid"));
        invokeParam.setApp(pluginCfg.getString("invokeappid"));
        invokeParam.setServiceName(pluginCfg.getString("servicename"));
        invokeParam.setMethodName(pluginCfg.getString("methodname"));
        invokeParam.setResultTypeEnum(ResultTypeEnum.getEnum(pluginCfg.getString("rettype")));
        invokeParam.setParamMap(paramMap);
        return invokeParam;
    }
}

