/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.rpt.invoke;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.frm.common.model.FRMDataSetModel;
import kd.fi.frm.common.relation.RelationParam;
import kd.fi.frm.common.util.MapUtil;
import kd.fi.frm.mservice.rpt.invoke.InvokeParam;
import kd.fi.frm.mservice.rpt.invoke.InvokeUtil;
import kd.fi.frm.mservice.rpt.invoke.ResultTypeEnum;

public class RptBizDataQueryService {
    private static final Log logger = LogFactory.getLog(RptBizDataQueryService.class);
    private final DynamicObject pluginConfig;
    private final DynamicObject refGlAppConfig;
    private boolean isVchIdStr = false;

    public RptBizDataQueryService(DynamicObject pluginConfig, DynamicObject relGlAppConfig) {
        String vchidtype;
        this.pluginConfig = pluginConfig;
        this.refGlAppConfig = relGlAppConfig;
        if (this.refGlAppConfig != null && "2".equals(vchidtype = this.refGlAppConfig.getString("vchidtype"))) {
            this.isVchIdStr = true;
        }
    }

    public boolean isVchIdStr() {
        return this.isVchIdStr;
    }

    public DataSet queryRelation(RelationParam relationParam, Set<Object> vchIds, Set<Long> billIds) {
        HashMap paramMap = MapUtil.newHashMap();
        paramMap.put("org", relationParam.getAcctOrgId());
        paramMap.put("period", relationParam.getPeriodId());
        paramMap.put("billType", relationParam.getSourceEntity());
        paramMap.put("vchIds", vchIds);
        paramMap.put("billIds", billIds);
        InvokeParam invokeParam = InvokeUtil.buildInvokeParam(this.pluginConfig, paramMap);
        DataSet relationDataSet = null;
        ResultTypeEnum resultTypeEnum = invokeParam.getResultTypeEnum();
        if (ResultTypeEnum.ARRAY == resultTypeEnum) {
            RowMeta rowMeta = FRMDataSetModel.getDapRelationRowMeta();
            relationDataSet = this.listToDataSet((List)InvokeUtil.invoke(invokeParam), rowMeta);
        } else {
            relationDataSet = ResultTypeEnum.CACHED_DATASET == resultTypeEnum ? this.cachedDataSetIdToDataSet((Set)InvokeUtil.invoke(invokeParam)) : (DataSet)InvokeUtil.invoke(invokeParam);
        }
        if (this.isVchIdStr) {
            logger.info("Query dap relation, vchIdType is String...");
        }
        return relationDataSet;
    }

    private DataSet listToDataSet(List dataList, RowMeta rowMeta) {
        DataSetBuilder builder = Algo.create((String)"RptGlDataQueryService.invokeForDataSet").createDataSetBuilder(rowMeta);
        for (Object data : dataList) {
            Object[] row = (Object[])data;
            builder.append(row);
        }
        return builder.build();
    }

    private DataSet cachedDataSetIdToDataSet(Set<String> cachedDataSetIds) {
        DataSet result = null;
        String algoKey = "RptBizDataQueryService.cachedDataSetIdToDataSet";
        for (String cachedDataSetId : cachedDataSetIds) {
            CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cachedDataSetId);
            if (result == null) {
                result = cacheDataSet.toDataSet(Algo.create((String)algoKey), false);
                continue;
            }
            result = result.union(cacheDataSet.toDataSet(Algo.create((String)algoKey), false));
        }
        return result;
    }
}

