/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.rpt.invoke;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.fi.frm.common.enums.AssistTypeEnum;
import kd.fi.frm.common.enums.DetailTypeEnum;
import kd.fi.frm.common.model.BaseGlDataParam;
import kd.fi.frm.common.model.FRMDataSetModel;
import kd.fi.frm.common.model.gldata.GLDataParam;
import kd.fi.frm.common.model2.GLDataParam2;
import kd.fi.frm.common.model2.RelationDataParam3;
import kd.fi.frm.common.util.MapUtil;
import kd.fi.frm.mservice.rpt.RptApplyType;
import kd.fi.frm.mservice.rpt.invoke.InvokeUtil;

public class RptGlDataQueryService {
    private static final Log logger = LogFactory.getLog(RptGlDataQueryService.class);
    private Long orgId;
    private Long bookType;
    private Long periodId;
    private DynamicObject glRptConfig;
    private BaseGlDataParam dataParam;
    private RelationDataParam3 detailDataParam;
    private DetailTypeEnum detailTypeEnum;

    public RptGlDataQueryService(DynamicObject glRptConfig, BaseGlDataParam dataParam) {
        this.glRptConfig = glRptConfig;
        this.dataParam = dataParam;
        this.orgId = dataParam.getAcctOrgID();
        this.bookType = dataParam.getAcctBookTypeID();
        this.periodId = dataParam.getPeriodid();
    }

    public RptGlDataQueryService(DynamicObject glRptConfig, RelationDataParam3 detailDataParam, DetailTypeEnum detailTypeEnum) {
        this.glRptConfig = glRptConfig;
        this.detailDataParam = detailDataParam;
        this.orgId = detailDataParam.getAcctOrgID();
        this.bookType = detailDataParam.getAcctBookTypeID();
        this.periodId = detailDataParam.getPeriodid();
        this.detailTypeEnum = detailTypeEnum;
    }

    public DataSet execute() {
        AssistTypeEnum type = this.dataParam.getType();
        if (AssistTypeEnum.Acct == type) {
            return this.querySumDataOnlyAccount();
        }
        if (AssistTypeEnum.Asstact == type) {
            return this.querySumDataWithAssist();
        }
        if (AssistTypeEnum.Assist == type) {
            return this.querySumDataWithAssist();
        }
        return null;
    }

    public DataSet executeForDetail(Map<Long, Object> indexVchMap, Map<Object, Long> vchIndexMap) {
        HashMap paramMap = MapUtil.newHashMap();
        paramMap.put("org", this.orgId);
        paramMap.put("bookType", this.bookType);
        paramMap.put("period", this.periodId);
        paramMap.put("currency", this.detailDataParam.getCurrency());
        paramMap.put("accounts", this.detailDataParam.getAccountIds());
        paramMap.put("amountType", this.detailTypeEnum.getValue());
        paramMap.put("assgrp", this.detailDataParam.getAssgrpSet());
        List dataList = InvokeUtil.invoke(this.glRptConfig.getDynamicObjectCollection("pluginentry"), RptApplyType.GL_VOUCHERDETAIL, paramMap);
        if (indexVchMap != null) {
            return this.trans2DataSet3(dataList, indexVchMap, vchIndexMap);
        }
        return this.trans2DataSet3(dataList);
    }

    private DataSet querySumDataOnlyAccount() {
        GLDataParam acctDataParam = (GLDataParam)this.dataParam;
        HashMap paramMap = MapUtil.newHashMap();
        paramMap.put("org", this.orgId);
        paramMap.put("bookType", this.bookType);
        paramMap.put("accountbook", "");
        paramMap.put("period", this.periodId);
        paramMap.put("accountTable", acctDataParam.getAccountTableID());
        paramMap.put("accounts", acctDataParam.getAccountConfig().getAccountIds());
        if (acctDataParam.isLocalCurrency()) {
            paramMap.put("currencyType", "2");
            paramMap.put("currency", acctDataParam.getCurrencyIds().toArray()[0]);
            paramMap.put("specialCurrency", null);
        } else {
            paramMap.put("currencyType", "1");
            paramMap.put("currency", null);
            paramMap.put("specialCurrency", null);
        }
        paramMap.put("currency", acctDataParam.getCurrencyIds());
        paramMap.put("balanceDc", acctDataParam.getBalanceDc());
        List dataList = InvokeUtil.invoke(this.glRptConfig.getDynamicObjectCollection("pluginentry"), RptApplyType.GL_ACCTSUMMARY, paramMap);
        return this.trans2DataSet1(dataList);
    }

    public DataSet querySumDataWithAssist() {
        GLDataParam2 assistDataParam = (GLDataParam2)this.dataParam;
        HashMap paramMap = MapUtil.newHashMap();
        paramMap.put("org", this.orgId);
        paramMap.put("bookType", this.bookType);
        paramMap.put("accountbook", "");
        paramMap.put("period", this.periodId);
        paramMap.put("accountTable", assistDataParam.getAccountTableID());
        paramMap.put("accounts", assistDataParam.getAccountConfig().getAccountIds());
        paramMap.put("assists", assistDataParam.getAssistIndexMap());
        if (assistDataParam.isLocalCurrency()) {
            paramMap.put("currencyType", "2");
            paramMap.put("currency", assistDataParam.getCurrencyId());
            paramMap.put("specialCurrency", null);
        } else {
            paramMap.put("currencyType", "1");
            paramMap.put("currency", null);
            paramMap.put("specialCurrency", null);
        }
        paramMap.put("balanceDc", assistDataParam.getBalanceDc());
        paramMap.put("ignoreEmpty", assistDataParam.getAccountConfig().isIgnoreEmpty());
        paramMap.put("assistIdFilter", assistDataParam.getAccountConfig().getAssistValueRange());
        List dataList = InvokeUtil.invoke(this.glRptConfig.getDynamicObjectCollection("pluginentry"), RptApplyType.GL_ASSISTSUMMARY, paramMap);
        return this.trans2DataSet2(dataList);
    }

    private DataSet trans2DataSet1(List dataList) {
        RowMeta rowMeta = FRMDataSetModel.getGLAcctRowMeta();
        DataSetBuilder builder = Algo.create((String)"glDataQueryBuild").createDataSetBuilder(rowMeta);
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            for (int i = 0; i < dataList.size(); ++i) {
                Object[] valList = (Object[])dataList.get(i);
                Object[] row = new Object[rowMeta.getFieldCount()];
                row[0] = ((Object[])valList[1])[0];
                row[1] = ((Object[])valList[2])[0];
                row[2] = ((Object[])valList[2])[1];
                row[3] = ((Object[])valList[2])[2];
                row[4] = ((Object[])valList[2])[3];
                builder.append(row);
            }
        }
        return builder.build();
    }

    private DataSet trans2DataSet2(List dataList) {
        RowMeta rowMeta = FRMDataSetModel.getGLRowMeta();
        DataSetBuilder builder = Algo.create((String)"glDataQueryBuild").createDataSetBuilder(rowMeta);
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            GLDataParam2 assistDataParam = (GLDataParam2)this.dataParam;
            for (int i = 0; i < dataList.size(); ++i) {
                Object[] valList = (Object[])dataList.get(i);
                Object[] row = new Object[rowMeta.getFieldCount()];
                row[0] = ((Object[])valList[1])[0];
                row[9] = ((Object[])valList[2])[0];
                row[10] = ((Object[])valList[2])[1];
                row[11] = ((Object[])valList[2])[2];
                row[12] = ((Object[])valList[2])[3];
                row[13] = valList[7];
                Object[] accounts = (Object[])valList[0];
                StringBuilder accountSb = new StringBuilder();
                for (Object account : accounts) {
                    Object[] accountObj = (Object[])account;
                    accountSb.append(accountObj[0]).append(",");
                }
                String accountStr = accountSb.toString();
                row[14] = accountStr.substring(0, accountStr.length() - 1);
                Object[] assistList = (Object[])valList[8];
                for (Map.Entry assistEntry : assistDataParam.getAssistIndexMap().entrySet()) {
                    String key = (String)assistEntry.getKey();
                    Integer index = (Integer)assistEntry.getValue();
                    Object assistVal = ((Object[])assistList[index])[0];
                    Integer glIndex = (Integer)assistDataParam.getAssistIndexMap().get(key);
                    row[1 + glIndex.intValue()] = assistVal == null ? Long.valueOf(0L) : assistVal;
                }
                builder.append(row);
            }
        }
        return builder.build();
    }

    private DataSet trans2DataSet3(List dataList) {
        String vchidtype = this.glRptConfig.getString("vchidtype");
        boolean needReplaceVchId = "2".equals(vchidtype);
        RowMeta rowMeta = FRMDataSetModel.getVchRowMeta((boolean)needReplaceVchId);
        DataSetBuilder builder = Algo.create((String)"glDataQueryBuild").createDataSetBuilder(rowMeta);
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            for (int i = 0; i < dataList.size(); ++i) {
                Object[] valList = (Object[])dataList.get(i);
                Object[] row = new Object[rowMeta.getFieldCount()];
                row[0] = valList[1];
                String dc = (String)valList[4];
                if ("2".equals(dc)) {
                    row[1] = valList[5];
                    row[2] = BigDecimal.ZERO;
                } else {
                    row[1] = BigDecimal.ZERO;
                    row[2] = valList[5];
                }
                row[3] = ((Object[])valList[0])[0];
                row[4] = "";
                row[5] = String.valueOf(valList[1]);
                row[6] = valList[3] + " " + valList[2];
                builder.append(row);
            }
        }
        return builder.build();
    }

    private DataSet trans2DataSet3(List dataList, Map<Long, Object> indexVchMap, Map<Object, Long> vchIndexMap) {
        boolean needReplaceVchId = "2".equals(this.glRptConfig.getString("vchidtype"));
        RowMeta rowMeta = FRMDataSetModel.getVchRowMeta((boolean)false);
        DataSetBuilder builder = Algo.create((String)"glDataQueryBuild").createDataSetBuilder(rowMeta);
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            for (int i = 0; i < dataList.size(); ++i) {
                Object[] valList = (Object[])dataList.get(i);
                Object[] row = new Object[rowMeta.getFieldCount()];
                if (needReplaceVchId) {
                    Collection<Object> values = indexVchMap.values();
                    if (!values.contains(valList[1])) {
                        Long index = Long.valueOf(String.valueOf(indexVchMap.size() + 1));
                        indexVchMap.put(index, valList[1]);
                        row[0] = indexVchMap.size();
                        vchIndexMap.putIfAbsent(valList[1], index);
                    } else {
                        row[0] = vchIndexMap.get(valList[1]);
                    }
                } else {
                    row[0] = valList[1];
                }
                String dc = (String)valList[4];
                if ("2".equals(dc)) {
                    row[1] = valList[5];
                    row[2] = BigDecimal.ZERO;
                } else {
                    row[1] = BigDecimal.ZERO;
                    row[2] = valList[5];
                }
                row[3] = ((Object[])valList[0])[0];
                row[4] = "";
                row[5] = String.valueOf(valList[1]);
                row[6] = valList[3] + " " + valList[2];
                builder.append(row);
            }
        }
        return builder.build();
    }
}

